/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util.formula;

import org.tigr.util.formula.Variant;
import org.tigr.util.formula.node.EvaluateException;
import org.tigr.util.formula.node.MathNode;

public class MathTree
implements Variant {
    private int gLastNodeId = 0;
    private int gKey;
    private MathNode gRoot;
    private MathNode gNode = null;
    private String[] gOperants;

    public float evaluate() throws EvaluateException {
        float res = 0.0f;
        if (this.gRoot == null) {
            throw new EvaluateException("No Math Tree is set.");
        }
        res = this.processNode(this.gRoot);
        return res;
    }

    public float evaluate(String[] vals) throws EvaluateException {
        float res = 0.0f;
        this.setOperants(vals);
        this.reset(this.gRoot);
        if (this.gRoot == null) {
            throw new EvaluateException("No Math Tree is set.");
        }
        res = this.evaluateNodeFor(this.gRoot);
        return res;
    }

    public int extendTree(String[] nodeVals, int offset) {
        int indx = this.gLastNodeId;
        MathNode left = new MathNode(nodeVals[0]);
        MathNode right = new MathNode(nodeVals[2]);
        MathNode[] children = new MathNode[]{left, right};
        if (this.gRoot == null) {
            this.gRoot = new MathNode(nodeVals[1]);
            this.gRoot.setIndex(++indx);
            this.gRoot.setChildren(children);
        } else {
            MathNode current = this.getNodeAt(offset);
            while (current.getChildren() != null) {
                current = current.getChildren()[0];
            }
            current.setContent(nodeVals[1]);
            current.setChildren(children);
        }
        left.setIndex(++indx);
        right.setIndex(++indx);
        this.gLastNodeId = indx;
        return indx;
    }

    public MathNode getNodeAt(int indx) {
        this.gKey = indx;
        MathNode current = this.gRoot;
        if (current.getIndex() == indx) {
            return current;
        }
        current = this.searchSubTree(current);
        return current;
    }

    public String[] findExpression() {
        String[] temp = null;
        temp = this.hasFormulaAt(this.gRoot);
        return temp;
    }

    public MathNode getRootNode() {
        return this.gRoot;
    }

    public void reset(MathNode node) {
        MathNode[] children = node.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                String val = children[i].getContent();
                if (this.isOperator(val.charAt(0))) {
                    children[i].setResult(null);
                } else {
                    children[i].setResult(new Float(0.0f));
                }
                this.reset(children[i]);
                ++i;
            }
        }
    }

    public void setOperants(String[] op) {
        this.gOperants = op;
    }

    private float evaluateNodeFor(MathNode node) throws EvaluateException {
        MathNode[] children = node.getChildren();
        float res = 0.0f;
        try {
            if (children != null) {
                float rVal;
                int addr;
                float lVal;
                Float lf = children[0].getResult();
                Float rf = children[1].getResult();
                String operator = node.getContent();
                if (lf != null) {
                    String lop = children[0].getContent();
                    if (this.isOperator(lop.charAt(0))) {
                        lVal = children[0].getResult().floatValue();
                    } else {
                        addr = Integer.parseInt(children[0].getContent());
                        lVal = Float.parseFloat(this.gOperants[addr]);
                    }
                } else {
                    lVal = this.evaluateNodeFor(children[0]);
                }
                if (rf != null) {
                    String rop = children[1].getContent();
                    if (this.isOperator(rop.charAt(0))) {
                        rVal = children[1].getResult().floatValue();
                    } else {
                        addr = Integer.parseInt(children[1].getContent());
                        rVal = Float.parseFloat(this.gOperants[addr]);
                    }
                } else {
                    rVal = this.evaluateNodeFor(children[1]);
                }
                char op = operator.charAt(0);
                if (op == Variant.OPERATORS[0]) {
                    res = lVal + rVal;
                } else if (op == Variant.OPERATORS[1]) {
                    res = lVal - rVal;
                } else if (op == Variant.OPERATORS[2]) {
                    res = lVal * rVal;
                } else if (op == Variant.OPERATORS[3]) {
                    res = lVal / rVal;
                }
                node.setResult(new Float(res));
            }
        }
        catch (Exception e) {
            throw new EvaluateException(e.getMessage());
        }
        return res;
    }

    private String[] hasFormulaAt(MathNode node) {
        MathNode[] children = node.getChildren();
        String[] fa = null;
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                int addr = children[i].getIndex();
                String val = children[i].getContent();
                if (!this.isOperator(val.charAt(0))) {
                    try {
                        float res = Float.parseFloat(val);
                    }
                    catch (NumberFormatException nfex) {
                        fa = new String[]{val, "" + addr};
                        return fa;
                    }
                }
                if ((fa = this.hasFormulaAt(children[i])) != null) {
                    return fa;
                }
                ++i;
            }
        }
        return fa;
    }

    private boolean isOperator(char ch) {
        boolean yes = false;
        int i = 0;
        while (i < 4) {
            if (ch == Variant.OPERATORS[i]) {
                yes = true;
                i = 4;
            }
            ++i;
        }
        return yes;
    }

    private float processNode(MathNode node) throws EvaluateException {
        MathNode[] children = node.getChildren();
        float res = 0.0f;
        try {
            if (children != null) {
                String lop = children[0].getContent();
                String rop = children[1].getContent();
                String operator = node.getContent();
                float lVal = this.isOperator(lop.charAt(0)) ? this.processNode(children[0]) : Float.parseFloat(lop);
                float rVal = this.isOperator(rop.charAt(0)) ? this.processNode(children[1]) : Float.parseFloat(rop);
                char op = operator.charAt(0);
                if (op == Variant.OPERATORS[0]) {
                    res = lVal + rVal;
                } else if (op == Variant.OPERATORS[1]) {
                    res = lVal - rVal;
                } else if (op == Variant.OPERATORS[2]) {
                    res = lVal * rVal;
                } else if (op == Variant.OPERATORS[3]) {
                    res = lVal / rVal;
                }
                node.setContent("" + res);
            }
        }
        catch (Exception e) {
            throw new EvaluateException(e.getMessage());
        }
        return res;
    }

    private MathNode searchSubTree(MathNode parent) {
        MathNode[] children = parent.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                int addr = children[i].getIndex();
                if (addr != this.gKey) {
                    MathNode temp = children[i];
                    if ((temp = this.searchSubTree(temp)).getIndex() == this.gKey) {
                        return temp;
                    }
                } else {
                    return children[i];
                }
                ++i;
            }
        }
        return parent;
    }
}

