/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util.swing;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.tigr.util.InitialWindow;
import org.tigr.util.StringSplitter;

public class InputHeaderSelector
extends JDialog
implements InitialWindow,
MouseListener,
KeyListener {
    private JFrame gParent;
    private JLabel gInfoLB;
    private JLabel gCellShow;
    private JLabel gCellLoc;
    private JPanel gFxnPL;
    private JPanel basePanel;
    private JScrollPane gTableScroll;
    private JTable gTable;
    private boolean gDataEntered;
    private int gSizeX;
    private int gSizeY;
    private int gSelX;
    private int gSelY;
    private String[] gHeader;
    private String[][] gTableData;

    public InputHeaderSelector(JFrame owner, String[] data) {
        this(owner, data, new String(""), true);
    }

    public InputHeaderSelector(JFrame owner, String[] data, String title, boolean modal) {
        super(owner, title, modal);
        this.gParent = owner;
        this.gSizeX = 450;
        this.gSizeY = 350;
        this.gSelX = 0;
        this.gSelY = 0;
        this.gDataEntered = false;
        this.gTableData = this.setTableData(data);
        this.createGUI();
        this.pack();
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == InitialWindow.cancelBtn) {
            this.gDataEntered = false;
            this.terminate();
        } else if (ae.getSource() == InitialWindow.okBtn) {
            this.gDataEntered = true;
            this.terminate();
        }
    }

    public void alertUsers(String msg) {
    }

    public void createGUI() {
        Dimension btnSize = new Dimension(50, 23);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                InputHeaderSelector.this.gDataEntered = false;
            }
        });
        this.basePanel = new JPanel(new GridBagLayout());
        this.getContentPane().add(this.basePanel);
        this.gInfoLB = new JLabel("Please select the header of your data file: ");
        this.gTable = new JTable(this.gTableData, this.gHeader);
        this.gTable.setDragEnabled(false);
        this.gTable.setAutoResizeMode(0);
        this.gTable.setSelectionMode(0);
        this.gTable.addMouseListener(this);
        this.gTable.addKeyListener(this);
        this.gTableScroll = new JScrollPane(this.gTable);
        this.gTableScroll.setBorder(InitialWindow.low);
        this.gCellLoc = new JLabel();
        this.gCellLoc.setPreferredSize(btnSize);
        this.gCellLoc.setMaximumSize(btnSize);
        this.gCellLoc.setMinimumSize(btnSize);
        this.gCellShow = new JLabel();
        this.gCellShow.setBorder(InitialWindow.low);
        this.gCellShow.setMaximumSize(new Dimension(this.gSizeX - 60, 23));
        this.gCellShow.setMinimumSize(new Dimension(this.gSizeX - 60, 23));
        this.gFxnPL = new JPanel(new GridBagLayout());
        InitialWindow.okBtn.setBorder(InitialWindow.high);
        InitialWindow.okBtn.setPreferredSize(btnSize);
        InitialWindow.okBtn.setMinimumSize(btnSize);
        InitialWindow.okBtn.setMaximumSize(btnSize);
        InitialWindow.okBtn.addActionListener(this);
        InitialWindow.cancelBtn.setBorder(InitialWindow.high);
        InitialWindow.cancelBtn.setPreferredSize(btnSize);
        InitialWindow.cancelBtn.setMinimumSize(btnSize);
        InitialWindow.cancelBtn.setMaximumSize(btnSize);
        InitialWindow.cancelBtn.addActionListener(this);
        this.showCellContent(this.gSelX, this.gSelY);
        InitialWindow.gba.add(this.basePanel, this.gInfoLB, 0, 0, 2, 1, 1, 0, 2, 10, 10, 10, 5, 5);
        InitialWindow.gba.add(this.basePanel, this.gTableScroll, 0, 1, 2, 1, 1, 1, 1, 10, 5, 5, 5, 5);
        InitialWindow.gba.add(this.basePanel, this.gCellLoc, 0, 2, 1, 1, 0, 0, 0, 17, 4, 15, 5, 1);
        InitialWindow.gba.add(this.basePanel, this.gCellShow, 1, 2, 1, 1, 1, 0, 2, 17, 4, 1, 5, 5);
        InitialWindow.gba.add(this.basePanel, this.gFxnPL, 0, 3, 2, 1, 1, 0, 2, 10, 5, 5, 5, 5);
        InitialWindow.gba.add(this.gFxnPL, InitialWindow.okBtn, 0, 0, 1, 1, 0, 0, 0, 10, 5, 5, 5, 5);
        InitialWindow.gba.add(this.gFxnPL, InitialWindow.cancelBtn, 1, 0, 1, 1, 0, 0, 0, 10, 5, 5, 5, 5);
        this.resize(this.gSizeX, this.gSizeY);
        Dimension pSize = this.gParent.getSize();
        int x = pSize.width - this.gSizeX >> 1;
        int y = pSize.height - this.gSizeY >> 1;
        this.setLocation(x, y);
    }

    public String[] getHeader() {
        return this.gTableData[this.gSelX];
    }

    public int getHeaderOffset() {
        return this.gSelX;
    }

    public boolean isDataReady() {
        return this.gDataEntered;
    }

    public void keyPressed(KeyEvent ke) {
        int kId = ke.getKeyCode();
        this.gSelX = this.gTable.getSelectedRow();
        this.gSelY = this.gTable.getSelectedColumn();
        if (kId == 10) {
            ++this.gSelX;
        } else if (kId == 38) {
            --this.gSelX;
        } else if (kId == 40) {
            ++this.gSelX;
        } else if (kId == 37) {
            --this.gSelY;
        } else if (kId == 39) {
            ++this.gSelY;
        }
        if (this.gSelY < 0) {
            ++this.gSelY;
        }
        if (this.gSelX < 0) {
            ++this.gSelX;
        }
        this.showCellContent(this.gSelX, this.gSelY);
    }

    public void keyReleased(KeyEvent ke) {
    }

    public void keyTyped(KeyEvent ke) {
    }

    public void mouseClicked(MouseEvent me) {
        this.gSelX = this.gTable.getSelectedRow();
        this.gSelY = this.gTable.getSelectedColumn();
        this.showCellContent(this.gSelX, this.gSelY);
    }

    public void mouseEntered(MouseEvent me) {
    }

    public void mouseExited(MouseEvent me) {
    }

    public void mousePressed(MouseEvent me) {
    }

    public void mouseReleased(MouseEvent me) {
    }

    public void terminate() {
        this.setVisible(false);
        if (this.basePanel != null) {
            this.basePanel.removeAll();
        }
        this.validate();
        this.repaint();
        this.dispose();
        this.basePanel = null;
    }

    private int getLargestY(String[] lines) {
        int length = lines.length;
        int largest = 0;
        int i = 0;
        while (i < length) {
            StringSplitter splitter = new StringSplitter(lines[i], "\t");
            int small = splitter.countTokens();
            if (largest < small) {
                largest = small;
            }
            ++i;
        }
        return largest;
    }

    private void showCellContent(int x, int y) {
        if (x < this.gTable.getRowCount() && y < this.gTable.getColumnCount()) {
            String val = (String)this.gTable.getValueAt(x, y);
            if (val == null) {
                val = new String("  ");
            }
            this.gCellLoc.setText("(" + (x + 1) + ", " + (y + 1) + ")");
            this.gCellShow.setText(val);
        }
    }

    private String[][] setTableData(String[] pData) {
        int x = pData.length;
        int y = this.getLargestY(pData);
        this.gHeader = new String[y];
        int i = 0;
        while (i < y) {
            this.gHeader[i] = new String("");
            ++i;
        }
        String[][] temp = new String[x][y];
        i = 0;
        while (i < pData.length) {
            StringSplitter sp = new StringSplitter(pData[i], "\t");
            int j = 0;
            while (sp.hasMoreTokens()) {
                temp[i][j++] = sp.nextToken();
            }
            ++i;
        }
        return temp;
    }
}

