/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util.swing;

import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.tigr.util.awt.GBA;

public class MultiInputOutputs
extends JSplitPane {
    private JLabel inputLB;
    private JLabel outputLB;
    private JLabel fileNumLB;
    private JList inputList;
    private JList outputList;
    private JPanel inputPL;
    private JPanel outputPL;
    private JScrollPane inputSP;
    private JScrollPane outputSP;
    private GBA gba;
    private final String NUM_FILE = "  Number of Files:  ";
    public final String OUT_READY = "outready";
    private int sizeX;
    private int sizeY;
    private boolean outputReady;

    public MultiInputOutputs() {
        super(0, true);
    }

    public MultiInputOutputs(int x, int y) {
        super(0, true);
        this.sizeX = x;
        this.sizeY = y;
        this.outputReady = false;
        this.initil();
    }

    public void addDataToLists(Vector in, Vector out) {
        this.inputList.setListData(in);
        this.outputList.setListData(out);
    }

    public int[] getSelectedInputIndices() {
        return this.inputList.getSelectedIndices();
    }

    public int getSelectedOutputIndex() {
        return this.outputList.getSelectedIndex();
    }

    public String getSelectedOutputName(int offset) {
        return (String)this.outputList.getModel().getElementAt(offset);
    }

    public boolean isOutputReady() {
        return this.outputReady;
    }

    public void setInputLabel(String str) {
        this.inputLB.setText(str);
    }

    public void setInputListData(Vector v) {
        this.inputList.setListData(v);
    }

    public void setOutputLabel(String str) {
        this.outputLB.setText(str);
    }

    public void setOutputListData(Vector v) {
        this.outputList.setListData(v);
    }

    public void setOutputSelectedIndex(int indx) {
        this.outputList.setSelectedIndex(indx);
    }

    public void setLabelTexts(String input, String output) {
        this.inputLB.setText(input);
        this.outputLB.setText(output);
    }

    public void setSize(int x, int y) {
        this.sizeX = x;
        this.sizeY = y;
        super.setSize(this.sizeX, this.sizeY);
    }

    public void showNumberOfFiles(int num) {
        if (num > 0) {
            this.fileNumLB.setText("  Number of Files:  " + num);
        } else {
            this.fileNumLB.setText("  Number of Files:  ");
        }
    }

    private void fireChanges() {
        this.firePropertyChange("outready", false, this.outputReady);
    }

    private void initil() {
        BevelBorder low = new BevelBorder(1);
        this.gba = new GBA();
        this.setSize(this.sizeX, this.sizeY);
        this.setDividerSize(4);
        this.setDividerLocation(0.5);
        this.inputLB = new JLabel("");
        this.outputLB = new JLabel("");
        this.inputPL = new JPanel(new GridBagLayout());
        this.outputPL = new JPanel(new GridBagLayout());
        super.setTopComponent(this.inputPL);
        super.setBottomComponent(this.outputPL);
        this.inputList = new JList();
        this.inputList.setBorder(low);
        this.actionHandler(this.inputList);
        this.inputSP = new JScrollPane(this.inputList);
        this.outputList = new JList();
        this.outputList.setBorder(low);
        this.outputList.setSelectionMode(0);
        this.actionHandler(this.outputList);
        this.outputSP = new JScrollPane(this.outputList);
        this.fileNumLB = new JLabel("  Number of Files:  ");
        this.fileNumLB.setBorder(low);
        this.gba.add(this.inputPL, this.inputLB, 0, 0, 1, 1, 1, 0, 2, 10, 5, 10, 5, 2);
        this.gba.add(this.inputPL, this.inputSP, 0, 1, 1, 1, 1, 1, 1, 10, 1, 2, 5, 2);
        this.gba.add(this.outputPL, this.outputLB, 0, 0, 1, 1, 1, 0, 2, 17, 5, 10, 2, 2);
        this.gba.add(this.outputPL, this.outputSP, 0, 1, 1, 1, 1, 1, 1, 10, 1, 2, 5, 2);
        this.gba.add(this.outputPL, this.fileNumLB, 0, 2, 1, 1, 1, 0, 2, 10, 1, 2, 5, 2);
    }

    private void actionHandler(JList l) {
        JList list = l;
        list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent lse) {
                if (MultiInputOutputs.this.outputList.getModel().getSize() > 0) {
                    MultiInputOutputs.this.outputReady = true;
                } else {
                    MultiInputOutputs.this.outputReady = false;
                }
                MultiInputOutputs.this.fireChanges();
            }
        });
    }
}

