/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.PrintJob;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class AACompDisplay
extends Frame
implements ActionListener {
    private String table;
    private String seqName;
    private TextField SequenceName;

    public AACompDisplay(Frame frame, String string, String string2, String string3) {
        int n = 0;
        while (n < string3.length()) {
            if (string3.charAt(n) == '(') {
                string3 = string3.substring(5, n - 2);
                break;
            }
            ++n;
        }
        this.table = String.valueOf(string) + "\rMolecular weight: " + string3 + "\r";
        this.seqName = string2;
        ((Component)this).setFont(MWCalculator.dia);
        FontMetrics fontMetrics = this.getFontMetrics(MWCalculator.dia);
        this.setTitle("Amino Acid Composition");
        Dimension dimension = this.getToolkit().getScreenSize();
        AACCanvas aACCanvas = new AACCanvas(this.table);
        Dimension dimension2 = aACCanvas.getSize();
        int n2 = Math.round((float)dimension2.width * 1.2f);
        int n3 = dimension2.height + fontMetrics.getHeight() * 6;
        if (MWCalculator.macOS) {
            ((Component)this).setBounds(dimension.width - n2 - 50, dimension.height - n3 - 100, n2, n3);
        } else {
            ((Component)this).setBounds(dimension.width - n2 - 100, dimension.height - n3 - 150, n2, n3 + fontMetrics.getHeight() * 4);
        }
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        Panel panel3 = new Panel();
        panel.setLayout(new FlowLayout(0));
        panel.add(new Label("Amino Acid Composition of:", 0));
        Panel panel4 = new Panel();
        panel4.setLayout(new BorderLayout());
        panel.add(panel4);
        panel4.add("North", new Panel());
        panel4.add("South", new Panel());
        panel4.add("West", new Panel());
        panel4.add("East", new Panel());
        this.SequenceName = new TextField(this.seqName, 25);
        panel4.add("Center", this.SequenceName);
        panel2.setLayout(new FlowLayout());
        panel2.add(aACCanvas);
        panel3.setLayout(new GridLayout(1, 2));
        Panel panel5 = new Panel();
        Panel panel6 = new Panel();
        Button button = new Button("Print AA Composition");
        button.addActionListener(this);
        Button button2 = new Button("Ok");
        button2.addActionListener(this);
        panel5.add(button);
        panel6.add(button2);
        panel3.add(panel5);
        panel3.add(panel6);
        this.add("North", panel);
        this.add("Center", panel2);
        this.add("South", panel3);
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("File");
        menuBar.add(menu);
        MenuItem menuItem = new MenuItem("Close Window", new MenuShortcut(119));
        menuItem.addActionListener(this);
        MenuItem menuItem2 = new MenuItem("Print AA Composition", new MenuShortcut(112));
        menu.add(menuItem);
        menuItem2.addActionListener(this);
        menu.add(menuItem2);
        MenuItem menuItem3 = new MenuItem("Quit", new MenuShortcut(113));
        menuItem3.addActionListener(this);
        menu.add(menuItem3);
        Menu menu2 = new Menu("Help");
        menuBar.add(menu2);
        MenuItem menuItem4 = new MenuItem("Instructions", new MenuShortcut(105));
        menuItem4.addActionListener(this);
        menu2.add(menuItem4);
        MenuItem menuItem5 = new MenuItem("About..", new MenuShortcut(97));
        menuItem5.addActionListener(this);
        menu2.add(menuItem5);
        this.setMenuBar(menuBar);
        this.addWindowListener(new 1());
        ((Component)this).setVisible(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Close Window")) {
            ((Component)this).setVisible(false);
            return;
        }
        if (string.equals("Print AA Composition")) {
            this.printAAComp();
            return;
        }
        if (string.equals("Ok")) {
            ((Component)this).setVisible(false);
            return;
        }
        if (string.equals("Instructions")) {
            new Instructions(this);
            return;
        }
        if (string.equals("About..")) {
            new MWDialog((Frame)this, "About", "");
            return;
        }
        if (string.equals("Quit")) {
            this.exitMWCalculator();
            return;
        }
        new MWDialog((Frame)this, "Alert!", "Please inform me how this happened.");
    }

    private void exitMWCalculator() {
        this.dispose();
        System.exit(0);
    }

    private void printAAComp() {
        Graphics graphics;
        PrintJob printJob;
        Toolkit toolkit = this.getToolkit();
        try {
            printJob = toolkit.getPrintJob(this, "Print AAComp", null);
        }
        catch (UnknownError unknownError) {
            return;
        }
        try {
            graphics = printJob.getGraphics();
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        Graphics graphics2 = graphics.create();
        Font font = new Font("TimesRoman", 0, 12);
        graphics2.setFont(font);
        String string = this.SequenceName.getText().equals("") ? "Amino Acid Composition and Molecular Weight of \"no Name\":\r\r" + this.table : "Amino Acid Composition and Molecular Weight of \"" + this.SequenceName.getText() + "\":\r\r" + this.table;
        int n = 50;
        int n2 = 0;
        int n3 = 0;
        int n4 = 50;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '\t') {
                graphics2.drawString(string.substring(n3, n2), n, n4);
                n3 = n2;
                n = 260;
            }
            if (string.charAt(n2) == '\r') {
                if (n4 == 64) {
                    graphics2.setFont(new Font("Courier", 0, 12));
                }
                graphics2.drawString(string.substring(n3, n2), n, n4);
                n3 = n2;
                n4 += 14;
                n = 65;
            }
            ++n2;
        }
        this.print(graphics2);
        graphics.dispose();
        graphics2.dispose();
        printJob.end();
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            ((Component)AACompDisplay.this).setVisible(false);
        }

        /* synthetic */ 1() {
        }
    }
}

