/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dom;

import com.ibm.xml.dom.DOMExceptionImpl;
import com.ibm.xml.dom.DocumentImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class NodeImpl
implements Node,
NodeList,
Cloneable {
    public static final short ELEMENT_DEFINITION_NODE = -1;
    protected String name;
    protected String value;
    protected boolean readOnly;
    protected DocumentImpl ownerDocument;
    protected NodeImpl parentNode;
    protected NodeImpl previousSibling;
    protected NodeImpl nextSibling;
    protected NodeImpl firstChild;
    protected NodeImpl lastChild;
    protected Object userData;
    int fNodeIndex = -1;
    boolean syncChildren;
    boolean syncData;
    int changes = 0;
    protected static int[] kidOK = new int[13];

    static {
        NodeImpl.kidOK[9] = 1410;
        NodeImpl.kidOK[1] = 442;
        NodeImpl.kidOK[5] = 442;
        NodeImpl.kidOK[6] = 442;
        NodeImpl.kidOK[11] = 442;
        NodeImpl.kidOK[2] = 40;
        NodeImpl.kidOK[12] = 0;
        NodeImpl.kidOK[4] = 0;
        NodeImpl.kidOK[3] = 0;
        NodeImpl.kidOK[8] = 0;
        NodeImpl.kidOK[7] = 0;
        NodeImpl.kidOK[10] = 0;
    }

    NodeImpl(DocumentImpl owner, int nodeIndex) {
        this.ownerDocument = owner != null ? owner : (DocumentImpl)this;
        this.fNodeIndex = nodeIndex;
        this.syncChildren = true;
        this.syncData = true;
    }

    protected NodeImpl(DocumentImpl ownerDocument, String name, String value) {
        this.ownerDocument = ownerDocument != null ? ownerDocument : (DocumentImpl)this;
        this.name = name;
        this.value = value;
    }

    public abstract short getNodeType();

    public String getNodeName() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.name;
    }

    public void setNodeValue(String value) {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, null);
        }
        if (this.syncData) {
            this.synchronizeData();
        }
        this.value = value;
    }

    public String getNodeValue() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.value;
    }

    public Node appendChild(Node newChild) throws DOMException {
        return this.insertBefore(newChild, null);
    }

    public Node cloneNode(boolean deep) {
        NodeImpl newnode;
        if (this.syncData) {
            this.synchronizeData();
        }
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        try {
            newnode = (NodeImpl)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        newnode.readOnly = false;
        newnode.parentNode = null;
        newnode.previousSibling = null;
        newnode.nextSibling = null;
        newnode.firstChild = null;
        newnode.lastChild = null;
        if (deep) {
            NodeImpl child = (NodeImpl)this.getFirstChild();
            while (child != null) {
                newnode.appendChild(child.cloneNode(true));
                child = (NodeImpl)child.getNextSibling();
            }
        }
        return newnode;
    }

    public Document getOwnerDocument() {
        return this.ownerDocument;
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    public Node getNextSibling() {
        return this.nextSibling;
    }

    public Node getPreviousSibling() {
        return this.previousSibling;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public boolean hasChildNodes() {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        return this.firstChild != null;
    }

    public NodeList getChildNodes() {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        return this;
    }

    public Node getFirstChild() {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        return this.firstChild;
    }

    public Node getLastChild() {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        return this.lastChild;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, null);
        }
        if (!(newChild instanceof NodeImpl) || newChild.getOwnerDocument() != this.ownerDocument && (this.getNodeType() != 9 || newChild.getOwnerDocument() != (Document)((Object)this))) {
            throw new DOMExceptionImpl(4, null);
        }
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        NodeImpl newInternal = (NodeImpl)newChild;
        boolean treeSafe = true;
        NodeImpl a = this.parentNode;
        while (treeSafe && a != null) {
            treeSafe = newInternal != a;
            a = a.parentNode;
        }
        if (!treeSafe) {
            throw new DOMExceptionImpl(3, null);
        }
        if (refChild != null && refChild.getParentNode() != this) {
            throw new DOMExceptionImpl(8, null);
        }
        if (newInternal.getNodeType() == 11) {
            Node kid = newInternal.getFirstChild();
            while (kid != null) {
                if (!NodeImpl.isKidOK(this, kid)) {
                    throw new DOMExceptionImpl(3, null);
                }
                kid = kid.getNextSibling();
            }
            while (newInternal.hasChildNodes()) {
                this.insertBefore(newInternal.getFirstChild(), refChild);
            }
        } else {
            if (!NodeImpl.isKidOK(this, newInternal)) {
                throw new DOMExceptionImpl(3, null);
            }
            Node oldparent = newInternal.getParentNode();
            if (oldparent != null) {
                oldparent.removeChild(newInternal);
            }
            NodeImpl prev = refChild == null ? this.lastChild : ((NodeImpl)refChild).previousSibling;
            newInternal.parentNode = this;
            newInternal.previousSibling = prev;
            if (prev == null) {
                this.firstChild = newInternal;
            } else {
                prev.nextSibling = newInternal;
            }
            newInternal.nextSibling = (NodeImpl)refChild;
            if (refChild == null) {
                this.lastChild = newInternal;
            } else {
                ((NodeImpl)refChild).previousSibling = newInternal;
            }
        }
        this.changed();
        return newInternal;
    }

    public Node removeChild(Node oldChild) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, null);
        }
        if (oldChild != null && oldChild.getParentNode() != this) {
            throw new DOMExceptionImpl(8, null);
        }
        NodeImpl oldInternal = (NodeImpl)oldChild;
        NodeImpl prev = oldInternal.previousSibling;
        NodeImpl next = oldInternal.nextSibling;
        if (prev != null) {
            prev.nextSibling = next;
        } else {
            this.firstChild = next;
        }
        if (next != null) {
            next.previousSibling = prev;
        } else {
            this.lastChild = prev;
        }
        oldInternal.parentNode = null;
        oldInternal.nextSibling = null;
        oldInternal.previousSibling = null;
        this.changed();
        return oldInternal;
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        this.insertBefore(newChild, oldChild);
        return this.removeChild(oldChild);
    }

    public int getLength() {
        int count = 0;
        NodeImpl node = this.firstChild;
        while (node != null) {
            ++count;
            node = node.nextSibling;
        }
        return count;
    }

    public Node item(int index) {
        NodeImpl node = this.firstChild;
        int i = 0;
        while (i < index && node != null) {
            node = node.nextSibling;
            ++i;
        }
        return node;
    }

    public void setReadOnly(boolean readOnly, boolean deep) {
        this.readOnly = readOnly;
        if (deep) {
            NodeImpl mykid = this.firstChild;
            while (mykid != null) {
                if (!(mykid instanceof EntityReference)) {
                    mykid.setReadOnly(readOnly, true);
                }
                mykid = mykid.nextSibling;
            }
        }
    }

    public void setUserData(Object data) {
        this.userData = data;
    }

    public Object getUserData() {
        return this.userData;
    }

    void synchronizeChildren() {
        NodeImpl last = null;
        int index = this.ownerDocument.getFirstChild(this.fNodeIndex);
        while (index != -1) {
            NodeImpl node = this.ownerDocument.getNodeObject(index);
            if (last == null) {
                this.firstChild = node;
            } else {
                last.nextSibling = node;
            }
            node.parentNode = this;
            node.previousSibling = last;
            last = node;
            index = this.ownerDocument.getNextSibling(index);
        }
        if (last != null) {
            this.lastChild = last;
        }
        this.syncChildren = false;
    }

    void synchronizeData() {
        this.name = this.ownerDocument.getNodeName(this.fNodeIndex);
        this.value = this.ownerDocument.getNodeValue(this.fNodeIndex);
        this.syncData = false;
    }

    void changed() {
        ++this.changes;
        if (this.parentNode != null) {
            this.parentNode.changed();
        }
    }

    protected static boolean isKidOK(Node parent, Node child) {
        return (kidOK[parent.getNodeType()] & 1 << child.getNodeType()) != 0;
    }

    public String toString() {
        return "[" + this.getNodeName() + ": " + this.getNodeValue() + "]";
    }
}

