/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.OpenString;
import iubio.readseq.BioseqFormat;
import iubio.readseq.BioseqReaderIface;
import iubio.readseq.FitchSeqReader;

public class FitchSeqFormat
extends BioseqFormat {
    public String formatName() {
        return "Fitch";
    }

    public String formatSuffix() {
        return ".fitch";
    }

    public String contentType() {
        return "biosequence/fitch";
    }

    public BioseqReaderIface newReader() {
        return new FitchSeqReader();
    }

    public boolean canread() {
        return false;
    }

    public boolean canwrite() {
        return false;
    }

    public boolean formatTestLine(OpenString line, int atline, int skiplines) {
        int splen = line.length();
        boolean isfitch = true;
        for (int k = 0; isfitch && k < splen; ++k) {
            if (k % 4 == 0) {
                isfitch &= line.charAt(k) == ' ';
                continue;
            }
            isfitch &= line.charAt(k) != ' ';
        }
        if (isfitch && splen > 20) {
            this.formatLikelihood += 10;
        }
        return false;
    }
}

