/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.OpenString;
import iubio.readseq.BioseqFormat;
import iubio.readseq.BioseqReaderIface;
import iubio.readseq.BioseqWriterIface;
import iubio.readseq.MsfSeqReader;
import iubio.readseq.MsfSeqWriter;

public class MsfSeqFormat
extends BioseqFormat {
    public String formatName() {
        return "MSF";
    }

    public String formatSuffix() {
        return ".msf";
    }

    public String contentType() {
        return "biosequence/msf";
    }

    public boolean canread() {
        return true;
    }

    public boolean canwrite() {
        return true;
    }

    public boolean interleaved() {
        return true;
    }

    public BioseqWriterIface newWriter() {
        return new MsfSeqWriter();
    }

    public BioseqReaderIface newReader() {
        return new MsfSeqReader();
    }

    public boolean formatTestLine(OpenString line, int atline, int skiplines) {
        int t;
        if (line.startsWith("!!")) {
            if ((line.startsWith("!!NA") || line.startsWith("!!AA")) && line.indexOf("MULTIPLE_ALIGNMENT") >= 0) {
                this.formatLikelihood += 92;
                return true;
            }
            return false;
        }
        int m = line.indexOf("MSF:");
        if (m >= 0 && (t = line.indexOf("Type:", m)) > m && line.indexOf("Check:", t) > t) {
            this.formatLikelihood += 95;
            if (this.recordStartline == 0) {
                this.recordStartline = atline;
            }
            return true;
        }
        return false;
    }
}

