/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import iubio.bioseq.BaseKind;
import iubio.readseq.BioseqWriter;
import iubio.readseq.WriteseqOpts;

class PlainSeqWriter
extends BioseqWriter {
    protected final int kMaxlongbuf = 2048;
    protected boolean isoneline;

    PlainSeqWriter() {
    }

    public void writeRecordEnd() {
        if (!this.isoneline) {
            this.writeln();
        }
    }

    public void setOpts(WriteseqOpts newopts) {
        if (newopts != null) {
            this.opts.seqwidth = newopts.seqwidth;
        }
    }

    protected void writeLoop() {
        if (this.opts.seqwidth < 9999 && this.opts.seqwidth > 0) {
            super.writeLoop();
        } else {
            this.isoneline = true;
            int bioseqlen = Math.min(this.offset + this.seqlen, this.bioseq.length());
            char[] bs = new char[2048];
            int i = 0;
            int bufl = 0;
            while (i < this.seqlen) {
                if (this.l1 < 0) {
                    this.l1 = 0;
                }
                ++this.l1;
                char bc = this.offset + i >= bioseqlen ? BaseKind.indelEdge : this.bioseq.base(this.offset + i, this.fBasePart);
                ++i;
                if (this.testbaseKind == 1) {
                    bc = (char)this.testbase.outSeqChar(bc);
                }
                if (bc > '\u0000') {
                    bs[bufl++] = bc;
                }
                if (bufl < 2048 && this.l1 != this.opts.seqwidth && i != this.seqlen) continue;
                int buflen = bufl;
                bufl = 0;
                this.l1 = 0;
                this.writeByteArray(bs, 0, buflen);
                if (i != this.seqlen && this.l1 != this.opts.seqwidth) continue;
                this.writeln();
            }
        }
    }
}

