/*
 * Decompiled with CFR 0.152.
 */
package forester.atv;

import forester.atv.ATVjapplet;
import forester.atv.ATVpanel;
import forester.atv.ATVpanel_applet;
import forester.atv.ATVtextframe;
import forester.tree.Tree;
import forester.tree.TreeHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

class ATVappletFrame
extends JFrame
implements ActionListener {
    private Tree reload_tree_ = null;
    private JMenuBar jmenubar;
    private JMenu file_jmenu;
    private JMenu edit_jmenu;
    private JMenu view_jmenu;
    private JMenu options_jmenu;
    private JMenu help_jmenu;
    private JMenu search_jmenu;
    private JMenuItem close_item;
    private JMenuItem open_url_item;
    private JMenuItem reload_item;
    private JMenuItem remove_root_item;
    private JMenuItem remove_root_tri_item;
    private JMenuItem tiny_fonts_item;
    private JMenuItem small_fonts_item;
    private JMenuItem medium_fonts_item;
    private JMenuItem large_fonts_item;
    private JMenuItem switch_colors_item;
    private JMenuItem view_as_NH_item;
    private JMenuItem view_as_NHX_item;
    private JMenuItem about_item;
    private JMenuItem help_item;
    private JMenuItem find_item;
    private JMenuItem find_reset_item;
    private ATVjapplet atvapplet;
    ATVpanel_applet atvpanel;
    private Container contentpane;
    private ATVtextframe atvtextframe;
    private static final Color menu_background_color = new Color(215, 215, 215);
    private static final Color menu_text_color = new Color(0, 0, 0);
    private static final Font menu_font = new Font("Helvetica", 0, 10);
    private static final int FRAME_X_SIZE = 640;
    private static final int FRAME_Y_SIZE = 580;

    ATVappletFrame(ATVjapplet aTVjapplet) {
        this.atvapplet = aTVjapplet;
        this.atvtextframe = null;
        URL uRL = null;
        Tree tree = null;
        if (this.atvapplet.getURLstring() != null) {
            try {
                uRL = new URL(this.atvapplet.getURLstring());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "ATVapplet: Could not create URL from: " + this.atvapplet.getURLstring() + "\nException: " + exception, "Could not create URL", 0);
                this.close();
            }
        }
        if (uRL != null) {
            try {
                tree = TreeHelper.readNHtree(uRL);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "ATVapplet: Could not read Tree: \nException: " + exception, "Could not read Tree", 0);
                this.close();
            }
        }
        if (tree != null && !tree.isEmpty()) {
            this.reload_tree_ = tree.copyTree();
        }
        this.setTitle("ATV");
        this.atvpanel = new ATVpanel_applet(tree, this);
        this.jmenubar = new JMenuBar();
        this.jmenubar.setBackground(menu_background_color);
        this.file_jmenu = new JMenu("File");
        this.edit_jmenu = new JMenu("Edit");
        this.search_jmenu = new JMenu("Search");
        this.view_jmenu = new JMenu("View");
        this.options_jmenu = new JMenu("Options");
        this.help_jmenu = new JMenu("Help");
        this.file_jmenu.setFont(menu_font);
        this.file_jmenu.setBackground(menu_background_color);
        this.file_jmenu.setForeground(menu_text_color);
        this.edit_jmenu.setFont(menu_font);
        this.edit_jmenu.setBackground(menu_background_color);
        this.edit_jmenu.setForeground(menu_text_color);
        this.search_jmenu.setFont(menu_font);
        this.search_jmenu.setBackground(menu_background_color);
        this.search_jmenu.setForeground(menu_text_color);
        this.view_jmenu.setFont(menu_font);
        this.view_jmenu.setBackground(menu_background_color);
        this.view_jmenu.setForeground(menu_text_color);
        this.options_jmenu.setFont(menu_font);
        this.options_jmenu.setBackground(menu_background_color);
        this.options_jmenu.setForeground(menu_text_color);
        this.help_jmenu.setFont(menu_font);
        this.help_jmenu.setBackground(menu_background_color);
        this.help_jmenu.setForeground(menu_text_color);
        this.reload_item = new JMenuItem("Reload");
        this.file_jmenu.add(this.reload_item);
        this.file_jmenu.addSeparator();
        this.open_url_item = new JMenuItem("Open URL to read a NH/NHX tree");
        this.file_jmenu.add(this.open_url_item);
        this.file_jmenu.addSeparator();
        this.close_item = new JMenuItem("Close");
        this.file_jmenu.add(this.close_item);
        this.remove_root_item = new JMenuItem("Remove root");
        this.edit_jmenu.add(this.remove_root_item);
        this.remove_root_tri_item = new JMenuItem("Remove root and trifurcate");
        this.edit_jmenu.add(this.remove_root_tri_item);
        this.find_item = new JMenuItem("Search");
        this.search_jmenu.add(this.find_item);
        this.search_jmenu.addSeparator();
        this.find_reset_item = new JMenuItem("Reset");
        this.search_jmenu.add(this.find_reset_item);
        this.view_as_NH_item = new JMenuItem("View as NH");
        this.view_jmenu.add(this.view_as_NH_item);
        this.view_as_NHX_item = new JMenuItem("View as NHX");
        this.view_jmenu.add(this.view_as_NHX_item);
        this.switch_colors_item = new JMenuItem("Switch colors");
        this.options_jmenu.add(this.switch_colors_item);
        this.options_jmenu.addSeparator();
        this.tiny_fonts_item = new JMenuItem("Tiny fonts");
        this.options_jmenu.add(this.tiny_fonts_item);
        this.small_fonts_item = new JMenuItem("Small fonts");
        this.options_jmenu.add(this.small_fonts_item);
        this.medium_fonts_item = new JMenuItem("Medium fonts");
        this.options_jmenu.add(this.medium_fonts_item);
        this.large_fonts_item = new JMenuItem("Large fonts");
        this.options_jmenu.add(this.large_fonts_item);
        this.help_item = new JMenuItem("Help");
        this.help_jmenu.add(this.help_item);
        this.about_item = new JMenuItem("About");
        this.help_jmenu.add(this.about_item);
        this.customizeJMenuItem(this.reload_item);
        this.customizeJMenuItem(this.open_url_item);
        this.customizeJMenuItem(this.close_item);
        this.customizeJMenuItem(this.remove_root_item);
        this.customizeJMenuItem(this.remove_root_tri_item);
        this.customizeJMenuItem(this.tiny_fonts_item);
        this.customizeJMenuItem(this.small_fonts_item);
        this.customizeJMenuItem(this.medium_fonts_item);
        this.customizeJMenuItem(this.large_fonts_item);
        this.customizeJMenuItem(this.switch_colors_item);
        this.customizeJMenuItem(this.view_as_NH_item);
        this.customizeJMenuItem(this.view_as_NHX_item);
        this.customizeJMenuItem(this.about_item);
        this.customizeJMenuItem(this.help_item);
        this.customizeJMenuItem(this.find_item);
        this.customizeJMenuItem(this.find_reset_item);
        this.jmenubar.add(this.file_jmenu);
        this.jmenubar.add(this.edit_jmenu);
        this.jmenubar.add(this.search_jmenu);
        this.jmenubar.add(this.view_jmenu);
        this.jmenubar.add(this.options_jmenu);
        this.jmenubar.add(this.help_jmenu);
        this.setJMenuBar(this.jmenubar);
        this.contentpane = this.getContentPane();
        this.contentpane.setLayout(new BorderLayout());
        this.contentpane.add((Component)this.atvpanel, "Center");
        ((Component)this).setSize(640, 580);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ATVappletFrame.this.close();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ATVappletFrame.this.atvpanel.getATVgraphic().setParametersForPainting(ATVappletFrame.this.atvpanel.getATVgraphic().getWidth(), ATVappletFrame.this.atvpanel.getATVgraphic().getHeight());
            }
        });
        ((Component)this).setVisible(true);
    }

    private void about() {
        String string = "ATV (A Tree Viewer)\nVersion 1.91\n";
        string = String.valueOf(string) + "Copyright (C) 1999-2001 Washington University School of Medicine\n";
        string = String.valueOf(string) + "and Howard Hughes Medical Institute\n";
        string = String.valueOf(string) + "All Rights Reserved\n";
        string = String.valueOf(string) + "Author: Christian M. Zmasek\n";
        string = String.valueOf(string) + "Last modified: 10/08/01\n";
        string = String.valueOf(string) + "Reference: Zmasek C.M. and Eddy S.R. Bioinformatics, 17, 383 (2001)\n";
        string = String.valueOf(string) + "For more information & download:\n";
        string = String.valueOf(string) + "http://www.genetics.wustl.edu/eddy/atv/\n";
        string = String.valueOf(string) + "Comments: zmasek@genetics.wustl.edu";
        JOptionPane.showMessageDialog(this, string, "ATV JApplet (Java 1.2 or greater)", -1);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.reload_item) {
            this.reLoad();
        } else if (object == this.open_url_item) {
            this.openURL();
        } else if (object == this.close_item) {
            this.close();
        } else if (object == this.remove_root_item) {
            this.removeRoot();
        } else if (object == this.remove_root_tri_item) {
            this.removeRootTri();
        } else if (object == this.switch_colors_item) {
            this.switchColors();
        } else if (object == this.view_as_NH_item) {
            this.viewAsNH();
        } else if (object == this.view_as_NHX_item) {
            this.viewAsNHX();
        } else if (object == this.tiny_fonts_item) {
            this.atvpanel.getATVgraphic().tinyFonts();
            this.atvpanel.getATVgraphic().repaint();
        } else if (object == this.small_fonts_item) {
            this.atvpanel.getATVgraphic().smallFonts();
            this.atvpanel.getATVgraphic().repaint();
        } else if (object == this.medium_fonts_item) {
            this.atvpanel.getATVgraphic().mediumFonts();
            this.atvpanel.getATVgraphic().repaint();
        } else if (object == this.large_fonts_item) {
            this.atvpanel.getATVgraphic().largeFonts();
            this.atvpanel.getATVgraphic().repaint();
        } else if (object == this.about_item) {
            this.about();
        } else if (object == this.help_item) {
            this.help();
        } else if (object == this.find_item) {
            this.find();
        } else if (object == this.find_reset_item) {
            this.findReset();
        }
    }

    void close() {
        this.removeTextJFrame();
        this.atvpanel.terminate();
        this.contentpane.removeAll();
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void customizeJMenuItem(JMenuItem jMenuItem) {
        jMenuItem.setFont(menu_font);
        jMenuItem.setBackground(menu_background_color);
        jMenuItem.setForeground(menu_text_color);
        jMenuItem.addActionListener(this);
    }

    private void find() {
        if (this.atvpanel.getATVgraphic().getTree() == null || this.atvpanel.getATVgraphic().getTree().isEmpty()) {
            return;
        }
        String string = "String to search for in sequence and species names,\nEC numbers; or integer for taxonomy IDs:";
        String string2 = JOptionPane.showInputDialog(this, string, "Search", 3);
        if (string2 != null && !(string2 = string2.trim()).equals("")) {
            Vector vector = null;
            try {
                vector = this.atvpanel.getATVgraphic().getTree().findInNameSpecECid(string2);
            }
            catch (Exception exception) {
                System.err.println("Unexpected exception: " + exception);
            }
            if (vector != null && vector.size() > 0) {
                this.atvpanel.getATVgraphic().setFoundNodes(vector);
            } else {
                JOptionPane.showMessageDialog(this, "Could not find \"" + string2 + "\"", "Search", 0);
            }
        }
        this.contentpane.repaint();
    }

    private void findReset() {
        if (this.atvpanel.getATVgraphic().getTree() == null || this.atvpanel.getATVgraphic().getTree().isEmpty()) {
            return;
        }
        this.atvpanel.getATVgraphic().setFoundNodes(null);
        this.contentpane.repaint();
    }

    ATVjapplet getATVapplet() {
        return this.atvapplet;
    }

    ATVpanel getATVpanel() {
        return this.atvpanel;
    }

    private void help() {
        String string = "(Left) click on nodes of the tree to:\n";
        string = String.valueOf(string) + "o  Display and edit information of a node.\n";
        string = String.valueOf(string) + "    To edit information, box \"Editable\" needs to be checked.\n";
        string = String.valueOf(string) + "o  Collapse and uncollapse subtrees.\n";
        string = String.valueOf(string) + "o  Go to SWISS-PROT and display its entry for the corresponding sequence.\n";
        string = String.valueOf(string) + "    Only available in JApplet version.\n";
        string = String.valueOf(string) + "    Seq names need to be proper SWISS-PROT names for this to work.\n";
        string = String.valueOf(string) + "o  Place a root in the middle of the parent branch.\n";
        string = String.valueOf(string) + "o  Display a subtree.\n";
        string = String.valueOf(string) + "    To go back to the parent tree, click on the root node of the subtree.\n";
        string = String.valueOf(string) + "o  Swap the children of a node (a pure cosmetic operation).\n\n";
        string = String.valueOf(string) + "Right clicking always displays the information of a node.\n\n";
        string = String.valueOf(string) + "\"SaveAs\" \"Save\" save the (sub)tree which is currently shown in the frame.\n";
        string = String.valueOf(string) + "\"Print\" prints the (sub)tree which is currently shown in the frame.\n\n";
        string = String.valueOf(string) + "For more information: http://www.genetics.wustl.edu/eddy/atv/\n";
        string = String.valueOf(string) + "Email: zmasek@genetics.wustl.edu\n\n";
        string = String.valueOf(string) + "Remarks:\n";
        string = String.valueOf(string) + "o  ATV can deal with trees with an arbitrary number of \n";
        string = String.valueOf(string) + "    children per parent.\n";
        string = String.valueOf(string) + "o  The application version allows to copy to the clipboard \n";
        string = String.valueOf(string) + "    in the \"View\"|\"View as ...\" frame.\n";
        string = String.valueOf(string) + "    For security reasons, the JApplet is not allowed to do so.\n";
        string = String.valueOf(string) + "o  The JApplet can only connect to network ports on the server.\n";
        string = String.valueOf(string) + "    E.g. \"http://www.genetics.wustl.edu/\".\n";
        string = String.valueOf(string) + "    The application can connect to any host.\n";
        string = String.valueOf(string) + "o  \"Save\", \"SaveAs\", \"Print\", and \"Open\" are only available in the \n";
        string = String.valueOf(string) + "    application version.\n";
        string = String.valueOf(string) + "o  Changes made to a subtree affect this subtree and its subtrees,\n";
        string = String.valueOf(string) + "    but not any of its parent tree(s).\n";
        string = String.valueOf(string) + "o  ATV tries to detect whether the numerical values in a NH tree \n";
        string = String.valueOf(string) + "    are likely to be bootstrap values instead of branch length values.\n";
        JOptionPane.showMessageDialog(this, string, "Help", -1);
    }

    private void openURL() {
        URL uRL = null;
        Tree tree = null;
        String string = "Please enter a complete URL. Must refer to same server as provided this Applet.";
        String string2 = JOptionPane.showInputDialog(this, string, "Open URL to read a NH/NHX tree", 3);
        if (string2 != null && string2.length() > 4) {
            try {
                uRL = new URL(string2);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "ATVapplet: openURL(): Exception: " + exception, "Malformed URL", 0);
            }
            if (uRL != null) {
                try {
                    tree = TreeHelper.readNHtree(uRL);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, "ATVapplet: openURL(): \nException: " + exception, "Could not read Tree", 0);
                }
                if (tree != null) {
                    this.reload_tree_ = tree.copyTree();
                    this.removeTextJFrame();
                    this.atvpanel.terminate();
                    this.contentpane.removeAll();
                    this.atvpanel = new ATVpanel_applet(tree, this);
                    this.contentpane.add((Component)this.atvpanel, "Center");
                    ((Component)this).setVisible(true);
                    this.contentpane.repaint();
                    this.setTitle("ATV: " + uRL);
                    this.atvpanel.getATVcontrol().showWhole();
                }
            }
        }
    }

    private void reLoad() {
        if (this.reload_tree_ != null && !this.reload_tree_.isEmpty()) {
            Tree tree = this.reload_tree_.copyTree();
            this.removeTextJFrame();
            this.atvpanel.terminate();
            this.contentpane.removeAll();
            this.atvpanel = new ATVpanel_applet(tree, this);
            this.contentpane.add((Component)this.atvpanel, "Center");
            ((Component)this).setVisible(true);
            this.contentpane.repaint();
            this.atvpanel.getATVcontrol().showWhole();
        }
    }

    private void removeRoot() {
        this.atvpanel.getATVgraphic().removeRoot();
    }

    private void removeRootTri() {
        this.atvpanel.getATVgraphic().removeRootTri();
    }

    private void removeTextJFrame() {
        if (this.atvtextframe != null) {
            this.atvtextframe.close();
            this.atvtextframe = null;
        }
    }

    private void switchColors() {
        this.atvpanel.getATVgraphic().switchColors();
    }

    private void viewAsNH() {
        this.removeTextJFrame();
        if (this.atvpanel.getATVgraphic().getTree() == null) {
            return;
        }
        if (this.atvpanel.getATVgraphic().getTree().isEmpty()) {
            return;
        }
        this.atvtextframe = new ATVtextframe(this.atvpanel.getATVgraphic().getTree().toNewHampshire(false));
    }

    private void viewAsNHX() {
        this.removeTextJFrame();
        if (this.atvpanel.getATVgraphic().getTree() == null) {
            return;
        }
        if (this.atvpanel.getATVgraphic().getTree().isEmpty()) {
            return;
        }
        this.atvtextframe = new ATVtextframe(this.atvpanel.getATVgraphic().getTree().toNewHampshireX());
    }
}

