/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LightRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

class DirectionalLightRetained
extends LightRetained {
    static final int DIRECTION_CHANGED = 32;
    Vector3f direction = new Vector3f(0.0f, 0.0f, -1.0f);
    Vector3f xformDirection = new Vector3f(0.0f, 0.0f, -1.0f);

    DirectionalLightRetained() {
        this.nodeType = 6;
        this.lightType = 2;
        this.localBounds = new BoundingBox();
        ((BoundingBox)this.localBounds).setLower(1.0, 1.0, 1.0);
        ((BoundingBox)this.localBounds).setUpper(-1.0, -1.0, -1.0);
    }

    protected Object clone() {
        DirectionalLightRetained directionalLightRetained = (DirectionalLightRetained)super.clone();
        directionalLightRetained.direction = new Vector3f(this.direction);
        directionalLightRetained.xformDirection = new Vector3f(0.0f, 0.0f, -1.0f);
        return directionalLightRetained;
    }

    void getDirection(Vector3f vector3f) {
        vector3f.set((Tuple3f)this.direction);
    }

    void initDirection(float f, float f2, float f3) {
        this.direction.x = f;
        this.direction.y = f2;
        this.direction.z = f3;
    }

    void initDirection(Vector3f vector3f) {
        this.direction.set((Tuple3f)vector3f);
    }

    synchronized void initMirrorObject(LightRetained lightRetained) {
        super.initMirrorObject(lightRetained);
        DirectionalLightRetained directionalLightRetained = (DirectionalLightRetained)lightRetained;
        directionalLightRetained.direction = new Vector3f(this.direction);
        directionalLightRetained.lastLocalToVworld[0].transform(directionalLightRetained.direction, directionalLightRetained.xformDirection);
        directionalLightRetained.xformDirection.normalize();
    }

    void setDirection(float f, float f2, float f3) {
        this.setDirection(new Vector3f(f, f2, f3));
    }

    void setDirection(Vector3f vector3f) {
        this.initDirection(vector3f);
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 4224;
        j3dMessage.type = 19;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(32);
        j3dMessage.args[2] = this.inSharedGroup ? new Integer(this.numMirrorLights) : new Integer(1);
        j3dMessage.args[3] = this.mirrorLights.clone();
        j3dMessage.args[4] = new Vector3f(vector3f);
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    void update(int n, int n2, double d) {
        super.update(n, n2, d);
        this.updateLight(n, n2, this.color.x, this.color.y, this.color.z, this.xformDirection.x, this.xformDirection.y, this.xformDirection.z);
    }

    native void updateLight(int var1, int var2, float var3, float var4, float var5, float var6, float var7, float var8);

    void updateMirrorObject(Object[] objectArray) {
        int n = (Integer)objectArray[1];
        if ((n & 0x20) != 0) {
            int n2 = (Integer)objectArray[2];
            LightRetained[] lightRetainedArray = (LightRetained[])objectArray[3];
            int n3 = 0;
            while (n3 < n2) {
                if (lightRetainedArray[n3].nodeType == 6) {
                    DirectionalLightRetained directionalLightRetained = (DirectionalLightRetained)lightRetainedArray[n3];
                    directionalLightRetained.direction = (Vector3f)objectArray[4];
                    directionalLightRetained.lastLocalToVworld[0].transform(directionalLightRetained.direction, directionalLightRetained.xformDirection);
                    directionalLightRetained.xformDirection.normalize();
                }
                ++n3;
            }
        }
        super.updateMirrorObject(objectArray);
    }

    void updateTransformChange() {
        super.updateTransformChange();
        this.lastLocalToVworld[0].transform(this.direction, this.xformDirection);
        this.xformDirection.normalize();
    }
}

