/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.j3d.ColorInterpolator;
import javax.media.j3d.Group;
import javax.media.j3d.J3dNodeTable;
import javax.media.j3d.LightRetained;
import javax.media.j3d.Material;
import javax.media.j3d.PositionInterpolator;
import javax.media.j3d.PositionPathInterpolator;
import javax.media.j3d.RotPosPathInterpolator;
import javax.media.j3d.RotPosScalePathInterpolator;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.RotationPathInterpolator;
import javax.media.j3d.ScaleInterpolator;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.Switch;
import javax.media.j3d.SwitchValueInterpolator;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;

class J3dDataInputStream
extends DataInputStream {
    byte[] floatBuffer = null;
    byte[] doubleBuffer = null;
    byte[] intBuffer = null;
    byte[] shortBuffer = null;
    byte[] matrixBuffer = new byte[128];
    J3dNodeTable nodeTable = new J3dNodeTable();
    Hashtable addressTable = new Hashtable();
    Hashtable interpolatorTable = new Hashtable();

    J3dDataInputStream(InputStream inputStream) {
        super(inputStream);
    }

    void addAddress(String string, SceneGraphObject sceneGraphObject) {
        this.addressTable.put(string, sceneGraphObject);
    }

    void addInterpolatorTarget(Object object, String string) {
        this.interpolatorTable.put(object, string);
    }

    Hashtable getInterpolatorList() {
        return this.interpolatorTable;
    }

    int getNodeValue(Object object) {
        return this.nodeTable.getNodeValue(object);
    }

    Object getObject(int n) {
        return this.nodeTable.getObject(n);
    }

    SceneGraphObject getObjectFromAddress(String string) {
        try {
            return (SceneGraphObject)this.addressTable.get(string);
        }
        catch (Exception exception) {
            System.err.println("Exception in J3dDataInputStream.getObjectFromAddress: " + exception);
            return null;
        }
    }

    Hashtable getTargetList() {
        return this.addressTable;
    }

    void readArray(Object object) {
        if (object instanceof byte[]) {
            this.readByteArray((byte[])object);
        } else if (object instanceof int[]) {
            this.readIntArray((int[])object);
        } else if (object instanceof float[]) {
            this.readFloatArray((float[])object);
        } else if (object instanceof double[]) {
            this.readDoubleArray((double[])object);
        } else if (object instanceof short[]) {
            this.readShortArray((short[])object);
        }
    }

    void readByteArray(byte[] byArray) {
        try {
            this.read(byArray);
        }
        catch (Exception exception) {
            System.err.println("Exception in readByteArray: " + exception);
        }
    }

    Color3f readColor3f() {
        Color3f color3f = null;
        try {
            color3f = new Color3f(this.readFloat(), this.readFloat(), this.readFloat());
        }
        catch (Exception exception) {
            System.err.println("Exception in readColor3f: " + exception);
        }
        return color3f;
    }

    Color4f readColor4f() {
        Color4f color4f = null;
        try {
            color4f = new Color4f(this.readFloat(), this.readFloat(), this.readFloat(), this.readFloat());
        }
        catch (Exception exception) {
            System.err.println("Exception in readColor4f: " + exception);
        }
        return color4f;
    }

    void readDoubleArray(double[] dArray) {
        try {
            if (this.doubleBuffer == null || this.doubleBuffer.length < dArray.length * 8) {
                this.doubleBuffer = new byte[dArray.length * 8];
            }
            byte[] byArray = this.doubleBuffer;
            this.read(byArray, 0, dArray.length * 8);
            int n = 0;
            int n2 = 0;
            while (n2 < dArray.length) {
                dArray[n2] = Double.longBitsToDouble((long)(byArray[n++] & 0xFF) << 56 | (long)(byArray[n++] & 0xFF) << 48 | (long)(byArray[n++] & 0xFF) << 40 | (long)(byArray[n++] & 0xFF) << 32 | (long)(byArray[n++] & 0xFF) << 24 | (long)(byArray[n++] & 0xFF) << 16 | (long)(byArray[n++] & 0xFF) << 8 | (long)(byArray[n++] & 0xFF));
                ++n2;
            }
        }
        catch (Exception exception) {
            System.err.println("Exception in readDoubleArray: " + exception);
        }
    }

    void readFloatArray(float[] fArray) {
        try {
            if (fArray != null) {
                if (this.floatBuffer == null || this.floatBuffer.length < fArray.length * 4) {
                    this.floatBuffer = new byte[fArray.length * 4];
                }
                byte[] byArray = this.floatBuffer;
                this.read(byArray, 0, fArray.length * 4);
                int n = 0;
                int n2 = 0;
                while (n2 < fArray.length) {
                    fArray[n2] = Float.intBitsToFloat((byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF);
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Exception in readFloatArray: " + exception);
        }
    }

    void readIntArray(int[] nArray) {
        try {
            if (nArray != null) {
                if (this.intBuffer == null || this.intBuffer.length < nArray.length * 4) {
                    this.intBuffer = new byte[nArray.length * 4];
                }
                byte[] byArray = this.intBuffer;
                this.read(byArray, 0, nArray.length * 4);
                int n = 0;
                int n2 = 0;
                while (n2 < nArray.length) {
                    nArray[n2] = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Exception in readIntArray: " + exception);
        }
    }

    void readMatrix(double[] dArray) {
        try {
            byte[] byArray = this.matrixBuffer;
            this.read(byArray);
            int n = 0;
            int n2 = 0;
            while (n2 < 16) {
                dArray[n2] = Double.longBitsToDouble((long)(byArray[n++] & 0xFF) << 56 | (long)(byArray[n++] & 0xFF) << 48 | (long)(byArray[n++] & 0xFF) << 40 | (long)(byArray[n++] & 0xFF) << 32 | (long)(byArray[n++] & 0xFF) << 24 | (long)(byArray[n++] & 0xFF) << 16 | (long)(byArray[n++] & 0xFF) << 8 | (long)(byArray[n++] & 0xFF));
                ++n2;
            }
        }
        catch (Exception exception) {
            System.err.println("Exception in readDoubleArray: " + exception);
        }
    }

    void readShortArray(short[] sArray) {
        try {
            if (this.shortBuffer == null || this.shortBuffer.length < sArray.length * 2) {
                this.shortBuffer = new byte[sArray.length * 2];
            }
            byte[] byArray = this.shortBuffer;
            this.read(byArray, 0, sArray.length * 2);
            boolean bl = false;
            int n = 0;
            while (n < sArray.length) {
                sArray[n] = this.readShort();
                ++n;
            }
        }
        catch (Exception exception) {
            System.err.println("Exception in readByteArray: " + exception);
        }
    }

    Tuple3f readTuple3f() {
        Point3f point3f = null;
        try {
            point3f = new Point3f(this.readFloat(), this.readFloat(), this.readFloat());
        }
        catch (Exception exception) {
            System.err.println("Exception in readColor3f: " + exception);
        }
        return point3f;
    }

    void targetObjects() {
        Enumeration enumeration = this.interpolatorTable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            try {
                String string = (String)this.interpolatorTable.get(k);
                Object v = this.addressTable.get(string);
                if (k instanceof RotationInterpolator) {
                    ((RotationInterpolator)k).setTarget((TransformGroup)v);
                    continue;
                }
                if (k instanceof RotationPathInterpolator) {
                    ((RotationPathInterpolator)k).setTarget((TransformGroup)v);
                    continue;
                }
                if (k instanceof RotPosPathInterpolator) {
                    ((RotPosPathInterpolator)k).setTarget((TransformGroup)v);
                    continue;
                }
                if (k instanceof RotPosScalePathInterpolator) {
                    ((RotPosScalePathInterpolator)k).setTarget((TransformGroup)v);
                    continue;
                }
                if (k instanceof PositionPathInterpolator) {
                    ((PositionPathInterpolator)k).setTarget((TransformGroup)v);
                    continue;
                }
                if (k instanceof PositionInterpolator) {
                    ((PositionInterpolator)k).setTarget((TransformGroup)v);
                    continue;
                }
                if (k instanceof SwitchValueInterpolator) {
                    ((SwitchValueInterpolator)k).setTarget((Switch)v);
                    continue;
                }
                if (k instanceof ColorInterpolator) {
                    ((ColorInterpolator)k).setTarget((Material)v);
                    continue;
                }
                if (k instanceof ScaleInterpolator) {
                    ((ScaleInterpolator)k).setTarget((TransformGroup)v);
                    continue;
                }
                if (!(k instanceof LightRetained)) continue;
                ((LightRetained)k).addScope((Group)v);
            }
            catch (Exception exception) {
                System.err.println("Exception in J3dDataInputStream.targetObjects(): " + exception);
            }
        }
    }
}

