/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import com.sun.j3d.internal.Distance;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.PickCone;
import javax.media.j3d.PickCylinder;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public final class PickConeSegment
extends PickCone {
    Point3d end;

    public PickConeSegment() {
        this.end = new Point3d();
    }

    public PickConeSegment(Point3d point3d, Point3d point3d2, double d) {
        this.origin = new Point3d(point3d);
        this.end = new Point3d(point3d2);
        this.direction = new Vector3d();
        this.spreadAngle = d;
        this.calcDirection();
    }

    private void calcDirection() {
        this.direction.x = this.end.x - this.origin.x;
        this.direction.y = this.end.y - this.origin.y;
        this.direction.z = this.end.z - this.origin.z;
    }

    public void getEnd(Point3d point3d) {
        point3d.set((Tuple3d)this.end);
    }

    final boolean intersect(Bounds bounds, Point4d point4d) {
        Point4d point4d2 = new Point4d();
        Vector3d vector3d = new Vector3d();
        Point3d point3d = new Point3d();
        if (bounds instanceof BoundingSphere) {
            Point3d point3d2 = ((BoundingSphere)bounds).getCenter();
            double d = ((BoundingSphere)bounds).getRadius();
            double d2 = Distance.pointToSegment((Point3d)point3d2, (Point3d)this.origin, (Point3d)this.end, (Point3d)point3d, null);
            vector3d.sub((Tuple3d)point3d, (Tuple3d)this.origin);
            double d3 = vector3d.length();
            double d4 = this.getRadius(d3);
            return d2 <= d * d + d4 * d4;
        }
        if (bounds instanceof BoundingBox) {
            Point3d point3d3 = new Point3d();
            ((BoundingBox)bounds).getLower(point3d3);
            Point3d point3d4 = ((BoundingBox)bounds).getCenter();
            double d = (point3d4.x - point3d3.x) * (point3d4.x - point3d3.x) + (point3d4.y - point3d3.y) * (point3d4.y - point3d3.y) + (point3d4.z - point3d3.z) * (point3d4.z - point3d3.z);
            double d5 = Distance.pointToSegment((Point3d)point3d4, (Point3d)this.origin, (Point3d)this.end, (Point3d)point3d, null);
            vector3d.sub((Tuple3d)point3d, (Tuple3d)this.origin);
            double d6 = vector3d.length();
            double d7 = this.getRadius(d6);
            if (d5 > d + d7 * d7) {
                return false;
            }
            if (d5 < d7 * d7) {
                return true;
            }
            if (((BoundingBox)bounds).intersect(this.origin, this.direction, point4d2)) {
                return true;
            }
            Point3d point3d5 = new Point3d();
            ((BoundingBox)bounds).getUpper(point3d5);
            Point3d[][] point3dArrayArray = new Point3d[][]{{point3d5, new Point3d(point3d3.x, point3d5.y, point3d5.z)}, {new Point3d(point3d3.x, point3d5.y, point3d5.z), new Point3d(point3d3.x, point3d3.y, point3d5.z)}, {new Point3d(point3d3.x, point3d3.y, point3d5.z), new Point3d(point3d5.x, point3d3.y, point3d5.z)}, {new Point3d(point3d5.x, point3d3.y, point3d5.z), point3d5}, {point3d3, new Point3d(point3d3.x, point3d5.y, point3d3.z)}, {new Point3d(point3d3.x, point3d5.y, point3d3.z), new Point3d(point3d5.x, point3d5.y, point3d3.z)}, {new Point3d(point3d5.x, point3d5.y, point3d3.z), new Point3d(point3d5.x, point3d3.y, point3d3.z)}, {new Point3d(point3d5.x, point3d3.y, point3d3.z), point3d3}, {point3d3, new Point3d(point3d3.x, point3d3.y, point3d5.z)}, {new Point3d(point3d3.x, point3d5.y, point3d3.z), new Point3d(point3d3.x, point3d5.y, point3d5.z)}, {new Point3d(point3d5.x, point3d5.y, point3d3.z), new Point3d(point3d5.x, point3d5.y, point3d5.z)}, {new Point3d(point3d5.x, point3d3.y, point3d3.z), new Point3d(point3d5.x, point3d3.y, point3d5.z)}};
            int n = 0;
            while (n < point3dArrayArray.length) {
                double d8 = Distance.segmentToSegment((Point3d)this.origin, (Point3d)this.end, (Point3d)point3dArrayArray[n][0], (Point3d)point3dArrayArray[n][1], (Point3d)point3d, null, null);
                vector3d.sub((Tuple3d)point3d, (Tuple3d)this.origin);
                d6 = vector3d.length();
                d7 = this.getRadius(d6);
                if (d8 <= d7 * d7) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        if (bounds instanceof BoundingPolytope) {
            Point3d point3d6 = new Point3d();
            BoundingSphere boundingSphere = new BoundingSphere(bounds);
            boundingSphere.getCenter(point3d6);
            double d = boundingSphere.getRadius();
            double d9 = Distance.pointToSegment((Point3d)point3d6, (Point3d)this.origin, (Point3d)this.end, (Point3d)point3d, null);
            vector3d.sub((Tuple3d)point3d, (Tuple3d)this.origin);
            double d10 = vector3d.length();
            double d11 = this.getRadius(d10);
            if (d9 > d * d + d11 * d11) {
                return false;
            }
            if (bounds.intersect(this.origin, this.direction, point4d2)) {
                return true;
            }
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            Point3d point3d7 = new Point3d();
            int n = 0;
            while (n < boundingPolytope.nVerts) {
                int n2 = n;
                while (n < boundingPolytope.nVerts) {
                    point3d7.x = (boundingPolytope.verts[n].x + boundingPolytope.verts[n2].x) * 0.5;
                    point3d7.y = (boundingPolytope.verts[n].y + boundingPolytope.verts[n2].y) * 0.5;
                    point3d7.z = (boundingPolytope.verts[n].z + boundingPolytope.verts[n2].z) * 0.5;
                    if (PickCylinder.pointInPolytope(boundingPolytope, point3d7.x, point3d7.y, point3d7.z)) {
                        double d12 = Distance.segmentToSegment((Point3d)this.origin, (Point3d)this.end, (Point3d)boundingPolytope.verts[n], (Point3d)boundingPolytope.verts[n2], (Point3d)point3d, null, null);
                        vector3d.sub((Tuple3d)point3d, (Tuple3d)this.origin);
                        d10 = vector3d.length();
                        d11 = this.getRadius(d10);
                        if (d12 <= d11 * d11) {
                            return true;
                        }
                    }
                    ++n;
                }
                ++n;
            }
            return false;
        }
        return false;
    }

    public void set(Point3d point3d, Point3d point3d2, double d) {
        this.origin.set((Tuple3d)point3d);
        this.end.set((Tuple3d)point3d2);
        this.spreadAngle = d;
        this.calcDirection();
    }
}

