/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Enumeration;
import javax.media.j3d.Appearance;
import javax.media.j3d.Bounds;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.Geometry;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Leaf;
import javax.media.j3d.Node;
import javax.media.j3d.PickPoint;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickShape;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Shape3DRetained;

public class Shape3D
extends Leaf {
    public static final int ALLOW_GEOMETRY_READ = 12;
    public static final int ALLOW_GEOMETRY_WRITE = 13;
    public static final int ALLOW_APPEARANCE_READ = 14;
    public static final int ALLOW_APPEARANCE_WRITE = 15;
    public static final int ALLOW_COLLISION_BOUNDS_READ = 16;
    public static final int ALLOW_COLLISION_BOUNDS_WRITE = 17;
    public static final int ALLOW_APPEARANCE_OVERRIDE_READ = 18;
    public static final int ALLOW_APPEARANCE_OVERRIDE_WRITE = 19;

    public Shape3D() {
    }

    public Shape3D(Geometry geometry) {
        ((Shape3DRetained)this.retained).setGeometry(geometry, 0);
    }

    public Shape3D(Geometry geometry, Appearance appearance) {
        ((Shape3DRetained)this.retained).setGeometry(geometry, 0);
        ((Shape3DRetained)this.retained).setAppearance(appearance);
    }

    public void addGeometry(Geometry geometry) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D2"));
        }
        ((Shape3DRetained)this.retained).addGeometry(geometry);
    }

    public Node cloneNode(boolean bl) {
        Shape3D shape3D = new Shape3D();
        shape3D.duplicateNode(this, bl);
        return shape3D;
    }

    void createRetained() {
        this.retained = new Shape3DRetained();
        this.retained.setSource(this);
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        Shape3DRetained shape3DRetained = (Shape3DRetained)node.retained;
        Shape3DRetained shape3DRetained2 = (Shape3DRetained)this.retained;
        shape3DRetained2.setAppearance((Appearance)this.getNodeComponent(shape3DRetained.getAppearance(), bl, node.nodeHashtable));
        int n = shape3DRetained.numGeometries();
        if (n > 0) {
            shape3DRetained2.setGeometry((Geometry)this.getNodeComponent(shape3DRetained.getGeometry(0), bl, node.nodeHashtable), 0);
            int n2 = 1;
            while (n2 < n) {
                shape3DRetained2.addGeometry((Geometry)this.getNodeComponent(shape3DRetained.getGeometry(n2), bl, node.nodeHashtable));
                ++n2;
            }
        }
        shape3DRetained2.setCollisionBounds(shape3DRetained.getCollisionBounds());
    }

    public void duplicateNode(Node node, boolean bl) {
        this.checkDuplicateNode(node, bl);
    }

    public Enumeration getAllGeometries() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D3"));
        }
        return ((Shape3DRetained)this.retained).getAllGeometries();
    }

    public Appearance getAppearance() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D5"));
        }
        return ((Shape3DRetained)this.retained).getAppearance();
    }

    public boolean getAppearanceOverrideEnable() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D9"));
        }
        return ((Shape3DRetained)this.retained).getAppearanceOverrideEnable();
    }

    public Bounds getCollisionBounds() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D1"));
        }
        return ((Shape3DRetained)this.retained).getCollisionBounds();
    }

    public Geometry getGeometry() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D3"));
        }
        return ((Shape3DRetained)this.retained).getGeometry(0);
    }

    public Geometry getGeometry(int n) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D3"));
        }
        return ((Shape3DRetained)this.retained).getGeometry(n);
    }

    public void insertGeometry(Geometry geometry, int n) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D2"));
        }
        ((Shape3DRetained)this.retained).insertGeometry(geometry, n);
    }

    public boolean intersect(SceneGraphPath sceneGraphPath, PickRay pickRay, double[] dArray) {
        if (this.isLiveOrCompiled() && !((Shape3DRetained)this.retained).allowIntersect()) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D6"));
        }
        return ((Shape3DRetained)this.retained).intersect(sceneGraphPath, pickRay, dArray);
    }

    public boolean intersect(SceneGraphPath sceneGraphPath, PickShape pickShape) {
        if (this.isLiveOrCompiled() && !((Shape3DRetained)this.retained).allowIntersect()) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D6"));
        }
        if (pickShape instanceof PickPoint) {
            throw new IllegalArgumentException(J3dI18N.getString("Shape3D7"));
        }
        return ((Shape3DRetained)this.retained).intersect(sceneGraphPath, pickShape);
    }

    public int numGeometries() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D3"));
        }
        return ((Shape3DRetained)this.retained).numGeometries();
    }

    public void removeGeometry(int n) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D2"));
        }
        ((Shape3DRetained)this.retained).removeGeometry(n);
    }

    public void setAppearance(Appearance appearance) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D4"));
        }
        ((Shape3DRetained)this.retained).setAppearance(appearance);
    }

    public void setAppearanceOverrideEnable(boolean bl) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D8"));
        }
        ((Shape3DRetained)this.retained).setAppearanceOverrideEnable(bl);
    }

    public void setCollisionBounds(Bounds bounds) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D0"));
        }
        ((Shape3DRetained)this.retained).setCollisionBounds(bounds);
    }

    public void setGeometry(Geometry geometry) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D2"));
        }
        ((Shape3DRetained)this.retained).setGeometry(geometry, 0);
    }

    public void setGeometry(Geometry geometry, int n) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D2"));
        }
        ((Shape3DRetained)this.retained).setGeometry(geometry, n);
    }
}

