/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.GeometryArray;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.TriangleArrayRetained;

public class TriangleArray
extends GeometryArray {
    TriangleArray() {
    }

    public TriangleArray(int n, int n2) {
        super(n, n2);
        if (n < 3 || n % 3 != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("TriangleArray0"));
        }
    }

    public TriangleArray(int n, int n2, int n3, int[] nArray) {
        super(n, n2, n3, nArray);
        if (n < 3 || n % 3 != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("TriangleArray0"));
        }
    }

    public NodeComponent cloneNodeComponent() {
        TriangleArray triangleArray;
        TriangleArrayRetained triangleArrayRetained = (TriangleArrayRetained)this.retained;
        int n = triangleArrayRetained.getTexCoordSetCount();
        if (n == 0) {
            triangleArray = new TriangleArray(triangleArrayRetained.getVertexCount(), triangleArrayRetained.getVertexFormat());
        } else {
            int[] nArray = new int[triangleArrayRetained.getTexCoordSetMapLength()];
            triangleArrayRetained.getTexCoordSetMap(nArray);
            triangleArray = new TriangleArray(triangleArrayRetained.getVertexCount(), triangleArrayRetained.getVertexFormat(), n, nArray);
        }
        triangleArray.duplicateNodeComponent(this);
        return triangleArray;
    }

    void createRetained() {
        this.retained = new TriangleArrayRetained();
        this.retained.setSource(this);
    }
}

