/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BehaviorStructure;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.UnorderList;
import javax.media.j3d.VirtualUniverse;
import javax.media.j3d.WakeupCriterion;

public final class WakeupOnElapsedFrames
extends WakeupCriterion {
    boolean passive;
    int frameCount;
    int countdown;

    public WakeupOnElapsedFrames(int n) {
        this(n, false);
    }

    public WakeupOnElapsedFrames(int n, boolean bl) {
        if (n < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("WakeupOnElapsedFrames0"));
        }
        this.frameCount = n;
        this.passive = bl;
    }

    void addBehaviorCondition(BehaviorStructure behaviorStructure) {
        this.countdown = this.frameCount;
        UnorderList unorderList = behaviorStructure.wakeupOnElapsedFrames;
        synchronized (unorderList) {
            behaviorStructure.wakeupOnElapsedFrames.add(this);
            if (!this.passive) {
                ++behaviorStructure.activeWakeupOnFrameCount;
            }
        }
        VirtualUniverse.mc.sendRunMessage(behaviorStructure.universe, 256);
    }

    public int getElapsedFrameCount() {
        return this.frameCount;
    }

    public boolean isPassive() {
        return this.passive;
    }

    void newFrame() {
        if (this.countdown == 0) {
            this.setTriggered();
        } else {
            --this.countdown;
        }
    }

    void removeBehaviorCondition(BehaviorStructure behaviorStructure) {
        UnorderList unorderList = behaviorStructure.wakeupOnElapsedFrames;
        synchronized (unorderList) {
            behaviorStructure.wakeupOnElapsedFrames.remove(this);
            if (!this.passive) {
                --behaviorStructure.activeWakeupOnFrameCount;
            }
        }
    }
}

