/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Material;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;

public class Text2D
extends Shape3D {
    private static Hashtable metricsTable = new Hashtable();
    float rectangleScaleFactor = 0.00390625f;
    Color3f color = new Color3f();
    String fontName;
    int fontSize;
    int fontStyle;

    public Text2D(String string, Color3f color3f, String string2, int n, int n2) {
        this.color.set((Tuple3f)color3f);
        this.fontName = string2;
        this.fontSize = n;
        this.fontStyle = n2;
        this.updateText2D(string, color3f, string2, n, n2);
    }

    public float getRectangleScaleFactor() {
        return this.rectangleScaleFactor;
    }

    public void setRectangleScaleFactor(float f) {
        this.rectangleScaleFactor = f;
    }

    public void setString(String string) {
        this.updateText2D(string, this.color, this.fontName, this.fontSize, this.fontStyle);
    }

    private Appearance setupAppearance(Texture2D texture2D) {
        TransparencyAttributes transparencyAttributes = new TransparencyAttributes();
        transparencyAttributes.setTransparencyMode(2);
        transparencyAttributes.setTransparency(0.0f);
        Appearance appearance = new Appearance();
        appearance.setTransparencyAttributes(transparencyAttributes);
        appearance.setTexture((Texture)texture2D);
        Material material = new Material();
        material.setLightingEnable(false);
        appearance.setMaterial(material);
        return appearance;
    }

    private QuadArray setupGeometry(int n, int n2) {
        float f = 0.0f;
        float f2 = (float)n * this.rectangleScaleFactor;
        float f3 = (float)n2 * this.rectangleScaleFactor;
        float[] fArray = new float[12];
        fArray[0] = f2;
        fArray[2] = f;
        fArray[3] = f2;
        fArray[4] = f3;
        fArray[5] = f;
        fArray[7] = f3;
        fArray[8] = f;
        fArray[11] = f;
        float[] fArray2 = fArray;
        float[] fArray3 = new float[8];
        fArray3[1] = -1.0f;
        fArray3[4] = -1.0f;
        fArray3[6] = -1.0f;
        fArray3[7] = -1.0f;
        float[] fArray4 = fArray3;
        QuadArray quadArray = new QuadArray(4, 33);
        quadArray.setCoordinates(0, fArray2);
        quadArray.setTextureCoordinates(0, fArray4);
        return quadArray;
    }

    private BufferedImage setupImage(String string, Color3f color3f, String string2, int n, int n2) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Font font = new Font(string2, n2, n);
        FontMetrics fontMetrics = (FontMetrics)metricsTable.get(font);
        if (fontMetrics == null) {
            fontMetrics = toolkit.getFontMetrics(font);
            metricsTable.put(font, fontMetrics);
        }
        int n3 = fontMetrics.stringWidth(string);
        int n4 = fontMetrics.getMaxDescent();
        int n5 = fontMetrics.getMaxAscent();
        int n6 = fontMetrics.getLeading();
        int n7 = n4 + n5;
        int n8 = 1;
        int n9 = 1;
        while (n9 < 32) {
            if (n3 <= (n8 *= 2)) break;
            ++n9;
        }
        n3 = Math.max(n3, n8);
        n8 = 1;
        int n10 = 1;
        while (n10 < 32) {
            if (n7 <= (n8 *= 2)) break;
            ++n10;
        }
        n7 = Math.max(n7, n8);
        BufferedImage bufferedImage = new BufferedImage(n3, n7, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        Color color = new Color(0.0f, 0.0f, 0.0f, 0.0f);
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, n3, n7);
        graphics2D.setFont(font);
        Color color2 = new Color(color3f.x, color3f.y, color3f.z, 1.0f);
        graphics2D.setColor(color2);
        ((Graphics)graphics2D).drawString(string, 0, n7 - n4);
        return bufferedImage;
    }

    private Texture2D setupTexture(BufferedImage bufferedImage) {
        ImageComponent2D imageComponent2D = new ImageComponent2D(2, bufferedImage);
        Texture2D texture2D = new Texture2D(1, 6, bufferedImage.getWidth(), bufferedImage.getHeight());
        texture2D.setMinFilter(3);
        texture2D.setMagFilter(3);
        texture2D.setImage(0, (ImageComponent)imageComponent2D);
        texture2D.setEnable(true);
        return texture2D;
    }

    private void updateText2D(String string, Color3f color3f, String string2, int n, int n2) {
        BufferedImage bufferedImage = this.setupImage(string, color3f, string2, n, n2);
        Texture2D texture2D = this.setupTexture(bufferedImage);
        QuadArray quadArray = this.setupGeometry(bufferedImage.getWidth(), bufferedImage.getHeight());
        Appearance appearance = this.setupAppearance(texture2D);
        this.setGeometry((Geometry)quadArray);
        this.setAppearance(appearance);
    }
}

