/*
 * Decompiled with CFR 0.152.
 */
package forester.atv_awt;

import forester.atv_awt.ATVpanel;
import forester.atv_awt.Message;
import forester.tree.Tree;
import forester.tree.TreeHelper;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;

public class ATVframe
extends Frame
implements ActionListener {
    private Tree reload_tree_ = null;
    private File treefile = null;
    private MenuBar menubar;
    private Menu file_jmenu;
    private Menu edit_jmenu;
    private Menu view_jmenu;
    private Menu options_jmenu;
    private Menu help_jmenu;
    private MenuItem open_item;
    private MenuItem open_url_item;
    private MenuItem save_item;
    private MenuItem saveas_item;
    private MenuItem close_item;
    private MenuItem exit_item;
    private MenuItem reload_item;
    private MenuItem remove_root_item;
    private MenuItem remove_root_tri_item;
    private MenuItem tiny_fonts_item;
    private MenuItem small_fonts_item;
    private MenuItem medium_fonts_item;
    private MenuItem large_fonts_item;
    private MenuItem switch_colors_item;
    private MenuItem view_as_NH_item;
    private MenuItem view_as_NHX_item;
    private MenuItem about_item;
    private MenuItem help_item;
    ATVpanel atvpanel;
    private Container contentpane;
    Dialog d;
    TextField url_tf;
    private String url_string = "http://";
    private static final Color menu_background_color = new Color(215, 215, 215);
    private static final Color menu_text_color = new Color(0, 0, 0);
    private static final Font menu_font = new Font("SansSerif", 0, 10);
    private static final int FRAME_X_SIZE = 640;
    private static final int FRAME_Y_SIZE = 580;

    public ATVframe(Tree tree) {
        ((Component)this).setVisible(false);
        if (tree != null && !tree.isEmpty()) {
            tree.adjustNodeCount(true);
            tree.recalculateAndReset();
            this.reload_tree_ = tree.copyTree();
        }
        this.setTitle("ATV");
        this.atvpanel = new ATVpanel(tree);
        this.menubar = new MenuBar();
        this.file_jmenu = new Menu("File");
        this.edit_jmenu = new Menu("Edit");
        this.view_jmenu = new Menu("View");
        this.options_jmenu = new Menu("Options");
        this.help_jmenu = new Menu("Help");
        this.file_jmenu.setFont(menu_font);
        this.edit_jmenu.setFont(menu_font);
        this.view_jmenu.setFont(menu_font);
        this.options_jmenu.setFont(menu_font);
        this.help_jmenu.setFont(menu_font);
        this.reload_item = new MenuItem("Reload");
        this.file_jmenu.add(this.reload_item);
        this.file_jmenu.addSeparator();
        this.open_item = new MenuItem("Open");
        this.file_jmenu.add(this.open_item);
        this.open_url_item = new MenuItem("Open URL to read a NH/NHX tree");
        this.file_jmenu.add(this.open_url_item);
        this.saveas_item = new MenuItem("Save As");
        this.file_jmenu.add(this.saveas_item);
        this.save_item = new MenuItem("Save");
        this.file_jmenu.add(this.save_item);
        this.file_jmenu.addSeparator();
        this.close_item = new MenuItem("Close");
        this.file_jmenu.add(this.close_item);
        this.file_jmenu.addSeparator();
        this.exit_item = new MenuItem("Exit");
        this.file_jmenu.add(this.exit_item);
        this.remove_root_item = new MenuItem("Remove root");
        this.edit_jmenu.add(this.remove_root_item);
        this.remove_root_tri_item = new MenuItem("Remove root and trifurcate");
        this.edit_jmenu.add(this.remove_root_tri_item);
        this.switch_colors_item = new MenuItem("Switch colors");
        this.options_jmenu.add(this.switch_colors_item);
        this.options_jmenu.addSeparator();
        this.tiny_fonts_item = new MenuItem("Tiny fonts");
        this.options_jmenu.add(this.tiny_fonts_item);
        this.small_fonts_item = new MenuItem("Small fonts");
        this.options_jmenu.add(this.small_fonts_item);
        this.medium_fonts_item = new MenuItem("Medium fonts");
        this.options_jmenu.add(this.medium_fonts_item);
        this.large_fonts_item = new MenuItem("Large fonts");
        this.options_jmenu.add(this.large_fonts_item);
        this.view_as_NH_item = new MenuItem("View as NH");
        this.view_jmenu.add(this.view_as_NH_item);
        this.view_as_NHX_item = new MenuItem("View as NHX");
        this.view_jmenu.add(this.view_as_NHX_item);
        this.help_item = new MenuItem("Help");
        this.help_jmenu.add(this.help_item);
        this.about_item = new MenuItem("About");
        this.help_jmenu.add(this.about_item);
        this.customizeMenuItem(this.reload_item);
        this.customizeMenuItem(this.open_item);
        this.customizeMenuItem(this.open_url_item);
        this.customizeMenuItem(this.save_item);
        this.customizeMenuItem(this.saveas_item);
        this.customizeMenuItem(this.close_item);
        this.customizeMenuItem(this.exit_item);
        this.customizeMenuItem(this.remove_root_item);
        this.customizeMenuItem(this.remove_root_tri_item);
        this.customizeMenuItem(this.tiny_fonts_item);
        this.customizeMenuItem(this.small_fonts_item);
        this.customizeMenuItem(this.medium_fonts_item);
        this.customizeMenuItem(this.large_fonts_item);
        this.customizeMenuItem(this.switch_colors_item);
        this.customizeMenuItem(this.view_as_NH_item);
        this.customizeMenuItem(this.view_as_NHX_item);
        this.customizeMenuItem(this.about_item);
        this.customizeMenuItem(this.help_item);
        this.menubar.add(this.file_jmenu);
        this.menubar.add(this.edit_jmenu);
        this.menubar.add(this.view_jmenu);
        this.menubar.add(this.options_jmenu);
        this.menubar.add(this.help_jmenu);
        this.setMenuBar(this.menubar);
        this.setLayout(new BorderLayout());
        this.add((Component)this.atvpanel, "Center");
        ((Component)this).setSize(640, 580);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ATVframe.this.close();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ATVframe.this.atvpanel.getATVgraphic().setParametersForPainting(ATVframe.this.atvpanel.getATVgraphic().getSize().width, ATVframe.this.atvpanel.getATVgraphic().getSize().height);
            }
        });
        ((Component)this).setVisible(true);
    }

    private void about() {
        this.d = new Dialog(this, "ATV application (AWT Version)", true);
        this.d.setLayout(new BorderLayout());
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        panel.setLayout(new GridLayout(14, 1));
        panel2.setLayout(new FlowLayout(1));
        panel.add(new Label("ATV (A Tree Viewer) Version AWT 1.6", 1));
        panel.add(new Label("Copyright (C) 1999-2001 Washington University School of Medicine", 1));
        panel.add(new Label("and Howard Hughes Medical Institute", 1));
        panel.add(new Label("All Rights Reserved", 1));
        panel.add(new Label("Author: Christian M. Zmasek", 1));
        panel.add(new Label("Last modified: 07/03/01", 1));
        panel.add(new Label("Reference: Zmasek C.M. and Eddy S.R. Bioinformatics, 17, 383 (2001)", 1));
        panel.add(new Label("THIS AWT VERSION OF THE APPLICATION (\"ATVapp_awt\")", 1));
        panel.add(new Label("IS NOT BEING SUPPORTED ANYMORE.", 1));
        panel.add(new Label("PLEASE USE THE \"SWING\" (Java 1.2) VERSION (\"ATVapp\").", 1));
        panel.add(new Label("For more information & download:", 1));
        panel.add(new Label("http://www.genetics.wustl.edu/eddy/atv/", 1));
        panel.add(new Label("Comments: zmasek@genetics.wustl.edu", 1));
        Button button = new Button("OK");
        panel2.add(button);
        this.d.add((Component)panel, "Center");
        this.d.add((Component)panel2, "South");
        ((Component)this.d).setSize(430, 300);
        this.d.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ATVframe.this.d.dispose();
            }
        });
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ATVframe.this.d.dispose();
            }
        });
        this.d.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.reload_item) {
            this.reLoad();
        } else if (object == this.open_item) {
            this.openFile();
        } else if (object == this.open_url_item) {
            this.openURL();
        } else if (object == this.save_item) {
            this.save(this.atvpanel.getATVgraphic().getTree());
        } else if (object == this.saveas_item) {
            this.saveAs(this.atvpanel.getATVgraphic().getTree());
        } else if (object == this.close_item) {
            this.close();
        } else if (object == this.exit_item) {
            this.exit();
        } else if (object == this.remove_root_item) {
            this.removeRoot();
        } else if (object == this.remove_root_tri_item) {
            this.removeRootTri();
        } else if (object == this.switch_colors_item) {
            this.switchColors();
        } else if (object == this.tiny_fonts_item) {
            this.atvpanel.getATVgraphic().tinyFonts();
            this.atvpanel.getATVgraphic().repaint();
        } else if (object == this.small_fonts_item) {
            this.atvpanel.getATVgraphic().smallFonts();
            this.atvpanel.getATVgraphic().repaint();
        } else if (object == this.medium_fonts_item) {
            this.atvpanel.getATVgraphic().mediumFonts();
            this.atvpanel.getATVgraphic().repaint();
        } else if (object == this.large_fonts_item) {
            this.atvpanel.getATVgraphic().largeFonts();
            this.atvpanel.getATVgraphic().repaint();
        } else if (object == this.view_as_NH_item) {
            this.viewAsNH();
        } else if (object == this.view_as_NHX_item) {
            this.viewAsNHX();
        } else if (object == this.about_item) {
            this.about();
        } else if (object == this.help_item) {
            this.help();
        }
    }

    private void close() {
        this.atvpanel.terminate();
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void customizeMenuItem(MenuItem menuItem) {
        menuItem.setFont(menu_font);
        menuItem.addActionListener(this);
    }

    void doOpenURL(String string) {
        this.url_string = string;
        boolean bl = false;
        URL uRL = null;
        Tree tree = null;
        if (this.url_string != null && this.url_string.length() > 4) {
            Message message;
            try {
                uRL = new URL(this.url_string);
            }
            catch (Exception exception) {
                message = new Message((Frame)this, "Exception during File|Open URL", String.valueOf(String.valueOf(exception)) + "\nCould not create URL from:\n" + this.url_string);
            }
            if (uRL != null) {
                try {
                    tree = TreeHelper.readNHtree(uRL);
                }
                catch (Exception exception) {
                    bl = true;
                    message = new Message((Frame)this, "Exception during File|Open URL", String.valueOf(String.valueOf(exception)) + "\nCould not read from URL:\n" + uRL);
                }
                if (!bl && tree != null && !tree.isEmpty()) {
                    this.atvpanel.terminate();
                    this.setTitle("ATV: " + uRL);
                    tree.adjustNodeCount(true);
                    tree.recalculateAndReset();
                    this.reload_tree_ = tree.copyTree();
                    this.atvpanel.getATVgraphic().setTree(tree);
                    this.atvpanel.getATVgraphic().setPropertiesForPainting(tree);
                    this.atvpanel.getATVcontrol().setCheckBoxes();
                    this.atvpanel.getATVcontrol().showWhole();
                }
            }
        }
    }

    private void exit() {
        System.exit(0);
    }

    private void help() {
        String string = "THIS AWT VERSION OF THE APPLICATION (\"ATVapp_awt\")\n";
        string = String.valueOf(string) + "IS NOT BEING SUPPORTED ANYMORE.\n";
        string = String.valueOf(string) + "PLEASE USE THE \"SWING\" (Java 1.2) VERSION (\"ATVapp\").\n\n";
        string = String.valueOf(string) + "Click on nodes of the tree to:\n";
        string = String.valueOf(string) + "- Display and edit information of a node.\n";
        string = String.valueOf(string) + "   To edit information, box \"Editable\" needs to be checked.\n";
        string = String.valueOf(string) + "- Collapse and uncollapse subtrees.\n";
        string = String.valueOf(string) + "- Go to SWISS-PROT and display its entry for the corresponding sequence.\n";
        string = String.valueOf(string) + "   Only available in Applet version.\n";
        string = String.valueOf(string) + "   Seq names need to be proper SWISS-PROT names for this to work.\n";
        string = String.valueOf(string) + "- Place a root in the middle of the parent branch.\n";
        string = String.valueOf(string) + "- Display a subtree.\n";
        string = String.valueOf(string) + "   To go back to the parent tree, click on the root node of the subtree.\n";
        string = String.valueOf(string) + "- Swap the children of a node (a pure cosmetic operation).\n\n";
        string = String.valueOf(string) + "\"SaveAs\" \"Save\" save the (sub)tree which is currently shown in the frame.\n";
        string = String.valueOf(string) + "For more information: http://www.genetics.wustl.edu/eddy/atv/\n";
        string = String.valueOf(string) + "Email: zmasek@genetics.wustl.edu\n\n";
        string = String.valueOf(string) + "Remarks:\n";
        string = String.valueOf(string) + "- This software can deal with trees with an arbitrary number of \n";
        string = String.valueOf(string) + "   children per parent.\n";
        string = String.valueOf(string) + "- The Applet can only connect to network ports on the server.\n";
        string = String.valueOf(string) + "   E.g. \"http://www.genetics.wustl.edu/\".\n";
        string = String.valueOf(string) + "   The application can connect to any host.\n";
        string = String.valueOf(string) + "- \"Save\", \"SaveAs\", and \"Open\" are only available in the \n";
        string = String.valueOf(string) + "   application version.\n";
        string = String.valueOf(string) + "- Changes made to a subtree affect this subtree and its subtrees,\n";
        string = String.valueOf(string) + "   but not any of its parent tree(s).\n";
        string = String.valueOf(string) + "- This software is able to detect whether the numerical values in a NH tree \n";
        string = String.valueOf(string) + "   are likely to be bootstrap values instead of branch length values.\n";
        Message message = new Message((Frame)this, "ATV application (AWT Version)", string);
    }

    private void openFile() {
        File file;
        boolean bl = false;
        Tree tree = null;
        FileDialog fileDialog = new FileDialog((Frame)this, "Open File", 0);
        fileDialog.setDirectory("");
        fileDialog.show();
        String string = fileDialog.getDirectory();
        String string2 = this.stripStars(fileDialog.getFile());
        if (string != null && string2 != null && (file = new File(string, string2)) != null) {
            try {
                tree = TreeHelper.readNHtree(file);
            }
            catch (Exception exception) {
                bl = true;
                Message message = new Message((Frame)this, "Exception during File|Open", exception.toString());
            }
            if (!bl && tree != null && !tree.isEmpty()) {
                this.treefile = file;
                this.atvpanel.terminate();
                this.setTitle("ATV: " + file);
                tree.adjustNodeCount(true);
                tree.recalculateAndReset();
                this.reload_tree_ = tree.copyTree();
                this.atvpanel.getATVgraphic().setTree(tree);
                this.atvpanel.getATVgraphic().setPropertiesForPainting(tree);
                this.atvpanel.getATVcontrol().setCheckBoxes();
                this.atvpanel.getATVcontrol().showWhole();
            }
        }
    }

    private void openURL() {
        String string = "Please enter a complete URL";
        this.d = new Dialog(this, "Open URL to read a NH/NHX tree", true);
        this.d.setLayout(new BorderLayout());
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        panel.setLayout(new FlowLayout(1, 5, 5));
        panel2.setLayout(new FlowLayout(1, 5, 5));
        panel.add(new Label(string));
        this.url_tf = new TextField(this.url_string, 60);
        panel.add(this.url_tf);
        Button button = new Button("Open ");
        Button button2 = new Button("Cancel");
        panel2.add(button);
        panel2.add(button2);
        this.d.add((Component)panel, "Center");
        this.d.add((Component)panel2, "South");
        ((Component)this.d).setSize(500, 130);
        this.d.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ATVframe.this.d.dispose();
            }
        });
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ATVframe.this.doOpenURL(ATVframe.this.url_tf.getText());
                ATVframe.this.d.dispose();
            }
        });
        button2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ATVframe.this.d.dispose();
            }
        });
        this.url_tf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ATVframe.this.doOpenURL(ATVframe.this.url_tf.getText());
                ATVframe.this.d.dispose();
            }
        });
        this.d.show();
    }

    private void reLoad() {
        if (this.reload_tree_ != null && !this.reload_tree_.isEmpty()) {
            Tree tree = this.reload_tree_.copyTree();
            this.atvpanel.terminate();
            this.atvpanel.getATVgraphic().setTree(tree);
            this.atvpanel.getATVgraphic().setPropertiesForPainting(tree);
            this.atvpanel.getATVcontrol().setCheckBoxes();
            this.atvpanel.getATVcontrol().showWhole();
        }
    }

    private void removeRoot() {
        this.atvpanel.getATVgraphic().removeRoot();
    }

    private void removeRootTri() {
        this.atvpanel.getATVgraphic().removeRootTri();
    }

    void save(Tree tree) {
        if (this.treefile == null || tree == null) {
            return;
        }
        try {
            TreeHelper.writeNHtree(tree, this.treefile, true, true, true);
        }
        catch (Exception exception) {
            Message message = new Message((Frame)this, "Exception during File|Save", exception.toString());
        }
    }

    void saveAs(Tree tree) {
        if (tree == null) {
            return;
        }
        boolean bl = false;
        FileDialog fileDialog = new FileDialog((Frame)this, " Safe File (\".nh\" to safe in NH format)", 1);
        fileDialog.setFile("");
        fileDialog.show();
        String string = fileDialog.getDirectory();
        String string2 = this.stripStars(fileDialog.getFile());
        if (string != null && string2 != null) {
            File file = new File(string, string2);
            if (file.getName().trim().toLowerCase().endsWith(".nh")) {
                try {
                    TreeHelper.writeNHtree(tree, file, false, true, true);
                }
                catch (Exception exception) {
                    bl = true;
                    Message message = new Message((Frame)this, "Exception during File|SaveAs", exception.toString());
                }
            } else {
                try {
                    TreeHelper.writeNHtree(tree, file, true, true, true);
                }
                catch (Exception exception) {
                    bl = true;
                    Message message = new Message((Frame)this, "Exception during File|SaveAs", exception.toString());
                }
            }
            if (!bl) {
                this.treefile = file;
                this.setTitle("ATV: " + this.treefile);
            }
        }
    }

    public void setMaxOrtho(int n) {
        this.atvpanel.getATVgraphic().setMaxOrtho(n);
    }

    public void showWhole() {
        this.atvpanel.getATVcontrol().showWhole();
    }

    private String stripStars(String string) {
        if (string == null) {
            return string;
        }
        if (string.endsWith(".*.*")) {
            string = string.substring(0, string.lastIndexOf(".*.*"));
        }
        return string;
    }

    private void switchColors() {
        this.atvpanel.getATVgraphic().switchColors();
    }

    private void viewAsNH() {
        if (this.atvpanel.getATVgraphic().getTree() == null) {
            return;
        }
        if (this.atvpanel.getATVgraphic().getTree().isEmpty()) {
            return;
        }
        String string = this.atvpanel.getATVgraphic().getTree().toNewHampshire(false);
        Message message = new Message((Frame)this, "ATV: Tree as NH", string);
    }

    private void viewAsNHX() {
        if (this.atvpanel.getATVgraphic().getTree() == null) {
            return;
        }
        if (this.atvpanel.getATVgraphic().getTree().isEmpty()) {
            return;
        }
        String string = this.atvpanel.getATVgraphic().getTree().toNewHampshireX();
        Message message = new Message((Frame)this, "ATV: Tree as NHX", string);
    }
}

