/*
 * Decompiled with CFR 0.152.
 */
package forester.atv_awt;

import forester.atv_awt.ATVmouseListener;
import forester.atv_awt.ATVnodeFrame;
import forester.atv_awt.ATVpanel;
import forester.tree.Node;
import forester.tree.Tree;
import forester.tree.TreeHelper;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.Vector;

class ATVgraphic
extends Canvas {
    private static final int MAX_ORTHO_DEFAULT = 100;
    static final int BOX_SIZE = 6;
    static final int HALF_BOX_SIZE = 3;
    static final int MAX_SUBTREES = 50;
    static final int MAX_NODEJFRAMES = 50;
    static final int MOVE = 30;
    static final int SHOW_INFO = 0;
    static final int COLLAPSE = 1;
    static final int REROOT = 3;
    static final int SUBTREE = 4;
    static final int SWAP = 5;
    Node node = null;
    Node n = null;
    Tree tree = null;
    Tree[] trees = new Tree[50];
    ATVpanel atvpanel = null;
    ATVnodeFrame[] atvnodeframes = new ATVnodeFrame[50];
    Vector found_nodes = null;
    boolean editable = false;
    boolean use_real_br_lenghts = true;
    boolean seq_name_internal_nodes = true;
    boolean species_internal_nodes = false;
    boolean ec_internal_nodes = false;
    boolean seq_name_ext_nodes = true;
    boolean species_ext_nodes = true;
    boolean ec_ext_nodes = false;
    boolean write_lnL_values = false;
    boolean write_br_length_values = false;
    boolean write_bootstrap_values = false;
    boolean write_dup_spec = false;
    boolean color_branches_acc_to_lnL = false;
    boolean color_orthologous = false;
    boolean color_super_orthologous = false;
    boolean done = false;
    int longest_ext_node_info = 0;
    int y_current = 0;
    int x1 = 0;
    int y1 = 0;
    int x2 = 0;
    int y2 = 0;
    int factor = 0;
    int green = 0;
    int red = 0;
    int max_ortho = 100;
    int j = 0;
    int x = 0;
    int action_when_node_clicked = 0;
    int i = 0;
    int color_scheme = 0;
    int small_maxDescent = 0;
    int small_maxAscent = 0;
    int ext_nodes_x = 0;
    double x_current = 0.0;
    double x2double = 0.0;
    double x_correction_factor = 0.0;
    double x_distance = 0.0;
    double y_distance = 0.0;
    double d = 0.0;
    Color ext_node_seq_name_color;
    Color int_node_seq_name_color;
    Color species_color;
    Color bootstrap_color;
    Color ec_color;
    Color dub_spec_color;
    Color lnL_color;
    Color branch_length_color;
    Color branch_color;
    Color box_color;
    Color background_color;
    Color duplication_box_color;
    Color seq_x_color;
    Color collapesed_fill_color;
    Color found_color;
    Font small_font;
    Font large_font;
    Font small_italic_font;
    Font large_italic_font;
    FontMetrics fm_small;
    FontMetrics fm_large;
    FontMetrics fm_small_italic;
    FontMetrics fm_large_italic;
    NumberFormat lnL_nf = NumberFormat.getNumberInstance();
    NumberFormat dist_nf = NumberFormat.getNumberInstance();

    ATVgraphic() {
    }

    ATVgraphic(Tree tree, ATVpanel aTVpanel) {
        this.tree = tree;
        if (this.tree != null && !this.tree.isEmpty()) {
            this.tree.adjustNodeCount(true);
            this.tree.recalculateAndReset();
        }
        this.atvpanel = aTVpanel;
        this.color_scheme = 1;
        this.setColors1();
        this.mediumFonts();
        this.setBackground(this.background_color);
        this.addMouseListener(new ATVmouseListener(this));
        this.lnL_nf.setMaximumFractionDigits(2);
        this.lnL_nf.setMinimumFractionDigits(2);
        this.setPropertiesForPainting(this.tree);
        this.setVisible(true);
    }

    boolean ECExtNodes() {
        return this.ec_ext_nodes;
    }

    boolean ECInternalNodes() {
        return this.ec_internal_nodes;
    }

    public void MouseClicked(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX();
        Node node = this.findNode(n2, n = mouseEvent.getY());
        if (node != null) {
            if (mouseEvent.getModifiers() == 4) {
                this.i = 0;
                while (this.atvnodeframes[this.i] != null) {
                    ++this.i;
                }
                this.atvnodeframes[this.i] = new ATVnodeFrame(node, this, this.i);
            } else if (this.action_when_node_clicked == 1) {
                this.collapse(node);
            } else if (this.action_when_node_clicked == 3) {
                this.reRoot(node);
            } else if (this.action_when_node_clicked == 4) {
                this.subTree(node);
            } else if (this.action_when_node_clicked == 5) {
                this.swap(node);
            } else {
                this.i = 0;
                while (this.atvnodeframes[this.i] != null) {
                    ++this.i;
                }
                this.atvnodeframes[this.i] = new ATVnodeFrame(node, this, this.i);
            }
        }
    }

    private Color calculateColorForOrthologous(Node node) {
        int n = node.getOrthologous();
        if (n == -11) {
            return this.seq_x_color;
        }
        if (n > this.getMaxOrtho()) {
            n = this.getMaxOrtho();
        } else if (n < 0) {
            n = 0;
        }
        int n2 = n * 200 / this.getMaxOrtho();
        if (this.color_scheme == 4) {
            return new Color(255 - n2, 255 - n2, this.ext_node_seq_name_color.getBlue());
        }
        return new Color(this.ext_node_seq_name_color.getRed(), n2, this.ext_node_seq_name_color.getBlue());
    }

    private Color calculateColorForSuperOrthologous(Node node) {
        int n = node.getSuperOrthologous();
        if (n == -11) {
            return this.seq_x_color;
        }
        if (n > this.getMaxOrtho()) {
            n = this.getMaxOrtho();
        } else if (n < 0) {
            n = 0;
        }
        int n2 = n * 255 / this.getMaxOrtho();
        if (this.color_scheme == 4) {
            return new Color(this.ext_node_seq_name_color.getRed(), 255 - n2, 255 - n2);
        }
        return new Color(n2, this.ext_node_seq_name_color.getGreen(), this.ext_node_seq_name_color.getBlue());
    }

    void calculateLongestExtNodeInfo() {
        if (this.tree == null) {
            return;
        }
        if (this.tree.isEmpty()) {
            return;
        }
        int n = 0;
        int n2 = 0;
        Node node = this.tree.getExtNode0();
        while (node != null) {
            n2 = this.fm_large_italic.stringWidth(String.valueOf(node.getSpecies()) + " ") + this.fm_large.stringWidth(String.valueOf(node.getSeqName()) + " ") + this.fm_large.stringWidth(node.getECnumber());
            node = node.getNextExtNode();
            if (n2 > n) {
                n = n2;
            }
            n2 = 0;
        }
        this.setLongestExtNodeInfo(n);
    }

    void collapse(Node node) {
        if (!node.isExternal()) {
            node.setCollapse(node.collapse() ^ true);
            this.tree.adjustNodeCount(true);
            this.tree.recalculateAndReset();
            this.resetPreferredSize();
            this.atvpanel.adjustJScrollPane();
            this.repaint();
        }
    }

    boolean colorBranchesAccToLnL() {
        return this.color_branches_acc_to_lnL;
    }

    boolean colorOrthologous() {
        return this.color_orthologous;
    }

    boolean colorSuperOrthologous() {
        return this.color_super_orthologous;
    }

    void drawCollapsedNode(int n, int n2, Graphics graphics, Node node, boolean bl) {
        int n3 = 0;
        graphics.setColor(this.branch_color);
        graphics.drawRect(n - 3, n2 - 3, 6, 6);
        if (bl) {
            graphics.setColor(this.background_color);
        } else {
            graphics.setColor(this.collapesed_fill_color);
        }
        graphics.fillRect(n - 3 + 1, n2 - 3 + 1, 5, 5);
        if (this.speciesExtNodes() && !node.getSpecies().equals("")) {
            graphics.setFont(this.large_italic_font);
            if (this.found_nodes != null && this.found_nodes.contains(node)) {
                graphics.setColor(this.found_color);
            } else {
                graphics.setColor(this.species_color);
            }
            if (this.seqNameExtNodes() && !node.getSeqName().equals("")) {
                graphics.drawString(String.valueOf(node.getSpecies()) + ": ", n + 3 + 3, n2 + this.fm_large_italic.getAscent() / 2);
                n3 = this.fm_large_italic.stringWidth(String.valueOf(node.getSpecies()) + ": ");
            } else {
                graphics.drawString(node.getSpecies(), n + 3 + 3, n2 + this.fm_large_italic.getAscent() / 2);
            }
        }
        if (this.seqNameExtNodes() && !node.getSeqName().equals("")) {
            graphics.setFont(this.large_font);
            if (this.found_nodes != null && this.found_nodes.contains(node)) {
                graphics.setColor(this.found_color);
            } else {
                graphics.setColor(this.int_node_seq_name_color);
            }
            graphics.drawString(node.getSeqName(), n + 3 + 3 + n3, n2 + this.fm_large.getAscent() / 2);
        }
    }

    void drawFoundNode(int n, int n2, Graphics graphics, boolean bl) {
        if (bl) {
            graphics.setColor(this.duplication_box_color);
        } else {
            graphics.setColor(this.box_color);
        }
        graphics.drawRect(n - 3, n2 - 3, 6, 6);
        graphics.setColor(this.background_color);
        graphics.fillRect(n - 3 + 1, n2 - 3 + 1, 5, 5);
    }

    Node findNode(int n, int n2) {
        if (this.tree == null) {
            return null;
        }
        if (this.tree.isEmpty()) {
            return null;
        }
        Node node = this.tree.getExtNode0();
        while (node != null) {
            Node node2 = node;
            while (node2 != null) {
                if (!(node2.isPseudoNode() || !this.tree.isRooted() && node2.isRoot() || node2.getXcoord() - 3 > n || node2.getXcoord() + 3 < n || node2.getYcoord() - 3 > n2 || node2.getYcoord() + 3 < n2)) {
                    return node2;
                }
                node2 = node2.getParent();
            }
            node = node.getNextExtNode();
        }
        return null;
    }

    ATVpanel getATVpanel() {
        return this.atvpanel;
    }

    int getActionWhenNodeClicked() {
        return this.action_when_node_clicked;
    }

    int getLengthOfRootSpecies() {
        if (this.tree == null) {
            return 0;
        }
        if (this.tree.isEmpty()) {
            return 0;
        }
        return this.fm_small_italic.stringWidth(this.tree.getRoot().getSpecies());
    }

    int getLongestExtNodeInfo() {
        return this.longest_ext_node_info;
    }

    int getMaxOrtho() {
        return this.max_ortho;
    }

    Tree getTree() {
        return this.tree;
    }

    double getXcorrectionFactor() {
        return this.x_correction_factor;
    }

    double getXdistance() {
        return this.x_distance;
    }

    double getYdistance() {
        return this.y_distance;
    }

    boolean isEditable() {
        return this.editable;
    }

    void largeFonts() {
        this.small_font = new Font("SansSerif", 0, 13);
        this.large_font = new Font("SansSerif", 0, 13);
        this.small_italic_font = new Font("SansSerif", 2, 13);
        this.large_italic_font = new Font("SansSerif", 2, 13);
        this.fm_small = this.getFontMetrics(this.small_font);
        this.fm_large = this.getFontMetrics(this.large_font);
        this.fm_small_italic = this.getFontMetrics(this.small_italic_font);
        this.fm_large_italic = this.getFontMetrics(this.large_italic_font);
        this.small_maxDescent = this.fm_small.getMaxDescent();
        this.small_maxAscent = this.fm_small.getMaxAscent() + 2;
    }

    void mediumFonts() {
        this.small_font = new Font("SansSerif", 0, 10);
        this.large_font = new Font("SansSerif", 0, 11);
        this.small_italic_font = new Font("SansSerif", 2, 10);
        this.large_italic_font = new Font("SansSerif", 2, 11);
        this.fm_small = this.getFontMetrics(this.small_font);
        this.fm_large = this.getFontMetrics(this.large_font);
        this.fm_small_italic = this.getFontMetrics(this.small_italic_font);
        this.fm_large_italic = this.getFontMetrics(this.large_italic_font);
        this.small_maxDescent = this.fm_small.getMaxDescent();
        this.small_maxAscent = this.fm_small.getMaxAscent() + 2;
    }

    public void paint(Graphics graphics) {
        if (this.tree == null || this.tree.isEmpty()) {
            return;
        }
        this.done = false;
        this.node = this.tree.getRoot();
        this.tree.setIndicatorsToZero();
        this.x_current = !this.tree.isRooted() ? 30.0 : (this.tree.getRoot().getDistanceToParent() > 0.0 && this.useRealBranchLenghts() ? 30.0 + this.tree.getRoot().getDistanceToParent() * this.x_correction_factor : 30.0 + this.getXdistance());
        this.y_current = TreeHelper.roundToInt(this.getYdistance() * (double)this.tree.getNumberOfExtNodes() + 15.0);
        this.ext_nodes_x = 30 + TreeHelper.roundToInt(this.x_distance * (double)this.tree.getNumberOfExtNodes());
        this.setBackground(this.background_color);
        do {
            if (!this.node.isPseudoNode()) {
                if (this.writeBranchLengthValues() && this.node.getIndicator() == 0 && this.node.getDistanceToParent() >= 0.0) {
                    graphics.setFont(this.small_font);
                    graphics.setColor(this.branch_length_color);
                    if (!this.node.isRoot()) {
                        graphics.drawString(this.dist_nf.format(this.node.getDistanceToParent()), this.node.getParent().getXcoord() + 3, this.y_current - this.small_maxDescent);
                    } else {
                        graphics.drawString(this.dist_nf.format(this.node.getDistanceToParent()), 3, this.y_current - this.small_maxDescent);
                    }
                }
                if (this.writeLnLValues() && this.node.getIndicator() == 0 && this.node.isLnLonParentBranchAssigned()) {
                    graphics.setFont(this.small_font);
                    graphics.setColor(this.lnL_color);
                    if (!this.node.isRoot()) {
                        graphics.drawString(String.valueOf(this.lnL_nf.format(this.tree.getHighestLnL() - (double)this.node.getLnLonParentBranch())) + " (" + this.lnL_nf.format(this.node.getLnLonParentBranch()) + ")", this.node.getParent().getXcoord() + 3, this.y_current + this.small_maxAscent);
                    } else if (this.tree.getNumberOfExtNodes() >= 2) {
                        graphics.drawString(String.valueOf(this.lnL_nf.format(this.tree.getHighestLnL() - (double)this.node.getLnLonParentBranch())) + " (" + this.lnL_nf.format(this.node.getLnLonParentBranch()) + ")", 3, this.y_current + this.small_maxAscent);
                    } else {
                        graphics.drawString(" (" + this.lnL_nf.format(this.node.getLnLonParentBranch()) + ")", 3, this.y_current + this.small_maxAscent);
                    }
                }
                if (this.writeBootstrapValues() && this.node.getIndicator() == 0 && this.node.getBootstrap() > 0 && this.tree.getNumberOfExtNodes() >= 2 && !this.node.collapse()) {
                    graphics.setFont(this.small_font);
                    graphics.setColor(this.bootstrap_color);
                    graphics.drawString(Integer.toString(this.node.getBootstrap()), TreeHelper.roundToInt(this.x_current) - this.fm_small.stringWidth(Integer.toString(this.node.getBootstrap())) - 2 - 3, this.y_current + this.small_maxAscent - 1);
                }
            }
            if (this.node.isRoot() && this.tree.isRooted() && this.node.getIndicator() == 0) {
                this.x1 = TreeHelper.roundToInt(this.x_current);
                if (!this.colorBranchesAccToLnL() || !this.node.isLnLonParentBranchAssigned()) {
                    graphics.setColor(this.branch_color);
                } else {
                    this.green = (int)(((double)this.node.getLnLonParentBranch() - this.tree.getLowestLnL()) * 254.0 / Math.abs(this.tree.getHighestLnL() - this.tree.getLowestLnL()));
                    this.red = 255 - this.green;
                    graphics.setColor(new Color(this.red, this.green, 0));
                }
                if (this.useRealBranchLenghts() && this.tree.getRoot().getDistanceToParent() > 0.0) {
                    this.d = this.x_correction_factor * this.tree.getRoot().getDistanceToParent();
                    graphics.drawLine(this.x1, this.y_current, this.x1 - TreeHelper.roundToInt(this.d), this.y_current);
                } else {
                    graphics.drawLine(this.x1, this.y_current, this.x1 - TreeHelper.roundToInt(this.x_distance), this.y_current);
                    if (this.colorBranchesAccToLnL() && !this.node.significantlyWorse()) {
                        graphics.drawLine(this.x1, this.y_current - 1, this.x1 - TreeHelper.roundToInt(this.x_distance), this.y_current - 1);
                        graphics.drawLine(this.x1, this.y_current + 1, this.x1 - TreeHelper.roundToInt(this.x_distance), this.y_current + 1);
                    }
                }
                if (this.node.collapse()) {
                    this.drawCollapsedNode(this.x1, this.y_current, graphics, this.node, this.found_nodes != null && this.found_nodes.contains(this.node));
                } else if (this.found_nodes != null && this.found_nodes.contains(this.node)) {
                    if (!this.writeDupSpec() && this.node.isDuplicationOrSpecAssigned() && this.node.isDuplication()) {
                        this.drawFoundNode(this.x1, this.y_current, graphics, true);
                    } else {
                        this.drawFoundNode(this.x1, this.y_current, graphics, false);
                    }
                } else {
                    if (!this.writeDupSpec() && this.node.isDuplicationOrSpecAssigned() && this.node.isDuplication()) {
                        graphics.setColor(this.duplication_box_color);
                    } else {
                        graphics.setColor(this.box_color);
                    }
                    graphics.fillRect(this.x1 - 3, this.y_current - 3, 6, 6);
                }
            }
            if (this.node.getIndicator() == 0 && !this.node.isExternal()) {
                this.node.setIndicator(1);
                this.factor = this.node.getSumExtNodes() - this.node.getChild1().getSumExtNodes();
                this.x1 = TreeHelper.roundToInt(this.x_current);
                this.node.setXcoord(this.x1);
                this.y1 = this.y_current;
                this.node.setYcoord(this.y1);
                this.y2 = this.y_current - TreeHelper.roundToInt(this.y_distance * (double)this.factor);
                if (!this.node.isPseudoNode()) {
                    if (this.speciesInternalNodes() && !this.node.collapse() && !this.node.getSpecies().equals("")) {
                        graphics.setFont(this.small_italic_font);
                        if (this.found_nodes != null && this.found_nodes.contains(this.node)) {
                            graphics.setColor(this.found_color);
                        } else {
                            graphics.setColor(this.species_color);
                        }
                        graphics.drawString(this.node.getSpecies(), this.x1 + 3 + 3, this.y_current + this.fm_small_italic.getAscent() / 2);
                    }
                    if (this.seqNameInternalNodes() && !this.node.getSeqName().equals("") && !this.node.collapse()) {
                        if (this.found_nodes != null && this.found_nodes.contains(this.node)) {
                            graphics.setColor(this.found_color);
                        } else {
                            graphics.setColor(this.int_node_seq_name_color);
                        }
                        graphics.setFont(this.large_font);
                        graphics.drawString(this.node.getSeqName(), this.x1 - this.fm_large.stringWidth(this.node.getSeqName()) - 3 - 3, this.y_current - this.fm_large.getMaxDescent());
                    }
                    if (this.ECInternalNodes() && !this.node.getECnumber().equals("") && !this.node.collapse()) {
                        if (this.found_nodes != null && this.found_nodes.contains(this.node)) {
                            graphics.setColor(this.found_color);
                        } else {
                            graphics.setColor(this.ec_color);
                        }
                        graphics.setFont(this.large_font);
                        this.x = this.seqNameInternalNodes() && !this.node.getSeqName().equals("") ? this.fm_large.stringWidth(String.valueOf(this.node.getSeqName()) + " ") : 0;
                        graphics.drawString(this.node.getECnumber(), this.x1 - this.x - this.fm_large.stringWidth(this.node.getECnumber()) - 4 - 3, this.y_current - this.fm_large.getMaxDescent());
                    }
                    if (this.writeDupSpec() && this.node.isDuplicationOrSpecAssigned() && !this.node.collapse()) {
                        graphics.setColor(this.dub_spec_color);
                        graphics.setFont(this.large_font);
                        this.x = this.speciesInternalNodes() ? this.fm_large.getMaxAscent() : 0;
                        if (this.node.isDuplication()) {
                            graphics.drawString("D", this.x1 + 3 + 3, this.y_current + this.fm_large.getAscent() / 2 + this.x);
                        } else {
                            graphics.drawString("S", this.x1 + 3 + 3, this.y_current + this.fm_large.getAscent() / 2 + this.x);
                        }
                    }
                }
                if (!this.node.collapse()) {
                    if (this.useRealBranchLenghts()) {
                        this.d = this.node.getChild1().getDistanceToParent();
                        if (this.d < 0.0) {
                            this.d = 0.0;
                        }
                        this.x2double = this.x_current + this.x_correction_factor * this.d;
                    } else {
                        this.x2double = this.node.getChild1().isExternal() || this.node.getChild1().collapse() ? (double)this.ext_nodes_x : (this.node.getChild1().isPseudoNode() ? this.x_current : this.x_current + this.x_distance * (double)this.factor);
                    }
                    if (!(this.useRealBranchLenghts() || !this.node.isPseudoNode() || this.node.getChild1().isPseudoNode() || this.node.getChild1().isExternal() || this.node.getChild1().collapse())) {
                        this.n = this.node.getParent();
                        while (this.n.isPseudoNode()) {
                            this.n = this.n.getParent();
                        }
                        this.x2double += (double)(this.n.getSumExtNodes() - this.node.getSumExtNodes()) * this.x_distance;
                    }
                    this.x2 = TreeHelper.roundToInt(this.x2double);
                    graphics.setColor(this.branch_color);
                    if (!(this.node.isPseudoNode() || this.node.isRoot() && !this.tree.isRooted())) {
                        if (this.y1 - this.y2 > 3) {
                            graphics.drawLine(this.x1, this.y1 - 3, this.x1, this.y2);
                        } else {
                            this.x1 += 3;
                        }
                    } else {
                        graphics.drawLine(this.x1, this.y1, this.x1, this.y2);
                    }
                    if (!this.colorBranchesAccToLnL() || !this.node.getChild1().isLnLonParentBranchAssigned() || this.tree.getHighestLnL() == this.tree.getLowestLnL()) {
                        graphics.setColor(this.branch_color);
                        graphics.drawLine(this.x1, this.y2, this.x2, this.y2);
                    } else {
                        this.green = (int)(((double)this.node.getChild1().getLnLonParentBranch() - this.tree.getLowestLnL()) * 254.0 / Math.abs(this.tree.getHighestLnL() - this.tree.getLowestLnL()));
                        this.red = 255 - this.green;
                        graphics.setColor(new Color(this.red, this.green, 0));
                        graphics.drawLine(this.x1, this.y2, this.x2, this.y2);
                        if (!this.node.getChild1().significantlyWorse()) {
                            graphics.drawLine(this.x1, this.y2 - 1, this.x2, this.y2 - 1);
                            graphics.drawLine(this.x1, this.y2 + 1, this.x2, this.y2 + 1);
                        }
                    }
                    if (!this.node.getChild1().isPseudoNode()) {
                        if (this.node.getChild1().collapse()) {
                            this.drawCollapsedNode(this.x2, this.y2, graphics, this.node.getChild1(), this.found_nodes != null && this.found_nodes.contains(this.node.getChild1()));
                        } else if (this.found_nodes != null && this.found_nodes.contains(this.node.getChild1())) {
                            if (!this.writeDupSpec() && this.node.getChild1().isDuplicationOrSpecAssigned() && this.node.getChild1().isDuplication()) {
                                this.drawFoundNode(this.x2, this.y2, graphics, true);
                            } else {
                                this.drawFoundNode(this.x2, this.y2, graphics, false);
                            }
                        } else {
                            if (!this.writeDupSpec() && this.node.getChild1().isDuplicationOrSpecAssigned() && this.node.getChild1().isDuplication()) {
                                graphics.setColor(this.duplication_box_color);
                            } else {
                                graphics.setColor(this.box_color);
                            }
                            graphics.fillRect(this.x2 - 3, this.y2 - 3, 6, 6);
                        }
                    }
                    this.x_current = this.x2double;
                    this.y_current = this.y2;
                    this.node = this.node.getChild1();
                }
            }
            if (this.node.getIndicator() == 1 && !this.node.isExternal()) {
                this.node.setIndicator(2);
                if (!this.node.collapse()) {
                    this.factor = this.node.getSumExtNodes() - this.node.getChild2().getSumExtNodes();
                    this.x1 = TreeHelper.roundToInt(this.x_current);
                    this.y1 = this.y_current;
                    this.y2 = this.y_current + TreeHelper.roundToInt(this.y_distance * (double)this.factor);
                    if (this.useRealBranchLenghts()) {
                        this.d = this.node.getChild2().getDistanceToParent();
                        if (this.d < 0.0) {
                            this.d = 0.0;
                        }
                        this.x2double = this.x_current + this.x_correction_factor * this.d;
                    } else {
                        this.x2double = this.node.getChild2().isExternal() || this.node.getChild2().collapse() ? (double)this.ext_nodes_x : (this.node.getChild2().isPseudoNode() ? this.x_current : this.x_current + this.x_distance * (double)this.factor);
                    }
                    if (!(this.useRealBranchLenghts() || !this.node.isPseudoNode() || this.node.getChild2().isPseudoNode() || this.node.getChild2().isExternal() || this.node.getChild2().collapse())) {
                        this.n = this.node.getParent();
                        while (this.n.isPseudoNode()) {
                            this.n = this.n.getParent();
                        }
                        this.x2double += (double)(this.n.getSumExtNodes() - this.node.getSumExtNodes()) * this.x_distance;
                    }
                    this.x2 = TreeHelper.roundToInt(this.x2double);
                    graphics.setColor(this.branch_color);
                    if (!(this.node.isPseudoNode() || this.node.isRoot() && !this.tree.isRooted())) {
                        if (this.y2 - this.y1 > 3) {
                            graphics.drawLine(this.x1, this.y1 + 3, this.x1, this.y2);
                        } else {
                            this.x1 += 3;
                        }
                    } else {
                        graphics.drawLine(this.x1, this.y1, this.x1, this.y2);
                    }
                    if (!this.colorBranchesAccToLnL() || !this.node.getChild2().isLnLonParentBranchAssigned() || this.tree.getHighestLnL() == this.tree.getLowestLnL()) {
                        graphics.setColor(this.branch_color);
                        graphics.drawLine(this.x1, this.y2, this.x2, this.y2);
                    } else {
                        this.green = (int)(((double)this.node.getChild2().getLnLonParentBranch() - this.tree.getLowestLnL()) * 254.0 / Math.abs(this.tree.getHighestLnL() - this.tree.getLowestLnL()));
                        this.red = 255 - this.green;
                        graphics.setColor(new Color(this.red, this.green, 0));
                        graphics.drawLine(this.x1, this.y2, this.x2, this.y2);
                        if (!this.node.getChild2().significantlyWorse()) {
                            graphics.drawLine(this.x1, this.y2 - 1, this.x2, this.y2 - 1);
                            graphics.drawLine(this.x1, this.y2 + 1, this.x2, this.y2 + 1);
                        }
                    }
                    if (!this.node.getChild2().isPseudoNode()) {
                        if (this.node.getChild2().collapse()) {
                            this.drawCollapsedNode(this.x2, this.y2, graphics, this.node.getChild2(), this.found_nodes != null && this.found_nodes.contains(this.node.getChild2()));
                        } else if (this.found_nodes != null && this.found_nodes.contains(this.node.getChild2())) {
                            if (!this.writeDupSpec() && this.node.getChild2().isDuplicationOrSpecAssigned() && this.node.getChild2().isDuplication()) {
                                this.drawFoundNode(this.x2, this.y2, graphics, true);
                            } else {
                                this.drawFoundNode(this.x2, this.y2, graphics, false);
                            }
                        } else {
                            if (!this.writeDupSpec() && this.node.getChild2().isDuplicationOrSpecAssigned() && this.node.getChild2().isDuplication()) {
                                graphics.setColor(this.duplication_box_color);
                            } else {
                                graphics.setColor(this.box_color);
                            }
                            graphics.fillRect(this.x2 - 3, this.y2 - 3, 6, 6);
                        }
                    }
                    this.x_current = this.x2double;
                    this.y_current = this.y2;
                    this.node = this.node.getChild2();
                }
            }
            if (this.node.isRoot()) {
                this.done = true;
            } else if (this.node.getIndicator() == 2 && !this.node.isExternal()) {
                this.node = this.node.getParent();
                this.x_current = this.node.getXcoord();
                this.y_current = this.node.getYcoord();
            }
            if (!this.node.isExternal()) continue;
            this.x1 = TreeHelper.roundToInt(this.x_current);
            if (this.speciesExtNodes() && !this.node.getSpecies().equals("")) {
                graphics.setFont(this.large_italic_font);
                if (this.found_nodes != null && this.found_nodes.contains(this.node)) {
                    graphics.setColor(this.found_color);
                } else if (this.colorOrthologous() && this.node.getOrthologous() != 0) {
                    graphics.setColor(this.calculateColorForOrthologous(this.node));
                } else if (this.colorSuperOrthologous() && this.node.getSuperOrthologous() != 0) {
                    graphics.setColor(this.calculateColorForSuperOrthologous(this.node));
                } else {
                    graphics.setColor(this.species_color);
                }
                graphics.drawString(String.valueOf(this.node.getSpecies()) + " ", this.x1 + 3 + 3, this.y_current + this.fm_large.getAscent() / 2);
            }
            if (this.seqNameExtNodes() && !this.node.getSeqName().equals("")) {
                graphics.setFont(this.large_font);
                if (this.found_nodes != null && this.found_nodes.contains(this.node)) {
                    graphics.setColor(this.found_color);
                } else if (this.colorOrthologous() && this.node.getOrthologous() != 0) {
                    graphics.setColor(this.calculateColorForOrthologous(this.node));
                } else if (this.colorSuperOrthologous() && this.node.getSuperOrthologous() != 0) {
                    graphics.setColor(this.calculateColorForSuperOrthologous(this.node));
                } else {
                    graphics.setColor(this.ext_node_seq_name_color);
                }
                this.x = this.speciesExtNodes() && !this.node.getSpecies().equals("") ? this.fm_large_italic.stringWidth(String.valueOf(this.node.getSpecies()) + " ") : 0;
                graphics.drawString(this.node.getSeqName(), this.x1 + this.x + 3 + 3, this.y_current + this.fm_large.getAscent() / 2);
            }
            if (this.ECExtNodes() && !this.node.getECnumber().equals("")) {
                graphics.setFont(this.large_font);
                if (this.found_nodes != null && this.found_nodes.contains(this.node)) {
                    graphics.setColor(this.found_color);
                } else {
                    graphics.setColor(this.ec_color);
                }
                this.x = this.speciesExtNodes() && !this.node.getSpecies().equals("") ? this.fm_large_italic.stringWidth(String.valueOf(this.node.getSpecies()) + " ") : 0;
                if (this.seqNameExtNodes() && !this.node.getSeqName().equals("")) {
                    this.x += this.fm_large.stringWidth(String.valueOf(this.node.getSeqName()) + " ");
                }
                graphics.drawString(this.node.getECnumber(), this.x1 + this.x + 3 + 3, this.y_current + this.fm_large.getAscent() / 2);
            }
            if (this.colorOrthologous() && this.node.getOrthologous() != 0 || this.colorSuperOrthologous() && this.node.getSuperOrthologous() != 0) {
                graphics.setColor(this.calculateColorForOrthologous(this.node));
                graphics.setFont(this.large_font);
                this.x = this.speciesExtNodes() && !this.node.getSpecies().equals("") ? this.fm_large_italic.stringWidth(String.valueOf(this.node.getSpecies()) + " ") : 0;
                if (this.seqNameExtNodes() && !this.node.getSeqName().equals("")) {
                    this.x += this.fm_large.stringWidth(String.valueOf(this.node.getSeqName()) + " ");
                }
                if (this.ECExtNodes() && !this.node.getECnumber().equals("")) {
                    this.x += this.fm_large.stringWidth(String.valueOf(this.node.getECnumber()) + " ");
                }
                if (this.colorOrthologous()) {
                    graphics.setColor(this.calculateColorForOrthologous(this.node));
                    if (this.node.getOrthologous() == -11) {
                        graphics.drawString(" [ Q ]", this.x1 + this.x + 3 + 3, this.y_current + this.fm_large.getAscent() / 2);
                    } else {
                        graphics.drawString(" [ " + this.node.getOrthologous() + " ]", this.x1 + this.x + 3 + 3, this.y_current + this.fm_large.getAscent() / 2);
                    }
                }
                if (this.colorSuperOrthologous()) {
                    graphics.setColor(this.calculateColorForSuperOrthologous(this.node));
                    if (this.node.getSuperOrthologous() == -11) {
                        graphics.drawString(" [ Q ]", this.x1 + this.x + 3 + 3, this.y_current + this.fm_large.getAscent() / 2);
                    } else {
                        graphics.drawString(" [ " + this.node.getSuperOrthologous() + " ]", this.x1 + this.x + 3 + 3, this.y_current + this.fm_large.getAscent() / 2);
                    }
                }
            }
            if (this.writeBranchLengthValues() && !this.node.isRoot() && this.node.getDistanceToParent() >= 0.0) {
                graphics.setFont(this.small_font);
                graphics.setColor(this.branch_length_color);
                graphics.drawString(this.dist_nf.format(this.node.getDistanceToParent()), this.node.getParent().getXcoord() + 3, this.y_current - this.small_maxDescent);
            }
            if (this.writeLnLValues() && !this.node.isRoot() && this.node.isLnLonParentBranchAssigned()) {
                graphics.setFont(this.small_font);
                graphics.setColor(this.lnL_color);
                graphics.drawString(String.valueOf(this.lnL_nf.format(this.tree.getHighestLnL() - (double)this.node.getLnLonParentBranch())) + " (" + this.lnL_nf.format(this.node.getLnLonParentBranch()) + ")", this.node.getParent().getXcoord() + 3, this.y_current + this.small_maxAscent);
            }
            this.node.setXcoord(this.x1);
            this.node.setYcoord(this.y_current);
            if (this.node.getNextExtNode() == null) {
                this.done = true;
            }
            if (this.node.isRoot()) continue;
            this.node = this.node.getParent();
            this.x_current = this.node.getXcoord();
            this.y_current = this.node.getYcoord();
        } while (!this.done);
    }

    void reRoot(Node node) {
        if (!node.isRoot() && !node.getParent().isRoot() || !this.tree.isRooted()) {
            try {
                this.tree.reRoot(node);
                this.tree.adjustNodeCount(true);
                this.tree.recalculateAndReset();
            }
            catch (Exception exception) {
                System.err.println("ATVgraphic: reRoot( node ): " + exception);
            }
            this.resetPreferredSize();
            this.atvpanel.adjustJScrollPane();
            this.repaint();
            this.atvpanel.validate();
        }
    }

    void removeAllNodeJFrames() {
        this.i = 0;
        while (this.i <= 49) {
            if (this.atvnodeframes[this.i] != null) {
                this.atvnodeframes[this.i].dispose();
                this.atvnodeframes[this.i] = null;
            }
            ++this.i;
        }
        this.i = 0;
    }

    void removeNodeJFrame(int n) {
        this.atvnodeframes[n] = null;
    }

    void removeRoot() {
        if (this.tree == null) {
            return;
        }
        if (this.tree.isEmpty()) {
            return;
        }
        this.tree.unRoot();
        this.repaint();
    }

    void removeRootTri() {
        if (this.tree == null) {
            return;
        }
        if (this.tree.isEmpty()) {
            return;
        }
        this.tree.unRootAndTrifurcate();
        this.repaint();
    }

    void resetPreferredSize() {
        if (this.tree == null || this.tree.isEmpty()) {
            return;
        }
        int n = 0;
        int n2 = 0;
        n2 = 30 + (int)(0.5 + this.getYdistance() * (double)this.tree.getNumberOfExtNodes() * 2.0);
        n = this.useRealBranchLenghts() ? 30 + this.getLongestExtNodeInfo() + this.getLengthOfRootSpecies() + TreeHelper.roundToInt(this.getXcorrectionFactor() * this.tree.getRealHeight() + this.getXdistance()) : 30 + this.getLongestExtNodeInfo() + this.getLengthOfRootSpecies() + TreeHelper.roundToInt(this.getXdistance() * (double)(this.tree.getNumberOfExtNodes() + 2));
        this.setSize(new Dimension(n, n2));
    }

    boolean seqNameExtNodes() {
        return this.seq_name_ext_nodes;
    }

    boolean seqNameInternalNodes() {
        return this.seq_name_internal_nodes;
    }

    void setActionWhenNodeClicked(int n) {
        this.action_when_node_clicked = n;
    }

    void setColorBranchesAccToLnL(boolean bl) {
        this.color_branches_acc_to_lnL = bl;
    }

    void setColorOrthologous(boolean bl) {
        this.color_orthologous = bl;
    }

    void setColorSuperOrthologous(boolean bl) {
        this.color_super_orthologous = bl;
    }

    void setColors1() {
        this.ext_node_seq_name_color = new Color(0, 0, 0);
        this.int_node_seq_name_color = new Color(255, 0, 0);
        this.species_color = new Color(40, 40, 40);
        this.bootstrap_color = new Color(0, 125, 0);
        this.ec_color = new Color(255, 100, 0);
        this.dub_spec_color = new Color(255, 0, 0);
        this.lnL_color = new Color(40, 40, 40);
        this.branch_length_color = new Color(70, 70, 0);
        this.branch_color = new Color(0, 20, 200);
        this.box_color = new Color(0, 20, 200);
        this.background_color = new Color(250, 250, 250);
        this.duplication_box_color = new Color(255, 0, 0);
        this.seq_x_color = new Color(0, 0, 255);
        this.collapesed_fill_color = new Color(255, 255, 0);
        this.found_color = new Color(255, 0, 0);
    }

    void setColors2() {
        this.ext_node_seq_name_color = new Color(0, 0, 0);
        this.int_node_seq_name_color = new Color(0, 0, 0);
        this.species_color = new Color(0, 0, 150);
        this.bootstrap_color = new Color(0, 0, 0);
        this.ec_color = new Color(150, 0, 0);
        this.dub_spec_color = new Color(150, 0, 150);
        this.lnL_color = new Color(255, 255, 255);
        this.branch_length_color = new Color(150, 0, 0);
        this.branch_color = new Color(255, 255, 0);
        this.box_color = new Color(255, 255, 0);
        this.background_color = new Color(180, 180, 180);
        this.duplication_box_color = new Color(255, 0, 0);
        this.seq_x_color = new Color(0, 0, 255);
        this.collapesed_fill_color = new Color(0, 90, 0);
        this.found_color = new Color(0, 180, 0);
    }

    void setColors3() {
        this.ext_node_seq_name_color = new Color(0, 0, 0);
        this.int_node_seq_name_color = new Color(0, 0, 0);
        this.species_color = new Color(50, 50, 50);
        this.bootstrap_color = new Color(100, 100, 100);
        this.ec_color = new Color(0, 0, 0);
        this.dub_spec_color = new Color(0, 0, 0);
        this.lnL_color = new Color(100, 100, 100);
        this.branch_length_color = new Color(50, 50, 50);
        this.branch_color = new Color(0, 0, 0);
        this.box_color = new Color(0, 0, 0);
        this.background_color = new Color(255, 255, 255);
        this.duplication_box_color = new Color(255, 0, 0);
        this.seq_x_color = new Color(0, 0, 255);
        this.collapesed_fill_color = new Color(255, 255, 0);
        this.found_color = new Color(255, 0, 0);
    }

    void setColors4() {
        this.ext_node_seq_name_color = new Color(255, 255, 255);
        this.int_node_seq_name_color = new Color(255, 255, 255);
        this.species_color = new Color(200, 200, 200);
        this.bootstrap_color = new Color(255, 255, 255);
        this.ec_color = new Color(200, 200, 200);
        this.dub_spec_color = new Color(255, 255, 255);
        this.lnL_color = new Color(200, 200, 200);
        this.branch_length_color = new Color(200, 200, 200);
        this.branch_color = new Color(0, 255, 255);
        this.box_color = new Color(0, 255, 255);
        this.background_color = new Color(0, 0, 70);
        this.duplication_box_color = new Color(255, 0, 0);
        this.seq_x_color = new Color(255, 255, 0);
        this.collapesed_fill_color = new Color(255, 255, 0);
        this.found_color = new Color(255, 0, 0);
    }

    void setECExtNodes(boolean bl) {
        this.ec_ext_nodes = bl;
    }

    void setECInternalNodes(boolean bl) {
        this.ec_internal_nodes = bl;
    }

    void setEditable(boolean bl) {
        this.editable = bl;
    }

    void setFoundNodes(Vector vector) {
        this.found_nodes = vector;
    }

    void setLongestExtNodeInfo(int n) {
        this.longest_ext_node_info = n;
    }

    void setMaxOrtho(int n) {
        this.max_ortho = n;
    }

    void setParametersForPainting(int n, int n2) {
        if (this.tree != null && !this.tree.isEmpty()) {
            double d = (double)(n - this.getLongestExtNodeInfo() - 30 - this.getLengthOfRootSpecies()) / ((double)this.tree.getNumberOfExtNodes() + 2.0);
            double d2 = (double)(n2 - 30) / ((double)this.tree.getNumberOfExtNodes() * 2.0);
            if (d < 0.0) {
                d = 0.0;
            }
            if (d2 < 0.0) {
                d2 = 0.0;
            }
            this.setXdistance(d);
            this.setYdistance(d2);
            if (this.tree.getRealHeight() > 0.0) {
                double d3 = ((double)(n - this.getLongestExtNodeInfo() - 30) - this.getXdistance() - (double)this.getLengthOfRootSpecies()) / this.tree.getRealHeight();
                if (d3 < 0.0) {
                    d3 = 0.0;
                }
                this.setXcorrectionFactor(d3);
            } else {
                this.setXcorrectionFactor(0.0);
            }
        }
    }

    void setPropertiesForPainting(Tree tree) {
        this.editable = false;
        this.use_real_br_lenghts = false;
        this.seq_name_internal_nodes = true;
        this.species_internal_nodes = false;
        this.ec_internal_nodes = false;
        this.seq_name_ext_nodes = true;
        this.species_ext_nodes = true;
        this.ec_ext_nodes = false;
        this.write_lnL_values = false;
        this.write_br_length_values = false;
        this.write_bootstrap_values = false;
        this.write_dup_spec = false;
        this.color_branches_acc_to_lnL = false;
        this.color_orthologous = false;
        this.color_super_orthologous = false;
        if (tree != null && !tree.isEmpty()) {
            this.calculateLongestExtNodeInfo();
            if (tree.getHighestLnL() != -1.7976931348623157E308 && tree.getLowestLnL() != Double.MAX_VALUE && tree.getLowestLnL() != tree.getHighestLnL()) {
                this.setColorBranchesAccToLnL(true);
            }
            if (tree.getExtNode0() != null) {
                if (tree.getExtNode0().getDistanceToParent() != -99.0) {
                    this.setUseRealBranchLenghts(true);
                }
                if (tree.getExtNode0().getParent() != null && tree.getExtNode0().getParent().getBootstrap() != -99) {
                    this.setWriteBootstrapValues(true);
                }
            }
        }
    }

    void setSeqNameExtNodes(boolean bl) {
        this.seq_name_ext_nodes = bl;
    }

    void setSeqNameInternalNodes(boolean bl) {
        this.seq_name_internal_nodes = bl;
    }

    void setSpeciesExtNodes(boolean bl) {
        this.species_ext_nodes = bl;
    }

    void setSpeciesInternalNodes(boolean bl) {
        this.species_internal_nodes = bl;
    }

    void setTree(Tree tree) {
        this.tree = tree;
    }

    void setUseRealBranchLenghts(boolean bl) {
        this.use_real_br_lenghts = bl;
    }

    void setWriteBootstrapValues(boolean bl) {
        this.write_bootstrap_values = bl;
    }

    void setWriteBranchLengthValues(boolean bl) {
        this.write_br_length_values = bl;
    }

    void setWriteDupSpec(boolean bl) {
        this.write_dup_spec = bl;
    }

    void setWriteLnLValues(boolean bl) {
        this.write_lnL_values = bl;
    }

    void setXcorrectionFactor(double d) {
        this.x_correction_factor = d;
    }

    void setXdistance(double d) {
        this.x_distance = d;
    }

    void setYdistance(double d) {
        this.y_distance = d;
    }

    void smallFonts() {
        this.small_font = new Font("SansSerif", 0, 9);
        this.large_font = new Font("SansSerif", 0, 10);
        this.small_italic_font = new Font("SansSerif", 2, 9);
        this.large_italic_font = new Font("SansSerif", 2, 10);
        this.fm_small = this.getFontMetrics(this.small_font);
        this.fm_large = this.getFontMetrics(this.large_font);
        this.fm_small_italic = this.getFontMetrics(this.small_italic_font);
        this.fm_large_italic = this.getFontMetrics(this.large_italic_font);
        this.small_maxDescent = this.fm_small.getMaxDescent();
        this.small_maxAscent = this.fm_small.getMaxAscent() + 1;
    }

    boolean speciesExtNodes() {
        return this.species_ext_nodes;
    }

    boolean speciesInternalNodes() {
        return this.species_internal_nodes;
    }

    void subTree(Node node) {
        if (!node.isExternal() && !node.isRoot() && this.j <= 49) {
            try {
                this.trees[this.j++] = this.tree;
                this.tree = this.tree.subTree(node.getID());
            }
            catch (Exception exception) {
                System.err.println("ATVgraphic: subTree( Node ): " + exception);
            }
        } else if (node.isRoot() && this.j >= 1) {
            try {
                this.trees[this.j] = null;
                this.tree = this.trees[--this.j];
            }
            catch (Exception exception) {
                System.err.println("ATVgraphic: subTree( Node ): " + exception);
            }
        }
        this.atvpanel.getATVcontrol().setCheckBoxes();
        this.atvpanel.getATVcontrol().showWhole();
        this.repaint();
    }

    void swap(Node node) {
        if (!node.isExternal()) {
            this.tree.swapChildren(node);
        }
        this.repaint();
    }

    void switchColors() {
        switch (this.color_scheme) {
            case 1: {
                this.color_scheme = 2;
                this.setColors2();
                break;
            }
            case 2: {
                this.color_scheme = 3;
                this.setColors3();
                break;
            }
            case 3: {
                this.color_scheme = 4;
                this.setColors4();
                break;
            }
            case 4: {
                this.color_scheme = 1;
                this.setColors1();
                break;
            }
        }
        this.repaint();
    }

    void tinyFonts() {
        this.small_font = new Font("SansSerif", 0, 8);
        this.large_font = new Font("SansSerif", 0, 8);
        this.small_italic_font = new Font("SansSerif", 2, 8);
        this.large_italic_font = new Font("SansSerif", 2, 8);
        this.fm_small = this.getFontMetrics(this.small_font);
        this.fm_large = this.getFontMetrics(this.large_font);
        this.fm_small_italic = this.getFontMetrics(this.small_italic_font);
        this.fm_large_italic = this.getFontMetrics(this.large_italic_font);
        this.small_maxDescent = this.fm_small.getMaxDescent();
        this.small_maxAscent = this.fm_small.getMaxAscent() + 1;
    }

    boolean useRealBranchLenghts() {
        return this.use_real_br_lenghts;
    }

    boolean writeBootstrapValues() {
        return this.write_bootstrap_values;
    }

    boolean writeBranchLengthValues() {
        return this.write_br_length_values;
    }

    boolean writeDupSpec() {
        return this.write_dup_spec;
    }

    boolean writeLnLValues() {
        return this.write_lnL_values;
    }
}

