/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.media.jai.DataBufferDouble;
import javax.media.jai.DataBufferFloat;
import javax.media.jai.JaiI18N;
import javax.media.jai.OpImage;
import javax.media.jai.RasterFormatTag;
import sun.awt.image.BytePackedRaster;

public class RasterAccessor {
    private static final int COPY_MASK_SHIFT = 7;
    private static final int COPY_MASK_SIZE = 2;
    public static final int COPY_MASK = 384;
    public static final int UNCOPIED = 0;
    public static final int COPIED = 128;
    private static final int EXPANSION_MASK_SHIFT = 9;
    private static final int EXPANSION_MASK_SIZE = 2;
    public static final int EXPANSION_MASK = 1536;
    public static final int DEFAULTEXPANSION = 0;
    public static final int EXPANDED = 512;
    public static final int UNEXPANDED = 1024;
    public static final int DATATYPE_MASK = 127;
    public static final int TAG_BYTE_UNCOPIED = 0;
    public static final int TAG_USHORT_UNCOPIED = 1;
    public static final int TAG_SHORT_UNCOPIED = 2;
    public static final int TAG_INT_UNCOPIED = 3;
    public static final int TAG_FLOAT_UNCOPIED = 4;
    public static final int TAG_DOUBLE_UNCOPIED = 5;
    public static final int TAG_INT_COPIED = 131;
    public static final int TAG_FLOAT_COPIED = 132;
    public static final int TAG_DOUBLE_COPIED = 133;
    public static final int TAG_BYTE_EXPANDED = 512;
    protected Raster raster;
    protected int rectWidth;
    protected int rectHeight;
    protected int rectX;
    protected int rectY;
    protected int formatTagID;
    protected byte[][] byteDataArrays = null;
    protected short[][] shortDataArrays = null;
    protected int[][] intDataArrays = null;
    protected float[][] floatDataArrays = null;
    protected double[][] doubleDataArrays = null;
    protected int[] bandDataOffsets;
    protected int[] bandOffsets;
    protected int numBands;
    protected int scanlineStride;
    protected int pixelStride;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RasterAccessor(Raster raster, Rectangle rectangle, RasterFormatTag rasterFormatTag, ColorModel colorModel) {
        this.raster = raster;
        this.rectX = rectangle.x;
        this.rectY = rectangle.y;
        this.rectWidth = rectangle.width;
        this.rectHeight = rectangle.height;
        this.formatTagID = rasterFormatTag.getFormatTagID();
        if ((this.formatTagID & 0x180) == 0) {
            int n;
            int n2;
            this.numBands = rasterFormatTag.getNumBands();
            this.pixelStride = rasterFormatTag.getPixelStride();
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
            this.scanlineStride = componentSampleModel.getScanlineStride();
            int[] nArray = null;
            if (rasterFormatTag.isPixelSequential()) {
                this.bandOffsets = rasterFormatTag.getBandOffsets();
                nArray = rasterFormatTag.getBankIndices();
            } else {
                this.bandOffsets = componentSampleModel.getBandOffsets();
                nArray = componentSampleModel.getBankIndices();
            }
            this.bandDataOffsets = new int[this.numBands];
            int[] nArray2 = raster.getDataBuffer().getOffsets();
            int n3 = (this.rectY - raster.getSampleModelTranslateY()) * this.scanlineStride + (this.rectX - raster.getSampleModelTranslateX()) * this.pixelStride;
            if (nArray2.length == 1) {
                n2 = nArray2[0];
                n = 0;
                while (n < this.numBands) {
                    this.bandDataOffsets[n] = this.bandOffsets[n] + n2 + n3;
                    ++n;
                }
            } else {
                if (nArray2.length != this.bandDataOffsets.length) throw new RuntimeException(JaiI18N.getString("RasterAccessor0"));
                n2 = 0;
                while (n2 < this.numBands) {
                    this.bandDataOffsets[n2] = this.bandOffsets[n2] + nArray2[n2] + n3;
                    ++n2;
                }
            }
            switch (this.formatTagID & 0x7F) {
                case 0: {
                    DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
                    this.byteDataArrays = new byte[this.numBands][];
                    n = 0;
                    while (n < this.numBands) {
                        this.byteDataArrays[n] = dataBufferByte.getData(nArray[n]);
                        ++n;
                    }
                    break;
                }
                case 1: {
                    DataBufferUShort dataBufferUShort = (DataBufferUShort)raster.getDataBuffer();
                    this.shortDataArrays = new short[this.numBands][];
                    int n4 = 0;
                    while (n4 < this.numBands) {
                        this.shortDataArrays[n4] = dataBufferUShort.getData(nArray[n4]);
                        ++n4;
                    }
                    break;
                }
                case 2: {
                    DataBufferShort dataBufferShort = (DataBufferShort)raster.getDataBuffer();
                    this.shortDataArrays = new short[this.numBands][];
                    int n5 = 0;
                    while (n5 < this.numBands) {
                        this.shortDataArrays[n5] = dataBufferShort.getData(nArray[n5]);
                        ++n5;
                    }
                    break;
                }
                case 3: {
                    DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
                    this.intDataArrays = new int[this.numBands][];
                    int n6 = 0;
                    while (n6 < this.numBands) {
                        this.intDataArrays[n6] = dataBufferInt.getData(nArray[n6]);
                        ++n6;
                    }
                    break;
                }
                case 4: {
                    DataBufferFloat dataBufferFloat = (DataBufferFloat)raster.getDataBuffer();
                    this.floatDataArrays = new float[this.numBands][];
                    int n7 = 0;
                    while (n7 < this.numBands) {
                        this.floatDataArrays[n7] = dataBufferFloat.getData(nArray[n7]);
                        ++n7;
                    }
                    break;
                }
                case 5: {
                    DataBufferDouble dataBufferDouble = (DataBufferDouble)raster.getDataBuffer();
                    this.doubleDataArrays = new double[this.numBands][];
                    int n8 = 0;
                    while (n8 < this.numBands) {
                        this.doubleDataArrays[n8] = dataBufferDouble.getData(nArray[n8]);
                        ++n8;
                    }
                    break;
                }
            }
            if ((this.formatTagID & 0x600) != 512 || !(colorModel instanceof IndexColorModel)) return;
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            int n9 = OpImage.getExpandedNumBands(raster.getSampleModel(), indexColorModel);
            int n10 = indexColorModel.getMapSize();
            int[] nArray3 = new int[n9];
            int n11 = this.rectWidth * n9;
            int n12 = n9;
            byte[][] byArray = new byte[n9][n10];
            indexColorModel.getReds(byArray[0]);
            indexColorModel.getGreens(byArray[1]);
            indexColorModel.getBlues(byArray[2]);
            byte[] byArray2 = byArray[0];
            byte[] byArray3 = byArray[1];
            byte[] byArray4 = byArray[2];
            byte[] byArray5 = null;
            if (n9 == 4) {
                indexColorModel.getAlphas(byArray[3]);
                byArray5 = byArray[3];
            }
            int n13 = 0;
            while (n13 < n9) {
                nArray3[n13] = n13;
                ++n13;
            }
            switch (this.formatTagID & 0x7F) {
                case 0: {
                    int n14;
                    byte[] byArray6 = new byte[this.rectWidth * this.rectHeight * n9];
                    byte[] byArray7 = this.byteDataArrays[0];
                    int n15 = this.bandDataOffsets[0];
                    int n16 = 0;
                    int n17 = 0;
                    while (n17 < this.rectHeight) {
                        n14 = n15;
                        int n18 = n16;
                        int n19 = 0;
                        while (n19 < this.rectWidth) {
                            int n20 = byArray7[n14] & 0xFF;
                            int n21 = 0;
                            while (n21 < n9) {
                                byArray6[n18 + n21] = byArray[n21][n20];
                                ++n21;
                            }
                            n14 += this.pixelStride;
                            n18 += n12;
                            ++n19;
                        }
                        n15 += this.scanlineStride;
                        n16 += n11;
                        ++n17;
                    }
                    this.byteDataArrays = new byte[n9][];
                    n14 = 0;
                    while (n14 < n9) {
                        this.byteDataArrays[n14] = byArray6;
                        ++n14;
                    }
                    break;
                }
                case 1: {
                    int n22;
                    short[] sArray = new short[this.rectWidth * this.rectHeight * n9];
                    short[] sArray2 = this.shortDataArrays[0];
                    int n23 = this.bandDataOffsets[0];
                    int n24 = 0;
                    int n25 = 0;
                    while (n25 < this.rectHeight) {
                        n22 = n23;
                        int n26 = n24;
                        int n27 = 0;
                        while (n27 < this.rectWidth) {
                            int n28 = sArray2[n22] & 0xFFFF;
                            int n29 = 0;
                            while (n29 < n9) {
                                sArray[n26 + n29] = (short)(byArray[n29][n28] & 0xFF);
                                ++n29;
                            }
                            n22 += this.pixelStride;
                            n26 += n12;
                            ++n27;
                        }
                        n23 += this.scanlineStride;
                        n24 += n11;
                        ++n25;
                    }
                    this.shortDataArrays = new short[n9][];
                    n22 = 0;
                    while (n22 < n9) {
                        this.shortDataArrays[n22] = sArray;
                        ++n22;
                    }
                    break;
                }
                case 2: {
                    int n30;
                    short[] sArray = new short[this.rectWidth * this.rectHeight * n9];
                    short[] sArray3 = this.shortDataArrays[0];
                    int n31 = this.bandDataOffsets[0];
                    int n32 = 0;
                    int n33 = 0;
                    while (n33 < this.rectHeight) {
                        n30 = n31;
                        int n34 = n32;
                        int n35 = 0;
                        while (n35 < this.rectWidth) {
                            short s = sArray3[n30];
                            int n36 = 0;
                            while (n36 < n9) {
                                sArray[n34 + n36] = (short)(byArray[n36][s] & 0xFF);
                                ++n36;
                            }
                            n30 += this.pixelStride;
                            n34 += n12;
                            ++n35;
                        }
                        n31 += this.scanlineStride;
                        n32 += n11;
                        ++n33;
                    }
                    this.shortDataArrays = new short[n9][];
                    n30 = 0;
                    while (n30 < n9) {
                        this.shortDataArrays[n30] = sArray;
                        ++n30;
                    }
                    break;
                }
                case 3: {
                    int n37;
                    int[] nArray4 = new int[this.rectWidth * this.rectHeight * n9];
                    int[] nArray5 = this.intDataArrays[0];
                    int n38 = this.bandDataOffsets[0];
                    int n39 = 0;
                    int n40 = 0;
                    while (n40 < this.rectHeight) {
                        n37 = n38;
                        int n41 = n39;
                        int n42 = 0;
                        while (n42 < this.rectWidth) {
                            int n43 = nArray5[n37];
                            int n44 = 0;
                            while (n44 < n9) {
                                nArray4[n41 + n44] = byArray[n44][n43] & 0xFF;
                                ++n44;
                            }
                            n37 += this.pixelStride;
                            n41 += n12;
                            ++n42;
                        }
                        n38 += this.scanlineStride;
                        n39 += n11;
                        ++n40;
                    }
                    this.intDataArrays = new int[n9][];
                    n37 = 0;
                    while (n37 < n9) {
                        this.intDataArrays[n37] = nArray4;
                        ++n37;
                    }
                    break;
                }
                case 4: {
                    int n45;
                    float[] fArray = new float[this.rectWidth * this.rectHeight * n9];
                    float[] fArray2 = this.floatDataArrays[0];
                    int n46 = this.bandDataOffsets[0];
                    int n47 = 0;
                    int n48 = 0;
                    while (n48 < this.rectHeight) {
                        n45 = n46;
                        int n49 = n47;
                        int n50 = 0;
                        while (n50 < this.rectWidth) {
                            int n51 = (int)fArray2[n45];
                            int n52 = 0;
                            while (n52 < n9) {
                                fArray[n49 + n52] = byArray[n52][n51] & 0xFF;
                                ++n52;
                            }
                            n45 += this.pixelStride;
                            n49 += n12;
                            ++n50;
                        }
                        n46 += this.scanlineStride;
                        n47 += n11;
                        ++n48;
                    }
                    this.floatDataArrays = new float[n9][];
                    n45 = 0;
                    while (n45 < n9) {
                        this.floatDataArrays[n45] = fArray;
                        ++n45;
                    }
                    break;
                }
                case 5: {
                    int n53;
                    double[] dArray = new double[this.rectWidth * this.rectHeight * n9];
                    double[] dArray2 = this.doubleDataArrays[0];
                    int n54 = this.bandDataOffsets[0];
                    int n55 = 0;
                    int n56 = 0;
                    while (n56 < this.rectHeight) {
                        n53 = n54;
                        int n57 = n55;
                        int n58 = 0;
                        while (n58 < this.rectWidth) {
                            int n59 = (int)dArray2[n53];
                            int n60 = 0;
                            while (n60 < n9) {
                                dArray[n57 + n60] = byArray[n60][n59] & 0xFF;
                                ++n60;
                            }
                            n53 += this.pixelStride;
                            n57 += n12;
                            ++n58;
                        }
                        n54 += this.scanlineStride;
                        n55 += n11;
                        ++n56;
                    }
                    this.doubleDataArrays = new double[n9][];
                    n53 = 0;
                    while (n53 < n9) {
                        this.doubleDataArrays[n53] = dArray;
                        ++n53;
                    }
                    break;
                }
            }
            this.numBands = n9;
            this.pixelStride = n12;
            this.scanlineStride = n11;
            this.bandDataOffsets = nArray3;
            this.bandOffsets = nArray3;
            return;
        }
        if ((this.formatTagID & 0x180) == 128 && (this.formatTagID & 0x600) != 1024 && colorModel != null) {
            this.pixelStride = this.numBands = OpImage.getExpandedNumBands(raster.getSampleModel(), colorModel);
            this.scanlineStride = this.rectWidth * this.numBands;
            this.bandOffsets = new int[this.numBands];
            int n = 0;
            while (n < this.numBands) {
                this.bandOffsets[n] = n;
                ++n;
            }
            this.bandDataOffsets = this.bandOffsets;
            Object object = null;
            int n61 = 0;
            int[] nArray = new int[colorModel.getNumComponents()];
            switch (this.formatTagID & 0x7F) {
                case 3: {
                    int[] nArray6 = new int[this.rectWidth * this.rectHeight * this.numBands];
                    this.intDataArrays = new int[this.numBands][];
                    int n62 = 0;
                    while (n62 < this.numBands) {
                        this.intDataArrays[n62] = nArray6;
                        ++n62;
                    }
                    object = raster.getDataElements(this.rectX, this.rectY, null);
                    n61 = 0;
                    byte[] byArray = null;
                    if (raster instanceof BytePackedRaster) {
                        byArray = (byte[])object;
                    }
                    int n63 = this.rectY;
                    while (n63 < this.rectY + this.rectHeight) {
                        int n64 = this.rectX;
                        while (n64 < this.rectX + this.rectWidth) {
                            if (byArray != null) {
                                byArray[0] = (byte)raster.getSample(n64, n63, 0);
                            } else {
                                raster.getDataElements(n64, n63, object);
                            }
                            colorModel.getComponents(object, nArray, 0);
                            nArray6[n61] = nArray[0];
                            nArray6[n61 + 1] = nArray[1];
                            nArray6[n61 + 2] = nArray[2];
                            if (this.numBands > 3) {
                                nArray6[n61 + 3] = nArray[3];
                            }
                            n61 += this.pixelStride;
                            ++n64;
                        }
                        ++n63;
                    }
                    return;
                }
                case 4: {
                    float[] fArray = new float[this.rectWidth * this.rectHeight * this.numBands];
                    this.floatDataArrays = new float[this.numBands][];
                    int n65 = 0;
                    while (n65 < this.numBands) {
                        this.floatDataArrays[n65] = fArray;
                        ++n65;
                    }
                    object = null;
                    n61 = 0;
                    n65 = this.rectY;
                    while (n65 < this.rectY + this.rectHeight) {
                        int n66 = this.rectX;
                        while (n66 < this.rectX + this.rectWidth) {
                            object = raster.getDataElements(n66, n65, object);
                            colorModel.getComponents(object, nArray, 0);
                            fArray[n61] = nArray[0];
                            fArray[n61 + 1] = nArray[1];
                            fArray[n61 + 2] = nArray[2];
                            if (this.numBands > 3) {
                                fArray[n61 + 3] = nArray[3];
                            }
                            n61 += this.pixelStride;
                            ++n66;
                        }
                        ++n65;
                    }
                    return;
                }
                case 5: {
                    double[] dArray = new double[this.rectWidth * this.rectHeight * this.numBands];
                    this.doubleDataArrays = new double[this.numBands][];
                    int n67 = 0;
                    while (n67 < this.numBands) {
                        this.doubleDataArrays[n67] = dArray;
                        ++n67;
                    }
                    object = null;
                    n61 = 0;
                    n67 = this.rectY;
                    while (n67 < this.rectY + this.rectHeight) {
                        int n68 = this.rectX;
                        while (n68 < this.rectX + this.rectWidth) {
                            object = raster.getDataElements(n68, n67, object);
                            colorModel.getComponents(object, nArray, 0);
                            dArray[n61] = nArray[0];
                            dArray[n61 + 1] = nArray[1];
                            dArray[n61 + 2] = nArray[2];
                            if (this.numBands > 3) {
                                dArray[n61 + 3] = nArray[3];
                            }
                            n61 += this.pixelStride;
                            ++n68;
                        }
                        ++n67;
                    }
                    return;
                }
                default: {
                    return;
                }
            }
        }
        this.pixelStride = this.numBands = rasterFormatTag.getNumBands();
        this.scanlineStride = this.rectWidth * this.numBands;
        this.bandDataOffsets = rasterFormatTag.getBandOffsets();
        this.bandOffsets = this.bandDataOffsets;
        switch (this.formatTagID & 0x7F) {
            case 3: {
                int[] nArray = raster.getPixels(this.rectX, this.rectY, this.rectWidth, this.rectHeight, (int[])null);
                this.intDataArrays = new int[this.numBands][];
                int n = 0;
                while (n < this.numBands) {
                    this.intDataArrays[n] = nArray;
                    ++n;
                }
                break;
            }
            case 4: {
                float[] fArray = raster.getPixels(this.rectX, this.rectY, this.rectWidth, this.rectHeight, (float[])null);
                this.floatDataArrays = new float[this.numBands][];
                int n = 0;
                while (n < this.numBands) {
                    this.floatDataArrays[n] = fArray;
                    ++n;
                }
                break;
            }
            case 5: {
                double[] dArray = raster.getPixels(this.rectX, this.rectY, this.rectWidth, this.rectHeight, (double[])null);
                this.doubleDataArrays = new double[this.numBands][];
                int n = 0;
                while (n < this.numBands) {
                    this.doubleDataArrays[n] = dArray;
                    ++n;
                }
            }
        }
    }

    private void clampDataArray(double[] dArray, double[] dArray2) {
        switch (this.getDataType()) {
            case 3: {
                this.clampIntArrays(this.toIntArray(dArray), this.toIntArray(dArray2));
                break;
            }
            case 4: {
                this.clampFloatArrays(this.toFloatArray(dArray), this.toFloatArray(dArray2));
                break;
            }
            case 5: {
                this.clampDoubleArrays(dArray, dArray2);
                break;
            }
        }
    }

    public void clampDataArrays() {
        int n;
        int[] nArray = this.raster.getSampleModel().getSampleSize();
        boolean bl = false;
        boolean bl2 = true;
        int n2 = 0;
        while (n2 < nArray.length) {
            n = nArray[0];
            if (nArray[n2] < 32) {
                bl = true;
            }
            if (nArray[n2] != n) {
                bl2 = false;
            }
            ++n2;
        }
        if (!bl) {
            return;
        }
        n = this.raster.getDataBuffer().getDataType();
        double[] dArray = new double[nArray.length];
        double[] dArray2 = new double[nArray.length];
        if (n == 1 && bl2 && nArray[0] == 16) {
            int n3 = 0;
            while (n3 < nArray.length) {
                dArray[n3] = 65535.0;
                dArray2[n3] = 0.0;
                ++n3;
            }
        } else if (n == 2 && bl2 && nArray[0] == 16) {
            int n4 = 0;
            while (n4 < nArray.length) {
                dArray[n4] = 32767.0;
                dArray2[n4] = -32768.0;
                ++n4;
            }
        } else if (n == 3 && bl2 && nArray[0] == 32) {
            int n5 = 0;
            while (n5 < nArray.length) {
                dArray[n5] = 2.147483647E9;
                dArray2[n5] = -2.147483648E9;
                ++n5;
            }
        } else {
            int n6 = 0;
            while (n6 < nArray.length) {
                dArray[n6] = (1 << nArray[n6]) - 1;
                dArray2[n6] = 0.0;
                ++n6;
            }
        }
        this.clampDataArray(dArray, dArray2);
    }

    private void clampDoubleArrays(double[] dArray, double[] dArray2) {
        int n = this.rectWidth;
        int n2 = this.rectHeight;
        int n3 = 0;
        while (n3 < this.numBands) {
            double[] dArray3 = this.doubleDataArrays[n3];
            int n4 = this.bandDataOffsets[n3];
            double d = dArray[n3];
            double d2 = dArray2[n3];
            int n5 = 0;
            while (n5 < n2) {
                int n6 = n4;
                int n7 = 0;
                while (n7 < n) {
                    double d3 = dArray3[n6];
                    if (d3 < d2) {
                        dArray3[n6] = d2;
                    } else if (d3 > d) {
                        dArray3[n6] = d;
                    }
                    n6 += this.pixelStride;
                    ++n7;
                }
                n4 += this.scanlineStride;
                ++n5;
            }
            ++n3;
        }
    }

    private void clampFloatArrays(float[] fArray, float[] fArray2) {
        int n = this.rectWidth;
        int n2 = this.rectHeight;
        int n3 = 0;
        while (n3 < this.numBands) {
            float[] fArray3 = this.floatDataArrays[n3];
            int n4 = this.bandDataOffsets[n3];
            float f = fArray[n3];
            float f2 = fArray2[n3];
            int n5 = 0;
            while (n5 < n2) {
                int n6 = n4;
                int n7 = 0;
                while (n7 < n) {
                    float f3 = fArray3[n6];
                    if (f3 < f2) {
                        fArray3[n6] = f2;
                    } else if (f3 > f) {
                        fArray3[n6] = f;
                    }
                    n6 += this.pixelStride;
                    ++n7;
                }
                n4 += this.scanlineStride;
                ++n5;
            }
            ++n3;
        }
    }

    private void clampIntArrays(int[] nArray, int[] nArray2) {
        int n = this.rectWidth;
        int n2 = this.rectHeight;
        int n3 = 0;
        while (n3 < this.numBands) {
            int[] nArray3 = this.intDataArrays[n3];
            int n4 = this.bandDataOffsets[n3];
            int n5 = nArray[n3];
            int n6 = nArray2[n3];
            int n7 = 0;
            while (n7 < n2) {
                int n8 = n4;
                int n9 = 0;
                while (n9 < n) {
                    int n10 = nArray3[n8];
                    if (n10 < n6) {
                        nArray3[n8] = n6;
                    } else if (n10 > n5) {
                        nArray3[n8] = n5;
                    }
                    n8 += this.pixelStride;
                    ++n9;
                }
                n4 += this.scanlineStride;
                ++n7;
            }
            ++n3;
        }
    }

    public void copyDataToRaster() {
        if (this.isDataCopy()) {
            WritableRaster writableRaster = (WritableRaster)this.raster;
            switch (this.getDataType()) {
                case 3: {
                    writableRaster.setPixels(this.rectX, this.rectY, this.rectWidth, this.rectHeight, this.intDataArrays[0]);
                    break;
                }
                case 4: {
                    writableRaster.setPixels(this.rectX, this.rectY, this.rectWidth, this.rectHeight, this.floatDataArrays[0]);
                    break;
                }
                case 5: {
                    writableRaster.setPixels(this.rectX, this.rectY, this.rectWidth, this.rectHeight, this.doubleDataArrays[0]);
                    break;
                }
            }
        }
    }

    public static int findCompatibleTag(SampleModel[] sampleModelArray, SampleModel sampleModel) {
        int n = sampleModel.getTransferType();
        int n2 = n | 0x80;
        if (n == 0 || n == 1 || n == 2) {
            n2 = 131;
        }
        if (sampleModel instanceof ComponentSampleModel) {
            if (sampleModelArray != null) {
                int n3 = sampleModelArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    int n5 = sampleModelArray[n4].getTransferType();
                    if (!(sampleModelArray[n4] instanceof ComponentSampleModel) || n5 != n) break;
                    ++n4;
                }
                if (n4 == n3) {
                    n2 = n;
                }
            } else {
                n2 = n;
            }
        }
        return n2 | 0x400;
    }

    public static RasterFormatTag[] findCompatibleTags(RenderedImage[] renderedImageArray, RenderedImage renderedImage) {
        int n;
        int n2;
        int n3;
        int n4;
        int[] nArray = renderedImageArray != null ? new int[renderedImageArray.length + 1] : new int[1];
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n5 = n4 = sampleModel.getTransferType();
        if (n4 == 0 || n4 == 1 || n4 == 2) {
            n5 = 3;
        }
        if (renderedImageArray != null) {
            n3 = renderedImageArray.length;
            n2 = 0;
            while (n2 < n3) {
                SampleModel sampleModel2 = renderedImageArray[n2].getSampleModel();
                n = sampleModel2.getTransferType();
                if (n > n5) {
                    n5 = n;
                }
                ++n2;
            }
        }
        n3 = n5 | 0x80;
        if (sampleModel instanceof ComponentSampleModel) {
            if (renderedImageArray != null) {
                n2 = renderedImageArray.length;
                int n6 = 0;
                while (n6 < n2) {
                    SampleModel sampleModel3 = renderedImageArray[n6].getSampleModel();
                    int n7 = sampleModel3.getTransferType();
                    if (!(sampleModel3 instanceof ComponentSampleModel) || n7 != n4) break;
                    ++n6;
                }
                if (n6 == n2) {
                    n3 = n4;
                }
            } else {
                n3 = n4;
            }
        }
        RasterFormatTag[] rasterFormatTagArray = new RasterFormatTag[nArray.length];
        if (renderedImageArray != null) {
            int n8 = 0;
            while (n8 < renderedImageArray.length) {
                nArray[n8] = renderedImageArray[n8].getColorModel() instanceof IndexColorModel ? (renderedImage.getColorModel() instanceof IndexColorModel ? n3 | 0x400 : n3 | 0x200) : (renderedImageArray[n8].getColorModel() instanceof ComponentColorModel ? n3 | 0x400 : n3);
                ++n8;
            }
            nArray[renderedImageArray.length] = n3 | 0x400;
            n = 0;
            while (n < renderedImageArray.length) {
                rasterFormatTagArray[n] = new RasterFormatTag(renderedImageArray[n].getSampleModel(), nArray[n]);
                ++n;
            }
            rasterFormatTagArray[renderedImageArray.length] = new RasterFormatTag(sampleModel, nArray[renderedImageArray.length]);
        } else {
            rasterFormatTagArray[0] = new RasterFormatTag(sampleModel, n3 | 0x400);
        }
        return rasterFormatTagArray;
    }

    public int getBandOffset(int n) {
        return this.bandDataOffsets[n];
    }

    public int[] getBandOffsets() {
        return this.bandDataOffsets;
    }

    public byte[] getByteDataArray(int n) {
        return this.byteDataArrays == null ? null : this.byteDataArrays[n];
    }

    public byte[][] getByteDataArrays() {
        return this.byteDataArrays;
    }

    public Object getDataArray(int n) {
        Object[] objectArray = null;
        switch (this.getDataType()) {
            case 0: {
                objectArray = this.getByteDataArray(n);
                break;
            }
            case 1: 
            case 2: {
                objectArray = this.getShortDataArray(n);
                break;
            }
            case 3: {
                objectArray = this.getIntDataArray(n);
                break;
            }
            case 4: {
                objectArray = this.getFloatDataArray(n);
                break;
            }
            case 5: {
                objectArray = this.getDoubleDataArray(n);
                break;
            }
            default: {
                objectArray = null;
            }
        }
        return objectArray;
    }

    public int getDataType() {
        return this.formatTagID & 0x7F;
    }

    public double[] getDoubleDataArray(int n) {
        return this.doubleDataArrays == null ? null : this.doubleDataArrays[n];
    }

    public double[][] getDoubleDataArrays() {
        return this.doubleDataArrays;
    }

    public float[] getFloatDataArray(int n) {
        return this.floatDataArrays == null ? null : this.floatDataArrays[n];
    }

    public float[][] getFloatDataArrays() {
        return this.floatDataArrays;
    }

    public int getHeight() {
        return this.rectHeight;
    }

    public int[] getIntDataArray(int n) {
        return this.intDataArrays == null ? null : this.intDataArrays[n];
    }

    public int[][] getIntDataArrays() {
        return this.intDataArrays;
    }

    public int getNumBands() {
        return this.numBands;
    }

    public int getOffsetForBand(int n) {
        return this.bandOffsets[n];
    }

    public int[] getOffsetsForBands() {
        return this.bandOffsets;
    }

    public int getPixelStride() {
        return this.pixelStride;
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public short[] getShortDataArray(int n) {
        return this.shortDataArrays == null ? null : this.shortDataArrays[n];
    }

    public short[][] getShortDataArrays() {
        return this.shortDataArrays;
    }

    public int getWidth() {
        return this.rectWidth;
    }

    public int getX() {
        return this.rectX;
    }

    public int getY() {
        return this.rectY;
    }

    public boolean isDataCopy() {
        return (this.formatTagID & 0x180) == 128;
    }

    public boolean needsClamping() {
        int[] nArray = this.raster.getSampleModel().getSampleSize();
        boolean bl = false;
        boolean bl2 = true;
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[0];
            if (nArray[n] < 32) {
                bl = true;
            }
            if (nArray[n] != n2) {
                bl2 = false;
            }
            ++n;
        }
        return bl;
    }

    private float[] toFloatArray(double[] dArray) {
        float[] fArray = new float[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            fArray[n] = (float)dArray[n];
            ++n;
        }
        return fArray;
    }

    private int[] toIntArray(double[] dArray) {
        int[] nArray = new int[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            nArray[n] = (int)dArray[n];
            ++n;
        }
        return nArray;
    }
}

