/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.Convert;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.JdbcDataObject;
import com.sybase.jdbc2.jdbc.ProtocolResultSet;
import com.sybase.jdbc2.jdbc.SybStatement;
import com.sybase.jdbc2.utils.CacheManager;
import com.sybase.jdbc2.utils.Cacheable;
import com.sybase.jdbc2.utils.Debug;
import com.sybase.jdbcx.TextPointer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;

public class SybResultSet
implements com.sybase.jdbcx.SybResultSet,
Cacheable {
    protected static final int BEFORE_FIRST = -1;
    protected static final int AFTER_LAST = -2;
    protected static final int INSERT_ROW = -3;
    protected static final int UNDEFINED = -4;
    protected ProtocolResultSet _prs;
    protected JdbcDataObject _currentColumn;
    protected SybStatement _statement;
    protected int _state = 2;
    private Hashtable _nameToColumn = null;
    protected CacheManager _cm;
    protected int _rowIndex;
    protected int _lastRowIndex = -4;
    protected int _concurType = 1007;
    protected String _concurTypeString = "CONCUR_READ_ONLY";
    protected int _scrollType = 1003;
    protected int _fetchSize = 0;
    protected int _fetchDirection = 1000;

    public SybResultSet(SybStatement sybStatement, ProtocolResultSet protocolResultSet) throws SQLException {
        this._statement = sybStatement;
        this._prs = protocolResultSet;
        this._rowIndex = -1;
        if (this._prs != null) {
            this._scrollType = this._prs.getType();
        }
    }

    public boolean absolute(int n) throws SQLException {
        int n2;
        this.checkForScrollability("absolute(int)");
        if (this._lastRowIndex == 0) {
            return false;
        }
        if (n == 0) {
            ErrorMessage.raiseError("JZ0I3", String.valueOf(n), "absolute(int)");
        }
        if (n < 0) {
            if (this._lastRowIndex == -4 && !this.last()) {
                return false;
            }
            if ((n += this._lastRowIndex + 1) <= 0) {
                this.beforeFirst();
                return false;
            }
        }
        if (n <= (n2 = this._prs.getNumRowsCached())) {
            this._rowIndex = n;
            this._prs.absolute(n);
            return true;
        }
        if (n2 > 0) {
            this._rowIndex = n2;
            this._prs.absolute(this._rowIndex);
        }
        while (this._rowIndex < n && this.next()) {
        }
        return this._rowIndex == n;
    }

    public void afterLast() throws SQLException {
        this.checkForScrollability("afterLast()");
        if (this.last()) {
            this.next();
        }
    }

    public void beforeFirst() throws SQLException {
        this.checkForScrollability("beforeFirst()");
        if (this.first()) {
            this.previous();
        }
    }

    public void cache() throws IOException {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            ErrorMessage.raiseIOException("JZ006", sQLException.getMessage());
        }
    }

    public void cancelRowUpdates() throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "cancelRowUpdates()", this._concurTypeString);
    }

    private void checkForScrollability(String string) throws SQLException {
        switch (this._scrollType) {
            case 1003: {
                ErrorMessage.raiseError("JZ0BT", string, "TYPE_FORWARD_ONLY");
                break;
            }
            case 1005: {
                Debug.notImplemented(this, String.valueOf(string) + " for TYPE_SCROLL_SENSITIVE");
                break;
            }
        }
    }

    protected void checkResultSet() throws SQLException {
        if (this._state != 2) {
            ErrorMessage.raiseError("JZ0R0");
        }
    }

    public void clear() throws IOException {
        try {
            this.close(false);
        }
        catch (SQLException sQLException) {
            ErrorMessage.raiseIOException("JZ006", sQLException.getMessage());
        }
    }

    public void clearWarnings() throws SQLException {
        this._prs.clearWarnings();
    }

    public void close() throws SQLException {
        this.close(false);
    }

    protected void close(boolean bl) throws SQLException {
        this.markDead(bl);
    }

    public void deleteRow() throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "deleteRow()", this._concurTypeString);
    }

    public int findColumn(String string) throws SQLException {
        Integer n;
        if (this._nameToColumn == null) {
            this._nameToColumn = new Hashtable();
        }
        if ((n = (Integer)this._nameToColumn.get(string)) != null) {
            return n;
        }
        int n2 = this._prs.findColumn(string);
        this._nameToColumn.put(string, new Integer(n2));
        return n2;
    }

    public boolean first() throws SQLException {
        this.checkForScrollability("first()");
        this.moveToCurrentRow();
        if (this._rowIndex == 1) {
            return true;
        }
        return this.absolute(1);
    }

    public Array getArray(int n) throws SQLException {
        Debug.notSupported(this, "getArray(int)");
        return null;
    }

    public Array getArray(String string) throws SQLException {
        Debug.notSupported(this, "getArray(String)");
        return null;
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        return this.getColumn(n).getAsciiStream();
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.getBigDecimal(n, -1);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.getColumn(n).getBigDecimal(n2);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(string, -1);
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        return this.getColumn(n).getBinaryStream();
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public Blob getBlob(int n) throws SQLException {
        Debug.notSupported(this, "getBlob(int)");
        return null;
    }

    public Blob getBlob(String string) throws SQLException {
        Debug.notSupported(this, "getBlob(String)");
        return null;
    }

    public boolean getBoolean(int n) throws SQLException {
        return this.getColumn(n).getBoolean();
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(int n) throws SQLException {
        return this.getColumn(n).getByte();
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public byte[] getBytes(int n) throws SQLException {
        return this.getColumn(n).getBytes();
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Reader getCharacterStream(int n) throws SQLException {
        return this.getColumn(n).getCharacterStream();
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public Clob getClob(int n) throws SQLException {
        Debug.notSupported(this, "getClob(int)");
        return null;
    }

    public Clob getClob(String string) throws SQLException {
        Debug.notSupported(this, "getClob(String)");
        return null;
    }

    protected JdbcDataObject getColumn(int n) throws SQLException {
        this.checkResultSet();
        this._currentColumn = this._prs.getColumn(n);
        return this._currentColumn;
    }

    public int getConcurrency() throws SQLException {
        return this._concurType;
    }

    public String getCursorName() throws SQLException {
        return null;
    }

    public Date getDate(int n) throws SQLException {
        return Convert.objectToDate(this.getColumn(n).getDateObject(91, null));
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return Convert.objectToDate(this.getColumn(n).getDateObject(91, calendar));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public double getDouble(int n) throws SQLException {
        return this.getColumn(n).getDouble();
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public int getFetchDirection() throws SQLException {
        return this._fetchDirection;
    }

    public int getFetchSize() throws SQLException {
        return this._fetchSize;
    }

    public float getFloat(int n) throws SQLException {
        return this.getColumn(n).getFloat();
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public int getInt(int n) throws SQLException {
        return this.getColumn(n).getInt();
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(int n) throws SQLException {
        return this.getColumn(n).getLong();
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkResultSet();
        return this._prs.getMetaData();
    }

    public Object getObject(int n) throws SQLException {
        return this.getColumn(n).getObject();
    }

    public Object getObject(int n, Map map) throws SQLException {
        Debug.notImplemented(this, "getObject(int, java.util.Map)");
        return null;
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public Object getObject(String string, Map map) throws SQLException {
        Debug.notImplemented(this, "getObject(String, java.util.Map)");
        return null;
    }

    public Ref getRef(int n) throws SQLException {
        Debug.notSupported(this, "getRef(int)");
        return null;
    }

    public Ref getRef(String string) throws SQLException {
        Debug.notSupported(this, "getRef(String)");
        return null;
    }

    public int getRow() throws SQLException {
        if (this._rowIndex <= 0) {
            return 0;
        }
        return this._rowIndex;
    }

    public short getShort(int n) throws SQLException {
        return this.getColumn(n).getShort();
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getState() {
        if (this._state == 4) {
            return 0;
        }
        return 1;
    }

    public Statement getStatement() throws SQLException {
        return this._statement;
    }

    public String getString(int n) throws SQLException {
        return this.getColumn(n).getString();
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public TextPointer getSybTextPointer(int n) throws SQLException {
        return this.getColumn(n).getTextPtr();
    }

    public TextPointer getSybTextPointer(String string) throws SQLException {
        return this.getSybTextPointer(this.findColumn(string));
    }

    public Time getTime(int n) throws SQLException {
        return Convert.objectToTime(this.getColumn(n).getDateObject(92, null));
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return Convert.objectToTime(this.getColumn(n).getDateObject(92, calendar));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return Convert.objectToTimestamp(this.getColumn(n).getDateObject(93, null));
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return Convert.objectToTimestamp(this.getColumn(n).getDateObject(93, calendar));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public int getType() throws SQLException {
        return this._scrollType;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        return this.getColumn(n).getUnicodeStream();
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        return this._prs.getWarnings();
    }

    public void insertRow() throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "insertRow()", this._concurTypeString);
    }

    public boolean isAfterLast() throws SQLException {
        return this._rowIndex == -2;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this._rowIndex == -1;
    }

    public boolean isFirst() throws SQLException {
        return this._rowIndex == 1;
    }

    public boolean isLast() throws SQLException {
        if (this._lastRowIndex != -4) {
            return this._rowIndex == this._lastRowIndex;
        }
        Debug.notImplemented(this, "isLast()");
        return false;
    }

    public boolean last() throws SQLException {
        this.checkForScrollability("last()");
        this.moveToCurrentRow();
        if (this._lastRowIndex == -4) {
            if (this._prs.getNumRowsCached() > 0) {
                this._rowIndex = this._prs.getNumRowsCached();
                this._prs.absolute(this._rowIndex);
            }
            while (this.next()) {
            }
            this.previous();
        } else if (this._lastRowIndex != 0) {
            this._rowIndex = this._lastRowIndex;
            this._prs.absolute(this._rowIndex);
        }
        return this._lastRowIndex != 0;
    }

    protected synchronized void markDead(boolean bl) throws SQLException {
        if (this._state == 4) {
            return;
        }
        this._state = 4;
        if (this._prs != null) {
            this._prs.close(bl);
            if (this._statement != null) {
                try {
                    SQLWarning sQLWarning = this._prs.getWarnings();
                    if (sQLWarning != null) {
                        this._statement.handleSQLE(sQLWarning);
                    }
                }
                catch (SQLException sQLException) {}
                this._statement.setRowCount(this._prs.getCount());
            }
        }
        if (this._cm != null) {
            this._cm.doneReading();
            this._cm.dead(this);
            this._cm = null;
        }
        if (this._statement != null) {
            this._statement._currentRS = null;
            this._statement = null;
        }
        this._nameToColumn = null;
        this._prs = null;
    }

    public void moveToCurrentRow() throws SQLException {
    }

    public void moveToInsertRow() throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "moveToInsertRow()", this._concurTypeString);
    }

    public boolean next() throws SQLException {
        this.checkResultSet();
        this.moveToCurrentRow();
        switch (this._rowIndex) {
            case -2: {
                return false;
            }
            case -1: {
                this._rowIndex = 1;
                break;
            }
            default: {
                if (this._rowIndex <= 0) break;
                ++this._rowIndex;
            }
        }
        boolean bl = this._prs.next();
        if (!bl) {
            if (this._statement != null && this._prs != null) {
                this._statement.setRowCount(this._prs.getCount());
            }
            if (this._rowIndex == 1) {
                this._lastRowIndex = 0;
                this._rowIndex = -1;
            } else {
                this._lastRowIndex = this._rowIndex - 1;
                this._rowIndex = -2;
            }
        }
        this._currentColumn = null;
        return bl;
    }

    public void open(boolean bl) {
    }

    public boolean previous() throws SQLException {
        this.checkForScrollability("previous()");
        boolean bl = true;
        switch (this._rowIndex) {
            case -1: {
                return false;
            }
            case 1: {
                this._rowIndex = -1;
                bl = false;
                break;
            }
            case -2: {
                this._rowIndex = this._lastRowIndex;
                break;
            }
            default: {
                --this._rowIndex;
            }
        }
        this._prs.previous();
        return bl;
    }

    public void refreshRow() throws SQLException {
        switch (this._scrollType) {
            case 1005: {
                Debug.notImplemented(this, "refreshRow() FOR TYPE_SCROLL_SENSITIVE");
                break;
            }
        }
    }

    public boolean relative(int n) throws SQLException {
        this.checkForScrollability("relative(int)");
        this.moveToCurrentRow();
        boolean bl = false;
        if (this._rowIndex != -1 && this._rowIndex != -2) {
            int n2 = this._rowIndex + n;
            if (n2 <= 0) {
                this.beforeFirst();
            } else {
                bl = this.absolute(n2);
            }
        }
        return bl;
    }

    public void reset() throws IOException {
        Debug.notSupported(this, "reset()");
    }

    public void resetInputStream(InputStream inputStream) {
        Debug.notSupported(this, "resetInputStream(InputStream is)");
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public void setFetchDirection(int n) throws SQLException {
        switch (this._scrollType) {
            case 1003: {
                ErrorMessage.raiseError("JZ0BT", "setFetchDirection(int)", "TYPE_FORWARD_ONLY");
                break;
            }
            case 1004: 
            case 1005: {
                this._fetchDirection = n;
            }
        }
    }

    public void setFetchSize(int n) throws SQLException {
        this._fetchSize = n;
    }

    public void setManager(CacheManager cacheManager) {
        this._cm = cacheManager;
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateAsciiStream(int, java.io.InputStream, int)", this._concurTypeString);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateAsciiStream(String, java.io.InputStream, int)", this._concurTypeString);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBigDecimal(int, BigDecimal)", this._concurTypeString);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBigDecimal(String, BigDecimal)", this._concurTypeString);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBinaryStream(int, java.io.InputStream, int)", this._concurTypeString);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBinaryStream(String, java.io.InputStream, int)", this._concurTypeString);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBoolean(int, boolean)", this._concurTypeString);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBoolean(String, boolean)", this._concurTypeString);
    }

    public void updateByte(int n, byte by) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateByte(int, byte)", this._concurTypeString);
    }

    public void updateByte(String string, byte by) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateByte(String, byte)", this._concurTypeString);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBytes(int, byte[])", this._concurTypeString);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBytes(String, byte[])", this._concurTypeString);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateCharacterStream(int, java.io.Reader, int)", this._concurTypeString);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateCharacterStream(String, java.io.Reader, int)", this._concurTypeString);
    }

    public void updateDate(int n, Date date) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateDate(int, java.sql.Date)", this._concurTypeString);
    }

    public void updateDate(String string, Date date) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateDate(String, java.sql.Date)", this._concurTypeString);
    }

    public void updateDouble(int n, double d) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateDouble(int, double)", this._concurTypeString);
    }

    public void updateDouble(String string, double d) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateDouble(String, double)", this._concurTypeString);
    }

    public void updateFloat(int n, float f) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateFloat(int, float)", this._concurTypeString);
    }

    public void updateFloat(String string, float f) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateFloat(String, float)", this._concurTypeString);
    }

    public void updateInt(int n, int n2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateInt(int, int)", this._concurTypeString);
    }

    public void updateInt(String string, int n) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateInt(String, int)", this._concurTypeString);
    }

    public void updateLong(int n, long l) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateLong(int, long)", this._concurTypeString);
    }

    public void updateLong(String string, long l) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateLong(String, long)", this._concurTypeString);
    }

    public void updateNull(int n) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateNull(int)", this._concurTypeString);
    }

    public void updateNull(String string) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateNull(String)", this._concurTypeString);
    }

    public void updateObject(int n, Object object) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateObject(int, Object)", this._concurTypeString);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateObject(int, Object, int)", this._concurTypeString);
    }

    public void updateObject(String string, Object object) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateObject(String, Object)", this._concurTypeString);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateObject(String, Object, int)", this._concurTypeString);
    }

    public void updateRow() throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateRow()", this._concurTypeString);
    }

    public void updateShort(int n, short s) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateShort(int, short)", this._concurTypeString);
    }

    public void updateShort(String string, short s) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateShort(String, short)", this._concurTypeString);
    }

    public void updateString(int n, String string) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateString(int, String)", this._concurTypeString);
    }

    public void updateString(String string, String string2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateString(String, String)", this._concurTypeString);
    }

    public void updateTime(int n, Time time) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateTime(int, java.sql.Time)", this._concurTypeString);
    }

    public void updateTime(String string, Time time) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateTime(String, java.sql.Time)", this._concurTypeString);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateTimestamp(int, java.sql.Timestamp)", this._concurTypeString);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateTimestamp(String, java.sql.Timestamp)", this._concurTypeString);
    }

    public boolean wasNull() throws SQLException {
        this.checkResultSet();
        if (this._currentColumn == null) {
            ErrorMessage.raiseError("JZ0NC");
        }
        return this._currentColumn.isNull();
    }
}

