/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.Tds;
import com.sybase.jdbc2.tds.TdsDataOutputStream;
import com.sybase.jdbc2.tds.TdsInputStream;
import com.sybase.jdbc2.tds.Token;
import java.io.IOException;
import java.sql.SQLException;

public class DynamicToken
extends Token {
    public static final int PREPARE = 1;
    public static final int EXEC = 2;
    public static final int DEALLOC = 4;
    public static final int EXEC_IMMED = 8;
    public static final int PROCNAME = 16;
    public static final int ACK = 32;
    public static final int DESCIN = 64;
    public static final int DESCOUT = 128;
    private static final int UNUSED = 0;
    private static final int HASARGS = 1;
    int _type;
    int _status;
    String _name;
    String _body;

    public DynamicToken(int n, String string, String string2, boolean bl) throws SQLException {
        this._type = n;
        this._name = string;
        this._body = string2;
        this._status = bl ? 1 : 0;
    }

    public DynamicToken(TdsInputStream tdsInputStream) throws IOException {
        try {
            int n = tdsInputStream.readShort();
            this._type = tdsInputStream.readUnsignedByte();
            this._status = tdsInputStream.readUnsignedByte();
            int n2 = tdsInputStream.readUnsignedByte();
            this._name = tdsInputStream.readString(n2);
            if ((n -= 3 + n2) < 2) {
                this._body = null;
                boolean bl = false;
            } else {
                short s = tdsInputStream.readShort();
                this._body = tdsInputStream.readString(s);
            }
        }
        catch (IOException iOException) {
            Token.readSQE(iOException);
        }
    }

    public void send(TdsDataOutputStream tdsDataOutputStream) throws IOException {
        try {
            Tds tds = tdsDataOutputStream._tds;
            tdsDataOutputStream.writeByte(231);
            byte[] byArray = tdsDataOutputStream.stringToByte(this._name);
            byte[] byArray2 = tdsDataOutputStream.stringToByte(this._body);
            int n = 3 + byArray.length;
            if (this._type != 32) {
                n += 2;
                if (byArray2 != null) {
                    n += byArray2.length;
                }
            }
            tdsDataOutputStream.writeShort(n);
            tdsDataOutputStream.writeByte(this._type);
            tdsDataOutputStream.writeByte(this._status);
            tdsDataOutputStream.writeByte(byArray.length);
            tdsDataOutputStream.write(byArray);
            if (this._type != 32) {
                if (byArray2 == null) {
                    tdsDataOutputStream.writeShort(0);
                } else {
                    tdsDataOutputStream.writeShort(byArray2.length);
                    tdsDataOutputStream.write(byArray2);
                }
            }
        }
        catch (IOException iOException) {
            Token.writeSQE(iOException);
        }
    }

    public String toString() {
        String string;
        switch (this._type) {
            case 1: {
                string = "PREPARE";
                break;
            }
            case 2: {
                string = "EXEC";
                break;
            }
            case 4: {
                string = "DEALLOC";
                break;
            }
            case 32: {
                string = "ACK";
                break;
            }
            default: {
                string = "Unknown!";
            }
        }
        return "DYNAMIC: type(" + this._type + ")=" + string + " name: >" + this._name + "< body: >" + this._body + ((this._status & 1) != 0 ? "< (Params)" : "< (No params)");
    }
}

