/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.analyze;

import at.tugraz.genome.arraynormcore.microarrayobjects.ExperimentData;
import at.tugraz.genome.math.MathFunctions;

public class FoldChangeDetector {
    private static final int DOWN = -1;
    private static final int EQUAL = 0;
    private static final int UP = 1;
    private int count_diff_;
    private int count_down_;
    private int count_up_;
    private ExperimentData experiment_;
    private float hi_limit_;
    private float lo_limit_;
    private float thres_;

    public FoldChangeDetector(ExperimentData exp, int find_signific, float thres) {
        this.experiment_ = exp;
        this.thres_ = thres;
        this.hi_limit_ = Math.abs(this.thres_);
        this.lo_limit_ = 0.0f - this.hi_limit_;
        this.count_up_ = 0;
        this.count_down_ = 0;
        this.count_diff_ = 0;
        if (find_signific == 3000) {
            this.detectFoldChanges();
        } else if (find_signific == 3001) {
            this.detectSignificantGenes();
        } else if (find_signific == 3002) {
            this.detectNone();
        } else {
            this.detectNone();
        }
    }

    private void detectFoldChanges() {
        int num_cl = this.experiment_.num_expe_classes_;
        int num_genes = this.experiment_.final_exp_log2_ratios_[0].length;
        int i_ = 0;
        while (i_ < num_cl) {
            this.experiment_.experiment_class_[i_].num_signific_genes_ = 0;
            this.experiment_.experiment_class_[i_].num_signif_gens_up_ = 0;
            this.experiment_.experiment_class_[i_].num_signif_gens_down_ = 0;
            int j_ = 0;
            while (j_ < num_genes) {
                float dummy = this.experiment_.final_exp_log2_ratios_[i_][j_];
                if (dummy > this.hi_limit_) {
                    this.experiment_.experiment_class_[i_].significanc_mark_[j_] = 1;
                    ++this.experiment_.experiment_class_[i_].num_signific_genes_;
                    ++this.experiment_.experiment_class_[i_].num_signif_gens_up_;
                    ++this.count_up_;
                    ++this.count_diff_;
                } else if (dummy < this.lo_limit_) {
                    this.experiment_.experiment_class_[i_].significanc_mark_[j_] = -1;
                    ++this.experiment_.experiment_class_[i_].num_signific_genes_;
                    ++this.experiment_.experiment_class_[i_].num_signif_gens_down_;
                    ++this.count_down_;
                    ++this.count_diff_;
                } else {
                    this.experiment_.experiment_class_[i_].significanc_mark_[j_] = Float.isNaN(dummy) ? 0 : 0;
                }
                ++j_;
            }
            ++i_;
        }
        this.experiment_.significance_mark_ = new int[num_genes];
        int i = 0;
        while (i < num_genes) {
            int j = 0;
            while (j < num_cl) {
                if (this.experiment_.experiment_class_[j].significanc_mark_[i] != 0) {
                    this.experiment_.significance_mark_[i] = 1;
                }
                ++j;
            }
            ++i;
        }
    }

    private void detectNone() {
        int num_cl = this.experiment_.num_expe_classes_;
        int num_genes = this.experiment_.final_exp_log2_ratios_[0].length;
        this.experiment_.significance_mark_ = new int[num_genes];
        int i = 0;
        while (i < num_genes) {
            int j = 0;
            while (j < num_cl) {
                this.experiment_.significance_mark_[i] = 1;
                ++j;
            }
            ++i;
        }
    }

    public void detectSignificantGenes() {
        float sign_lim = this.thres_;
        int num_cl = this.experiment_.num_expe_classes_;
        int num_genes = this.experiment_.final_exp_log2_ratios_[0].length;
        int i_ = 0;
        while (i_ < num_cl) {
            this.experiment_.experiment_class_[i_].num_signific_genes_ = 0;
            this.experiment_.experiment_class_[i_].num_signif_gens_up_ = 0;
            this.experiment_.experiment_class_[i_].num_signif_gens_down_ = 0;
            float mu = MathFunctions.mean(this.experiment_.final_exp_log2_ratios_[i_]);
            float stdd = MathFunctions.stddeviation(this.experiment_.final_exp_log2_ratios_[i_]);
            int j_ = 0;
            while (j_ < num_genes) {
                float z_val = (this.experiment_.final_exp_log2_ratios_[i_][j_] - mu) / stdd;
                if (Math.abs(z_val) > sign_lim) {
                    this.experiment_.experiment_class_[i_].significanc_mark_[j_] = 1;
                    ++this.experiment_.experiment_class_[i_].num_signific_genes_;
                    ++this.experiment_.experiment_class_[i_].num_signif_gens_up_;
                    ++this.count_diff_;
                } else {
                    this.experiment_.experiment_class_[i_].significanc_mark_[j_] = Math.abs(z_val) < sign_lim ? 0 : (Float.isNaN(z_val) ? 0 : 0);
                }
                ++j_;
            }
            ++i_;
        }
        this.experiment_.significance_mark_ = new int[num_genes];
        int i = 0;
        while (i < num_genes) {
            int j = 0;
            while (j < num_cl) {
                if (this.experiment_.experiment_class_[j].significanc_mark_[i] != 0) {
                    this.experiment_.significance_mark_[i] = 1;
                }
                ++j;
            }
            ++i;
        }
    }

    public int[] getGeneCounters() {
        int[] counts = new int[]{this.count_diff_, this.experiment_.final_exp_log2_ratios_[0].length};
        return counts;
    }
}

