/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.analyze;

import VisualNumerics.math.Statistics;
import at.tugraz.genome.math.MathFunctions;

public class TTest2Groups {
    public static double calculateTTestNaN(float[] x_in, float[] y_in, double alpha_star) {
        int n1 = MathFunctions.countReliableValues(x_in);
        int n2 = MathFunctions.countReliableValues(y_in);
        float[] dummy_x = new float[n1];
        float[] dummy_y = new float[n2];
        int cnt1 = 0;
        int cnt2 = 0;
        int i = 0;
        while (i < x_in.length) {
            float dummy1 = x_in[i];
            if (!Float.isNaN(dummy1)) {
                dummy_x[cnt1] = dummy1;
                ++cnt1;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < y_in.length) {
            float dummy2 = y_in[i2];
            if (!Float.isNaN(dummy2)) {
                dummy_y[cnt2] = dummy2;
                ++cnt2;
            }
            ++i2;
        }
        float mean_x = MathFunctions.mean(dummy_x);
        float mean_y = MathFunctions.mean(dummy_y);
        float stddev_x = MathFunctions.stddeviation(dummy_x);
        float stddev_y = MathFunctions.stddeviation(dummy_y);
        double dumy_nom = mean_x - mean_y;
        double dumy_denom = (float)Math.pow(stddev_x, 2.0) / (float)n1 + (float)Math.pow(stddev_y, 2.0) / (float)n2;
        dumy_denom = (float)Math.sqrt(dumy_denom);
        double t_score = dumy_nom / dumy_denom;
        int deg_freedom = n1 + n2 - 2;
        double p_value = (float)(1.0 - Statistics.tCdf(Math.abs(t_score), deg_freedom));
        return p_value;
    }

    public static void main(String[] args) {
        double alpha = 0.05;
        float[] x_in = new float[]{99.0f, 100.0f, 123.0f, 125.0f, 126.0f, 134.0f, 145.0f, 151.0f};
        float[] y_in = new float[]{100.0f, 130.0f, 133.0f, 135.0f, 136.0f, 144.0f, 155.0f};
        float[][] x_a = new float[1][8];
        x_a[0] = x_in;
        float[][] x_b = new float[1][7];
        x_b[0] = y_in;
        double[] p_val = TTest2Groups.multipleTTest(x_a, x_b, alpha);
    }

    public static double[] multipleTTest(float[][] mat_a, float[][] mat_b, double alpha_level) {
        if (mat_a.length == mat_b.length) {
            int num_tests = mat_a.length;
            double[] p_values = new double[num_tests];
            double alpha_lev = alpha_level / (double)num_tests;
            int i_ = 0;
            while (i_ < num_tests) {
                float[] dummy_a = mat_a[i_];
                float[] dummy_b = mat_b[i_];
                p_values[i_] = TTest2Groups.calculateTTestNaN(dummy_a, dummy_b, alpha_lev);
                ++i_;
            }
            return p_values;
        }
        return null;
    }
}

