/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.analyze;

import VisualNumerics.math.Statistics;
import at.tugraz.genome.arraynormcore.microarrayobjects.ExperimentData;

public class TTestSingleClass {
    float alpha_level_;
    ExperimentData exp_;
    ExperimentData.ExpClass expclass_;
    int num_genes_;

    public TTestSingleClass(ExperimentData exp, int tt_class, float alfa) {
        this.exp_ = exp;
        this.expclass_ = this.exp_.experiment_class_[tt_class];
        this.alpha_level_ = alfa;
        this.createTandPValues();
        this.markSignificantGenes();
    }

    public TTestSingleClass() {
    }

    private void createTandPValues() {
        this.num_genes_ = this.expclass_.merged_ratios_log_.length;
        int i = 0;
        while (i < this.exp_.num_expe_classes_) {
            this.exp_.experiment_class_[i].t_values_ = new float[this.num_genes_];
            this.exp_.experiment_class_[i].p_values_ = new float[this.num_genes_];
            ++i;
        }
        int i2 = 0;
        while (i2 < this.num_genes_) {
            int n1 = this.expclass_.ttest_samp_size_[i2];
            this.expclass_.t_values_[i2] = this.expclass_.merged_ratios_log_[i2] * (float)Math.sqrt(n1) / (float)Math.pow(this.expclass_.stddev_ratios_log_[i2], 2.0);
            float beta = (float)Statistics.tCdf(Math.abs(this.expclass_.t_values_[i2]), n1 - 1);
            this.expclass_.p_values_[i2] = 1.0f - beta;
            ++i2;
        }
    }

    private void markSignificantGenes() {
        this.exp_.significance_mark_ = new int[this.num_genes_];
        int i = 0;
        while (i < this.num_genes_) {
            if (this.expclass_.p_values_[i] < this.alpha_level_) {
                this.exp_.significance_mark_[i] = 1;
            }
            ++i;
        }
    }
}

