/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.dataio;

import at.tugraz.genome.arraynormcore.dataio.FileLoader;
import at.tugraz.genome.arraynormcore.microarrayobjects.MicroArrayData;
import at.tugraz.genome.arraynormcore.microarrayobjects.SlideMatrix;
import at.tugraz.genome.utils.StringTokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.Vector;

public class GenePixLoader
implements FileLoader {
    private static int b532mean_col_;
    private static int b532med_col_;
    private static int b532sd_col_;
    private static int b635mean_col_;
    private static int b635med_col_;
    private static int b635sd_col_;
    private static int block_col_;
    private static int column_col_;
    private static int columns_header_line_;
    private static int data_line_count_;
    private static int data_lines_;
    private static int data_start_line_;
    MicroArrayData dummy_ma;
    private static int f532mean_col_;
    private static int f532med_col_;
    private static int f532sd_col_;
    private static int f635mean_col_;
    private static int f635med_col_;
    private static int f635sd_col_;
    private static int flag_col_;
    private static int id_col_;
    private static int max_lines_;
    private static int meanofratios_col_;
    private static int medianofratios_col_;
    private static int name_col_;
    private static int ratioofmeans_col_;
    private static int ratioofmedians_col_;
    private static int rngratio_col_;
    private static int row_col_;

    static {
        max_lines_ = 0;
        data_start_line_ = 0;
        columns_header_line_ = 0;
        data_lines_ = 0;
    }

    private void getInputFileInfo(File file_name) throws Exception {
        boolean first_row = false;
        try {
            System.out.println("ROL -> [GenePixLoader::getinputfileinfo] -> fileinfo = " + file_name.getName());
            BufferedReader file_reader = new BufferedReader(new FileReader(file_name));
            String read_line = file_reader.readLine();
            while (read_line != null) {
                StringTokenizer tokenizer;
                ++max_lines_;
                if (!first_row && (tokenizer = new StringTokenizer(read_line = read_line.replaceAll("\"", ""))).getCount() > 20) {
                    data_start_line_ = max_lines_ + 1;
                    columns_header_line_ = max_lines_;
                    first_row = true;
                    int gpr_cols = tokenizer.getCount();
                    int i = 0;
                    while (i < gpr_cols) {
                        String col_name = tokenizer.nextToken();
                        if (col_name.equals("Block")) {
                            block_col_ = i;
                        }
                        if (col_name.equals("Column")) {
                            column_col_ = i;
                        }
                        if (col_name.equals("Row")) {
                            row_col_ = i;
                        }
                        if (col_name.equals("Name")) {
                            name_col_ = i;
                        }
                        if (col_name.equals("ID")) {
                            id_col_ = i;
                        }
                        if (col_name.equals("F635 Median")) {
                            f635med_col_ = i;
                        }
                        if (col_name.equals("B635 Median")) {
                            b635med_col_ = i;
                        }
                        if (col_name.equals("F532 Median")) {
                            f532med_col_ = i;
                        }
                        if (col_name.equals("B532 Median")) {
                            b532med_col_ = i;
                        }
                        if (col_name.equals("F635 Mean")) {
                            f635mean_col_ = i;
                        }
                        if (col_name.equals("B635 Mean")) {
                            b635mean_col_ = i;
                        }
                        if (col_name.equals("F532 Mean")) {
                            f532mean_col_ = i;
                        }
                        if (col_name.equals("B532 Mean")) {
                            b532mean_col_ = i;
                        }
                        if (col_name.equals("F635 SD")) {
                            f635sd_col_ = i;
                        }
                        if (col_name.equals("B635 SD")) {
                            b635sd_col_ = i;
                        }
                        if (col_name.equals("F532 SD")) {
                            f532sd_col_ = i;
                        }
                        if (col_name.equals("B532 SD")) {
                            b532sd_col_ = i;
                        }
                        if (col_name.equals("Ratio of Medians (635/532)")) {
                            ratioofmedians_col_ = i;
                        }
                        if (col_name.equals("Ratio of Means (635/532)")) {
                            ratioofmeans_col_ = i;
                        }
                        if (col_name.equals("Median of Ratios (635/532)")) {
                            medianofratios_col_ = i;
                        }
                        if (col_name.equals("Mean of Ratios (635/532)")) {
                            meanofratios_col_ = i;
                        }
                        if (col_name.equals("Rgn Ratio (635/532)")) {
                            rngratio_col_ = i;
                        }
                        if (col_name.equals("Flags")) {
                            flag_col_ = i;
                        }
                        ++i;
                    }
                }
                read_line = file_reader.readLine();
            }
            file_reader.close();
            data_lines_ = ++max_lines_ - data_start_line_;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public MicroArrayData loadFile(File input_file, Vector info_set) {
        max_lines_ = 0;
        data_start_line_ = 0;
        data_lines_ = 0;
        data_line_count_ = 0;
        this.dummy_ma = null;
        try {
            this.getInputFileInfo(input_file);
            SlideMatrix dummy_1 = this.uploadGprFileAdaptive(input_file);
            dummy_1.findMetaIndicesForGenePix();
            this.dummy_ma = new MicroArrayData(dummy_1, info_set);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.dummy_ma;
    }

    private void parseGprHeader(File file_name) {
        int cnter = 0;
        try {
            BufferedReader file_reader = new BufferedReader(new FileReader(file_name));
            while (cnter < columns_header_line_) {
                String read_line = file_reader.readLine();
                if (read_line == null) break;
                if (!read_line.equals(null)) {
                    String[] line_splitted;
                    if ((read_line = read_line.replaceAll("\"", "")).startsWith("Type")) {
                        line_splitted = read_line.split("=");
                        if (line_splitted.length > 1) {
                            this.dummy_ma.setType_(line_splitted[1]);
                        }
                    } else if (read_line.startsWith("DateTime")) {
                        line_splitted = read_line.split("=");
                        if (line_splitted.length > 1) {
                            this.dummy_ma.setDate_time_(line_splitted[1]);
                        }
                    } else if (read_line.startsWith("GalFile")) {
                        line_splitted = read_line.split("=");
                        if (line_splitted.length > 1) {
                            this.dummy_ma.setGal_file_(line_splitted[1]);
                        }
                    } else if (read_line.startsWith("Wavelengths")) {
                        line_splitted = read_line.split("=");
                        if (line_splitted.length > 1) {
                            this.dummy_ma.setWavelenghts_(line_splitted[1]);
                        }
                    } else if (read_line.startsWith("Imagefiles")) {
                        line_splitted = read_line.split("=");
                        if (line_splitted.length > 1) {
                            this.dummy_ma.setImagefiles_(line_splitted[1]);
                        }
                    } else if (read_line.startsWith("NormalizationMethod")) {
                        line_splitted = read_line.split("=");
                        if (line_splitted.length > 1) {
                            this.dummy_ma.setNormalization_method_(line_splitted[1]);
                        }
                    } else if (read_line.startsWith("NormalizationFactors")) {
                        line_splitted = read_line.split("=");
                        if (line_splitted.length > 1) {
                            this.dummy_ma.setNormalization_factors_(line_splitted[1]);
                        }
                    } else if (read_line.startsWith("Barcode")) {
                        line_splitted = read_line.split("=");
                        if (line_splitted.length > 1) {
                            this.dummy_ma.setBarcode_(line_splitted[1]);
                        }
                    } else if (read_line.startsWith("Creator")) {
                        line_splitted = read_line.split("=");
                        if (line_splitted.length > 1) {
                            this.dummy_ma.setCreator_(line_splitted[1]);
                        }
                    } else if (read_line.startsWith("Scanner")) {
                        line_splitted = read_line.split("=");
                        if (line_splitted.length > 1) {
                            this.dummy_ma.setScanner_(line_splitted[1]);
                        }
                    } else if (read_line.startsWith("Temperature")) {
                        line_splitted = read_line.split("=");
                        if (line_splitted.length > 1) {
                            this.dummy_ma.setTemperature_(line_splitted[1]);
                        }
                    } else if (read_line.startsWith("Comment")) {
                        line_splitted = read_line.split("=");
                        if (line_splitted.length > 1) {
                            this.dummy_ma.setComment_(line_splitted[1]);
                        }
                    } else if (read_line.startsWith("PMTGain")) {
                        line_splitted = read_line.split("=");
                        if (line_splitted.length > 1) {
                            this.dummy_ma.setPmt_gains_(line_splitted[1]);
                        }
                    } else if (read_line.startsWith("ScanPower")) {
                        line_splitted = read_line.split("=");
                        if (line_splitted.length > 1) {
                            this.dummy_ma.setScan_powers_(line_splitted[1]);
                        }
                    } else if (read_line.startsWith("LaserPower")) {
                        line_splitted = read_line.split("=");
                        if (line_splitted.length > 1) {
                            this.dummy_ma.setLaser_powers_(line_splitted[1]);
                        }
                    } else if (read_line.startsWith("LaserOnTime") && (line_splitted = read_line.split("=")).length > 1) {
                        this.dummy_ma.setLasers_on_time_(line_splitted[1]);
                    }
                }
                ++cnter;
            }
            file_reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void throwParserError(String message, int offset) throws ParseException {
        throw new ParseException(message, offset);
    }

    private SlideMatrix uploadGprFileAdaptive(File file_name) throws Exception {
        int line = 0;
        data_line_count_ = 0;
        SlideMatrix dummy_slide_matrix = new SlideMatrix(data_lines_, 4);
        dummy_slide_matrix.spot_nbr_[0] = 0;
        BufferedReader file_reader = new BufferedReader(new FileReader(file_name));
        String read_line = file_reader.readLine();
        while (read_line != null) {
            dummy_slide_matrix.spot_nbr_[GenePixLoader.data_line_count_] = data_line_count_ + 1;
            StringTokenizer tokenizer = new StringTokenizer(read_line);
            if (++line >= data_start_line_) {
                try {
                    dummy_slide_matrix.bloc_[GenePixLoader.data_line_count_] = Integer.parseInt(tokenizer.getToken(block_col_));
                    dummy_slide_matrix.column_[GenePixLoader.data_line_count_] = Integer.parseInt(tokenizer.getToken(column_col_));
                    dummy_slide_matrix.row_[GenePixLoader.data_line_count_] = Integer.parseInt(tokenizer.getToken(row_col_));
                    String idtoken = tokenizer.getToken(id_col_);
                    dummy_slide_matrix.gene_id_[GenePixLoader.data_line_count_] = idtoken = idtoken.replaceAll("\"", "");
                    String nametoken = tokenizer.getToken(name_col_);
                    dummy_slide_matrix.gene_name_[GenePixLoader.data_line_count_] = nametoken = nametoken.replaceAll("\"", "");
                    dummy_slide_matrix.x_coord_[GenePixLoader.data_line_count_] = Integer.parseInt(tokenizer.getToken(5));
                    dummy_slide_matrix.y_coord_[GenePixLoader.data_line_count_] = Integer.parseInt(tokenizer.getToken(6));
                    dummy_slide_matrix.setValue(data_line_count_, 0, Float.parseFloat(tokenizer.getToken(f635med_col_)));
                    dummy_slide_matrix.setValue(data_line_count_, 1, Float.parseFloat(tokenizer.getToken(b635med_col_)));
                    dummy_slide_matrix.setValue(data_line_count_, 2, Float.parseFloat(tokenizer.getToken(f532med_col_)));
                    dummy_slide_matrix.setValue(data_line_count_, 3, Float.parseFloat(tokenizer.getToken(b532med_col_)));
                    dummy_slide_matrix.flag_[GenePixLoader.data_line_count_] = Integer.parseInt(tokenizer.getToken(flag_col_));
                }
                catch (NumberFormatException ex) {
                    System.out.println("[GenePixLoader::loadadaptive.....] -> crashed!");
                    this.throwParserError("GenePixLoader-Error parsing file " + file_name + ", in line " + data_line_count_, data_line_count_);
                }
                ++data_line_count_;
            }
            read_line = file_reader.readLine();
        }
        file_reader.close();
        return dummy_slide_matrix;
    }
}

