/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.dataio;

import at.tugraz.genome.arraynormcore.dataio.FileLoader;
import at.tugraz.genome.arraynormcore.microarrayobjects.MicroArrayData;
import at.tugraz.genome.arraynormcore.microarrayobjects.SlideMatrix;
import at.tugraz.genome.utils.StringTokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class ImaGeneLoader
implements FileLoader {
    private static int b532_col_;
    private static int b635_col_;
    private static int col_col_;
    private static int coldef_line_;
    private String cy3_file_name_;
    private String cy5_file_name_;
    private static int data_end_line_;
    private static int data_line_count_;
    private static int data_lines_;
    private static int data_start_line_;
    private static int f532_col_;
    private static int f635_col_;
    private static int flag_col_;
    private String geneid_;
    private static int geneid_col_;
    private static int max_lines_;
    private static int metacol_col_;
    private static int metarow_col_;
    private static int row_col_;
    private static SlideMatrix slide_matrix_;
    private static int xcoord_col_;
    private static int ycoord_col_;

    static {
        max_lines_ = 0;
        data_lines_ = 0;
    }

    private void getInputFileInfo(File file_name) throws Exception {
        int first_row = 0;
        try {
            String read_line;
            BufferedReader file_reader = new BufferedReader(new FileReader(file_name));
            while ((read_line = file_reader.readLine()) != null) {
                if (read_line.equals(null)) continue;
                if (read_line.indexOf("End Raw Data") != -1) {
                    data_end_line_ = max_lines_ - 1;
                }
                if (read_line.indexOf("Meta Row") != -1) {
                    data_start_line_ = max_lines_ + 1;
                    coldef_line_ = max_lines_;
                    ++first_row;
                    StringTokenizer tokenizer = new StringTokenizer(read_line);
                    int gpr_cols = tokenizer.getCount();
                    int i = 0;
                    while (i < gpr_cols) {
                        String col_name = tokenizer.nextToken();
                        if (col_name.equals("Meta Row")) {
                            metarow_col_ = i;
                        }
                        if (col_name.equals("Meta Column")) {
                            metacol_col_ = i;
                        }
                        if (col_name.equals("Row")) {
                            row_col_ = i;
                        }
                        if (col_name.equals("Column")) {
                            col_col_ = i;
                        }
                        if (col_name.equals("Gene ID")) {
                            geneid_col_ = i;
                        }
                        if (col_name.equals("Flag")) {
                            flag_col_ = i;
                        }
                        if (col_name.equals("Signal Mean")) {
                            f635_col_ = i;
                        }
                        if (col_name.equals("Background Mean")) {
                            b635_col_ = i;
                        }
                        if (col_name.equals("X Coord") || col_name.equals("XCoord")) {
                            xcoord_col_ = i;
                        }
                        if (col_name.equals("Y Coord") || col_name.equals("YCoord")) {
                            ycoord_col_ = i;
                        }
                        ++i;
                    }
                }
                ++max_lines_;
            }
            file_reader.close();
            data_lines_ = data_end_line_ - data_start_line_ + 1;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public MicroArrayData loadFile(File input_file, Vector info_set) {
        this.cy5_file_name_ = input_file.getAbsolutePath();
        if (this.cy5_file_name_.indexOf("cy5") == -1) {
            System.out.println("[ImageneLoader::loadfile] -> uuups, no cy5-file selected...");
            return null;
        }
        this.cy3_file_name_ = input_file.getAbsolutePath();
        this.cy3_file_name_ = this.cy3_file_name_.replaceAll("cy5", "cy3");
        max_lines_ = 0;
        data_start_line_ = 0;
        data_lines_ = 0;
        data_line_count_ = 0;
        MicroArrayData dummy_ma = null;
        try {
            this.getInputFileInfo(input_file);
            this.parseCy5ImaGeneFile(this.cy5_file_name_);
            this.parseCy3ImaGeneFileAndMerge(this.cy3_file_name_);
            slide_matrix_.findBlocksForImagGene();
            dummy_ma = new MicroArrayData(slide_matrix_, info_set);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dummy_ma;
    }

    private void parseCy3ImaGeneFileAndMerge(String file_name) throws Exception {
        String read_line;
        int line = 0;
        data_line_count_ = 0;
        BufferedReader file_reader = new BufferedReader(new FileReader(file_name));
        while ((read_line = file_reader.readLine()) != null) {
            if (line >= data_start_line_) {
                if (line <= data_end_line_) {
                    read_line.replaceAll(".", ",");
                    StringTokenizer tokenizer = new StringTokenizer(read_line);
                    try {
                        slide_matrix_.setValue(data_line_count_, 2, Float.parseFloat(tokenizer.getToken(f635_col_)));
                        slide_matrix_.setValue(data_line_count_, 3, Float.parseFloat(tokenizer.getToken(b635_col_)));
                    }
                    catch (NumberFormatException ex) {
                        ex.printStackTrace();
                    }
                    ++data_line_count_;
                }
            }
            ++line;
        }
        file_reader.close();
    }

    private void parseCy5ImaGeneFile(String file_name) throws Exception {
        String read_line;
        int line = 0;
        data_line_count_ = 0;
        int cnt_bads = 0;
        slide_matrix_ = new SlideMatrix(data_lines_, 4);
        ImaGeneLoader.slide_matrix_.spot_nbr_[0] = 0;
        BufferedReader file_reader = new BufferedReader(new FileReader(file_name));
        while ((read_line = file_reader.readLine()) != null) {
            if (line >= data_start_line_) {
                if (line <= data_end_line_) {
                    ImaGeneLoader.slide_matrix_.spot_nbr_[ImaGeneLoader.data_line_count_] = data_line_count_ + 1;
                    read_line.replaceAll(".", ",");
                    StringTokenizer tokenizer = new StringTokenizer(read_line);
                    try {
                        ImaGeneLoader.slide_matrix_.bloc_[ImaGeneLoader.data_line_count_] = 1;
                        ImaGeneLoader.slide_matrix_.meta_column_[ImaGeneLoader.data_line_count_] = Integer.parseInt(tokenizer.getToken(metacol_col_));
                        ImaGeneLoader.slide_matrix_.meta_row_[ImaGeneLoader.data_line_count_] = Integer.parseInt(tokenizer.getToken(metarow_col_));
                        ImaGeneLoader.slide_matrix_.column_[ImaGeneLoader.data_line_count_] = Integer.parseInt(tokenizer.getToken(col_col_));
                        ImaGeneLoader.slide_matrix_.row_[ImaGeneLoader.data_line_count_] = Integer.parseInt(tokenizer.getToken(row_col_));
                        ImaGeneLoader.slide_matrix_.gene_name_[ImaGeneLoader.data_line_count_] = this.geneid_ = tokenizer.getToken(geneid_col_);
                        ImaGeneLoader.slide_matrix_.gene_id_[ImaGeneLoader.data_line_count_] = this.geneid_;
                        int flag = Integer.parseInt(tokenizer.getToken(flag_col_));
                        if (flag != 0) {
                            flag = -100;
                            ++cnt_bads;
                        }
                        ImaGeneLoader.slide_matrix_.flag_[ImaGeneLoader.data_line_count_] = flag;
                        ImaGeneLoader.slide_matrix_.x_coord_[ImaGeneLoader.data_line_count_] = Math.round(Float.parseFloat(tokenizer.getToken(xcoord_col_)));
                        ImaGeneLoader.slide_matrix_.y_coord_[ImaGeneLoader.data_line_count_] = Math.round(Float.parseFloat(tokenizer.getToken(ycoord_col_)));
                        slide_matrix_.setValue(data_line_count_, 0, Float.parseFloat(tokenizer.getToken(f635_col_)));
                        slide_matrix_.setValue(data_line_count_, 1, Float.parseFloat(tokenizer.getToken(b635_col_)));
                    }
                    catch (NumberFormatException ex) {
                        ex.printStackTrace();
                    }
                    ++data_line_count_;
                }
            }
            ++line;
        }
        file_reader.close();
    }

    private void printSomeValues() {
        int i = 0;
        while (i < 50) {
            System.out.println("geneid = " + ImaGeneLoader.slide_matrix_.gene_id_[i] + ",  f635 = " + slide_matrix_.getValue(i, 0) + ",   f532 = " + slide_matrix_.getValue(i, 2));
            ++i;
        }
    }
}

