/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.dataio;

import at.tugraz.genome.arraynormcore.gui.ParentFrame;
import at.tugraz.genome.arraynormcore.microarrayobjects.ExperimentData;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import javax.swing.JOptionPane;

public class MAResultsFileWriter {
    ExperimentData experiment_;
    int line_;
    File ma_file_;
    ParentFrame parent_gui_;

    public MAResultsFileWriter(ParentFrame parent, ExperimentData experiment, File result_file) {
        this.parent_gui_ = parent;
        this.experiment_ = experiment;
        this.ma_file_ = result_file;
    }

    public void writeFinalMAResultsFile(int deal_ctrls) {
        int num_of_classes = this.experiment_.num_expe_classes_;
        int num_of_genes = this.experiment_.num_genes_on_slide_;
        String[] class_names = new String[num_of_classes];
        int i_ = 0;
        while (i_ < num_of_classes) {
            class_names[i_] = this.experiment_.experiment_class_[i_].class_name_;
            if (class_names[i_] == null) {
                class_names[i_] = "Class" + i_;
            }
            ++i_;
        }
        String[] gene_ids = this.experiment_.final_exp_geneids_;
        String[] gene_names = this.experiment_.final_exp_genenames_;
        try {
            BufferedWriter write_out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.ma_file_)));
            String dummy_str = new String("UNIQID");
            dummy_str = dummy_str + "\tNAME";
            int i_2 = 0;
            while (i_2 < num_of_classes) {
                dummy_str = dummy_str + "\t" + class_names[i_2] + "-M" + "\t" + class_names[i_2] + "-A";
                ++i_2;
            }
            write_out.write(dummy_str, 0, dummy_str.length());
            write_out.newLine();
            this.line_ = 0;
            int i_3 = 0;
            while (i_3 < num_of_genes) {
                if (this.experiment_.significance_mark_[i_3] == 1) {
                    dummy_str = gene_ids != null ? gene_ids[i_3] + "\t" + gene_names[i_3] : "?Gene?\t?name?";
                    int j_ = 0;
                    while (j_ < num_of_classes) {
                        dummy_str = dummy_str + "\t" + Float.toString(this.experiment_.final_exp_log2_ratios_[j_][i_3]) + "\t" + Float.toString(this.experiment_.final_exp_avalues_[j_][i_3]);
                        ++j_;
                    }
                    if (deal_ctrls == 2212) {
                        if (!(gene_names[i_3].startsWith("C_") || gene_names[i_3].startsWith("CN_") || gene_names[i_3].startsWith("CPG_") || gene_names[i_3].startsWith("CPH_") || gene_names[i_3].startsWith("CPS_") || gene_names[i_3].startsWith("CPM_"))) {
                            write_out.write(dummy_str, 0, dummy_str.length());
                            write_out.newLine();
                            ++this.line_;
                        }
                    } else if (deal_ctrls == 2211) {
                        if (!gene_names[i_3].startsWith("CN_")) {
                            write_out.write(dummy_str, 0, dummy_str.length());
                            write_out.newLine();
                            ++this.line_;
                        }
                    } else {
                        write_out.write(dummy_str, 0, dummy_str.length());
                        write_out.newLine();
                        ++this.line_;
                    }
                }
                ++i_3;
            }
            write_out.flush();
            write_out.close();
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(this.parent_gui_, "Can not create file " + this.ma_file_.getPath() + "!", e2.toString(), 0);
            System.out.println("write to file crashed in line " + this.line_);
            e2.printStackTrace();
        }
    }
}

