/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.microarrayobjects;

import at.tugraz.genome.arraynormcore.microarrayobjects.MicroArrayQualityCheckResultsVO;
import at.tugraz.genome.arraynormcore.microarrayobjects.MicroArrayQualityCheckVO;
import at.tugraz.genome.math.MathFunctions;

public class MicroArrayQualityCheckCalculator {
    private MicroArrayQualityCheckVO qc_data_;
    private MicroArrayQualityCheckResultsVO qc_results_;

    public MicroArrayQualityCheckCalculator(MicroArrayQualityCheckVO qualcheck_vo) {
        this.qc_data_ = qualcheck_vo;
        System.out.println("ROL -> [MicroArrayQualityCheckCalculator]");
        this.qc_results_ = new MicroArrayQualityCheckResultsVO();
        System.out.println("ROL -> [MicroArrayQualityCheckCalculator] set header data");
        this.setHeaderInformation();
        System.out.println("ROL -> [MicroArrayQualityCheckCalculator] calc 635 stats");
        this.calculate635Statistics();
        System.out.println("ROL -> [MicroArrayQualityCheckCalculator] calc 532 stats");
        this.calculate532Statistics();
        System.out.println("ROL -> [MicroArrayQualityCheckCalculator] calc ratio stats");
        this.calculateRatioStatistics();
    }

    private void calculate532Statistics() {
        this.qc_results_.setF532med_med(MathFunctions.median(this.qc_data_.getF532median_()));
        this.qc_results_.setF532med_mean(MathFunctions.mean(this.qc_data_.getF532median_()));
        this.qc_results_.setF532med_sd(MathFunctions.stddeviation(this.qc_data_.getF532median_()));
        this.qc_results_.setF532mean_med(MathFunctions.median(this.qc_data_.getF532mean_()));
        this.qc_results_.setF532mean_mean(MathFunctions.mean(this.qc_data_.getF532mean_()));
        this.qc_results_.setF532mean_sd(MathFunctions.stddeviation(this.qc_data_.getF532mean_()));
        this.qc_results_.setB532med_med(MathFunctions.median(this.qc_data_.getB532median_()));
        this.qc_results_.setB532med_mean(MathFunctions.mean(this.qc_data_.getB532median_()));
        this.qc_results_.setB532med_sd(MathFunctions.stddeviation(this.qc_data_.getB532median_()));
        this.qc_results_.setB532mean_med(MathFunctions.median(this.qc_data_.getB532mean_()));
        this.qc_results_.setB532mean_mean(MathFunctions.mean(this.qc_data_.getB532mean_()));
        this.qc_results_.setF532mean_sd(MathFunctions.stddeviation(this.qc_data_.getB532mean_()));
    }

    private void calculate635Statistics() {
        this.qc_results_.setF635med_med(MathFunctions.median(this.qc_data_.getF635median_()));
        this.qc_results_.setF635med_mean(MathFunctions.mean(this.qc_data_.getF635median_()));
        this.qc_results_.setF635med_sd(MathFunctions.stddeviation(this.qc_data_.getF635median_()));
        this.qc_results_.setF635mean_med(MathFunctions.median(this.qc_data_.getF635mean_()));
        this.qc_results_.setF635mean_mean(MathFunctions.mean(this.qc_data_.getF635mean_()));
        this.qc_results_.setF635mean_sd(MathFunctions.stddeviation(this.qc_data_.getF635mean_()));
        this.qc_results_.setB635med_med(MathFunctions.median(this.qc_data_.getB635median_()));
        this.qc_results_.setB635med_mean(MathFunctions.mean(this.qc_data_.getB635median_()));
        this.qc_results_.setB635med_sd(MathFunctions.stddeviation(this.qc_data_.getB635median_()));
        this.qc_results_.setB635mean_med(MathFunctions.median(this.qc_data_.getB635mean_()));
        this.qc_results_.setB635mean_mean(MathFunctions.mean(this.qc_data_.getB635mean_()));
        this.qc_results_.setF635mean_sd(MathFunctions.stddeviation(this.qc_data_.getB635mean_()));
    }

    private void calculateRatioStatistics() {
        this.qc_results_.setRatioofmedians_med(MathFunctions.median(this.qc_data_.getRatioofmedians_ch12_()));
        this.qc_results_.setRatioofmedians_mean(MathFunctions.mean(this.qc_data_.getRatioofmedians_ch12_()));
        this.qc_results_.setRatioofmedians_sd(MathFunctions.stddeviation(this.qc_data_.getRatioofmedians_ch12_()));
        this.qc_results_.setRatioofmeans_med(MathFunctions.median(this.qc_data_.getRatioofmeans_ch12_()));
        this.qc_results_.setRatioofmeans_mean(MathFunctions.mean(this.qc_data_.getRatioofmeans_ch12_()));
        this.qc_results_.setRatioofmeans_sd(MathFunctions.stddeviation(this.qc_data_.getRatioofmeans_ch12_()));
        this.qc_results_.setMedianofratios_med(MathFunctions.median(this.qc_data_.getMedianofratios_ch12_()));
        this.qc_results_.setMedianofratios_mean(MathFunctions.mean(this.qc_data_.getMedianofratios_ch12_()));
        this.qc_results_.setMedianofratios_sd(MathFunctions.stddeviation(this.qc_data_.getMedianofratios_ch12_()));
        this.qc_results_.setMeanofratios_med(MathFunctions.median(this.qc_data_.getMeanofratios_ch12_()));
        this.qc_results_.setMeanofratios_mean(MathFunctions.mean(this.qc_data_.getMeanofratios_ch12_()));
        this.qc_results_.setMeanofratios_sd(MathFunctions.stddeviation(this.qc_data_.getMeanofratios_ch12_()));
        this.qc_results_.setRngratio_med(MathFunctions.median(this.qc_data_.getRng_ratios_()));
        this.qc_results_.setRngratio_mean(MathFunctions.mean(this.qc_data_.getRng_ratios_()));
        this.qc_results_.setRngratio_sd(MathFunctions.stddeviation(this.qc_data_.getRng_ratios_()));
    }

    private void calculateVitalStatistics() {
    }

    public MicroArrayQualityCheckResultsVO getQualityCheckResult() {
        return this.qc_results_;
    }

    private void setHeaderInformation() {
        this.qc_results_.setType_(this.qc_data_.getType_());
        this.qc_results_.setDate_time_(this.qc_data_.getDate_time_());
        this.qc_results_.setGal_file_(this.qc_data_.getGal_file_());
        this.qc_results_.setWavelenghts_(this.qc_data_.getWavelenghts_());
        this.qc_results_.setImagefiles_(this.qc_data_.getImagefiles_());
        this.qc_results_.setNormalization_method_(this.qc_data_.getNormalization_method_());
        this.qc_results_.setNormalization_factors_(this.qc_data_.getNormalization_factors_());
        this.qc_results_.setBarcode_(this.qc_data_.getBarcode_());
        this.qc_results_.setCreator_(this.qc_data_.getCreator_());
        this.qc_results_.setScanner_(this.qc_data_.getScanner_());
        this.qc_results_.setTemperature_(this.qc_data_.getTemperature_());
        this.qc_results_.setComment_(this.qc_data_.getComment_());
        this.qc_results_.setPmt_gains_(this.qc_data_.getPmt_gains_());
        this.qc_results_.setScan_powers_(this.qc_data_.getScan_powers_());
        this.qc_results_.setLaser_powers_(this.qc_data_.getLaser_powers_());
        this.qc_results_.setLasers_on_time_(this.qc_data_.getLasers_on_time_());
    }
}

