/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.plot;

import at.tugraz.genome.arraynormcore.math.Univariate;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Vector;
import javax.swing.JPanel;

public class GenerateHistogram
extends JPanel {
    public static final Color DEFAULT_AXES_COLOR;
    public static final Color DEFAULT_FILL_COLOR;
    private static final Font DEFAULT_FONT;
    public static final Color DEFAULT_GRAPHBACKGROUD_COLOR;
    public static final Color DEFAULT_GRAPHIC_COLOR;
    public static final int DEFAULT_HEIGHT = 590;
    public static final int DEFAULT_WIDTH = 680;
    protected float[] bin_bounds_;
    protected float[] bin_counts_;
    protected float[] bin_cumulative_;
    protected float bin_width_;
    protected int bins_;
    protected boolean box_;
    protected String class_type_;
    private Univariate data_ = null;
    private float[] data_in_;
    protected boolean draw_counts_;
    protected boolean have_bin_width_;
    protected boolean have_max_y_;
    protected boolean have_title_;
    protected boolean have_x_label_;
    protected boolean have_y_label_;
    protected int height_;
    protected Font label_font_;
    protected int[] margins_;
    protected float max_x_;
    protected float max_y_;
    protected float min_x_;
    protected boolean probability_;
    protected int sampl_size_;
    protected String title_;
    protected Font title_font_;
    private static final Font trb12;
    private static final Font trp10;
    protected int width_;
    protected String x_lab_;
    protected String y_lab_;
    protected boolean zero_counts_;

    static {
        DEFAULT_FILL_COLOR = Color.lightGray;
        DEFAULT_GRAPHBACKGROUD_COLOR = Color.white;
        DEFAULT_GRAPHIC_COLOR = Color.black;
        DEFAULT_AXES_COLOR = Color.blue;
        DEFAULT_FONT = new Font("TimesRoman", 0, 9);
        trp10 = new Font("TimesRoman", 0, 10);
        trb12 = new Font("TimesRoman", 1, 12);
    }

    public GenerateHistogram(Vector info_set) {
        this.data_in_ = (float[])info_set.get(0);
        this.x_lab_ = (String)info_set.get(1);
        this.y_lab_ = (String)info_set.get(2);
        this.width_ = 680;
        this.height_ = 590;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.newData(this.data_in_);
    }

    public void addCounts(boolean zero_counts) {
        this.draw_counts_ = true;
        this.zero_counts_ = zero_counts;
    }

    public void addCounts() {
        this.draw_counts_ = true;
        this.zero_counts_ = false;
    }

    public void addXLabel(String x_lab) {
        this.x_lab_ = x_lab;
        if (!this.have_x_label_) {
            this.margins_[0] = this.margins_[0] + 10;
        }
        this.have_x_label_ = true;
    }

    public void addYLabel(String y_lab) {
        this.y_lab_ = y_lab;
        if (!this.have_y_label_) {
            this.margins_[1] = this.margins_[1] + 10;
        }
        this.have_y_label_ = true;
    }

    void jbInit() throws Exception {
        this.setSize(this.width_, this.height_);
        this.margins_ = new int[4];
        this.margins_[0] = 40;
        this.margins_[1] = 40;
        this.margins_[2] = 50;
        this.margins_[3] = 40;
        super.setBackground(Color.white);
        this.have_bin_width_ = false;
        this.have_x_label_ = true;
        this.have_y_label_ = true;
        this.class_type_ = "Sturges";
        this.box_ = true;
        this.probability_ = true;
        this.draw_counts_ = false;
        this.zero_counts_ = false;
        this.label_font_ = DEFAULT_FONT;
        this.setPreferredSize(new Dimension(this.width_, this.height_));
    }

    public static void main(String[] args) {
        GenerateHistogram test_histo = new GenerateHistogram(null);
        float[] test_flo = new float[10000];
        int i = 0;
        while (i < 10000) {
            test_flo[i] = i;
            ++i;
        }
        test_histo.newData(test_flo);
    }

    public void newData(Univariate data, float[] x_lim, float max_y) {
        this.data_ = data;
        this.sampl_size_ = this.data_.size();
        this.min_x_ = x_lim[0];
        this.max_x_ = x_lim[1];
        this.max_y_ = max_y;
        this.have_bin_width_ = false;
        this.have_max_y_ = true;
        this.setHistParams();
    }

    public void newData(Univariate data, float[] xlim) {
        this.data_ = data;
        this.sampl_size_ = this.data_.size();
        this.min_x_ = xlim[0];
        this.max_x_ = xlim[1];
        this.have_bin_width_ = false;
        this.have_max_y_ = false;
        this.setHistParams();
    }

    public void newData(Univariate data, float max_y) {
        this.data_ = data;
        this.sampl_size_ = this.data_.size();
        this.min_x_ = this.data_.min();
        this.max_x_ = this.data_.max();
        this.max_y_ = max_y;
        this.have_bin_width_ = false;
        this.have_max_y_ = true;
        this.setHistParams();
    }

    public void newData(Univariate data) {
        this.data_ = data;
        this.sampl_size_ = this.data_.size();
        this.min_x_ = this.data_.min();
        this.max_x_ = this.data_.max();
        this.have_bin_width_ = false;
        this.have_max_y_ = false;
        this.setHistParams();
    }

    public void newData(float[] data, float[] x_lim, float max_y) {
        this.data_ = new Univariate(data);
        this.sampl_size_ = this.data_.size();
        this.min_x_ = x_lim[0];
        this.max_x_ = x_lim[1];
        this.max_y_ = max_y;
        this.have_bin_width_ = false;
        this.have_max_y_ = true;
        this.setHistParams();
    }

    public void newData(float[] data, float[] x_lim) {
        this.data_ = new Univariate(data);
        this.sampl_size_ = this.data_.size();
        this.min_x_ = x_lim[0];
        this.max_x_ = x_lim[1];
        this.have_bin_width_ = false;
        this.have_max_y_ = false;
        this.setHistParams();
    }

    public void newData(float[] data, float max_y) {
        this.data_ = new Univariate(data);
        this.sampl_size_ = this.data_.size();
        this.min_x_ = this.data_.min();
        this.max_x_ = this.data_.max();
        this.max_y_ = max_y;
        this.have_bin_width_ = false;
        this.have_max_y_ = true;
        this.setHistParams();
    }

    public void newData(float[] data) {
        this.data_ = new Univariate(data);
        this.sampl_size_ = this.data_.size();
        this.min_x_ = this.data_.min();
        this.max_x_ = this.data_.max();
        this.have_bin_width_ = false;
        this.have_max_y_ = false;
        this.setHistParams();
    }

    public void paint(Graphics g) {
        if (this.data_ == null) {
            return;
        }
        g.setColor(Color.white);
        g.fillRect(0, 0, this.width_, this.height_);
        int yOrigin = this.height_;
        int xOrigin = 0;
        int bottom = -this.margins_[0];
        int left = this.margins_[1];
        int top = this.margins_[2];
        int right = this.margins_[3];
        int barwidth_ = (this.width_ - left - right) / this.bins_;
        float scale = (float)(yOrigin - top + bottom) / this.max_y_;
        g.setFont(trp10);
        FontMetrics fm = g.getFontMetrics();
        g.setColor(Color.black);
        if (this.box_) {
            g.drawRect(0, 0, this.width_, this.height_);
        }
        g.drawLine(xOrigin + left, yOrigin + bottom, this.width_ - right, yOrigin + bottom);
        g.drawLine(xOrigin + left, yOrigin + bottom, xOrigin + left, top);
        int ytick = (int)((double)(yOrigin + bottom - top) * 0.25);
        int xtick = (int)((double)(this.width_ - left - right) * 0.25);
        int i = 0;
        while (i < 5) {
            g.drawLine(xOrigin + left - 2, yOrigin + bottom - i * ytick, xOrigin + left, yOrigin + bottom - i * ytick);
            float y_label = (float)((double)((float)i * this.max_y_) * 0.25);
            g.drawString(Float.toString(y_label), xOrigin + left - 2, yOrigin + bottom - i * ytick);
            g.drawLine(xOrigin + left + i * xtick, yOrigin + bottom, xOrigin + left + i * xtick, yOrigin + bottom + 5);
            float x_label = this.min_x_ + (float)i * (this.max_x_ - this.min_x_) * 0.25f;
            g.drawString(Double.toString(x_label), xOrigin + left + i * xtick, yOrigin + bottom + 15);
            ++i;
        }
        i = 0;
        while (i < this.bins_) {
            int x1 = i * barwidth_ + xOrigin + left;
            int y1 = top + (int)((this.max_y_ - this.bin_counts_[i]) * scale);
            int barheight_ = yOrigin + bottom - y1;
            if (barheight_ > 1) {
                g.setColor(DEFAULT_FILL_COLOR);
                g.fillRect(x1, y1, barwidth_, barheight_);
                g.setColor(Color.black);
                g.drawRect(x1, y1, barwidth_, barheight_);
            }
            if (!this.draw_counts_ || this.bin_counts_[i] > 0.0f || this.zero_counts_) {
                // empty if block
            }
            ++i;
        }
        g.setFont(this.label_font_);
        fm = g.getFontMetrics();
        if (this.have_x_label_) {
            int x_lab_Center = (int)((double)fm.stringWidth(this.x_lab_) * 0.5);
            g.drawString(this.x_lab_, left + (int)((double)(this.width_ - right) * 0.5) - x_lab_Center, yOrigin - 4);
        }
        if (this.have_y_label_) {
            int stringheight_ = (int)((double)fm.getHeight() * 0.75);
            int len = this.y_lab_.length();
            int textCenter = (int)(0.5 * (double)len * (double)stringheight_);
            int axisCenter = (int)(0.5 * (double)(yOrigin + bottom + top));
            int charwidth_ = 0;
            char[] charArray = new char[1];
            i = 0;
            while (i < len) {
                char character;
                charArray[0] = character = this.y_lab_.charAt(i);
                String string = new String(charArray);
                charwidth_ = (int)(0.5 * (double)fm.stringWidth(string));
                g.drawString(string, 8 - charwidth_, axisCenter - textCenter + i * stringheight_);
                ++i;
            }
        }
        if (this.have_title_) {
            g.setFont(this.title_font_);
            fm = g.getFontMetrics();
            int title_Center = (int)((double)fm.stringWidth(this.title_) * 0.5);
            g.drawString(this.title_, (int)((double)(this.width_ - right) * 0.5) - title_Center, top - 2);
        }
    }

    public void paintComponent(Graphics g) {
        this.paint(g);
    }

    public void removeCounts() {
        this.draw_counts_ = false;
        this.zero_counts_ = false;
    }

    public void removeXLabel() {
        this.have_x_label_ = false;
        this.margins_[0] = this.margins_[0] - 10;
    }

    public void removeYLabel() {
        this.have_y_label_ = false;
        this.margins_[1] = this.margins_[1] - 10;
    }

    public void setBinWidth(float bin_width) {
        this.bin_width_ = bin_width;
        this.have_bin_width_ = true;
        if (this.data_ != null) {
            this.setHistParams();
        }
    }

    public void setClassType(String class_type) {
        if (!(class_type.equals("Sturges") || class_type.equals("Scott") || class_type.equals("FD"))) {
            throw new IllegalArgumentException("Class type " + class_type + " not recognized.");
        }
        this.class_type_ = class_type;
    }

    public void setDefaultBins() {
        this.have_bin_width_ = false;
        if (this.data_ != null) {
            this.setHistParams();
        }
    }

    private void setHistParams() {
        if (!this.have_bin_width_) {
            if (this.class_type_.equals("Sturges")) {
                this.bins_ = (int)Math.ceil(1.0 + Math.log(this.sampl_size_) / Math.log(2.0));
                this.bins_ *= 2;
            } else if (this.class_type_.equals("FD")) {
                this.bins_ = (int)Math.ceil((double)(this.max_x_ - this.min_x_) / ((double)(2.0f * (this.data_.quant(0.75f) - this.data_.quant(0.25f))) * Math.pow(this.sampl_size_, -0.3333333333333333)));
            } else if (this.class_type_.equals("Scott")) {
                this.bins_ = (int)Math.ceil((double)(this.max_x_ - this.min_x_) / (3.49 * (double)this.data_.stdev() * Math.pow(this.sampl_size_, -0.3333333333333333)));
            }
            this.bin_width_ = (this.max_x_ - this.min_x_) / (float)this.bins_;
        } else {
            this.bins_ = (int)Math.ceil((this.max_x_ - this.min_x_) / this.bin_width_);
        }
        this.bin_bounds_ = new float[this.bins_ + 1];
        this.bin_cumulative_ = new float[this.bins_ + 1];
        this.bin_counts_ = new float[this.bins_];
        this.bin_width_ = (this.max_x_ - this.min_x_) / (float)this.bins_;
        int i = 0;
        while (i <= this.bins_) {
            this.bin_bounds_[i] = this.min_x_ + this.bin_width_ * (float)i;
            ++i;
        }
        this.bin_cumulative_[0] = 0.0f;
        i = 1;
        while (i <= this.bins_) {
            this.bin_cumulative_[i] = 0.0f;
            int j = 0;
            while (j < this.sampl_size_) {
                if (this.data_.elementAt(j) <= this.bin_bounds_[i]) {
                    int n = i;
                    this.bin_cumulative_[n] = this.bin_cumulative_[n] + 1.0f;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.bins_) {
            this.bin_counts_[i] = (this.bin_cumulative_[i + 1] - this.bin_cumulative_[i]) / (this.bin_width_ * (float)this.sampl_size_);
            if (i == 0) {
                this.max_y_ = this.bin_counts_[0];
            } else if (this.bin_counts_[i] > this.max_y_) {
                this.max_y_ = this.bin_counts_[i];
            }
            ++i;
        }
    }
}

