/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.marsejb.arrayplate.vo;

import at.tugraz.genome.marsejb.arrayplate.ejb.Arrayblock;
import at.tugraz.genome.marsejb.arrayplate.ejb.Arraytype;
import at.tugraz.genome.marsejb.arrayplate.vo.ArrayblockVO;
import at.tugraz.genome.marsejb.exception.ValidationException;
import at.tugraz.genome.marsejb.molecule.vo.OrganismVO;
import at.tugraz.genome.marsejb.utils.vo.FileUploadVO;
import at.tugraz.genome.marsejb.utils.vo.ProtocolVO;
import at.tugraz.genome.marsejb.utils.vo.SubmitterVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class ArraytypeVO
implements Serializable {
    private Long id;
    private Long userid;
    private String name;
    private String platform;
    private BigDecimal rownumber;
    private BigDecimal columnnumber;
    private BigDecimal blocknumber;
    private Long protocol;
    private String descr;
    private Date addeddate;
    private Boolean printed;
    private String printmapname;
    private Collection arrayBlocks;
    private SubmitterVO submitterVO;
    private ProtocolVO protocolVO;
    private OrganismVO mainOrganismVO;
    private Long mainOrganismID;
    private Boolean commercial = new Boolean(false);
    private FileUploadVO uploadVO = null;
    private Long uploadID = null;

    public ArraytypeVO(Arraytype entity) {
        try {
            this.setId(entity.getId());
            this.setUserid(entity.getUserid());
            this.setName(entity.getName());
            this.setPlatform(entity.getPlatform());
            this.setRownumber(entity.getRownumber());
            this.setColumnnumber(entity.getColumnnumber());
            this.setBlocknumber(entity.getBlocknumber());
            this.setProtocol(entity.getProtocol());
            this.setDescr(entity.getDescr());
            this.setAddeddate(entity.getAddeddate());
            this.setPrinted(new Boolean(entity.getPrinted()));
            this.setPrintmapname(entity.getPrintmapname());
            this.setMainorganismid(entity.getMainorganismid());
            this.setCommercial(new Boolean(entity.getCommercial()));
            this.setFileUploadID(entity.getUpload());
            this.arrayBlocks = new Vector();
            try {
                if (entity.getUserid() != null) {
                    this.submitterVO = entity.getSubmitterVO();
                }
                if (entity.getProtocol() != null) {
                    this.protocolVO = entity.getProtocolVO();
                }
                if (entity.getMainorganismid() != null) {
                    this.mainOrganismVO = entity.getMainorganismVO();
                }
                if (entity.getUpload() != null) {
                    this.uploadVO = entity.getFileUploadVO();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Iterator iterator = entity.getArrayblock().iterator();
            while (iterator.hasNext()) {
                Arrayblock arrayBlock = (Arrayblock)iterator.next();
                this.arrayBlocks.add(new ArrayblockVO(arrayBlock));
            }
        }
        catch (ValidationException validationExc) {
            validationExc.printStackTrace();
        }
    }

    public ArraytypeVO(Arraytype entity, boolean elements) {
        try {
            this.setId(entity.getId());
            this.setUserid(entity.getUserid());
            this.setName(entity.getName());
            this.setPlatform(entity.getPlatform());
            this.setRownumber(entity.getRownumber());
            this.setColumnnumber(entity.getColumnnumber());
            this.setBlocknumber(entity.getBlocknumber());
            this.setProtocol(entity.getProtocol());
            this.setDescr(entity.getDescr());
            this.setAddeddate(entity.getAddeddate());
            this.setPrinted(new Boolean(entity.getPrinted()));
            this.setPrintmapname(entity.getPrintmapname());
            this.setMainorganismid(entity.getMainorganismid());
            this.setCommercial(new Boolean(entity.getCommercial()));
            this.setFileUploadID(entity.getUpload());
            this.arrayBlocks = new Vector();
            try {
                if (entity.getUserid() != null) {
                    this.submitterVO = entity.getSubmitterVO();
                }
                if (entity.getProtocol() != null) {
                    this.protocolVO = entity.getProtocolVO();
                }
                if (entity.getMainorganismid() != null) {
                    this.mainOrganismVO = entity.getMainorganismVO();
                }
                if (entity.getUpload() != null) {
                    this.uploadVO = entity.getFileUploadVO();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Iterator iterator = entity.getArrayblock().iterator();
            int nrOfArrayBlocks = entity.getArrayblock().size();
            int currArrayBlock = 0;
            while (iterator.hasNext()) {
                System.out.println("ArrayBlock : " + ++currArrayBlock + " of " + nrOfArrayBlocks);
                Arrayblock arrayBlock = (Arrayblock)iterator.next();
                this.arrayBlocks.add(new ArrayblockVO(arrayBlock, elements));
            }
        }
        catch (ValidationException validationExc) {
            validationExc.printStackTrace();
        }
    }

    public ArraytypeVO(Long userID, String name, String platform, BigDecimal rowNumber, BigDecimal columnNumber, BigDecimal blockNumber, Long protocol, String description, Date addedDate, Boolean printed, String printMapName, Collection arrayBlocks, Long mainOrganismID, Boolean commercial, FileUploadVO uploadVO) throws ValidationException {
        this.setUserid(userID);
        this.setName(name);
        this.setPlatform(platform);
        this.setRownumber(rowNumber);
        this.setColumnnumber(columnNumber);
        this.setBlocknumber(blockNumber);
        this.setProtocol(protocol);
        this.setDescr(description);
        this.setAddeddate(addedDate);
        this.setPrinted(printed);
        this.setPrintmapname(printMapName);
        this.setArrayblocks(arrayBlocks);
        this.setMainorganismid(mainOrganismID);
        this.setCommercial(commercial);
        this.setFileUploadVO(uploadVO);
    }

    public ArraytypeVO(Long userID, String name, String platform, Long protocol, String description, String printMapName, Boolean commercial, FileUploadVO uploadVO) throws ValidationException {
        this(userID, name, platform, null, null, null, protocol, description, new Date(System.currentTimeMillis()), null, printMapName, null, null, commercial, uploadVO);
    }

    public void setCommercial(Boolean commercial) {
        this.commercial = commercial;
    }

    public Boolean getCommercial() {
        return this.commercial;
    }

    public OrganismVO getMainorganismVO() {
        return this.mainOrganismVO;
    }

    public Long getMainorganismid() {
        return this.mainOrganismID;
    }

    public void setMainorganismid(Long id) {
        this.mainOrganismID = id;
    }

    public Long getId() {
        return this.id;
    }

    public Long getUserid() {
        return this.userid;
    }

    public String getName() {
        return this.name;
    }

    public String getPlatform() {
        return this.platform;
    }

    public BigDecimal getRownumber() {
        return this.rownumber;
    }

    public BigDecimal getColumnnumber() {
        return this.columnnumber;
    }

    public BigDecimal getBlocknumber() {
        return this.blocknumber;
    }

    public Long getProtocol() {
        return this.protocol;
    }

    public String getDescr() {
        return this.descr;
    }

    public Date getAddeddate() {
        return this.addeddate;
    }

    public Boolean getPrinted() {
        return this.printed;
    }

    public String getPrintmapname() {
        return this.printmapname;
    }

    public Collection getArrayblocks() {
        return this.arrayBlocks;
    }

    public ArrayblockVO getArrayblock(Long blockNumber) {
        Iterator iterator = this.arrayBlocks.iterator();
        while (iterator.hasNext()) {
            ArrayblockVO arrayBlockVO = (ArrayblockVO)iterator.next();
            if (arrayBlockVO.getBlocknum().intValue() != blockNumber.intValue()) continue;
            return arrayBlockVO;
        }
        return null;
    }

    public SubmitterVO getSubmitterVO() {
        return this.submitterVO;
    }

    public ProtocolVO getProtocolVO() {
        return this.protocolVO;
    }

    public void setId(Long id) throws ValidationException {
        if (id == null) {
            throw new ValidationException("id in ArraytypeVO is NULL", this.getClass());
        }
        if (this.id != null) {
            throw new ValidationException("id in ArraytypeVO was already set", this.getClass());
        }
        this.id = id;
    }

    public void setUserid(Long userid) throws ValidationException {
        if (userid == null) {
            throw new ValidationException("userid in ArraytypeVO is NULL", this.getClass());
        }
        this.userid = userid;
    }

    public void setName(String name) throws ValidationException {
        if (name == null) {
            throw new ValidationException("name in ArraytypeVO is NULL", this.getClass());
        }
        this.name = name;
    }

    public void setPlatform(String platform) throws ValidationException {
        if (platform == null) {
            throw new ValidationException("platform in ArraytypeVO is NULL", this.getClass());
        }
        if (platform.trim().length() < 1) {
            throw new ValidationException("platform in ArraytypeVO must have more than 0 characters", this.getClass());
        }
        this.platform = platform;
    }

    public void setRownumber(BigDecimal rownumber) {
        this.rownumber = rownumber;
    }

    public void setColumnnumber(BigDecimal columnnumber) {
        this.columnnumber = columnnumber;
    }

    public void setBlocknumber(BigDecimal blocknumber) {
        this.blocknumber = blocknumber;
    }

    public void setProtocol(Long protocol) {
        this.protocol = protocol;
    }

    public void setDescr(String descr) {
        this.descr = descr;
    }

    public void setAddeddate(Date addeddate) throws ValidationException {
        if (addeddate == null) {
            throw new ValidationException("addeddate in ArraytypeVO is NULL", this.getClass());
        }
        this.addeddate = addeddate;
    }

    public void setPrinted(Boolean printed) {
        this.printed = printed;
    }

    public void setPrintmapname(String printmapname) {
        this.printmapname = printmapname;
    }

    public void setArrayblocks(Collection arrayBlockVOs) {
        this.arrayBlocks = arrayBlockVOs;
    }

    public void setFileUploadVO(FileUploadVO uploadVO) {
        this.uploadVO = uploadVO;
        if (this.uploadVO != null) {
            this.uploadID = uploadVO.getId();
        }
    }

    public FileUploadVO getFileUploadVO() {
        return this.uploadVO;
    }

    public void setFileUploadID(Long id) {
        this.uploadID = id;
    }

    public Long getFileUploadID() {
        return this.uploadID;
    }

    public String toString() {
        StringBuffer _ret = new StringBuffer();
        _ret.append("at.tugraz.genome.marsejb.arrayplate.vo.ArrayTypeVO {");
        _ret.append("\n");
        _ret.append("java.lang.Long id = ");
        _ret.append(this.id);
        _ret.append("\n");
        _ret.append("java.math.BigDecimal userid = ");
        _ret.append(this.userid);
        _ret.append("\n");
        _ret.append("java.lang.String name = ");
        _ret.append(this.name);
        _ret.append("\n");
        _ret.append("java.lang.String platform = ");
        _ret.append(this.platform);
        _ret.append("\n");
        _ret.append("java.math.BigDecimal rownumber = ");
        _ret.append(this.rownumber);
        _ret.append("\n");
        _ret.append("java.math.BigDecimal columnnumber = ");
        _ret.append(this.columnnumber);
        _ret.append("\n");
        _ret.append("java.math.BigDecimal blocknumber = ");
        _ret.append(this.blocknumber);
        _ret.append("\n");
        _ret.append("java.math.BigDecimal protocol = ");
        _ret.append(this.protocol);
        _ret.append("\n");
        _ret.append("java.lang.String descr = ");
        _ret.append(this.descr);
        _ret.append("\n");
        _ret.append("java.sql.Date addeddate = ");
        _ret.append(this.addeddate);
        _ret.append("\n");
        _ret.append("java.lang.String printed = ");
        _ret.append(this.printed);
        _ret.append("\n");
        _ret.append("java.lang.String printmapname = ");
        _ret.append(this.printmapname);
        _ret.append("\n");
        _ret.append("}");
        return _ret.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof ArraytypeVO) {
            ArraytypeVO obj = (ArraytypeVO)o;
            boolean res = true;
            boolean bl = res = this.id == obj.getId() || this.id != null && obj.getId() != null && this.id.equals(obj.getId());
            if (res) {
                boolean bl2 = res = this.userid == obj.getUserid() || this.userid != null && obj.getUserid() != null && this.userid.equals(obj.getUserid());
                if (res) {
                    boolean bl3 = res = this.name == obj.getName() || this.name != null && obj.getName() != null && this.name.equals(obj.getName());
                    if (res) {
                        boolean bl4 = res = this.platform == obj.getPlatform() || this.platform != null && obj.getPlatform() != null && this.platform.equals(obj.getPlatform());
                        if (res) {
                            boolean bl5 = res = this.rownumber == obj.getRownumber() || this.rownumber != null && obj.getRownumber() != null && this.rownumber.equals(obj.getRownumber());
                            if (res) {
                                boolean bl6 = res = this.columnnumber == obj.getColumnnumber() || this.columnnumber != null && obj.getColumnnumber() != null && this.columnnumber.equals(obj.getColumnnumber());
                                if (res) {
                                    boolean bl7 = res = this.blocknumber == obj.getBlocknumber() || this.blocknumber != null && obj.getBlocknumber() != null && this.blocknumber.equals(obj.getBlocknumber());
                                    if (res) {
                                        boolean bl8 = res = this.protocol == obj.getProtocol() || this.protocol != null && obj.getProtocol() != null && this.protocol.equals(obj.getProtocol());
                                        if (res) {
                                            boolean bl9 = res = this.descr == obj.getDescr() || this.descr != null && obj.getDescr() != null && this.descr.equals(obj.getDescr());
                                            if (res) {
                                                boolean bl10 = res = this.addeddate == obj.getAddeddate() || this.addeddate != null && obj.getAddeddate() != null && this.addeddate.equals(obj.getAddeddate());
                                                if (res) {
                                                    boolean bl11 = res = this.printed == obj.getPrinted() || this.printed != null && obj.getPrinted() != null && this.printed.equals(obj.getPrinted());
                                                    if (res) {
                                                        boolean bl12 = res = this.printmapname == obj.getPrintmapname() || this.printmapname != null && obj.getPrintmapname() != null && this.printmapname.equals(obj.getPrintmapname());
                                                        if (!res) {
                                                            // empty if block
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return res;
        }
        return false;
    }

    public int hashCode() {
        return (this.name + this.platform + this.addeddate.toString() + this.printmapname).hashCode();
    }
}

