/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.math;

import at.tugraz.genome.math.ArrayOp;
import at.tugraz.genome.math.HillFunction;
import at.tugraz.genome.math.LineFunction;
import at.tugraz.genome.math.PolynomFunction;
import at.tugraz.genome.math.QuadraticFunction;

public class FunctionTest {
    public FunctionTest() {
        this.TestHillFunction();
    }

    private void TestHillFunction() {
        HillFunction f = new HillFunction();
        double[] hill_parameter = new double[]{20.0, 8.0, 4.0, 0.5};
        int num_values = 25;
        double[] x_values = new double[]{0.0, 10.0, 30.0, 90.0, 270.0, 810.0};
        double[] y_values = new double[]{0.001804, 0.00316, 0.007717, 0.022451, 0.098531, 0.54124};
        double[] sigma = new double[]{3.0E-4, 0.001251, 0.002153, 0.004563, 0.008645, 0.015575};
        ArrayOp.dumpArray("X:   ", x_values, 11, 4);
        ArrayOp.dumpArray("Y:   ", y_values, 11, 4);
        ArrayOp.dumpArray("Sigma", sigma, 11, 4);
        double tolerance = 1.0E-9;
        double[] fit = f.fit(x_values, y_values, sigma, tolerance);
        ArrayOp.dumpArray("Start: ", f.getStartParameters(x_values, y_values), 11, 4);
        ArrayOp.dumpArray("Fit:   ", fit, 11, 4);
        System.out.println("Iterations: " + f.getIterations() + "   R^2: " + f.getCorrelationOfDetermination() + "   chi^2: " + f.getChiSquareReduced());
        fit = f.fit(x_values, y_values, null, tolerance);
        ArrayOp.dumpArray("Start: ", f.getStartParameters(x_values, y_values), 11, 4);
        ArrayOp.dumpArray("Fit:   ", fit, 11, 4);
        System.out.println("Chi^2: " + f.getChiSquareReduced() + "   R^2: " + f.getCorrelationOfDetermination() + "   Iterations: " + f.getIterations());
        double[] zparam = new double[]{4.01981, 8.67519, -1.22834, -0.75495};
        ArrayOp.dumpArray("ZParam:", zparam, 11, 4);
        f.setParameters(zparam);
        System.out.println("   R^2: " + f.getCorrelationOfDetermination() + "   chi^2: " + f.getChiSquareReduced());
        System.out.println("log(Double.MIN_VALUE): " + Math.log(Double.MIN_VALUE));
        System.out.println("Double.MIN_VALUE ^ 10: " + Math.pow(Double.MIN_VALUE, 10.0));
        System.out.println("Double.MIN_VALUE ^ -10: " + Math.pow(Double.MIN_VALUE, -10.0));
        System.out.println("Float.MIN_VALUE ^ -10: " + Math.pow(1.4E-45f, -10.0));
        double y = f.getValue(fit, 0.5);
        System.out.println("X: 0.5   Y: " + y);
        y = 2.0;
        System.out.println("Y: " + y + "  X: " + f.getXValue(fit, y));
        y = 1.0;
        System.out.println("Y: " + y + "  X: " + f.getXValue(fit, y));
    }

    private void TestLineFunction() {
        LineFunction f = new LineFunction();
        double[] line_parameter = new double[]{2.1, 1.5};
        int num_values = 25;
        double[] x_values = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0};
        double[] y_values = new double[]{0.0, 0.7, 1.2, 1.6, 1.8, 2.0, 1.8, 1.6, 1.2, 0.7, 0.0};
        double[] sigma = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        ArrayOp.dumpArray("X:   ", x_values, 11, 4);
        ArrayOp.dumpArray("Y:   ", y_values, 11, 4);
        double[] fit = f.fit(x_values, y_values, sigma, 1.0E-8);
        ArrayOp.dumpArray("Org:   ", line_parameter, 11, 4);
        ArrayOp.dumpArray("Start: ", f.getStartParameters(x_values, y_values), 11, 4);
        ArrayOp.dumpArray("Fit:   ", fit, 11, 4);
        System.out.println("Iterations: " + f.getIterations() + "   R^2: " + f.getCorrelationOfDetermination());
        double y = f.getValue(fit, 0.5);
        System.out.println("X: 0.5   Y: " + y);
        System.out.println("Y: " + y + "  X: " + f.getXValue(fit, y));
        f.setParameters(fit);
        System.out.println("Y: " + y + "  X: " + f.getXValue(y));
    }

    private void TestPolyFunction() {
        PolynomFunction f = new PolynomFunction(6);
        double[] x_values = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0};
        double[] y_values = new double[]{0.0, 3.3, 6.7, 12.5, 25.0, 50.0, 75.0, 87.5, 93.5, 97.0, 100.0};
        double[] sigma = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        ArrayOp.dumpArray("X:   ", x_values, 11, 4);
        ArrayOp.dumpArray("Y:   ", y_values, 11, 4);
        double[] fit = f.fit(x_values, y_values, sigma, 1.0E-8);
        ArrayOp.dumpArray("Start: ", f.getStartParameters(x_values, y_values), 11, 4);
        ArrayOp.dumpArray("Fit:   ", fit, 11, 4);
        System.out.println("Iterations: " + f.getIterations() + "   R^2: " + f.getCorrelationOfDetermination());
        double y = f.getValue(fit, 1.5);
        System.out.println("X: 1.5   Y: " + y);
        y = f.getValue(fit, 4.5);
        System.out.println("X: 4.5   Y: " + y);
        y = f.getValue(fit, 5.5);
        System.out.println("X: 5.5   Y: " + y);
        y = f.getValue(fit, 8.5);
        System.out.println("X: 8.5   Y: " + y);
        y = f.getValue(fit, 9.5);
        System.out.println("X: 9.5   Y: " + y);
        System.out.println("parname0 = " + f.getParameterName(0));
        System.out.println("parname6 = " + f.getParameterName(6));
    }

    private void TestQuadraticFunction() {
        QuadraticFunction f = new QuadraticFunction();
        double[] x_values = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0};
        double[] y_values = new double[]{0.0, 0.7, 1.2, 1.6, 1.8, 2.0, 1.8, 1.6, 1.2, 0.7, 0.0};
        double[] sigma = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        ArrayOp.dumpArray("X:   ", x_values, 11, 4);
        ArrayOp.dumpArray("Y:   ", y_values, 11, 4);
        double[] fit = f.fit(x_values, y_values, sigma, 1.0E-8);
        ArrayOp.dumpArray("Start: ", f.getStartParameters(x_values, y_values), 11, 4);
        ArrayOp.dumpArray("Fit:   ", fit, 11, 4);
        System.out.println("Iterations: " + f.getIterations() + "   R^2: " + f.getCorrelationOfDetermination());
        double y = f.getValue(fit, 4.5);
        System.out.println("X: 4.5   Y: " + y);
        y = f.getValue(fit, 9.5);
        System.out.println("X: 9.5   Y: " + y);
        System.out.println("Y: " + y + "  X: " + f.getXValue(fit, y));
        f.setParameters(fit);
        System.out.println("Y: " + y + "  X: " + f.getXValue(y));
    }

    public static void main(String[] args) {
        FunctionTest functionTest = new FunctionTest();
    }
}

