/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.math;

import java.util.Arrays;
import java.util.Vector;

public class MathFunctions {
    public static float[] absoluteArray(float[] x_in) {
        int len = x_in.length;
        float[] x_out = new float[len];
        int i = 0;
        while (i < len) {
            x_out[i] = Math.abs(x_in[i]);
            ++i;
        }
        return x_out;
    }

    public static double[] addArrays(double[] x1, double[] x2) {
        int len = x1.length;
        double[] y = new double[len];
        if (x1.length == x2.length) {
            int i = 0;
            while (i < len) {
                y[i] = x1[i] + x2[i];
                ++i;
            }
            return y;
        }
        return null;
    }

    public static float[] addArrays(float[] x1, float[] x2) {
        int len = x1.length;
        float[] y = new float[len];
        if (x1.length == x2.length) {
            int i = 0;
            while (i < len) {
                y[i] = x1[i] + x2[i];
                ++i;
            }
            return y;
        }
        return null;
    }

    public static float[] addToArray(float[] x1, float x2) {
        int len = x1.length;
        float[] y = new float[len];
        int i = 0;
        while (i < len) {
            y[i] = x1[i] + x2;
            ++i;
        }
        return y;
    }

    public static int advancedCeil(float x, float thres) {
        float rest = x % 1.0f;
        if (rest >= thres) {
            x -= rest;
            x += 1.0f;
        } else {
            x -= rest;
        }
        return (int)x;
    }

    public static float[] bubbleSort(float[] in) {
        int x_len = 0;
        float trans = 0.0f;
        x_len = in.length;
        int i = 0;
        while (i < x_len - 1) {
            int j = x_len - 1;
            while (j > i) {
                if (in[j] < in[j - 1]) {
                    trans = in[j];
                    in[j] = in[j - 1];
                    in[j - 1] = trans;
                }
                --j;
            }
            ++i;
        }
        return in;
    }

    public static int countReliableValues(float[] x) {
        int x_len = 0;
        int cnt_rel = 0;
        x_len = x.length;
        int i = 0;
        while (i < x_len) {
            if (!Float.isNaN(x[i])) {
                ++cnt_rel;
            }
            ++i;
        }
        return cnt_rel;
    }

    public static float[] createLinSpacedArray(float x1, float x2, int points) {
        float[] interval = new float[points];
        float dist = (x2 - x1) / (float)(points - 1);
        interval[0] = x1;
        int i = 1;
        while (i < points) {
            interval[i] = interval[i - 1] + dist;
            ++i;
        }
        return interval;
    }

    public static Vector createLinSpacedVector(float x1, float x2, int points) {
        Vector<float[]> y = new Vector<float[]>();
        float[] interval = new float[points];
        float dist = (x2 - x1) / (float)(points - 1);
        interval[0] = x1;
        int i = 1;
        while (i < points) {
            interval[i] = interval[i - 1] + dist;
            ++i;
        }
        y.add(interval);
        return y;
    }

    public static float[] divideArrayByConst(float[] x1, float x2) {
        int len = x1.length;
        float[] y = new float[len];
        int i = 0;
        while (i < len) {
            y[i] = x2 > 0.0f ? x1[i] / x2 : x1[i] / 1.0E-4f;
            ++i;
        }
        return y;
    }

    public static double[] exp2(double[] x_in) {
        int len = x_in.length;
        double[] y = new double[len];
        int i = 0;
        while (i < len) {
            y[i] = Math.pow(2.0, x_in[i]);
            ++i;
        }
        return y;
    }

    public static float[] exp2(float[] x_in) {
        int len = x_in.length;
        float[] y = new float[len];
        int i = 0;
        while (i < len) {
            y[i] = (float)Math.pow(2.0, x_in[i]);
            ++i;
        }
        return y;
    }

    public static float fastLinSpaceSum(Vector x) {
        int x_len = 0;
        float[] in = new float[x_len];
        float x_sum = 0.0f;
        in = (float[])x.get(0);
        x_len = in.length;
        x_sum = (in[0] + in[x_len - 1]) * (float)(x_len / 2);
        return x_sum;
    }

    public static int find(float[] x, float a, int option) {
        int x_len = 0;
        int i_found = 0;
        x_len = x.length;
        block0 : switch (option) {
            case 0: {
                int i = 0;
                while (i < x_len) {
                    if (x[i] == a) {
                        i_found = i;
                        break block0;
                    }
                    ++i;
                }
                break;
            }
        }
        return i_found;
    }

    public static int find(Vector x, float a, int option) {
        int x_len = 0;
        int i_found = 0;
        float[] in = new float[x_len];
        in = (float[])x.get(0);
        x_len = in.length;
        block0 : switch (option) {
            case 0: {
                int i = 0;
                while (i < x_len) {
                    if (in[i] == a) {
                        i_found = i;
                        break block0;
                    }
                    ++i;
                }
                break;
            }
        }
        return i_found;
    }

    public static float firstReliableValue(float[] x) {
        int x_len = 0;
        float rel_val = 0.0f;
        boolean cnt_nan = false;
        x_len = x.length;
        int i = 0;
        while (i < x_len) {
            rel_val = x[i];
            if (!Float.isNaN(rel_val)) break;
            ++i;
        }
        return rel_val;
    }

    public static double[] innerProduct(double[] x1, double[] x2) {
        int len = x1.length;
        double[] y = new double[len];
        if (x1.length == x2.length) {
            int i = 0;
            while (i < len) {
                y[i] = x1[i] * x2[i];
                ++i;
            }
            return y;
        }
        return null;
    }

    public static float[] innerProduct(float[] x1, float[] x2) {
        int len = x1.length;
        float[] y = new float[len];
        if (x1.length == x2.length) {
            int i = 0;
            while (i < len) {
                y[i] = x1[i] * x2[i];
                ++i;
            }
            return y;
        }
        return null;
    }

    public static float[] join2Arrays(float[] x1, float[] x2) {
        int len = x1.length + x2.length;
        int offset = x1.length;
        float[] y = new float[len];
        int i = 0;
        while (i < x1.length) {
            y[i] = x1[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < x2.length) {
            y[i2 + offset] = x2[i2];
            ++i2;
        }
        return y;
    }

    public static float[] ln(float[] x_in) {
        int len = x_in.length;
        float[] y = new float[len];
        int i = 0;
        while (i < len) {
            y[i] = (float)Math.log(x_in[i]);
            ++i;
        }
        return y;
    }

    public static double log2(double x_in) {
        double y = Math.log(x_in) / 0.6931471824645996;
        return y;
    }

    public static float log2(float x_in) {
        float y = (float)(Math.log(x_in) / 0.6931471824645996);
        return y;
    }

    public static double[] log2(double[] x_in) {
        int len = x_in.length;
        double[] y = new double[len];
        int i = 0;
        while (i < len) {
            y[i] = Math.log(x_in[i]) / 0.6931471824645996;
            ++i;
        }
        return y;
    }

    public static float[] log2(float[] x_in) {
        int len = x_in.length;
        float[] y = new float[len];
        int i = 0;
        while (i < len) {
            y[i] = (float)(Math.log(x_in[i]) / 0.6931471824645996);
            ++i;
        }
        return y;
    }

    public static void main(String[] args) {
        MathFunctions mathFunctions1 = new MathFunctions();
        float[] var1 = new float[5];
        float[] var2 = new float[5];
        int i = 0;
        while (i < 5) {
            var1[i] = i + 1;
            var2[i] = i + 1;
            ++i;
        }
        var1[0] = Float.NaN;
        var1[4] = Float.NaN;
        float min = MathFunctions.min(var1);
        float max = MathFunctions.max(var1);
        float sum = MathFunctions.sum(var1);
        var1 = MathFunctions.powerArray(var1, 2);
        System.out.println("max = " + max);
        System.out.println("min = " + min);
        System.out.println("sum = " + sum);
        int i2 = 0;
        while (i2 < 5) {
            System.out.println("power[" + i2 + "] = " + var1[i2]);
            ++i2;
        }
        var1 = MathFunctions.sqrtArray(var1);
        int i3 = 0;
        while (i3 < 5) {
            System.out.println("power[" + i3 + "] = " + var1[i3]);
            ++i3;
        }
        var1 = MathFunctions.innerProduct(var1, var2);
        int i4 = 0;
        while (i4 < 5) {
            System.out.println("innerproduct[" + i4 + "] = " + var1[i4]);
            ++i4;
        }
        int i5 = 0;
        while (i5 < 5) {
            var1[i5] = i5 + 1;
            var2[i5] = i5 + 1;
            ++i5;
        }
        var2[0] = Float.NaN;
        var2[4] = Float.NaN;
        float mean = MathFunctions.mean(var2);
        float median = MathFunctions.median(var2);
        System.out.println("mean = " + mean);
        System.out.println("median = " + median);
        float[] var3 = new float[10];
        int i6 = 0;
        while (i6 < 10) {
            var3[i6] = i6 + 1;
            ++i6;
        }
        var3[3] = Float.NaN;
        var3[5] = Float.NaN;
        var3[4] = Float.NaN;
        median = MathFunctions.median(var3);
        System.out.println("median var3 = " + median);
    }

    public static int max(int[] in) {
        int x_len = 0;
        int x_max = 0;
        x_len = in.length;
        x_max = Integer.MIN_VALUE;
        int i = 0;
        while (i < x_len) {
            if (in[i] > x_max) {
                x_max = in[i];
            }
            ++i;
        }
        return x_max;
    }

    public static double max(double[] in) {
        int x_len = 0;
        double x_max = 0.0;
        x_len = in.length;
        x_max = Double.MIN_VALUE;
        int i = 0;
        while (i < x_len) {
            if (in[i] > x_max) {
                x_max = in[i];
            }
            ++i;
        }
        return x_max;
    }

    public static float max(float[] in) {
        int x_len = 0;
        float x_max = 0.0f;
        x_len = in.length;
        x_max = Float.MIN_VALUE;
        int i = 0;
        while (i < x_len) {
            if (in[i] > x_max) {
                x_max = in[i];
            }
            ++i;
        }
        return x_max;
    }

    public static int mean(int[] x) {
        int x_len = 0;
        int x_mean = 0;
        int i = 0;
        while (i < x.length) {
            int val = x[i];
            if (!Float.isNaN(val)) {
                ++x_len;
                x_mean += val;
            }
            ++i;
        }
        return x_mean /= x_len;
    }

    public static float mean(float[] x) {
        float x_mean = 0.0f;
        int x_len = 0;
        int i = 0;
        while (i < x.length) {
            float val = x[i];
            if (!Float.isNaN(val)) {
                ++x_len;
                x_mean += val;
            }
            ++i;
        }
        return x_mean /= (float)x_len;
    }

    public static float median(float[] x) {
        int x_len = 0;
        float x_median = 0.0f;
        int cnt_nan = 0;
        x_len = x.length;
        float[] dummy_x = new float[x_len];
        dummy_x = (float[])x.clone();
        Arrays.sort(dummy_x);
        int i = 0;
        while (i < x_len) {
            if (Float.isNaN(dummy_x[i])) {
                ++cnt_nan;
            }
            ++i;
        }
        if ((x_len -= cnt_nan) % 2 == 0) {
            x_median = (dummy_x[x_len / 2 - 1] + dummy_x[x_len / 2]) / 2.0f;
        } else if (x_len % 2 != 0) {
            x_median = dummy_x[x_len / 2];
        }
        dummy_x = null;
        return x_median;
    }

    public static int min(int[] in) {
        int x_len = 0;
        int x_min = 0;
        x_len = in.length;
        x_min = Integer.MAX_VALUE;
        int i = 0;
        while (i < x_len) {
            int val = in[i];
            if (!Float.isNaN(val) && val <= x_min) {
                x_min = val;
            }
            ++i;
        }
        return x_min;
    }

    public static double min(double[] in) {
        int x_len = 0;
        x_len = in.length;
        double x_min = Double.MAX_VALUE;
        int i = 0;
        while (i < x_len) {
            double val = in[i];
            if (!Double.isNaN(val) && val <= x_min) {
                x_min = val;
            }
            ++i;
        }
        return x_min;
    }

    public static float min(float[] in) {
        int x_len = 0;
        x_len = in.length;
        float x_min = Float.MAX_VALUE;
        int i = 0;
        while (i < x_len) {
            float val = in[i];
            if (!Float.isNaN(val) && val <= x_min) {
                x_min = val;
            }
            ++i;
        }
        return x_min;
    }

    public static double[] multArrayWithConst(double[] x1, double x2) {
        int len = x1.length;
        double[] y = new double[len];
        int i = 0;
        while (i < len) {
            y[i] = x1[i] * x2;
            ++i;
        }
        return y;
    }

    public static float[] multArrayWithConst(float[] x1, float x2) {
        int len = x1.length;
        float[] y = new float[len];
        int i = 0;
        while (i < len) {
            y[i] = x1[i] * x2;
            ++i;
        }
        return y;
    }

    public static float[] onesArray(int len) {
        float[] ones = new float[len];
        int i = 0;
        while (i < len) {
            ones[i] = 1.0f;
            ++i;
        }
        return ones;
    }

    public static float[] powerArray(float[] x_in, double pow) {
        int len = x_in.length;
        float[] x_out = new float[len];
        int i = 0;
        while (i < len) {
            x_out[i] = (float)Math.pow(x_in[i], pow);
            ++i;
        }
        return x_out;
    }

    public static double[] powerArray(double[] x_in, int pow) {
        int len = x_in.length;
        double[] x_out = new double[len];
        int i = 0;
        while (i < len) {
            x_out[i] = Math.pow(x_in[i], pow);
            ++i;
        }
        return x_out;
    }

    public static float[] powerArray(float[] x_in, int pow) {
        int len = x_in.length;
        float[] x_out = new float[len];
        int i = 0;
        while (i < len) {
            x_out[i] = (float)Math.pow(x_in[i], pow);
            ++i;
        }
        return x_out;
    }

    private static void quickSort(float[] elements, int low_index, int high_index) {
        int low_to_high_index = low_index;
        int high_to_low_index = high_index;
        int pivot_index = (low_to_high_index + high_to_low_index) / 2;
        float pivotValue = elements[pivot_index];
        int new_low_index = high_index + 1;
        int new_high_index = low_index - 1;
        while (new_high_index + 1 < new_low_index) {
            float low_to_high_value = elements[low_to_high_index];
            while (low_to_high_index < new_low_index & low_to_high_value < pivotValue) {
                new_high_index = low_to_high_index++;
                low_to_high_value = elements[low_to_high_index];
            }
            float high_to_low_value = elements[high_to_low_index];
            while (new_high_index <= high_to_low_index & high_to_low_value > pivotValue) {
                new_low_index = high_to_low_index--;
                high_to_low_value = elements[high_to_low_index];
            }
            if (low_to_high_index == high_to_low_index) {
                new_high_index = low_to_high_index;
                continue;
            }
            if (low_to_high_index >= high_to_low_index || !(low_to_high_value >= high_to_low_value)) continue;
            float parking = low_to_high_value;
            elements[low_to_high_index] = high_to_low_value;
            elements[high_to_low_index] = parking;
            new_low_index = high_to_low_index--;
            new_high_index = low_to_high_index++;
        }
        if (low_index < new_high_index) {
            MathFunctions.quickSort(elements, low_index, new_high_index);
        }
        if (new_low_index < high_index) {
            MathFunctions.quickSort(elements, new_low_index, high_index);
        }
    }

    public static void quickSortEntire(float[] input) {
        if (input.length > 0) {
            MathFunctions.quickSort(input, 0, input.length - 1);
        }
    }

    public static double[] ratioOfArrays(double[] x1, double[] x2) {
        int len = x1.length;
        double[] y = new double[len];
        if (x1.length == x2.length) {
            int i = 0;
            while (i < len) {
                y[i] = x1[i] / x2[i];
                ++i;
            }
            return y;
        }
        return null;
    }

    public static float[] ratioOfArrays(float[] x1, float[] x2) {
        int len = x1.length;
        float[] y = new float[len];
        if (x1.length == x2.length) {
            int i = 0;
            while (i < len) {
                y[i] = x1[i] / x2[i];
                ++i;
            }
            return y;
        }
        return null;
    }

    public static double[] sqrtArray(double[] x_in) {
        int len = x_in.length;
        double[] x_out = new double[len];
        int i = 0;
        while (i < len) {
            x_out[i] = Math.sqrt(x_in[i]);
            ++i;
        }
        return x_out;
    }

    public static float[] sqrtArray(float[] x_in) {
        int len = x_in.length;
        float[] x_out = new float[len];
        int i = 0;
        while (i < len) {
            x_out[i] = (float)Math.sqrt(x_in[i]);
            ++i;
        }
        return x_out;
    }

    public static float stddeviation(float[] x_in) {
        return (float)Math.sqrt(MathFunctions.variance(x_in));
    }

    public static float[] subtractArrays(float[] x1, float[] x2) {
        int len = x1.length;
        float[] y = new float[len];
        if (x1.length == x2.length) {
            int i = 0;
            while (i < len) {
                y[i] = x1[i] - x2[i];
                ++i;
            }
            return y;
        }
        return null;
    }

    public static float[] subtractFromArray(float[] x1, float x2) {
        int len = x1.length;
        float[] y = new float[len];
        int i = 0;
        while (i < len) {
            y[i] = x1[i] - x2;
            ++i;
        }
        return y;
    }

    public static int sum(int[] x) {
        int x_sum = 0;
        int x_len = x.length;
        int i = 0;
        while (i < x_len) {
            int val = x[i];
            if (!Float.isNaN(val)) {
                x_sum += val;
            }
            ++i;
        }
        return x_sum;
    }

    public static float sum(float[] x) {
        float x_sum = 0.0f;
        int x_len = x.length;
        float val = 0.0f;
        int i = 0;
        while (i < x_len) {
            val = x[i];
            if (!Float.isNaN(val)) {
                x_sum += val;
            }
            ++i;
        }
        return x_sum;
    }

    public static float variance(float[] x_in) {
        float varia = 0.0f;
        float mu = 0.0f;
        int samp_size = 0;
        mu = MathFunctions.mean(x_in);
        if (x_in.length > 1) {
            int cnt = 0;
            while (cnt < x_in.length) {
                float val = x_in[cnt];
                if (!Float.isNaN(val)) {
                    ++samp_size;
                    varia = (float)((double)varia + Math.pow(val - mu, 2.0));
                }
                ++cnt;
            }
            return varia /= (float)(samp_size - 1);
        }
        return Float.NaN;
    }

    public static float[] zerosArray(int len) {
        float[] zeros = new float[len];
        int i = 0;
        while (i < len) {
            zeros[i] = 0.0f;
            ++i;
        }
        return zeros;
    }
}

