/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.math;

import at.tugraz.genome.math.Function;

public class QuadraticFunction
extends Function {
    public QuadraticFunction() {
        this.setParameterNames(new String[]{"a", "b", "c"});
    }

    public String getFunctionDefinition() {
        return "y = a + b*x + c*x^2";
    }

    public String getFunctionName() {
        return "Quadratic";
    }

    double getGradient(double[] parm, int pk, double x) {
        double gradient = 0.0;
        switch (pk) {
            case 0: {
                gradient = 1.0;
                break;
            }
            case 1: {
                gradient = x;
                break;
            }
            case 2: {
                gradient = Math.pow(x, 2.0);
            }
            default: {
                System.err.println("getGradient: Hit default case in parameter switch");
            }
        }
        return gradient;
    }

    double getHessian(double[] parm, int pk, int l, double x) {
        double hessian = 0.0;
        return hessian;
    }

    public int getNumberOfParameters() {
        return 3;
    }

    double[] getStartParameters(double[] x, double[] y) {
        double[] start_values = new double[this.getNumberOfParameters()];
        int last_point = x.length - 1;
        start_values[1] = (y[last_point] - y[0]) / (x[last_point] - x[0]);
        start_values[0] = y[last_point] - start_values[1] * x[last_point];
        return start_values;
    }

    public double getValue(double[] param, double x) {
        double y = param[0] + param[1] * x + param[2] * Math.pow(x, 2.0);
        return y;
    }

    public double getXValue(double[] param, double y) {
        double a0 = param[0] - y;
        double a1 = param[1];
        double a2 = param[2];
        double x1 = 1.0 / (2.0 * a2) * (-a1 + Math.sqrt(Math.pow(a1, 2.0) - 4.0 * a2 * a0));
        double x2 = 1.0 / (2.0 * a2) * (-a1 - Math.sqrt(Math.pow(a1, 2.0) - 4.0 * a2 * a0));
        return x1;
    }
}

