/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.math.stattests;

import VisualNumerics.math.Statistics;
import at.tugraz.genome.math.MathFunctions;
import at.tugraz.genome.math.stattests.RankNumber;
import java.util.Arrays;

public class MannWhitneyUTest {
    public static double calculateMannWhitneyNaN(float[] x_in, float[] y_in) {
        int n1 = MathFunctions.countReliableValues(x_in);
        int n2 = MathFunctions.countReliableValues(y_in);
        float[] dummy_x = new float[n1];
        float[] dummy_y = new float[n2];
        int cnt1 = 0;
        int cnt2 = 0;
        int i = 0;
        while (i < x_in.length) {
            float dummy1 = x_in[i];
            if (!Float.isNaN(dummy1)) {
                dummy_x[cnt1] = dummy1;
                ++cnt1;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < y_in.length) {
            float dummy2 = y_in[i2];
            if (!Float.isNaN(dummy2)) {
                dummy_y[cnt2] = dummy2;
                ++cnt2;
            }
            ++i2;
        }
        Arrays.sort(dummy_x);
        Arrays.sort(dummy_y);
        Object[] rank = new RankNumber[n1 + n2];
        int i3 = 0;
        while (i3 < n1) {
            rank[i3] = new RankNumber(dummy_x[i3], 'A');
            ++i3;
        }
        int i4 = 0;
        while (i4 < n2) {
            rank[i4 + n1] = new RankNumber(dummy_y[i4], 'B');
            ++i4;
        }
        Arrays.sort(rank);
        int i5 = 0;
        while (i5 < rank.length) {
            ((RankNumber)rank[i5]).rank_ = i5 + 1;
            int j = i5 + 1;
            float dummySum = j;
            while (j < rank.length && ((RankNumber)rank[i5]).x_ == ((RankNumber)rank[j]).x_) {
                dummySum = dummySum + (float)j + 1.0f;
                ++j;
            }
            dummySum /= (float)(j - i5);
            int k = i5;
            while (k < j) {
                ((RankNumber)rank[k]).rank_ = dummySum;
                ++k;
            }
            i5 = j - 1;
            ++i5;
        }
        float sumR1 = 0.0f;
        float sumR2 = 0.0f;
        int i6 = 0;
        while (i6 < n1 + n2) {
            if (((RankNumber)rank[i6]).group_ == 'A') {
                sumR1 += ((RankNumber)rank[i6]).rank_;
            } else {
                sumR2 += ((RankNumber)rank[i6]).rank_;
            }
            ++i6;
        }
        float sum_what = sumR1;
        int n_what = n1;
        double dumy_nom = (double)sum_what + 0.5 - (double)(n_what * (n1 + n2 + 1) / 2);
        double dumy_denom = Math.sqrt(n1 * n2 * (n1 + n2 + 1) / 12);
        double z_score = dumy_nom / dumy_denom;
        double p_value = Statistics.normalCdf(z_score);
        return p_value;
    }

    public static void main(String[] args) {
        double alpha = 0.05;
        float[] x_in = new float[]{99.0f, 100.0f, 123.0f, 125.0f, 126.0f, 134.0f, 145.0f, 151.0f};
        float[] y_in = new float[]{100.0f, 130.0f, 133.0f, 135.0f, 136.0f, 144.0f, 155.0f};
        float[][] x_a = new float[1][8];
        x_a[0] = x_in;
        float[][] x_b = new float[1][7];
        x_b[0] = y_in;
        double[] p_val = MannWhitneyUTest.multipleCalcMannWhitney(x_a, x_b);
        System.out.println("p-val = " + p_val[0]);
    }

    public static double[] multipleCalcMannWhitney(float[][] mat_a, float[][] mat_b) {
        if (mat_a.length == mat_b.length) {
            System.out.println("ok: both matrices have same length -> do the test");
            int num_tests = mat_a.length;
            double[] p_values = new double[num_tests];
            int i_ = 0;
            while (i_ < num_tests) {
                float[] dummy_a = mat_a[i_];
                float[] dummy_b = mat_b[i_];
                p_values[i_] = MannWhitneyUTest.calculateMannWhitneyNaN(dummy_a, dummy_b);
                ++i_;
            }
            return p_values;
        }
        System.out.println("ko: matrices do not have same length -> no test");
        return null;
    }
}

