/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.utils;

import at.tugraz.genome.utils.JUProxy;
import at.tugraz.genome.utils.MenuAL;
import at.tugraz.genome.utils.MyFrame;
import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.PaintEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.filechooser.FileFilter;
import sun.awt.SunToolkit;

public class FileChooser {
    private ActionListener actionListener = null;
    private int approveButtonMnemonic = 0;
    private String approveButtonText = null;
    private String approveButtonToolTipText = null;
    static /* synthetic */ Class class$java$awt$event$ActionListener;
    private boolean controlsShown = true;
    private File currentDirectory;
    private String dialogTitle = null;
    private int dialogType = 0;
    private FileFilter fileFilter = null;
    private int fileSelectionMode = 0;
    private Vector filters;
    JUProxy juprox_;
    protected EventListenerList listenerList = new EventListenerList();
    private boolean multiSelectionEnabled = false;
    private boolean overwritePromptEnabled = false;
    private boolean resizable = true;
    private int returnValue = -1;
    private File selectedFile = null;
    private File[] selectedFiles;
    private String toolTipText = null;
    private boolean useAcceptAllFileFilter = true;
    private boolean useFileHiding = true;

    public FileChooser(String currentDirectoryPath) {
        this(new File(currentDirectoryPath));
        this.juprox_ = new JUProxy();
    }

    public FileChooser(File currentDirectory) {
        this.filters = new Vector(5);
        this.currentDirectory = new File(System.getProperty("user.home"));
        this.juprox_ = new JUProxy();
        this.setCurrentDirectory(currentDirectory);
    }

    public FileChooser() {
        this.filters = new Vector(5);
        this.currentDirectory = new File(System.getProperty("user.home"));
        this.juprox_ = new JUProxy();
    }

    public boolean accept(File f) {
        boolean shown = true;
        if (f != null && this.fileFilter != null) {
            shown = this.fileFilter.accept(f);
        }
        return shown;
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = FileChooser.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, l);
    }

    public void addChoosableFileFilter(FileFilter filter) {
        if (filter != null && !this.filters.contains(filter)) {
            FileFilter[] oldValue = this.getChoosableFileFilters();
            this.filters.addElement(filter);
            this.firePropertyChange("ChoosableFileFilterChangedProperty", oldValue, this.getChoosableFileFilters());
        }
        this.setFileFilter(filter);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    private void addToFilterList(Vector fList, FileFilter file_filter) {
        String description = file_filter.getDescription();
        fList.add(description);
        String extensions = "*.*";
        extensions = "*.*";
        int ext_start = description.indexOf("(*");
        if (ext_start > 0) {
            extensions = description.substring(ext_start + 1, description.indexOf(")"));
        }
        fList.add(extensions);
    }

    public void approveSelection() {
        throw new UnsupportedOperationException();
    }

    public void cancelSelection() {
        throw new UnsupportedOperationException();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected void fireActionPerformed(String command) {
        Object[] listeners = this.listenerList.getListenerList();
        long mostRecentEventTime = EventQueue.getMostRecentEventTime();
        int modifiers = 0;
        AWTEvent currentEvent = EventQueue.getCurrentEvent();
        if (currentEvent instanceof InputEvent) {
            modifiers = ((InputEvent)currentEvent).getModifiers();
        } else if (currentEvent instanceof ActionEvent) {
            modifiers = ((ActionEvent)currentEvent).getModifiers();
        }
        ActionEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$java$awt$event$ActionListener == null ? FileChooser.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) {
                if (e == null) {
                    e = new ActionEvent(this, 1001, command, mostRecentEventTime, modifiers);
                }
                ((ActionListener)listeners[i + 1]).actionPerformed(e);
            }
            i -= 2;
        }
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.firePropertyChange(propertyName, new Boolean(oldValue), new Boolean(newValue));
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.firePropertyChange(propertyName, new Integer(oldValue), new Integer(newValue));
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    public FileFilter getAcceptAllFileFilter() {
        FileFilter filter = null;
        return filter;
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = FileChooser.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener);
    }

    public int getApproveButtonMnemonic() {
        return this.approveButtonMnemonic;
    }

    public String getApproveButtonText() {
        return this.approveButtonText;
    }

    public FileFilter[] getChoosableFileFilters() {
        Object[] filterArray = new FileFilter[this.filters.size()];
        this.filters.copyInto(filterArray);
        return filterArray;
    }

    public boolean getControlButtonsAreShown() {
        return this.controlsShown;
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public String getDialogTitle() {
        return this.dialogTitle;
    }

    public int getDialogType() {
        return this.dialogType;
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public int getFileSelectionMode() {
        return this.fileSelectionMode;
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    public File[] getSelectedFiles() {
        if (this.selectedFiles == null) {
            return new File[0];
        }
        return (File[])this.selectedFiles.clone();
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public boolean isAcceptAllFileFilterUsed() {
        return this.useAcceptAllFileFilter;
    }

    public boolean isDirectorySelectionEnabled() {
        return this.fileSelectionMode == 1 || this.fileSelectionMode == 2;
    }

    public boolean isFileHidingEnabled() {
        return this.useFileHiding;
    }

    public boolean isFileSelectionEnabled() {
        return this.fileSelectionMode == 0 || this.fileSelectionMode == 2;
    }

    public boolean isMultiSelectionEnabled() {
        return this.multiSelectionEnabled;
    }

    public boolean isOverwritePromptEnabled() {
        return this.overwritePromptEnabled;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public static void main(String[] argv) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            MyFrame window = new MyFrame("Native FileChooser Test");
            ((Component)window).setSize(800, 600);
            JMenuBar menu_bar = new JMenuBar();
            JMenu menu = new JMenu();
            MenuAL al = new MenuAL(window);
            menu.setText("File");
            JMenuItem jmenu_native_open = new JMenuItem();
            jmenu_native_open.setText("1- Open native Open FC...");
            jmenu_native_open.addActionListener(al);
            JMenuItem jmenu_native_save = new JMenuItem();
            jmenu_native_save.setText("2- Open native Save FC...");
            jmenu_native_save.addActionListener(al);
            JMenuItem jmenu_native_folder = new JMenuItem();
            jmenu_native_folder.setText("3- Open native Folder FC...");
            jmenu_native_folder.addActionListener(al);
            JMenuItem jmenu_java_open = new JMenuItem();
            jmenu_java_open.setText("4- Open Java Open FC...");
            jmenu_java_open.addActionListener(al);
            JMenuItem jmenu_java_save = new JMenuItem();
            jmenu_java_save.setText("5- Open Java Save FC...");
            jmenu_java_save.addActionListener(al);
            JMenuItem jmenu_java_folder = new JMenuItem();
            jmenu_java_folder.setText("6- Open Java Folder FC...");
            jmenu_java_folder.addActionListener(al);
            menu.addSeparator();
            menu.add(jmenu_native_open);
            menu.add(jmenu_native_save);
            menu.add(jmenu_native_folder);
            menu.addSeparator();
            menu.add(jmenu_java_open);
            menu.add(jmenu_java_save);
            menu.add(jmenu_java_folder);
            menu_bar.add(menu);
            window.setJMenuBar(menu_bar);
            ((Component)window).setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String paramString() {
        String useFileHidingString;
        String dialogTitleString;
        String approveButtonTextString = this.approveButtonText != null ? this.approveButtonText : "";
        String string = dialogTitleString = this.dialogTitle != null ? this.dialogTitle : "";
        String dialogTypeString = this.dialogType == 0 ? "OPEN_DIALOG" : (this.dialogType == 1 ? "SAVE_DIALOG" : (this.dialogType == 2 ? "CUSTOM_DIALOG" : ""));
        String returnValueString = this.returnValue == 1 ? "CANCEL_OPTION" : (this.returnValue == 0 ? "APPROVE_OPTION" : (this.returnValue == -1 ? "ERROR_OPTION" : ""));
        String string2 = useFileHidingString = this.useFileHiding ? "true" : "false";
        String fileSelectionModeString = this.fileSelectionMode == 0 ? "FILES_ONLY" : (this.fileSelectionMode == 1 ? "DIRECTORIES_ONLY" : (this.fileSelectionMode == 2 ? "FILES_AND_DIRECTORIES" : ""));
        String currentDirectoryString = this.currentDirectory != null ? this.currentDirectory.toString() : "";
        String selectedFileString = this.selectedFile != null ? this.selectedFile.toString() : "";
        return "approveButtonText=" + approveButtonTextString + ",currentDirectory=" + currentDirectoryString + ",dialogTitle=" + dialogTitleString + ",dialogType=" + dialogTypeString + ",fileSelectionMode=" + fileSelectionModeString + ",returnValue=" + returnValueString + ",selectedFile=" + selectedFileString + ",useFileHiding=" + useFileHidingString;
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = FileChooser.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, l);
    }

    public boolean removeChoosableFileFilter(FileFilter f) {
        if (this.filters.contains(f)) {
            if (this.getFileFilter() == f) {
                this.setFileFilter(null);
            }
            FileFilter[] oldValue = this.getChoosableFileFilters();
            this.filters.removeElement(f);
            this.firePropertyChange("ChoosableFileFilterChangedProperty", oldValue, this.getChoosableFileFilters());
            return true;
        }
        return false;
    }

    public void resetChoosableFileFilters() {
        FileFilter[] oldValue = this.getChoosableFileFilters();
        this.setFileFilter(null);
        this.filters.removeAllElements();
        if (this.isAcceptAllFileFilterUsed()) {
            this.addChoosableFileFilter(this.getAcceptAllFileFilter());
        }
        this.firePropertyChange("ChoosableFileFilterChangedProperty", oldValue, this.getChoosableFileFilters());
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private FileFilter searchFilter(String description) {
        FileFilter used_filter = this.getFileFilter();
        if (used_filter != null || this.isAcceptAllFileFilterUsed()) {
            // empty if block
        }
        if (used_filter != null) {
            Enumeration enumeration = this.filters.elements();
            boolean bl = true;
            do {
                if (!bl || (bl = false) || !true) {
                    used_filter = (FileFilter)enumeration.nextElement();
                }
                if (description.equals(used_filter.getDescription())) break;
            } while (enumeration.hasMoreElements());
        }
        return used_filter;
    }

    public void setAcceptAllFileFilterUsed(boolean b) {
        boolean oldValue = this.useAcceptAllFileFilter;
        this.useAcceptAllFileFilter = b;
        if (!b) {
            this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
        } else {
            this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
            this.addChoosableFileFilter(this.getAcceptAllFileFilter());
        }
        this.firePropertyChange("acceptAllFileFilterUsedChanged", oldValue, this.useAcceptAllFileFilter);
    }

    public void setApproveButtonMnemonic(char mnemonic) {
        int vk = mnemonic;
        if (vk >= 97 && vk <= 122) {
            vk -= 32;
        }
        this.setApproveButtonMnemonic(vk);
    }

    public void setApproveButtonMnemonic(int mnemonic) {
        if (this.approveButtonMnemonic == mnemonic) {
            return;
        }
        int oldValue = this.approveButtonMnemonic;
        this.approveButtonMnemonic = mnemonic;
        this.firePropertyChange("ApproveButtonMnemonicChangedProperty", oldValue, this.approveButtonMnemonic);
    }

    public void setApproveButtonText(String approveButtonText) {
        if (this.approveButtonText != approveButtonText) {
            String oldValue = this.approveButtonText;
            this.approveButtonText = approveButtonText;
            this.firePropertyChange("ApproveButtonTextChangedProperty", oldValue, approveButtonText);
        }
    }

    public void setControlButtonsAreShown(boolean b) {
        if (this.controlsShown == b) {
            return;
        }
        boolean oldValue = this.controlsShown;
        this.controlsShown = b;
        this.firePropertyChange("ControlButtonsAreShownChangedProperty", oldValue, this.controlsShown);
    }

    public void setCurrentDirectory(File dir) {
        File oldValue = this.currentDirectory;
        if (dir != null && !dir.exists()) {
            dir = this.currentDirectory;
        }
        if (dir == null) {
            dir = new File(System.getProperty("user.home"));
        }
        if (this.currentDirectory != null && this.currentDirectory.equals(dir)) {
            return;
        }
        this.currentDirectory = dir;
        this.firePropertyChange("directoryChanged", oldValue, this.currentDirectory);
    }

    public void setDialogTitle(String dialogTitle) {
        String oldValue = this.dialogTitle;
        this.dialogTitle = dialogTitle;
        this.firePropertyChange("DialogTitleChangedProperty", oldValue, dialogTitle);
    }

    public void setDialogType(int dialogType) {
        if (this.dialogType == dialogType) {
            return;
        }
        if (dialogType != 0 && dialogType != 1 && dialogType != 2) {
            throw new IllegalArgumentException("Incorrect Dialog Type: " + dialogType);
        }
        int oldValue = this.dialogType;
        this.dialogType = dialogType;
        if (dialogType == 0 || dialogType == 1) {
            this.setApproveButtonText(null);
        }
        this.firePropertyChange("DialogTypeChangedProperty", oldValue, dialogType);
    }

    public void setFileFilter(FileFilter filter) {
        FileFilter oldValue = this.fileFilter;
        this.fileFilter = filter;
        if (filter != null) {
            if (this.isMultiSelectionEnabled() && this.selectedFiles != null && this.selectedFiles.length > 0) {
                Vector<File> fList = new Vector<File>();
                boolean failed = false;
                int i = 0;
                while (i < this.selectedFiles.length) {
                    if (filter.accept(this.selectedFiles[i])) {
                        fList.add(this.selectedFiles[i]);
                    } else {
                        failed = true;
                    }
                    ++i;
                }
                if (failed) {
                    this.setSelectedFiles(fList.size() == 0 ? null : fList.toArray(new File[fList.size()]));
                }
            } else if (this.selectedFile != null && !filter.accept(this.selectedFile)) {
                this.setSelectedFile(null);
            }
        }
        this.firePropertyChange("fileFilterChanged", oldValue, this.fileFilter);
    }

    public void setFileHidingEnabled(boolean b) {
        boolean oldValue = this.useFileHiding;
        this.useFileHiding = b;
        this.firePropertyChange("FileHidingChanged", oldValue, this.useFileHiding);
    }

    public void setFileSelectionMode(int mode) {
        if (this.fileSelectionMode != mode) {
            if (mode == 0 || mode == 1) {
                int oldValue = this.fileSelectionMode;
                this.fileSelectionMode = mode;
                this.firePropertyChange("fileSelectionChanged", oldValue, this.fileSelectionMode);
            } else {
                throw new IllegalArgumentException("Incorrect Mode for Dialog: " + mode);
            }
        }
    }

    public void setMultiSelectionEnabled(boolean b) {
        if (this.multiSelectionEnabled != b) {
            boolean oldValue = this.multiSelectionEnabled;
            this.multiSelectionEnabled = b;
            this.firePropertyChange("MultiSelectionEnabledChangedProperty", oldValue, this.multiSelectionEnabled);
        }
    }

    public void setOverwritePromptEnabled(boolean b) {
        if (this.overwritePromptEnabled != b) {
            boolean oldValue = this.multiSelectionEnabled;
            this.overwritePromptEnabled = b;
            this.firePropertyChange("MultiSelectionEnabledChangedProperty", oldValue, this.multiSelectionEnabled);
        }
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
    }

    public void setSelectedFile(File file) {
        File oldValue = this.selectedFile;
        this.selectedFile = file;
        if (this.selectedFile != null) {
            this.setCurrentDirectory(this.selectedFile.getParentFile());
        }
        this.firePropertyChange("SelectedFileChangedProperty", oldValue, this.selectedFile);
    }

    public void setSelectedFiles(File[] selectedFiles) {
        File[] oldValue = this.selectedFiles;
        if (selectedFiles != null && selectedFiles.length == 0) {
            selectedFiles = null;
        }
        this.selectedFiles = selectedFiles;
        this.setSelectedFile(selectedFiles != null ? selectedFiles[0] : null);
        this.firePropertyChange("SelectedFilesChangedProperty", oldValue, this.selectedFiles);
    }

    public void setToolTipText(String text) {
        this.toolTipText = text;
    }

    public int showDialog(Component parent, String approveButtonText) {
        if (approveButtonText != null) {
            this.setApproveButtonText(approveButtonText);
            this.setDialogType(2);
        }
        this.returnValue = -1;
        int type = 1;
        int flags = 4;
        int num_filters = this.filters.size();
        if (this.isAcceptAllFileFilterUsed()) {
            ++num_filters;
        }
        FileFilter file_filter = null;
        int filter_index = 0;
        Enumeration enumeration = this.filters.elements();
        Vector<String> fList = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            file_filter = (FileFilter)enumeration.nextElement();
            this.addToFilterList(fList, file_filter);
            if (file_filter != this.getFileFilter()) continue;
            filter_index = fList.size() / 2;
        }
        if (filter_index == 0 && this.getFileFilter() != null) {
            this.addToFilterList(fList, this.getFileFilter());
            filter_index = fList.size() / 2;
        }
        if (this.isAcceptAllFileFilterUsed()) {
            fList.add("All Files");
            fList.add("*.*");
        }
        String[] filters = fList.toArray(new String[fList.size()]);
        String default_filename = this.selectedFile == null ? null : this.selectedFile.getName();
        String current_directory = this.currentDirectory.getAbsolutePath();
        switch (this.dialogType) {
            case 0: 
            case 2: {
                if (this.isDirectorySelectionEnabled()) {
                    type = 3;
                    if (default_filename == null) break;
                    current_directory = current_directory + System.getProperty("file.separator") + default_filename;
                    default_filename = null;
                    break;
                }
                if (!this.isMultiSelectionEnabled()) break;
                flags |= 0x200;
                break;
            }
            case 1: {
                type = 2;
                if (!this.isOverwritePromptEnabled()) break;
                flags |= 2;
            }
        }
        if (this.isResizable()) {
            flags |= 0x800000;
        }
        FileChooser fileChooser = this;
        DisplayThread t = new DisplayThread(type, fileChooser.juprox_.getForegroundWindow(), filters, filter_index, default_filename, current_directory, this.dialogTitle, flags);
        try {
            t.start();
            EventQueue queue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            AWTEvent event = null;
            Object src = null;
            while (t.isAlive()) {
                if (queue.peekEvent() == null) {
                    Thread.sleep(25L);
                    SunToolkit.flushPendingEvents();
                    continue;
                }
                event = queue.getNextEvent();
                src = event.getSource();
                if (event instanceof ActiveEvent) {
                    ((ActiveEvent)((Object)event)).dispatch();
                    continue;
                }
                if (src instanceof Component) {
                    boolean dispatch = true;
                    Component src_comp = (Component)src;
                    if (src_comp == parent && event.getID() == 800) {
                        PaintEvent paint = (PaintEvent)event;
                        if ((double)(parent.getWidth() - 8) == paint.getUpdateRect().getWidth()) {
                            dispatch = false;
                        }
                    }
                    if (!dispatch) continue;
                    src_comp.dispatchEvent(event);
                    continue;
                }
                if (src instanceof MenuComponent) {
                    ((MenuComponent)src).dispatchEvent(event);
                    continue;
                }
                System.err.println("Unable to dispatch event: " + event);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String[] filenames = t.getFilenames();
        if (filenames == null) {
            this.returnValue = 1;
        } else {
            if (this.isMultiSelectionEnabled()) {
                this.selectedFile = new File("");
                String file_seperator = System.getProperty("file.separator");
                int num_files = filenames.length - 1;
                if (num_files > 1) {
                    --num_files;
                }
                this.selectedFiles = new File[num_files];
                if (num_files == 1) {
                    this.selectedFiles[0] = new File(filenames[0]);
                } else {
                    int i = 0;
                    while (i < num_files) {
                        this.selectedFiles[i] = new File(filenames[0] + file_seperator + filenames[i + 1]);
                        ++i;
                    }
                    Arrays.sort(this.selectedFiles);
                }
                this.setCurrentDirectory(new File(this.selectedFiles[0].getParent()));
            } else {
                this.selectedFiles = new File[0];
                this.selectedFile = new File(filenames[0]);
                this.setCurrentDirectory(new File(this.selectedFile.getParent()));
            }
            filter_index = Integer.parseInt(filenames[filenames.length - 1]);
            if (filter_index < filters.length) {
                this.fileFilter = this.searchFilter(filters[(filter_index - 1) * 2]);
            }
            this.returnValue = 0;
        }
        return this.returnValue;
    }

    public int showOpenDialog(Component parent) {
        this.setDialogType(0);
        return this.showDialog(parent, null);
    }

    public int showSaveDialog(Component parent) {
        this.setDialogType(1);
        return this.showDialog(parent, null);
    }

    private class DisplayThread
    extends Thread {
        private int dialog_type_;
        private String[] filenames;
        private int filter_index_;
        private String[] filter_list_;
        private int flags_;
        private int hwnd_;
        private String initial_directory_;
        private String initial_file_;
        private String title_;

        DisplayThread(int dialog_type, int hwnd, String[] filter_list, int filter_index, String initial_file, String initial_directory, String title, int flags) {
            this.dialog_type_ = dialog_type;
            this.hwnd_ = hwnd;
            this.filter_list_ = filter_list;
            this.filter_index_ = filter_index;
            this.initial_file_ = initial_file;
            this.initial_directory_ = initial_directory;
            this.title_ = title;
            this.flags_ = flags;
        }

        public String[] getFilenames() {
            return this.filenames;
        }

        public void run() {
            JUProxy cfr_ignored_0 = FileChooser.this.juprox_;
            this.filenames = JUProxy.getOpenSaveFileName(this.dialog_type_, this.hwnd_, this.filter_list_, this.filter_index_, this.initial_file_, this.initial_directory_, this.title_, this.flags_);
        }
    }
}

