/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.utils;

import at.tugraz.genome.utils.DateTime;
import at.tugraz.genome.utils.JUProxy;
import at.tugraz.genome.utils.PackageInfo;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.ResourceBundle;

public class SaveOutput
extends PrintStream {
    private static String applicationName_;
    private static String companyName_;
    private static String dirName_;
    private static JUProxy juprox_;
    private static String logFileName_;
    static PrintStream logfile;
    static PrintStream oldStderr;
    static PrintStream oldStdout;
    private static String releaseName_;
    static ResourceBundle res;
    static Runtime runTime;

    static {
        res = ResourceBundle.getBundle("at.tugraz.genome.utils.AboutDialogRes_en_US");
        runTime = Runtime.getRuntime();
        logFileName_ = "";
        companyName_ = "";
        applicationName_ = "";
        releaseName_ = "";
        dirName_ = "";
    }

    SaveOutput(PrintStream ps) {
        super(ps);
    }

    public static String getApplicationDataDirectory() {
        juprox_ = new JUProxy();
        return JUProxy.getProgramApplicationDataDirectory(companyName_, applicationName_, releaseName_);
    }

    public static String getApplicationName() {
        return applicationName_;
    }

    public static String getCurrentLogFileDirectory() {
        return dirName_;
    }

    public static String getCurrentLogFileName() {
        return logFileName_;
    }

    public static String getRelease() {
        return releaseName_;
    }

    public static String getReleaseString() {
        return "Release " + releaseName_;
    }

    public static boolean isJava3DInstalled() {
        try {
            Class.forName("javax.media.j3d.Screen3D", false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
        return true;
    }

    public static void setCurrentLogFileName(String logFileName) {
        logFileName_ = logFileName;
    }

    public static void start(String companyName, String applicationName, String release) throws IOException {
        String file_sep = File.separator;
        companyName_ = companyName;
        applicationName_ = applicationName;
        releaseName_ = release;
        dirName_ = SaveOutput.getApplicationDataDirectory() + file_sep + "log" + file_sep;
        String logName = dirName_ + System.currentTimeMillis() + ".log";
        File f = new File(dirName_);
        if (!f.exists()) {
            f.mkdirs();
        }
        SaveOutput.setCurrentLogFileName(logName);
        oldStdout = System.out;
        oldStderr = System.err;
        logfile = new PrintStream(new BufferedOutputStream(new FileOutputStream(logName)));
        System.setErr(new SaveOutput(System.err));
    }

    public static void start(String f, String applicationName) throws IOException {
        SaveOutput.setCurrentLogFileName(f);
        applicationName_ = applicationName;
        oldStdout = System.out;
        oldStderr = System.err;
        logfile = new PrintStream(new BufferedOutputStream(new FileOutputStream(f)));
        System.setErr(new SaveOutput(System.err));
    }

    public static void stop() {
        System.setOut(oldStdout);
        System.setErr(oldStderr);
        try {
            logfile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void write(byte[] buf, int off, int len) {
        try {
            logfile.write(buf, off, len);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setError();
        }
        super.write(buf, off, len);
    }

    public void write(int b) {
        try {
            logfile.write(b);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setError();
        }
        super.write(b);
    }

    public static void writeCustomString(String user_message) {
        String header = "------ USERMESSAGE::  ";
        try {
            logfile.println(header + user_message);
            logfile.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeFooter() {
        String header = "--- END: " + applicationName_ + " --- ";
        String time = DateTime.getDateTimeAsString() + " ---";
        try {
            logfile.println(header + time);
            logfile.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeHeader() {
        String header = "--- START: " + applicationName_ + " --- ";
        String time = DateTime.getDateTimeAsString() + " ---";
        long freeMemory = 0L;
        long totalMemory = 0L;
        long maxMem = 0L;
        String javaversion = null;
        String javavendor = null;
        String javavendorurl = null;
        String javahome = null;
        String javavmspecificationversion = null;
        String javavmspecificationvendor = null;
        String javavmspecificationname = null;
        String javavmversion = null;
        String javavmvendor = null;
        String javavmname = null;
        String javaspecificationversion = null;
        String javaspecificationvendor = null;
        String javaspecificationname = null;
        String javaclassversion = null;
        String javaclasspath = null;
        String osname = null;
        String osarch = null;
        String osversion = null;
        String fileseparator = null;
        String pathseparator = null;
        Object lineseparator = null;
        String username = null;
        String userhome = null;
        String userdir = null;
        String defaultText = res.getString("System_information");
        String nrOfCPUs = null;
        try {
            logfile.println(header + time);
            logfile.println("System information");
            freeMemory = runTime.freeMemory() / 1024L;
            logfile.println(res.getString("_Amount_of_free_memory") + freeMemory + "kByte");
            try {
                String jspc = System.getProperty("java.specification.version");
                System.out.println("java.spec.version = " + jspc);
                Float javaspec = Float.valueOf(jspc);
                if (!((double)javaspec.floatValue() > 1.3)) {
                    logfile.println("[SaveOutput::writeHeader] -> Could not find javaversion >1.3");
                } else {
                    logfile.println("[SaveOutput::writeHeader] -> javaversion is > 1.3");
                }
                totalMemory = runTime.totalMemory() / 1024L;
                logfile.println(res.getString("_Amount_of_memory_in") + totalMemory + "kByte");
                maxMem = runTime.maxMemory() / 1024L;
                logfile.println(res.getString("java.maxmem.available") + maxMem + "kByte");
            }
            catch (Exception ex1) {
                logfile.println("exception while runtime.totalmemory or runtime.maxmemory!->");
                ex1.printStackTrace();
            }
            javaversion = System.getProperty(res.getString("java_version"));
            logfile.println(res.getString("_Java_Runtime") + javaversion);
            javavendor = System.getProperty(res.getString("java_vendor"));
            logfile.println(res.getString("_Java_Runtime1") + javavendor);
            javavendorurl = System.getProperty(res.getString("java_vendor_url"));
            logfile.println(res.getString("_Java_vendor_URL_n_t") + javavendorurl);
            javahome = System.getProperty(res.getString("java_home"));
            logfile.println(res.getString("_Java_installation") + javahome);
            javavmspecificationversion = System.getProperty(res.getString("java_vm_specification"));
            logfile.println(res.getString("_Java_Virtual_Machine") + javavmspecificationversion);
            javavmspecificationvendor = System.getProperty(res.getString("java_vm_specification1"));
            logfile.println(res.getString("_Java_Virtual_Machine1") + javavmspecificationvendor);
            javavmspecificationname = System.getProperty(res.getString("java_vm_specification2"));
            logfile.println(res.getString("_Java_Virtual_Machine2") + javavmspecificationname);
            javavmversion = System.getProperty(res.getString("java_vm_version"));
            logfile.println(res.getString("_Java_Virtual_Machine3") + javavmversion);
            javavmvendor = System.getProperty(res.getString("java_vm_vendor"));
            logfile.println(res.getString("_Java_Virtual_Machine4") + javavmvendor);
            javavmname = System.getProperty(res.getString("java_vm_name"));
            logfile.println(res.getString("_Java_Virtual_Machine5") + javavmname);
            javaspecificationversion = System.getProperty(res.getString("java_specification"));
            logfile.println(res.getString("_Java_Runtime2") + javaspecificationversion);
            javaspecificationvendor = System.getProperty(res.getString("java_specification1"));
            logfile.println(res.getString("_Java_Runtime3") + javaspecificationvendor);
            javaspecificationname = System.getProperty(res.getString("java_specification2"));
            logfile.println(res.getString("_Java_Runtime4") + javaspecificationname);
            javaclassversion = System.getProperty(res.getString("java_class_version"));
            PackageInfo pi = new PackageInfo();
            String[] java3Dinfo = pi.getJava3DInfo();
            logfile.println(res.getString("java3DTitle") + java3Dinfo[0]);
            logfile.println(res.getString("java3DVendor") + java3Dinfo[1]);
            logfile.println(res.getString("java3DVersion") + java3Dinfo[2]);
            String[] javaJDOMinfo = pi.getJavaJDOMInfo();
            logfile.println(res.getString("javaJDOMTitle") + javaJDOMinfo[0]);
            logfile.println(res.getString("javaJDOMVendor") + javaJDOMinfo[1]);
            logfile.println(res.getString("javaJDOMVersion") + javaJDOMinfo[2]);
            String[] javaJAIinfo = pi.getJavaJAIInfo();
            logfile.println(res.getString("javaJAITitle") + javaJAIinfo[0]);
            logfile.println(res.getString("javaJAIVendor") + javaJAIinfo[1]);
            logfile.println(res.getString("javaJAIVersion") + javaJAIinfo[2]);
            logfile.println(res.getString("_Java_class_format") + javaclassversion);
            javaclasspath = System.getProperty(res.getString("java_class_path"));
            logfile.println(res.getString("_Java_class_path_n_t") + javaclasspath);
            logfile.println("Java3D installed: " + SaveOutput.isJava3DInstalled());
            osname = System.getProperty(res.getString("os_name"));
            logfile.println(res.getString("_Operating_system_name") + osname);
            osarch = System.getProperty(res.getString("os_arch"));
            logfile.println(res.getString("_Operating_system") + osarch);
            osversion = System.getProperty(res.getString("os_version"));
            logfile.println(res.getString("_Operating_system1") + osversion);
            fileseparator = System.getProperty(res.getString("file_separator"));
            logfile.println(res.getString("_File_separator_on") + fileseparator);
            pathseparator = System.getProperty(res.getString("path_separator"));
            logfile.println(res.getString("_Path_separator_on") + pathseparator);
            username = System.getProperty(res.getString("user_name"));
            logfile.println(res.getString("_User_s_account_name_n") + username);
            userhome = System.getProperty(res.getString("user_home"));
            logfile.println(res.getString("_User_s_home_directory") + userhome);
            userdir = System.getProperty(res.getString("user_dir"));
            logfile.println(res.getString("_User_s_current") + userdir);
            nrOfCPUs = String.valueOf(Runtime.getRuntime().availableProcessors());
            logfile.println(res.getString("Number_of_Processors") + nrOfCPUs);
            try {
                logfile.println(res.getString("IP_address") + InetAddress.getLocalHost().getHostAddress());
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                logfile.println(res.getString("Computer_name") + InetAddress.getLocalHost().getHostName());
            }
            catch (Exception ex) {
                // empty catch block
            }
            logfile.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

