/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.utils.javazip;

import at.tugraz.genome.utils.javazip.JavaZipStandartFilter;
import at.tugraz.genome.utils.javazip.JavaZipSuffixFilter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class JavaZip {
    static final int BUFFER = 2048;
    FilenameFilter acceptedFiles;
    int compressionLevel;
    int methode;
    String zipFile;

    public JavaZip(String zipFile) throws IllegalArgumentException {
        this.zipFile = zipFile;
        if (zipFile.length() == 0) {
            throw new IllegalArgumentException("No Filename provided");
        }
        this.acceptedFiles = new JavaZipStandartFilter();
        this.methode = 8;
        this.compressionLevel = 9;
    }

    public JavaZip(File zipFile) {
        this(zipFile.getAbsolutePath());
    }

    public File getFile() {
        return new File(this.zipFile);
    }

    public FilenameFilter getFilenameFilter() {
        return this.acceptedFiles;
    }

    public long getSize() {
        File zipFile = new File(this.zipFile);
        if (zipFile.exists()) {
            return zipFile.length();
        }
        return -1L;
    }

    public static void main(String[] argv) {
        try {
            boolean zip;
            String suffix = "";
            String folder = "";
            String file = "";
            if (argv.length != 2) {
                System.out.println("java JavaZip quelle ziel");
                return;
            }
            if (argv[0].endsWith(".zip")) {
                file = argv[0];
                folder = argv[1];
                zip = false;
            } else {
                file = argv[1];
                if (argv[0].indexOf("*") > -1) {
                    folder = argv[0].substring(0, argv[0].indexOf("*") - 1);
                    suffix = argv[0].substring(argv[0].lastIndexOf("*"));
                } else {
                    File tmpFile = new File(argv[0]);
                    if (tmpFile.isFile()) {
                        folder = tmpFile.getParent();
                        suffix = tmpFile.getCanonicalFile().getName();
                    } else {
                        folder = tmpFile.getName();
                    }
                }
                zip = true;
            }
            JavaZip test = new JavaZip(file);
            if (suffix.length() > 0) {
                test.setFilenameFilter(new JavaZipSuffixFilter(suffix));
            }
            if (zip) {
                test.zip(new File(folder), true);
            } else {
                test.unzip(new File(folder));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public void setFilenameFilter(FilenameFilter acceptedFiles) {
        this.acceptedFiles = acceptedFiles;
    }

    public void setMethode(int methode) {
        this.methode = methode;
    }

    /*
     * WARNING - void declaration
     */
    public int unzip(File toDirectory) throws IllegalArgumentException, FileNotFoundException, IOException {
        if (!toDirectory.exists() && !toDirectory.mkdirs()) {
            throw new IllegalArgumentException("provided directory " + toDirectory.getName() + " doesn't exist and can't be created!");
        }
        if (!toDirectory.isDirectory() || !toDirectory.canWrite()) {
            throw new IllegalArgumentException("provided argument toDirectory is no directory or not writeable!");
        }
        System.out.println("extracting fils to: " + toDirectory);
        int fileCount = 0;
        BufferedOutputStream dest = null;
        BufferedInputStream is = null;
        ZipFile zipfile = new ZipFile(this.zipFile);
        Enumeration<? extends ZipEntry> e = zipfile.entries();
        while (e.hasMoreElements()) {
            int count;
            ZipEntry entry = e.nextElement();
            ++fileCount;
            is = new BufferedInputStream(zipfile.getInputStream(entry));
            byte[] data = new byte[2048];
            File destFile = new File(toDirectory, entry.getName());
            if (!destFile.getParentFile().exists()) {
                destFile.getParentFile().mkdirs();
            }
            dest = new BufferedOutputStream(new FileOutputStream(destFile.getCanonicalFile()), 2048);
            while ((count = is.read(data, 0, 2048)) != -1) {
                void var9_9;
                dest.write(data, 0, (int)var9_9);
            }
            dest.flush();
            dest.close();
            is.close();
        }
        return fileCount;
    }

    public int zip(File fromDirectory, boolean subDirs) throws IllegalArgumentException, FileNotFoundException, IOException {
        if (!fromDirectory.isDirectory() || !fromDirectory.canRead()) {
            throw new IllegalArgumentException("provided argument fromDirectory is no directory or not readable!");
        }
        int fileCount = this.zip(fromDirectory, subDirs, null, true, "");
        return fileCount;
    }

    /*
     * WARNING - void declaration
     */
    private int zip(File fromDirectory, boolean subDirs, ZipOutputStream outZipped, boolean closeOutZipped, String path) throws FileNotFoundException, IOException {
        if (outZipped == null) {
            outZipped = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.zipFile)));
            outZipped.setMethod(this.methode);
            outZipped.setLevel(this.compressionLevel);
            SimpleDateFormat nowFormat = new SimpleDateFormat("dd. MMM yyyy hh:mm");
            outZipped.setComment("Zip created on " + nowFormat.format(new Date()) + " by JavaZip. JavaZip was developed in Feb. 2002 by Christof Rath");
        }
        BufferedInputStream origin = null;
        int fileCount = 0;
        byte[] data = new byte[2048];
        File[] files = fromDirectory.listFiles(this.acceptedFiles);
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory() && subDirs) {
                String subPath = "";
                if (path.length() > 0) {
                    File cfr_ignored_0 = files[i];
                    subPath = path + File.separatorChar + files[i].getName();
                } else {
                    subPath = files[i].getName();
                }
                int fileSubCount = this.zip(new File(fromDirectory, files[i].getName()), true, outZipped, false, subPath);
                fileCount += fileSubCount;
            }
            if (files[i].isFile()) {
                int count;
                ++fileCount;
                origin = new BufferedInputStream(new FileInputStream(files[i]), 2048);
                String fileName = "";
                if (path.length() > 0) {
                    File cfr_ignored_1 = files[i];
                    fileName = path + File.separatorChar + files[i].getName();
                } else {
                    fileName = files[i].getName();
                }
                ZipEntry entry = new ZipEntry(fileName);
                entry.setTime(files[i].lastModified());
                outZipped.putNextEntry(entry);
                while ((count = origin.read(data, 0, 2048)) != -1) {
                    void var13_14;
                    outZipped.write(data, 0, (int)var13_14);
                }
                origin.close();
            }
            ++i;
        }
        if (closeOutZipped && outZipped != null) {
            outZipped.close();
        }
        return fileCount;
    }
}

