/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.utils.straightlinedata;

import at.tugraz.genome.utils.straightlinedata.Constants;
import at.tugraz.genome.utils.straightlinedata.DoubleRef;
import at.tugraz.genome.utils.straightlinedata.MnbrakPararmeterFunction;

class Brent {
    Brent() {
    }

    public static double brent(double ax, double bx, double cx, MnbrakPararmeterFunction func, double tol, DoubleRef xmin) throws IllegalArgumentException {
        double fx;
        double v;
        double e = 0.0;
        double d = 0.0;
        double a = ax < cx ? ax : cx;
        double b = ax > cx ? ax : cx;
        double w = v = bx;
        double x = v;
        double fv = fx = func.execute(x);
        double fw = fx;
        int iter = 0;
        while (iter < 100) {
            double u;
            double xm = 0.5 * (a + b);
            double tol1 = tol * Math.abs(x) + 1.0E-10;
            double tol2 = 2.0 * tol1;
            if (Math.abs(x - xm) <= tol2 - 0.5 * (b - a)) {
                xmin.value = x;
                return fx;
            }
            if (Math.abs(e) > tol1) {
                double r = (x - w) * (fx - fv);
                double q = (x - v) * (fx - fw);
                double p = (x - v) * q - (x - w) * r;
                if ((q = 2.0 * (q - r)) > 0.0) {
                    p = -p;
                }
                q = Math.abs(q);
                double etemp = e;
                e = d;
                if (Math.abs(p) >= Math.abs(0.5 * q * etemp) || p <= q * (a - x) || p >= q * (b - x)) {
                    e = x >= xm ? a - x : b - x;
                    d = 0.381966 * e;
                } else {
                    d = p / q;
                    u = x + d;
                    if (u - a < tol2 || b - u < tol2) {
                        d = Constants.sign(tol1, xm - x);
                    }
                }
            } else {
                e = x >= xm ? a - x : b - x;
                d = 0.381966 * e;
            }
            u = Math.abs(d) >= tol1 ? x + d : x + Constants.sign(tol1, d);
            double fu = func.execute(u);
            if (fu <= fx) {
                if (u >= x) {
                    a = x;
                } else {
                    b = x;
                }
                DoubleRef uRef = new DoubleRef(u);
                DoubleRef vRef = new DoubleRef(v);
                DoubleRef wRef = new DoubleRef(w);
                DoubleRef xRef = new DoubleRef(x);
                Constants.shft(vRef, wRef, xRef, uRef);
                u = uRef.value;
                v = vRef.value;
                w = wRef.value;
                x = xRef.value;
                DoubleRef fuRef = new DoubleRef(fu);
                DoubleRef fvRef = new DoubleRef(fv);
                DoubleRef fwRef = new DoubleRef(fw);
                DoubleRef fxRef = new DoubleRef(fx);
                Constants.shft(fvRef, fwRef, fxRef, fuRef);
                fu = fuRef.value;
                fv = fvRef.value;
                fw = fwRef.value;
                fx = fxRef.value;
            } else {
                if (u < x) {
                    a = u;
                } else {
                    b = u;
                }
                if (fu <= fw || w == x) {
                    v = w;
                    w = u;
                    fv = fw;
                    fw = fu;
                } else if (fu <= fv || v == x || v == w) {
                    v = u;
                    fv = fu;
                }
            }
            ++iter;
        }
        throw new IllegalArgumentException("Too many iterations in brent");
    }
}

