/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.utils.straightlinedata;

import at.tugraz.genome.utils.straightlinedata.Avevar;
import at.tugraz.genome.utils.straightlinedata.Brent;
import at.tugraz.genome.utils.straightlinedata.DoubleRef;
import at.tugraz.genome.utils.straightlinedata.Fit;
import at.tugraz.genome.utils.straightlinedata.FiteXY;
import at.tugraz.genome.utils.straightlinedata.Gammln;
import at.tugraz.genome.utils.straightlinedata.Gammq;
import at.tugraz.genome.utils.straightlinedata.Gcf;
import at.tugraz.genome.utils.straightlinedata.Gser;
import at.tugraz.genome.utils.straightlinedata.Mnbrak;
import at.tugraz.genome.utils.straightlinedata.MnbrakPararmeterFunction;
import at.tugraz.genome.utils.straightlinedata.Zbrent;

public class MathNR {
    public static void avevar(double[] data, int n, DoubleRef ave, DoubleRef variance) {
        Avevar.avevar(data, n, ave, variance);
    }

    public static double brent(double ax, double bx, double cx, MnbrakPararmeterFunction func, double tol, DoubleRef xmin) throws IllegalArgumentException {
        return Brent.brent(ax, bx, cx, func, tol, xmin);
    }

    public static void fit(DoubleRef[] x, DoubleRef[] y, int ndata, DoubleRef[] sig, int mwt, DoubleRef a, DoubleRef b, DoubleRef siga, DoubleRef sigb, DoubleRef chi2, DoubleRef q) {
        Fit.fit(x, y, ndata, sig, mwt, a, b, siga, sigb, chi2, q);
    }

    public static void fitexy(double[] x, double[] y, int ndat, double[] sigx, double[] sigy, DoubleRef a, DoubleRef b, DoubleRef siga, DoubleRef sigb, DoubleRef chi2, DoubleRef q) {
        FiteXY.fitexy(x, y, ndat, sigx, sigy, a, b, siga, sigb, chi2, q);
    }

    public static double gammln(double xx) {
        return Gammln.gammln(xx);
    }

    public static double gammq(double a, double x) throws IllegalArgumentException {
        return Gammq.gammq(a, x);
    }

    public static void gcf(DoubleRef gammcf, double a, double x, DoubleRef gln) throws IllegalArgumentException {
        Gcf.gcf(gammcf, a, x, gln);
    }

    public static void gser(DoubleRef gamser, double a, double x, DoubleRef gln) throws IllegalArgumentException {
        Gser.gser(gamser, a, x, gln);
    }

    public static void mnbrak(DoubleRef ax, DoubleRef bx, DoubleRef cx, DoubleRef fa, DoubleRef fb, DoubleRef fc, MnbrakPararmeterFunction func) {
        Mnbrak.mnbrak(ax, bx, cx, fa, fb, fc, func);
    }

    public static double zbrent(MnbrakPararmeterFunction func, double x1, double x2, double tol) throws IllegalArgumentException {
        return Zbrent.zbrent(func, x1, x2, tol);
    }
}

