/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.control.ButtonDialog;
import com.borland.jbcl.model.BasicViewManager;
import com.borland.jbcl.view.FieldView;
import com.borland.jbcl.view.WrappedTextItemPainter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;

public class MessageDialog
extends ButtonDialog {
    protected Panel messagePanel = new Panel(new BorderLayout());
    protected String message;

    public MessageDialog(Frame frame, String title, String msg, int buttonSet) {
        super(frame, title, null, buttonSet);
        super.setCenterPanel(this.messagePanel);
        this.message = msg;
        this.messagePanel.add(this.buildMessageComponent(this.message), "Center");
        this.getContentPane().add((Component)this.messagePanel, "Center");
    }

    public MessageDialog(Frame frame, String title, String msg) {
        this(frame, title, msg, 1);
    }

    public MessageDialog(Frame frame, String title) {
        this(frame, title, "", 1);
    }

    public MessageDialog(Frame frame) {
        this(frame, "", "", 1);
    }

    private Component buildMessageComponent(String message) {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int width = fm.stringWidth(message) + 20;
        if (width < 320) {
            Label messageLabel = new Label(message, 1);
            return messageLabel;
        }
        FieldView messageField = new FieldView();
        messageField.setFlat(true);
        messageField.setItemMargins(new Insets(10, 10, 10, 10));
        messageField.setBackground(SystemColor.control);
        messageField.setViewManager(new BasicViewManager(new WrappedTextItemPainter()));
        messageField.getWriteModel().set(message);
        return messageField;
    }

    public void setMessage(String s) {
        this.message = s;
        this.messagePanel.removeAll();
        this.messagePanel.add(this.buildMessageComponent(s));
    }

    public String getMessage() {
        return this.message;
    }

    public Dimension getPreferredSize() {
        return new Dimension(320, 160);
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.messagePanel.removeAll();
        this.messagePanel.add(this.buildMessageComponent(this.message));
    }
}

