/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.field;

import com.klg.jclass.field.DataProperties;
import com.klg.jclass.field.DataPropertiesRegistry;
import com.klg.jclass.field.JCComboField;
import com.klg.jclass.field.JCInvalidInfo;
import com.klg.jclass.field.JCLabelField;
import com.klg.jclass.field.JCPopupField;
import com.klg.jclass.field.JCSpinField;
import com.klg.jclass.field.validate.FieldParseException;
import com.klg.jclass.field.validate.JCIPAddressValidator;
import com.klg.jclass.field.validate.JCStringValidator;
import com.klg.jclass.field.validate.JCValidator;
import com.klg.jclass.field.validate.TextCursorEvent;
import com.klg.jclass.field.validate.TextEvent;
import com.klg.jclass.util.JCDebug;
import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.swing.AbstractSpinBox;
import com.klg.jclass.util.swing.JCListModel;
import com.klg.jclass.util.value.JCValueEvent;
import com.klg.jclass.util.value.JCValueListener;
import com.klg.jclass.util.value.JCValueModel;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.UndoableEdit;

public class Field
implements Serializable,
JCValueListener,
ComboBoxModel {
    public static final int VALID = 1;
    public static final int UNDEREDIT = 2;
    public static final int INVALID = 3;
    public static final int SHOW_INVALID = 1;
    public static final int RESTORE_DEFAULT = 2;
    public static final int RESTORE_PREVIOUS = 3;
    public static final int CLEAR_FIELD = 4;
    public static final int AS_IS = 0;
    public static final int UPPERCASE = 1;
    public static final int LOWERCASE = 2;
    protected boolean internalBackgroundChange = false;
    protected boolean internalForegroundChange = false;
    protected Color invalidBackground;
    protected Color invalidForeground;
    protected Color validBackground;
    protected Color validForeground;
    protected boolean select_on_enter;
    protected Object edit_initial_value;
    protected Class edit_class;
    transient Object defaultValue;
    transient Object previousValue = null;
    transient JCValidator validator;
    protected Locale current;
    transient Object event_source;
    transient Component vc;
    protected int state;
    protected int invalidPolicy = 1;
    protected boolean beepOnInvalid = true;
    protected boolean internal_text_change = false;
    protected boolean has_focus = false;
    protected boolean auto_complete_mode = false;
    protected boolean doing_completion = false;
    protected boolean doing_commit = false;
    protected boolean in_set_selected_item = false;
    protected boolean changing_picklist = false;
    transient JCListenerList propertyListeners = null;
    transient JCListenerList valueListeners = null;
    transient Listeners listener = new Listeners();
    transient EventListenerList listenerList = new EventListenerList();
    protected boolean okayToBeep = false;
    protected boolean allow_text_change = false;
    protected boolean is_cell_editor = false;
    protected boolean select_all = false;
    transient JCValueModel valueModel = null;
    transient TextFieldDocument document = null;
    protected boolean restoringPrevious = false;
    static /* synthetic */ Class class$javax$swing$event$ListDataListener;

    public Field(Component component, JCValidator jCValidator) {
        this.vc = component;
        this.validator = jCValidator;
        if (jCValidator != null) {
            this.defaultValue = jCValidator.getDefaultValue();
        }
        this.event_source = component;
        this.initialize();
    }

    public void addListDataListener(ListDataListener listDataListener) {
        this.listenerList.add(class$javax$swing$event$ListDataListener != null ? class$javax$swing$event$ListDataListener : (class$javax$swing$event$ListDataListener = Field.class$("javax.swing.event.ListDataListener")), listDataListener);
    }

    public void addNotify() {
        JCDebug.println("field", "Field.addNotify()");
        Object object = null;
        if (this.valueModel != null) {
            object = this.valueModel.getValue();
        }
        this.okayToBeep = true;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyListeners = JCListenerList.add(this.propertyListeners, propertyChangeListener);
    }

    public void addValueListener(JCValueListener jCValueListener) {
        this.valueListeners = JCListenerList.add(this.valueListeners, jCValueListener);
    }

    protected void calcAutoCompleteMode(JCComboField jCComboField) {
        this.auto_complete_mode = false;
        if (!this.doing_commit && jCComboField != null && this.validator.getPickList() != null && this.validator instanceof JCStringValidator) {
            this.auto_complete_mode = jCComboField.isAutoComplete();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void commitEdit() {
        this.commitEdit(null);
    }

    public void commitEdit(AWTEvent aWTEvent) {
        JComboBox jComboBox;
        this.doCommitEdit(aWTEvent);
        JComboBox jComboBox2 = jComboBox = this.vc instanceof JComboBox ? (JComboBox)this.vc : null;
        if (jComboBox != null) {
            if (jComboBox.isPopupVisible()) {
                jComboBox.hidePopup();
                jComboBox.showPopup();
            }
            jComboBox.setPopupVisible(false);
        }
    }

    protected void doCommitEdit(AWTEvent aWTEvent) {
        JTextField jTextField = this.getTextField();
        JCDebug.println("field", "Field.commitEdit()");
        if (this.validator == null || this.valueModel == null) {
            return;
        }
        if (this.state != 2) {
            if (jTextField != null && this.select_on_enter) {
                jTextField.setSelectionStart(0);
                jTextField.setSelectionEnd(jTextField.getText().length());
            }
            return;
        }
        this.turnOffAutoCompleteMode();
        this.doing_commit = true;
        String string = null;
        if (jTextField != null) {
            string = jTextField.getText();
        }
        Object object = null;
        boolean bl = false;
        if (jTextField == null || string == null || string.length() == 0) {
            object = null;
        } else {
            try {
                object = this.validator.parse(this.valueModel.getValueClass(), jTextField.getText());
            }
            catch (FieldParseException fieldParseException) {
                bl = true;
            }
        }
        if (bl) {
            this.previousValue = this.valueModel.getValue();
            this.processFailure();
            this.doing_commit = false;
            return;
        }
        this.setValue(object);
        if (this.invalidPolicy != 1) {
            this.valueChanged(null);
        }
        this.doing_commit = false;
    }

    protected void fireContentsChanged(Object object, int n, int n2) {
        Object[] objectArray = this.listenerList.getListenerList();
        ListDataEvent listDataEvent = null;
        int n3 = objectArray.length - 2;
        while (n3 >= 0) {
            if (objectArray[n3] == (class$javax$swing$event$ListDataListener != null ? class$javax$swing$event$ListDataListener : Field.class$("javax.swing.event.ListDataListener"))) {
                if (listDataEvent == null) {
                    listDataEvent = new ListDataEvent(object, 0, n, n2);
                }
                ((ListDataListener)objectArray[n3 + 1]).contentsChanged(listDataEvent);
            }
            n3 -= 2;
        }
    }

    protected void fireValueChangedEvent(JCValueEvent jCValueEvent) {
        if (jCValueEvent == null || this.doing_completion || this.changing_picklist) {
            return;
        }
        Enumeration enumeration = JCListenerList.elements(this.valueListeners);
        while (enumeration.hasMoreElements()) {
            JCValueListener jCValueListener = (JCValueListener)enumeration.nextElement();
            jCValueListener.valueChanged(jCValueEvent);
        }
    }

    protected void fireValueChangingEvent(JCValueEvent jCValueEvent) {
        if (jCValueEvent == null || this.doing_completion || this.changing_picklist) {
            return;
        }
        Enumeration enumeration = JCListenerList.elements(this.valueListeners);
        while (enumeration.hasMoreElements()) {
            JCValueListener jCValueListener = (JCValueListener)enumeration.nextElement();
            jCValueListener.valueChanging(jCValueEvent);
        }
    }

    public boolean getAllowTextChange() {
        return this.allow_text_change;
    }

    protected boolean getBeepOnInvalid() {
        return this.beepOnInvalid;
    }

    public Component getComponent() {
        return this.vc;
    }

    public DataProperties getDataProperties() {
        if (this.validator != null) {
            this.defaultValue = this.validator.getDefaultValue();
        }
        DataProperties dataProperties = new DataProperties(this.validator, this.valueModel, this.getInvalidInfo());
        return dataProperties;
    }

    public Object getElementAt(int n) {
        if (this.validator == null || this.validator.getPickList() == null) {
            return null;
        }
        return this.validator.format(this.validator.getPickList().getElementAt(n));
    }

    public Object getEventSource() {
        return this.event_source;
    }

    protected Color getInvalidBackground() {
        JTextField jTextField = this.getTextField();
        if (this.invalidBackground == null) {
            if (jTextField != null) {
                return jTextField.getBackground();
            }
            return this.vc.getBackground();
        }
        return this.invalidBackground;
    }

    protected Color getInvalidForeground() {
        JTextField jTextField = this.getTextField();
        if (this.invalidForeground == null) {
            if (jTextField != null) {
                return jTextField.getForeground();
            }
            return this.vc.getForeground();
        }
        return this.invalidForeground;
    }

    public JCInvalidInfo getInvalidInfo() {
        Color color = this.invalidBackground;
        Color color2 = this.invalidForeground;
        if (this.invalidForeground == null) {
            color2 = this.validForeground;
        }
        if (this.invalidBackground == null) {
            color = this.validBackground;
        }
        return new JCInvalidInfo(this.beepOnInvalid, this.invalidPolicy, color2, color);
    }

    protected int getInvalidPolicy() {
        return this.invalidPolicy;
    }

    public boolean getSelectOnEnter() {
        return this.select_on_enter;
    }

    public Object getSelectedItem() {
        if (this.validator == null) {
            return "";
        }
        Object object = this.getValue();
        object = this.state == 2 && !this.auto_complete_mode ? this.validator.formatForEdit(object) : this.validator.format(object);
        return object;
    }

    public int getSize() {
        if (this.validator == null || this.validator.getPickList() == null) {
            return 0;
        }
        return this.validator.getPickList().getSize();
    }

    public int getState() {
        return this.state;
    }

    protected JTextField getTextField() {
        AbstractSpinBox abstractSpinBox;
        JTextField jTextField = null;
        if (this.vc instanceof JTextField) {
            jTextField = (JTextField)this.vc;
            if (!jTextField.isEditable()) {
                jTextField = null;
            }
        } else if (this.vc instanceof JComboBox) {
            JComboBox jComboBox = (JComboBox)this.vc;
            if (jComboBox.isEditable()) {
                jTextField = (JTextField)jComboBox.getEditor().getEditorComponent();
            }
        } else if (this.vc instanceof AbstractSpinBox && (abstractSpinBox = (AbstractSpinBox)this.vc).isEditable()) {
            jTextField = (JTextField)abstractSpinBox.getEditor().getEditorComponent();
        }
        return jTextField;
    }

    protected Color getValidBackground() {
        return this.validBackground;
    }

    protected Color getValidForeground() {
        return this.validForeground;
    }

    public JCValidator getValidator() {
        return this.validator;
    }

    public Object getValue() {
        if (this.validator == null || this.valueModel == null) {
            return null;
        }
        return this.validator.copyValue(this.valueModel.getValue());
    }

    public JCValueModel getValueModel() {
        return this.valueModel;
    }

    public Component getVisualComponent() {
        return this.vc;
    }

    private void initialize() {
        JCDebug.println("field", "Field.initialize");
        JTextField jTextField = this.getTextField();
        boolean bl = false;
        if (jTextField == null) {
            bl = this.vc instanceof JCLabelField;
        }
        if (jTextField != null) {
            this.document = new TextFieldDocument(new TextFieldContent());
            ((JTextComponent)jTextField).setDocument(this.document);
        }
        if (jTextField == null && !bl) {
            throw new ClassCastException("Visual Component not supported by Field");
        }
        this.invalidBackground = null;
        this.invalidForeground = null;
        this.select_on_enter = false;
        if (jTextField != null) {
            jTextField.addFocusListener(this.listener);
            jTextField.addKeyListener(this.listener);
            this.validBackground = (Color)UIManager.get("TextField.background");
            this.validForeground = (Color)UIManager.get("TextField.foreground");
        } else {
            if (!bl) {
                this.vc.addFocusListener(this.listener);
                this.vc.addKeyListener(this.listener);
            }
            this.validBackground = this.vc.getBackground();
            this.validForeground = this.vc.getForeground();
        }
        if (this.vc instanceof JComboBox && !(this.vc instanceof JCPopupField)) {
            ((JComboBox)this.vc).setModel(this);
        }
    }

    protected void processFailure() {
        JCDebug.println("field", "Field.processFailure");
        switch (this.invalidPolicy) {
            case 1: {
                this.setStateInvalid();
                break;
            }
            case 2: {
                this.setValue(this.defaultValue);
                break;
            }
            case 3: {
                this.setValue(this.previousValue);
                break;
            }
            case 4: {
                this.setValue(null);
                break;
            }
        }
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        this.listenerList.remove(class$javax$swing$event$ListDataListener != null ? class$javax$swing$event$ListDataListener : (class$javax$swing$event$ListDataListener = Field.class$("javax.swing.event.ListDataListener")), listDataListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyListeners = JCListenerList.remove(this.propertyListeners, propertyChangeListener);
    }

    public void removeValueListener(JCValueListener jCValueListener) {
        this.valueListeners = JCListenerList.remove(this.valueListeners, jCValueListener);
    }

    protected void restorePickList() {
        JCComboField jCComboField;
        JCComboField jCComboField2 = jCComboField = this.vc instanceof JCComboField ? (JCComboField)this.vc : null;
        if (jCComboField != null && jCComboField.isAutoComplete() && jCComboField.isAutoRefinement() && this.validator != null) {
            this.changing_picklist = true;
            jCComboField.restoreOriginalPickList();
            this.changing_picklist = false;
        }
    }

    protected void setBeepOnInvalid(boolean bl) {
        this.beepOnInvalid = bl;
    }

    public void setClass(Class clazz) {
        JCDebug.println("field", "Field.setClass");
        if (this.valueModel != null && this.valueModel.getValueClass() == clazz) {
            return;
        }
        if (DataPropertiesRegistry.isRegistered(clazz)) {
            if (this.valueModel == null) {
                this.setValueModel(DataPropertiesRegistry.createValueModel(clazz));
            }
            if (this.validator == null) {
                this.setValidator(DataPropertiesRegistry.createValidator(clazz));
            }
        }
    }

    protected void setColors(Color color, Color color2) {
        Component component = null;
        JTextField jTextField = this.getTextField();
        component = jTextField != null ? jTextField : this.vc;
        if (color == null) {
            color = this.validBackground;
        }
        if (color2 == null) {
            color2 = this.validForeground;
        }
        this.internalBackgroundChange = true;
        component.setBackground(color);
        this.internalBackgroundChange = false;
        this.internalForegroundChange = true;
        component.setForeground(color2);
        this.internalForegroundChange = false;
    }

    public void setDataProperties(DataProperties dataProperties) {
        this.validator = dataProperties.getValidator();
        if (this.validator != null && this.vc instanceof JCPopupField) {
            ((JCPopupField)this.vc).setPopupEditor(this.validator.createPopupComponent());
        }
        if (this.validator != null) {
            this.defaultValue = this.validator.getDefaultValue();
        }
        if (this.valueModel != null) {
            this.valueModel.removeValueListener(this);
        }
        if (dataProperties.getValueModel() != null) {
            this.valueModel = dataProperties.getValueModel();
            this.valueModel.addValueListener(this);
        }
        if (this.vc instanceof JCPopupField) {
            this.valueModel.addValueListener((JCPopupField)this.vc);
        }
        this.setValueAndReformat(this.valueModel.getValue());
        this.setInvalidInfo(dataProperties.getInvalidInfo());
    }

    public void setEventSource(Object object) {
        this.event_source = object;
    }

    protected void setInvalidBackground(Color color) {
        this.invalidBackground = color;
        if (this.state == 3) {
            this.setColors(this.invalidBackground, this.invalidForeground);
        }
    }

    protected void setInvalidForeground(Color color) {
        this.invalidForeground = color;
        if (this.state == 3) {
            this.setColors(this.invalidBackground, this.invalidForeground);
        }
    }

    public void setInvalidInfo(JCInvalidInfo jCInvalidInfo) {
        this.setBeepOnInvalid(jCInvalidInfo.getBeepOnInvalid());
        this.setInvalidForeground(jCInvalidInfo.getInvalidForeground());
        this.setInvalidBackground(jCInvalidInfo.getInvalidBackground());
        this.setInvalidPolicy(jCInvalidInfo.getInvalidPolicy());
    }

    protected void setInvalidPolicy(int n) {
        if (this.invalidPolicy == n) {
            return;
        }
        if (this.validator == null || this.valueModel == null) {
            return;
        }
        if (n != 1 && n != 2 && n != 3 && n != 4) {
            throw new IllegalArgumentException("invalid value for invalidPolicy");
        }
        this.invalidPolicy = n;
        if (this.state != 3) {
            return;
        }
        if (this.state == 3) {
            this.processFailure();
        }
    }

    public void setSelectOnEnter(boolean bl) {
        this.select_on_enter = bl;
    }

    public void setSelectedItem(Object object) {
        if (object == null || this.validator == null) {
            return;
        }
        this.in_set_selected_item = true;
        boolean bl = this.validator instanceof JCStringValidator && !(this.validator instanceof JCIPAddressValidator);
        boolean bl2 = bl && ((JCStringValidator)this.validator).getMask() != null && ((JCStringValidator)this.validator).getMask().length() > 0;
        boolean bl3 = true;
        if (this.doing_completion && bl && bl2) {
            bl3 = false;
        }
        ListModel listModel = this.validator.getPickList();
        boolean bl4 = false;
        if (listModel != null) {
            int n = 0;
            while (n < listModel.getSize()) {
                Object e = listModel.getElementAt(n);
                boolean bl5 = bl4 = bl3 ? object.equals(this.validator.format(e)) : object.equals(e);
                if (bl4) {
                    object = listModel.getElementAt(n).toString();
                    break;
                }
                ++n;
            }
        }
        if (!(!bl3 || bl4 && bl && bl2)) {
            Object object2 = null;
            try {
                object2 = this.validator.parse(this.valueModel.getValueClass(), (String)object);
            }
            catch (FieldParseException fieldParseException) {}
            object = object2;
        }
        this.setValue(object, this.auto_complete_mode ^ true);
        if (!this.doing_completion) {
            this.restorePickList();
        }
        this.in_set_selected_item = false;
    }

    protected void setStateInvalid() {
        JCDebug.println("field", "Field.setStateInvalid()");
        if (this.validator == null || this.valueModel == null) {
            return;
        }
        if (this.state != 3) {
            if (this.okayToBeep && this.beepOnInvalid) {
                this.vc.getToolkit().beep();
            }
            this.setColors(this.invalidBackground, this.invalidForeground);
            int n = this.state;
            this.state = 3;
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.vc, "state", new Integer(n), new Integer(3));
            Enumeration enumeration = JCListenerList.elements(this.propertyListeners);
            while (enumeration.hasMoreElements()) {
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)enumeration.nextElement();
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
    }

    protected void setStateUnderEdit() {
        JCDebug.println("field", "Field.setStateUnderEdit()");
        if (this.state == 3) {
            this.setColors(null, null);
        }
        if (this.state != 2) {
            int n = this.state;
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.vc, "state", new Integer(n), new Integer(2));
            Enumeration enumeration = JCListenerList.elements(this.propertyListeners);
            while (enumeration.hasMoreElements()) {
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)enumeration.nextElement();
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
        this.state = 2;
    }

    protected void setStateValid() {
        JCDebug.println("field", "Field.setStateValid()");
        if (this.state != 1) {
            this.setColors(null, null);
            int n = this.state;
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.vc, "state", new Integer(n), new Integer(1));
            Enumeration enumeration = JCListenerList.elements(this.propertyListeners);
            while (enumeration.hasMoreElements()) {
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)enumeration.nextElement();
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
            this.state = 1;
        }
    }

    protected void setText(String string) {
        JCDebug.println("field", "Field.setText: text is \"" + string + "\"");
        JTextField jTextField = this.getTextField();
        if (jTextField == null) {
            if (this.vc instanceof JCLabelField) {
                this.allow_text_change = true;
                ((JCLabelField)this.vc).setText(string);
                this.allow_text_change = false;
            } else if (this.vc instanceof JCSpinField) {
                this.allow_text_change = true;
                ((JCSpinField)this.vc).getRenderer().getComponent((AbstractSpinBox)this.vc, this.getValue());
                this.allow_text_change = false;
            } else if (this.vc instanceof JCPopupField) {
                ((JCPopupField)this.vc).getRenderer().getListCellRendererComponent(new JList(), string, -1, true, false);
            }
            return;
        }
        this.allow_text_change = true;
        if (this.document.getOverstrike()) {
            this.document.setOverstrike(false);
            jTextField.setText(string);
            this.document.setOverstrike(true);
        } else {
            jTextField.setText(string);
        }
        this.allow_text_change = false;
    }

    public void setValidator(JCValidator jCValidator) {
        JCDebug.println("field", "Field.setValidator");
        if (jCValidator != null && jCValidator != this.validator && this.vc instanceof JCPopupField) {
            ((JCPopupField)this.vc).setPopupEditor(jCValidator.createPopupComponent());
        }
        if (this.valueModel == null) {
            this.validator = jCValidator;
            if (jCValidator != null) {
                this.defaultValue = jCValidator.getDefaultValue();
            }
            return;
        }
        Class clazz = this.valueModel.getValueClass();
        if (!jCValidator.isClassSupported(clazz)) {
            throw new IllegalArgumentException("Validator being set does not support the current data model");
        }
        this.validator = jCValidator;
        if (jCValidator != null) {
            this.defaultValue = jCValidator.getDefaultValue();
        }
        this.setValueAndReformat(this.valueModel.getValue());
        if (this.vc instanceof JCSpinField) {
            ((JCSpinField)this.vc).checkArrowButtons();
        }
    }

    public void setValue(Object object) {
        this.setValue(object, true);
    }

    protected void setValue(Object object, boolean bl) {
        JCDebug.println("field", "Field.setValue: obj is \"" + object + "\"");
        if (this.valueModel == null || this.validator == null) {
            JCDebug.println("field", "setValue: null valueModel or validator so we are creating one");
            if (object != null) {
                this.setClass(object.getClass());
            } else {
                return;
            }
        }
        if (this.valueModel == null) {
            return;
        }
        Object object2 = this.valueModel.getValue();
        if (bl && (object == object2 || this.validator != null && this.validator.compareValues(object, object2))) {
            this.internal_text_change = true;
            JTextField jTextField = this.getTextField();
            if (this.has_focus && this.validator.hasEditFormat() && jTextField != null && jTextField.isEditable()) {
                this.setText(this.validator.formatForEdit(object2));
            } else {
                this.setText(this.validator.format(object2));
            }
            this.internal_text_change = false;
            boolean bl2 = this.validator.validate(object2);
            if (bl2) {
                this.setStateValid();
            } else {
                this.setStateInvalid();
            }
            return;
        }
        this.valueModel.setValue(object, bl);
    }

    protected void setValueAndReformat(Object object) {
        JCDebug.println("field", "Field.setValueAndReformat");
        this.setValue(object, false);
        this.valueChanged(null);
    }

    public void setValueModel(JCValueModel jCValueModel) {
        JCDebug.println("field", "Field.setValueModel");
        if (jCValueModel == null) {
            return;
        }
        if (this.valueModel != null) {
            this.valueModel.removeValueListener(this);
        }
        Class clazz = jCValueModel.getValueClass();
        if (this.validator != null) {
            if (!this.validator.isClassSupported(clazz)) {
                throw new IllegalArgumentException("Current validator cannot support the data model");
            }
        } else if (DataPropertiesRegistry.isRegistered(clazz)) {
            this.valueModel = jCValueModel;
            this.setValidator(DataPropertiesRegistry.createValidator(clazz));
        }
        this.valueModel = jCValueModel;
        this.valueModel.addValueListener(this);
        if (this.vc instanceof JCPopupField) {
            this.valueModel.addValueListener((JCPopupField)this.vc);
        }
        this.setValueAndReformat(this.valueModel.getValue());
    }

    public void textCursorMoveBegin(TextCursorEvent textCursorEvent) {
        JCDebug.println("field", "Field.textCursorMoveBegin");
        if (this.validator != null) {
            this.validator.setCursor(textCursorEvent);
        }
    }

    public void textValueChangeBegin(TextEvent textEvent) {
        if (this.validator == null || this.valueModel == null) {
            return;
        }
        JCDebug.println("field", "Field.textValueChangeBegin()");
        if (this.internal_text_change) {
            return;
        }
        if (this.validator != null) {
            this.validator.changeText(textEvent);
        }
        if (!textEvent.getAllowChange() && this.beepOnInvalid && this.okayToBeep) {
            JCDebug.println("field", "\tgenerating beep");
            this.vc.getToolkit().beep();
        }
    }

    public void textValueChangeEnd(TextEvent textEvent) {
        if (this.internal_text_change) {
            return;
        }
    }

    protected void turnOffAutoCompleteMode() {
        JTextField jTextField = this.getTextField();
        if (this.auto_complete_mode && jTextField != null) {
            jTextField.setSelectionStart(jTextField.getCaretPosition());
            jTextField.setSelectionEnd(jTextField.getCaretPosition());
        }
        this.restorePickList();
        this.auto_complete_mode = false;
    }

    public void valueChanged(JCValueEvent jCValueEvent) {
        Object object;
        JCDebug.print("field", "Field.valueChanged:");
        if (jCValueEvent != null) {
            object = new JCValueEvent(this.vc, jCValueEvent.getOldValue(), jCValueEvent.getNewValue());
            this.fireValueChangedEvent((JCValueEvent)object);
        }
        object = null;
        if (jCValueEvent == null) {
            object = this.valueModel.getValue();
        } else {
            object = jCValueEvent.getNewValue();
            this.previousValue = jCValueEvent.getOldValue();
        }
        this.internal_text_change = true;
        JTextField jTextField = this.getTextField();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (jTextField != null) {
            n2 = jTextField.getSelectionStart();
            n3 = jTextField.getSelectionEnd();
            n4 = jTextField.getText().length();
        }
        if (this.validator != null) {
            if (this.has_focus && this.validator.hasEditFormat() && jTextField != null && jTextField.isEditable()) {
                this.setText(this.validator.formatForEdit(object));
            } else {
                this.setText(this.validator.format(object));
            }
        }
        if (jTextField != null && n4 == jTextField.getText().length() && !this.auto_complete_mode) {
            if (n2 == n3 && n2 == n) {
                jTextField.setCaretPosition(n);
            } else {
                jTextField.select(n2, n3);
            }
        }
        this.internal_text_change = false;
        if (this.vc instanceof JCSpinField) {
            ((JCSpinField)this.vc).checkArrowButtons();
        }
    }

    public void valueChanging(JCValueEvent jCValueEvent) {
        boolean bl;
        Object object;
        JCDebug.print("field", "Field.valueChanging:");
        if (jCValueEvent != null) {
            object = new JCValueEvent(this.vc, jCValueEvent.getOldValue(), jCValueEvent.getNewValue());
            this.fireValueChangingEvent((JCValueEvent)object);
            if (!((JCValueEvent)object).getAllowChange()) {
                jCValueEvent.setAllowChange(false);
                this.valueChanged(null);
                return;
            }
            if (((JCValueEvent)object).getNewValue() != jCValueEvent.getNewValue()) {
                jCValueEvent.setNewValue(((JCValueEvent)object).getNewValue());
            }
        }
        object = jCValueEvent.getOldValue();
        Object object2 = jCValueEvent.getNewValue();
        if (this.validator != null) {
            bl = this.validator.validate(object2);
            JCDebug.println("field", "\tvalue valid is " + bl);
        } else {
            JCDebug.println("field", "\tvalue is NOT valid -- validator null");
            bl = false;
        }
        if (bl) {
            if (this.valueModel != null && this.validator != null && object2 != object) {
                jCValueEvent.setNewValue(this.validator.copyValue(object2));
            }
            this.setStateValid();
        } else {
            switch (this.invalidPolicy) {
                case 1: {
                    this.setStateInvalid();
                    break;
                }
                case 2: {
                    object2 = this.defaultValue;
                    break;
                }
                case 3: {
                    object2 = jCValueEvent.getOldValue();
                    if (this.valueModel != null && this.validator != null && this.validator.validate(object2) && jCValueEvent.getNewValue() != object) {
                        object2 = this.validator.copyValue(object2);
                        break;
                    }
                    this.setStateInvalid();
                    break;
                }
                case 4: {
                    boolean bl2 = this.validator.validate(null);
                    object2 = null;
                    if (bl2) {
                        this.setStateValid();
                        break;
                    }
                    this.setStateInvalid();
                    break;
                }
            }
            jCValueEvent.setNewValue(object2);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    class Listeners
    implements FocusListener,
    KeyListener,
    Serializable {
        Listeners() {
        }

        public void focusGained(FocusEvent focusEvent) {
            JCDebug.println("field", "Field.focusGained()");
            if (Field.this.is_cell_editor) {
                return;
            }
            Field.this.has_focus = true;
            if (Field.this.validator == null || Field.this.valueModel == null) {
                return;
            }
            JTextField jTextField = Field.this.getTextField();
            if (jTextField == null) {
                return;
            }
            if (!jTextField.isEditable()) {
                return;
            }
            if (Field.this.validator.hasEditFormat() && Field.this.state != 3) {
                Field.this.internal_text_change = true;
                Field.this.setText(Field.this.validator.formatForEdit(Field.this.valueModel.getValue()));
                Field.this.internal_text_change = false;
            }
            if (Field.this.select_on_enter) {
                jTextField.setSelectionStart(0);
                jTextField.setSelectionEnd(jTextField.getText().length());
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            JCDebug.println("field", "Field.FocusLost");
            if (Field.this.is_cell_editor) {
                return;
            }
            Field.this.has_focus = false;
            if (Field.this.validator == null || Field.this.valueModel == null) {
                return;
            }
            if (Field.this.state == 2) {
                JCDebug.println("field", "\tfield under edit");
                Field.this.commitEdit(focusEvent);
            } else if (Field.this.state != 3 && Field.this.validator != null && Field.this.validator.hasEditFormat()) {
                JCDebug.println("field", "\tfield NOT under edit 1: state is VALID");
                Field.this.setValue(Field.this.valueModel.getValue());
            } else {
                JCDebug.print("field", "\tfield NOT under edit 2: state is ");
                JCDebug.println("field", Field.this.state == 1 ? "VALID" : "INVALID");
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            Object object = null;
            boolean bl = false;
            if (Field.this.validator == null || Field.this.valueModel == null) {
                return;
            }
            Object object2 = Field.this.valueModel.getValue();
            JTextField jTextField = Field.this.getTextField();
            JCDebug.println("field", "keyPressed(" + keyEvent.getKeyCode() + ") and \"" + jTextField.getText() + "\" is in the box");
            if (Field.this.vc instanceof JCPopupField && ((JCPopupField)Field.this.vc).isPopupVisible()) {
                if (((JCPopupField)Field.this.vc).getPopupEditor() == null) {
                    return;
                }
                boolean bl2 = ((JCPopupField)Field.this.vc).getPopupEditor().processKeyEvent(keyEvent);
                if (bl2) {
                    return;
                }
            }
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 27: {
                    JComboBox jComboBox;
                    JComboBox jComboBox2 = jComboBox = Field.this.vc instanceof JComboBox ? (JComboBox)Field.this.vc : null;
                    if (jComboBox != null && jComboBox.isPopupVisible()) {
                        jComboBox.setPopupVisible(false);
                        keyEvent.consume();
                        return;
                    }
                    bl = true;
                    if (Field.this.state != 2 && Field.this.state != 3) break;
                    int n2 = Field.this.state;
                    PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(Field.this.vc, "state", new Integer(n2), new Integer(1));
                    Enumeration enumeration = JCListenerList.elements(Field.this.propertyListeners);
                    while (enumeration.hasMoreElements()) {
                        PropertyChangeListener propertyChangeListener = (PropertyChangeListener)enumeration.nextElement();
                        propertyChangeListener.propertyChange(propertyChangeEvent);
                    }
                    Field.this.state = 1;
                    object = object2;
                    keyEvent.consume();
                    break;
                }
                case 10: {
                    Field.this.commitEdit(keyEvent);
                    keyEvent.consume();
                    return;
                }
                default: {
                    if (Field.this.state == 2) break;
                    Field.this.setStateUnderEdit();
                }
            }
            if (object != null) {
                Field.this.setValue(object);
            }
            if (jTextField != null && bl && Field.this.select_on_enter) {
                jTextField.setSelectionStart(0);
                jTextField.setSelectionEnd(jTextField.getText().length());
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    class TextFieldDocument
    extends PlainDocument
    implements CaretListener {
        protected SelectedItem selected = null;
        protected int currentCursorPosition = 0;
        protected int lastCursorPosition = 0;

        public TextFieldDocument(AbstractDocument.Content content) {
            super(content);
            JTextField jTextField = Field.this.getTextField();
            jTextField.addCaretListener(this);
            this.currentCursorPosition = jTextField.getCaretPosition();
        }

        public void caretUpdate(CaretEvent caretEvent) {
            this.lastCursorPosition = this.currentCursorPosition;
            this.currentCursorPosition = caretEvent.getDot();
            JTextField jTextField = Field.this.getTextField();
            JCDebug.print("field", "TextFieldDocument.caretUpdate:");
            JCDebug.print("field", " Last cursor position: " + this.lastCursorPosition);
            JCDebug.println("field", " New cursor position: " + this.currentCursorPosition);
            TextCursorEvent textCursorEvent = new TextCursorEvent(this.lastCursorPosition, this.currentCursorPosition);
            Field.this.textCursorMoveBegin(textCursorEvent);
            if (this.getOverstrike() && textCursorEvent.getNewPosition() != this.currentCursorPosition) {
                jTextField.getCaret().setDot(textCursorEvent.getNewPosition());
            }
        }

        protected void doAutoCompleteSelection(JTextField jTextField, JCComboField jCComboField) {
            int n;
            String string;
            int n2;
            if (!Field.this.auto_complete_mode || jTextField == null || jCComboField == null || !jCComboField.isAutoAppend() || this.selected == null || this.selected.start_pos >= this.selected.end_pos) {
                return;
            }
            JCStringValidator jCStringValidator = (JCStringValidator)Field.this.validator;
            String string2 = jTextField.getText();
            if (this.getOverstrike() && (n2 = jCStringValidator.getLastValidInputCharPosition(string = jCStringValidator.format(this.selected.parsed))) >= (n = jCStringValidator.getLastValidInputCharPosition(string2))) {
                jTextField.getCaret().setDot(jCStringValidator.getNextCursorPosition(n, true));
                return;
            }
            if (string2 != null && this.selected.end_pos <= string2.length()) {
                jTextField.select(this.selected.start_pos, this.selected.end_pos);
            }
        }

        protected void doCompletion(JCComboField jCComboField, String string, int n) {
            SelectedItem selectedItem;
            Object object;
            String string2 = null;
            if (this.getOverstrike()) {
                object = null;
                try {
                    object = Field.this.validator.parse(Field.this.valueModel.getValueClass(), string);
                }
                catch (FieldParseException fieldParseException) {}
                string2 = object == null ? null : object.toString();
            }
            this.selected = null;
            object = null;
            if (jCComboField.isAutoRefinement()) {
                object = new JCListModel();
                selectedItem = this.getPickListCompletion(jCComboField, string, string2, 0, n);
                while (selectedItem != null) {
                    if (this.selected == null) {
                        this.selected = selectedItem;
                    }
                    ((DefaultListModel)object).addElement(selectedItem.item);
                    selectedItem = this.getPickListCompletion(jCComboField, string, string2, selectedItem.index + 1, n);
                }
                String string3 = string;
                if (this.getOverstrike() && string2 != null) {
                    string3 = string2;
                }
                if (this.selected == null || string3 != null && !string3.equals(this.selected.item)) {
                    ((DefaultListModel)object).addElement(string3);
                }
                int n2 = ((DefaultListModel)object).getSize();
                if (this.selected == null && n2 > 0) {
                    this.selected = new SelectedItem(((DefaultListModel)object).getElementAt(n2 - 1), 0);
                }
            } else {
                this.selected = this.getPickListCompletion(jCComboField, string, string2, 0, n);
            }
            SelectedItem selectedItem2 = selectedItem = this.selected == null ? null : Field.this.validator.format(this.selected.item);
            if (this.selected != null && selectedItem != null) {
                this.selected.start_pos = this.getOverstrike() ? n : string.length();
                this.selected.end_pos = ((String)((Object)selectedItem)).length();
                if (this.selected.prefix_length > 0) {
                    this.selected.end_pos -= this.selected.prefix_length;
                }
                this.selected.end_pos = Math.max(this.selected.start_pos, this.selected.end_pos);
                this.selected.parsed = string2;
                Field.this.doing_completion = true;
                if (object != null) {
                    Field.this.changing_picklist = true;
                    jCComboField.setTemporaryPickList((ListModel)object);
                    Field.this.changing_picklist = false;
                }
                if (jCComboField.isAutoSuggest()) {
                    if (jCComboField.isPopupVisible()) {
                        jCComboField.setPopupVisible(false);
                    }
                    jCComboField.showPopup();
                }
                jCComboField.setSelectedItem(this.selected.item);
                if (jCComboField.isPopupVisible() || jCComboField.isAutoSuggest()) {
                    jCComboField.showPopup();
                }
                Field.this.doing_completion = false;
            }
        }

        protected String getMatchedPrefix(JCComboField jCComboField, String string) {
            int n = 0;
            int n2 = -1;
            String[] stringArray = jCComboField.getPrefixList();
            if (stringArray != null) {
                int n3 = 0;
                while (n3 < stringArray.length) {
                    String string2 = stringArray[n3];
                    if (string2 != null && string2.length() != 0) {
                        int n4 = string2.length();
                        if (string.startsWith(string2) && n4 > n) {
                            n = n4;
                            n2 = n3;
                        }
                    }
                    ++n3;
                }
            }
            if (n > 0) {
                return stringArray[n2];
            }
            return null;
        }

        public boolean getOverstrike() {
            return ((TextFieldContent)this.getContent()).getOverstrike();
        }

        protected SelectedItem getPickListCompletion(JCComboField jCComboField, String string, String string2, int n, int n2) {
            String string3;
            if (Field.this.validator == null || Field.this.validator.getPickList() == null || string == null || string.length() == 0 || n < 0) {
                return null;
            }
            ListModel listModel = jCComboField.isAutoRefinement() ? jCComboField.getOriginalPickList() : Field.this.validator.getPickList();
            String string4 = string3 = this.getOverstrike() ? string2 : string;
            if (listModel != null && string3 != null && string3.length() != 0) {
                int n3 = n;
                while (n3 < listModel.getSize()) {
                    Object e = listModel.getElementAt(n3);
                    String string5 = e.toString();
                    if (string5 != null && string5.length() > 0) {
                        String string6 = this.getMatchedPrefix(jCComboField, string5);
                        if (string6 != null && string6.length() != 0) {
                            StringBuffer stringBuffer = new StringBuffer(string6);
                            stringBuffer.append(string3);
                            if (string5.startsWith(stringBuffer.toString())) {
                                return new SelectedItem(e, n3, string6.length());
                            }
                        } else if (string5.startsWith(string3)) {
                            return new SelectedItem(e, n3);
                        }
                    }
                    ++n3;
                }
            }
            return null;
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            int n2;
            if (Field.this.validator == null || Field.this.valueModel == null || Field.this.changing_picklist) {
                return;
            }
            JCDebug.print("field", "TextFieldDocument.insertString: \"" + string + "\" ");
            JCDebug.print("field", "at offset " + n);
            JTextField jTextField = Field.this.getTextField();
            String string2 = jTextField.getText();
            int n3 = n2 = string2 == null ? 0 : string2.length();
            if (Field.this.validator instanceof JCStringValidator && ((JCStringValidator)Field.this.validator).getMask() != null && ((JCStringValidator)Field.this.validator).getMask().length() > 0) {
                this.setOverstrike(true);
            }
            boolean bl = false;
            Caret caret = jTextField.getCaret();
            int n4 = Math.min(caret.getDot(), caret.getMark());
            int n5 = Math.max(caret.getDot(), caret.getMark());
            int n6 = Field.this.validator.getFirstValidCursorPosition();
            if (n4 < n6) {
                n4 = n6;
            }
            TextEvent textEvent = new TextEvent(jTextField.getText(), n4, n5, string, false);
            Field.this.textValueChangeBegin(textEvent);
            bl = textEvent.getAllowChange();
            String string3 = jTextField.getSelectedText();
            if (bl && string3 != null && string3.length() != 0) {
                try {
                    this.remove(textEvent.getStartPosition(), string3.length());
                }
                catch (BadLocationException badLocationException) {}
            }
            caret.setDot(textEvent.getStartPosition());
            if (bl && !Field.this.doing_completion) {
                super.insertString(caret.getDot(), textEvent.getText(), attributeSet);
            }
            JCComboField jCComboField = Field.this.vc instanceof JComboBox ? (JCComboField)Field.this.vc : null;
            Field.this.calcAutoCompleteMode(jCComboField);
            if (Field.this.auto_complete_mode && bl) {
                if (!Field.this.doing_completion) {
                    if (Field.this.in_set_selected_item) {
                        return;
                    }
                    String string4 = jTextField.getText();
                    if (string4 != null && string4.length() != 0) {
                        this.doCompletion(jCComboField, string4, textEvent.getEndPosition());
                    }
                    return;
                }
                String string5 = textEvent.getText();
                if (this.getOverstrike() && this.selected != null) {
                    string5 = !jCComboField.isAutoAppend() ? this.selected.parsed : this.selected.item.toString();
                }
                if (string5 != null && string5.length() != 0) {
                    if (this.selected != null && this.selected.prefix_length > 0) {
                        string5 = string5.substring(this.selected.prefix_length);
                    }
                    if (this.getOverstrike() && this.selected != null) {
                        string5 = Field.this.validator.format(string5);
                    }
                    if (!jCComboField.isAutoAppend() && this.selected != null) {
                        if (this.getOverstrike()) {
                            super.insertString(caret.getDot(), string5, attributeSet);
                            caret.setDot(this.selected.start_pos);
                        } else {
                            super.insertString(caret.getDot(), string5.substring(0, this.selected.start_pos), attributeSet);
                        }
                    } else {
                        super.insertString(caret.getDot(), string5, attributeSet);
                    }
                }
                this.doAutoCompleteSelection(jTextField, jCComboField);
                Field.this.setStateUnderEdit();
            }
        }

        public void remove(int n, int n2) throws BadLocationException {
            int n3;
            if (Field.this.validator == null || Field.this.valueModel == null || Field.this.changing_picklist) {
                return;
            }
            JCDebug.print("field", "TextFieldDocument.remove:");
            JCDebug.print("field", " offset " + n);
            JCDebug.println("field", " length " + n2);
            JTextField jTextField = Field.this.getTextField();
            String string = jTextField == null ? null : jTextField.getText();
            int n4 = string == null ? 0 : string.length();
            TextEvent textEvent = new TextEvent(jTextField.getText(), n, n + n2, "", true);
            Field.this.textValueChangeBegin(textEvent);
            String string2 = textEvent.getText();
            int n5 = n3 = string2 == null ? 0 : string2.length();
            if (this.getOverstrike()) {
                jTextField.setCaretPosition(textEvent.getStartPosition());
                int n6 = jTextField.getCaretPosition();
                int n7 = 0;
                if (n < n6 && string2 != null && n3 >= 1) {
                    n7 = n6 - n;
                    string2 = string2.substring(n7);
                }
                super.insertString(n6, string2, null);
                jTextField.getCaret().setDot(textEvent.getStartPosition() + n7);
            } else {
                super.remove(n, n2);
            }
            JCComboField jCComboField = Field.this.vc instanceof JComboBox ? (JCComboField)Field.this.vc : null;
            Field.this.calcAutoCompleteMode(jCComboField);
            if (!Field.this.auto_complete_mode || !textEvent.getAllowChange()) {
                return;
            }
            JCStringValidator jCStringValidator = (JCStringValidator)Field.this.validator;
            int n8 = n + n2;
            String string3 = jTextField == null ? null : jTextField.getText();
            int n9 = string3 == null ? 0 : string3.length();
            int n10 = jTextField.getCaret().getDot();
            int n11 = jCStringValidator.getLastValidInputCharPosition(string3);
            if (!(n9 <= 0 || Field.this.doing_completion || n10 >= n11 && !jCComboField.isAutoRefinement() || this.selected == null || this.selected.start_pos == n && this.selected.end_pos == n8)) {
                this.doCompletion(jCComboField, string3, n10);
            }
        }

        public void setOverstrike(boolean bl) {
            ((TextFieldContent)this.getContent()).setOverstrike(bl);
        }

        public class SelectedItem {
            public int prefix_length = -1;
            public Object item = null;
            public String parsed = null;
            public int index = -1;
            public int start_pos = 0;
            public int end_pos = 0;

            SelectedItem(Object object, int n) {
                this.item = object;
                this.index = n;
            }

            SelectedItem(Object object, int n, int n2) {
                this.item = object;
                this.index = n;
                this.prefix_length = n2;
            }
        }
    }

    public class TextFieldContent
    implements AbstractDocument.Content,
    Serializable {
        protected boolean overstrike = false;
        private int data_length;
        private final char[] empty = new char[0];
        private char[] data;
        public transient Vector marks;

        public TextFieldContent() {
            this(10);
        }

        public TextFieldContent(int n) {
            if (n < 1) {
                n = 1;
            }
            this.data = new char[n];
            this.data[0] = 10;
            this.data_length = 1;
        }

        public Position createPosition(int n) throws BadLocationException {
            if (this.marks == null) {
                this.marks = new Vector();
            }
            return new ContentPosition(n, this);
        }

        public void getChars(int n, int n2, Segment segment) throws BadLocationException {
            if (n + n2 > this.data_length) {
                throw new BadLocationException("Invalid location", this.data_length);
            }
            segment.array = this.data;
            segment.offset = n;
            segment.count = n2;
        }

        public boolean getOverstrike() {
            return this.overstrike;
        }

        public String getString(int n, int n2) throws BadLocationException {
            if (n + n2 > this.data_length) {
                throw new BadLocationException("Invalid range", this.data_length);
            }
            return new String(this.data, n, n2);
        }

        public UndoableEdit insertString(int n, String string) throws BadLocationException {
            if (n >= this.data_length) {
                throw new BadLocationException("Invalid location", this.data_length);
            }
            char[] cArray = string.toCharArray();
            if (!this.overstrike || n == this.data_length - 1) {
                this.insertText(n, 0, cArray, 0, cArray.length);
                if (this.marks != null) {
                    this.updateMarksForInsert(n, string.length());
                }
            } else {
                this.replaceRange(n, cArray, 0, cArray.length);
            }
            return null;
        }

        public void insertText(int n, int n2, char[] cArray, int n3, int n4) {
            int n5 = n4 - n2;
            int n6 = n + n2;
            int n7 = this.data_length - n6;
            int n8 = n6 + n5;
            if (this.data_length + n5 >= this.data.length) {
                int n9 = Math.max(2 * this.data.length, this.data_length + n5);
                char[] cArray2 = new char[n9];
                System.arraycopy(this.data, 0, cArray2, 0, n);
                System.arraycopy(cArray, n3, cArray2, n, n4);
                System.arraycopy(this.data, n6, cArray2, n8, n7);
                this.data = cArray2;
            } else {
                System.arraycopy(this.data, n6, this.data, n8, n7);
                System.arraycopy(cArray, n3, this.data, n, n4);
            }
            this.data_length += n5;
        }

        public int length() {
            return this.data_length;
        }

        public UndoableEdit remove(int n, int n2) throws BadLocationException {
            if (n + n2 >= this.data_length) {
                throw new BadLocationException("Invalid range", this.data_length);
            }
            if (!this.overstrike) {
                String string = this.getString(n, n2);
                this.insertText(n, n2, this.empty, 0, 0);
                if (this.marks != null) {
                    this.updateMarksForRemove(n, n2);
                }
            } else {
                char[] cArray = new char[n2];
                int n3 = 0;
                while (n3 < cArray.length) {
                    cArray[n3] = 32;
                    ++n3;
                }
                this.replaceRange(n, cArray, 0, n2);
            }
            return null;
        }

        protected void replaceRange(int n, char[] cArray, int n2, int n3) {
            System.arraycopy(cArray, n2, this.data, n, n3);
        }

        public void setOverstrike(boolean bl) {
            this.overstrike = bl;
        }

        synchronized void updateMarksForInsert(int n, int n2) {
            if (n == 0) {
                n = 1;
            }
            int n3 = this.marks.size();
            int n4 = 0;
            while (n4 < n3) {
                PositionEntry positionEntry = (PositionEntry)this.marks.elementAt(n4);
                if (positionEntry.unused) {
                    this.marks.removeElementAt(n4);
                    --n4;
                    --n3;
                } else if (positionEntry.offset >= n) {
                    positionEntry.offset += n2;
                }
                ++n4;
            }
        }

        synchronized void updateMarksForRemove(int n, int n2) {
            int n3 = this.marks.size();
            int n4 = 0;
            while (n4 < n3) {
                PositionEntry positionEntry = (PositionEntry)this.marks.elementAt(n4);
                if (positionEntry.unused) {
                    this.marks.removeElementAt(n4);
                    --n4;
                    --n3;
                } else if (positionEntry.offset >= n + n2) {
                    positionEntry.offset -= n2;
                } else if (positionEntry.offset >= n) {
                    positionEntry.offset = n;
                }
                ++n4;
            }
        }
    }

    final class PositionEntry {
        int offset;
        boolean unused;

        PositionEntry(int n) {
            this.offset = n;
        }
    }

    final class ContentPosition
    implements Position {
        PositionEntry rec;

        ContentPosition(int n, TextFieldContent textFieldContent) {
            Field field2 = Field.this;
            field2.getClass();
            this.rec = field2.new PositionEntry(n);
            textFieldContent.marks.addElement(this.rec);
        }

        protected void finalize() throws Throwable {
            this.rec.unused = true;
        }

        public int getOffset() {
            return this.rec.offset;
        }

        public String toString() {
            return Integer.toString(this.getOffset());
        }
    }
}

