/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.field.validate;

import com.klg.jclass.field.validate.FieldParseException;
import com.klg.jclass.field.validate.JCValidator;
import com.klg.jclass.field.validate.PopupFieldEditor;
import com.klg.jclass.field.validate.TextCursorEvent;
import com.klg.jclass.field.validate.TextEvent;
import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ListModel;

public abstract class AbstractValidator
implements JCValidator,
Serializable {
    private static final boolean TRACE = false;
    public static final int AS_IS = 0;
    public static final int UPPERCASE = 1;
    public static final int LOWERCASE = 2;
    public static final int SPIN_FIELD = 0;
    public static final int SPIN_SUBFIELD = 1;
    public static final int SPIN_WRAP = 2;
    public static final int NOT_FOUND = -1;
    protected Object max;
    protected Object min;
    protected Locale locale;
    protected Object increment;
    protected boolean allow_null = false;
    protected int case_policy = 0;
    protected String invalid_chars = null;
    protected boolean match_picklist = true;
    protected String valid_chars = null;
    protected ListModel picklist = null;
    protected int spin_policy = 0;
    protected boolean abstractInitializing = true;
    protected ResourceBundle li;
    protected Class[] supportedClasses;

    public AbstractValidator() {
        this.setLocale(Locale.getDefault());
        this.abstractInitializing = false;
    }

    protected abstract Object addIncrement(Object var1);

    public int calculateSpinability(Object object) {
        if (object != null && !this.isClassSupported(object.getClass())) {
            return 0;
        }
        int n = 0;
        if (this.picklist != null && this.picklist.getSize() > 0) {
            int n2 = this.getPickListIndex(object);
            if (this.spin_policy == 2) {
                n |= 2;
                n |= 1;
            } else {
                if (n2 > 0 || n2 == -1) {
                    n |= 2;
                }
                if (n2 < this.picklist.getSize() - 1) {
                    n |= 1;
                }
            }
            return n;
        }
        if (this.increment != null) {
            Object object2 = this.subtractIncrement(object);
            if (this.spin_policy == 2) {
                n |= 2;
                n |= 1;
            } else {
                if (object2 != null && !object2.equals(object)) {
                    n |= 2;
                }
                if ((object2 = this.addIncrement(object)) != null && !object2.equals(object)) {
                    n |= 1;
                }
            }
            return n;
        }
        return 0;
    }

    public void changeText(TextEvent textEvent) {
        String string = textEvent.getText();
        if (string == null || string.length() == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            stringBuffer.append(this.convertCase(string.charAt(n)));
            ++n;
        }
        textEvent.setText(stringBuffer.toString());
    }

    protected StringBuffer checkValidInvalid(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (this.isValidChar(c)) {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer;
    }

    public boolean compareValues(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return object.equals(object2);
    }

    public char convertCase(char c) {
        switch (this.case_policy) {
            case 1: {
                c = Character.toUpperCase(c);
                break;
            }
            case 2: {
                c = Character.toLowerCase(c);
                break;
            }
        }
        return c;
    }

    public abstract Object convertFromSupported(Object var1, Class var2);

    public abstract Object convertToSupported(Object var1);

    public abstract Object copyValue(Object var1);

    public PopupFieldEditor createPopupComponent() {
        return null;
    }

    public abstract String format(Object var1);

    public abstract String formatForEdit(Object var1);

    public boolean getAllowNull() {
        return this.allow_null;
    }

    public int getCasePolicy() {
        return this.case_policy;
    }

    public abstract Object getDefaultValue();

    public abstract int getFirstValidCursorPosition();

    public String getInvalidChars() {
        return this.invalid_chars;
    }

    protected String getItem(int n) {
        return this.picklist.getElementAt(n).toString();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean getMatchPickList() {
        return this.match_picklist;
    }

    public Object getMax() {
        return this.max;
    }

    public Object getMin() {
        return this.min;
    }

    protected Object getNextValue(int n) {
        if (n + 1 >= 0 && n + 1 >= this.picklist.getSize()) {
            return null;
        }
        return this.picklist.getElementAt(n + 1);
    }

    public ListModel getPickList() {
        return this.picklist;
    }

    public int getPickListIndex(Object object) {
        if (this.picklist == null || object == null) {
            return -1;
        }
        int n = 0;
        while (n < this.picklist.getSize()) {
            if (object.equals(this.picklist.getElementAt(n))) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected Object getPreviousValue(int n) {
        if (n - 1 < 0) {
            return null;
        }
        return this.picklist.getElementAt(n - 1);
    }

    public int getSpinPolicy() {
        return this.spin_policy;
    }

    public String getValidChars() {
        return this.valid_chars;
    }

    public abstract boolean hasEditFormat();

    protected abstract boolean inRange(Object var1);

    public void inferSubField(int n, int n2) {
    }

    public boolean isClassSupported(Class clazz) {
        if (this.supportedClasses == null) {
            return false;
        }
        int n = 0;
        while (n < this.supportedClasses.length) {
            if (clazz == this.supportedClasses[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isValidChar(char c) {
        int n;
        if (this.invalid_chars != null) {
            n = 0;
            while (n < this.invalid_chars.length()) {
                if (c == this.invalid_chars.charAt(n)) {
                    return false;
                }
                ++n;
            }
        }
        if (this.valid_chars == null || this.valid_chars.length() == 0) {
            return true;
        }
        n = 0;
        while (n < this.valid_chars.length()) {
            if (c == this.valid_chars.charAt(n)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public abstract Object parse(Class var1, String var2) throws FieldParseException;

    public void setAllowNull(boolean bl) {
        this.allow_null = bl;
    }

    public void setCasePolicy(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("invalid value for casePolicy");
        }
        this.case_policy = n;
    }

    public abstract void setCursor(TextCursorEvent var1);

    public void setInvalidChars(String string) {
        this.invalid_chars = string;
    }

    public void setLocale(Locale locale) {
        if (this.locale == locale) {
            return;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            this.li = ResourceBundle.getBundle("com.klg.jclass.field.resources.LocaleInfo", locale);
        }
        catch (MissingResourceException missingResourceException) {
            locale = new Locale(locale.getLanguage(), locale.getCountry());
            try {
                this.li = ResourceBundle.getBundle("com.klg.jclass.field.resources.LocaleInfo", locale);
            }
            catch (MissingResourceException missingResourceException2) {
                locale = new Locale(locale.getLanguage(), "");
                try {
                    this.li = ResourceBundle.getBundle("com.klg.class.field.resources.LocaleInfo", locale);
                }
                catch (MissingResourceException missingResourceException3) {
                    locale = null;
                    try {
                        this.li = ResourceBundle.getBundle("com.klg.jclass.field.resources.LocaleInfo", locale);
                    }
                    catch (MissingResourceException missingResourceException4) {
                        throw missingResourceException;
                    }
                }
            }
        }
        this.locale = locale;
    }

    public void setMatchPickList(boolean bl) {
        this.match_picklist = bl;
    }

    public void setMax(Object object) {
        this.max = object;
    }

    public void setMin(Object object) {
        this.min = object;
    }

    public void setPickList(ListModel listModel) {
        this.picklist = listModel;
    }

    public void setRange(Object object, Object object2) {
        this.min = object;
        this.max = object2;
    }

    public void setSpinPolicy(int n) {
        if (n != 1 && n != 0 && n != 2) {
            throw new IllegalArgumentException("invalid value for spinPolicy");
        }
        this.spin_policy = n;
    }

    public void setValidChars(String string) {
        this.valid_chars = string;
    }

    public Object spinDown(Object object) {
        if (this.picklist != null && this.picklist.getSize() > 0) {
            int n = this.getPickListIndex(object);
            if (n > 0) {
                return this.picklist.getElementAt(n - 1);
            }
            if (n == -1) {
                return this.picklist.getElementAt(this.picklist.getSize() - 1);
            }
            if (this.spin_policy == 2) {
                return this.picklist.getElementAt(this.picklist.getSize() - 1);
            }
            return null;
        }
        if (this.increment != null) {
            Object object2 = this.subtractIncrement(object);
            if (object2 != null) {
                return object2;
            }
            if (this.spin_policy == 2) {
                return this.max;
            }
        }
        return null;
    }

    public Object spinUp(Object object) {
        if (this.picklist != null && this.picklist.getSize() > 0) {
            int n = this.getPickListIndex(object);
            if (n + 1 < this.picklist.getSize()) {
                return this.picklist.getElementAt(n + 1);
            }
            if (this.spin_policy == 2) {
                return this.picklist.getElementAt(0);
            }
            return null;
        }
        if (this.increment != null) {
            Object object2 = this.addIncrement(object);
            if (object2 != null) {
                return object2;
            }
            if (this.spin_policy == 2) {
                return this.min;
            }
        }
        return null;
    }

    protected abstract Object subtractIncrement(Object var1);

    public boolean validate(Object object) {
        boolean bl = true;
        if (this.picklist != null && this.picklist.getSize() > 0 && this.match_picklist) {
            int n = this.getPickListIndex(object);
            bl = n != -1;
        }
        if (!this.allow_null && object == null) {
            bl = false;
        }
        return bl;
    }
}

