/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing;

import com.klg.jclass.cell.EditorRendererRegistry;
import com.klg.jclass.cell.JCCellEditor;
import com.klg.jclass.cell.JCCellRenderer;
import com.klg.jclass.cell.swing.JCCellEditorToJTable;
import com.klg.jclass.cell.swing.JCCellRendererToJTable;
import com.klg.jclass.swing.DefaultTreeTableSelectionModel;
import com.klg.jclass.swing.JCTreeTableSelectionModel;
import com.klg.jclass.swing.Version;
import com.klg.jclass.util.JCDebug;
import com.klg.jclass.util.JCEnvironment;
import com.klg.jclass.util.swing.JCBrace;
import com.klg.jclass.util.swing.JCElasticLayout;
import com.klg.jclass.util.swing.JCSortableTable;
import com.klg.jclass.util.swing.JCTableColumn;
import com.klg.jclass.util.treetable.EmptyTreeTableModel;
import com.klg.jclass.util.treetable.JCTreeIconRenderer;
import com.klg.jclass.util.treetable.JCTreeTableModel;
import com.klg.jclass.util.treetable.TreeTableSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;

public class JCTreeTable
extends JCSortableTable {
    public static final int TREE = 1;
    public static final int TABLE = 2;
    public static final int SWITCH_VIEW_NEVER = 1;
    public static final int SWITCH_VIEW_TO_TABLE_ON_SORT = 2;
    public static final int SWITCH_VIEW_ON_ICON_ONLY = 3;
    public static final int NODE_LINES_SHOW = 1;
    public static final int NODE_LINES_HIDE = 2;
    public static final int NODE_LINES_USE_PLAF = 3;
    protected static final int ICON_SIZE = 16;
    protected int switchPolicy = 3;
    protected TreeTableSupport support;
    private static final Border emptyBorder = new EmptyBorder(0, 0, 0, 0);
    protected JCTreeTableSelectionModel treeSelectionModel;
    protected boolean sortable = true;
    static /* synthetic */ Class class$javax$swing$tree$TreePath;

    public JCTreeTable() {
        this((JCTreeTableModel)null);
    }

    public JCTreeTable(JCTreeTableModel jCTreeTableModel) {
        this(jCTreeTableModel, new Dimension(0, 0));
    }

    public JCTreeTable(JCTreeTableModel jCTreeTableModel, Dimension dimension) {
        this.setDefaultRenderer(class$javax$swing$tree$TreePath != null ? class$javax$swing$tree$TreePath : (class$javax$swing$tree$TreePath = JCTreeTable.class$("javax.swing.tree.TreePath")), new Renderer());
        this.setDefaultEditor(class$javax$swing$tree$TreePath != null ? class$javax$swing$tree$TreePath : (class$javax$swing$tree$TreePath = JCTreeTable.class$("javax.swing.tree.TreePath")), new Editor());
        this.support = new TreeTableSupport(this);
        double d = 0.0;
        String string = System.getProperty("java.version");
        string.trim();
        if (string.lastIndexOf(".") > 2) {
            string = string.substring(0, 3);
        }
        try {
            d = Double.valueOf(string.trim());
        }
        catch (NumberFormatException numberFormatException) {}
        if (d < 1.3) {
            this.setIntercellSpacing(dimension);
        }
        if (jCTreeTableModel == null) {
            jCTreeTableModel = new EmptyTreeTableModel(EmptyTreeTableModel.makeDefaultTree());
        }
        this.support.setTreeTableModel(jCTreeTableModel);
        this.setTreeTableSelectionModel(new DefaultTreeTableSelectionModel());
        this.setModel(this.support);
        this.setUI(new TreeTableUI());
        if (this.support.getMaxIconHeight() > this.getRowHeight()) {
            this.setRowHeight(this.support.getMaxIconHeight());
        }
    }

    public void addSelectionPath(TreePath treePath) {
        this.makeVisible(treePath);
        this.treeSelectionModel.addSelectionPath(treePath);
    }

    public void addSelectionPaths(TreePath[] treePathArray) {
        if (treePathArray != null) {
            int n = treePathArray.length - 1;
            while (n >= 0) {
                this.makeVisible(treePathArray[n]);
                --n;
            }
        }
        this.treeSelectionModel.addSelectionPaths(treePathArray);
    }

    public void addTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.support.addTreeExpansionListener(treeExpansionListener);
    }

    public void addTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.support.addTreeWillExpandListener(treeWillExpandListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void collapsePath(TreePath treePath) {
        this.support.collapsePath(treePath);
    }

    public void collapseRow(int n) {
        this.support.collapseRow(n);
    }

    protected TableColumn createSortableTableColumn(int n) {
        if (n == 0) {
            return new SwitchTableColumn(n);
        }
        return super.createSortableTableColumn(n);
    }

    protected MouseAdapter createTableHeaderMouseListener() {
        return new TableHeaderMouseAdapter();
    }

    public void expandPath(TreePath treePath) {
        this.support.expandPath(treePath);
    }

    public void expandRow(int n) {
        this.support.expandRow(n);
    }

    public String getAbout() {
        return Version.getVersionString();
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        TableCellEditor tableCellEditor = null;
        tableCellEditor = this.support.getView() == 1 && n2 == this.getTreeColumn() ? this.getDefaultEditor(class$javax$swing$tree$TreePath != null ? class$javax$swing$tree$TreePath : (class$javax$swing$tree$TreePath = JCTreeTable.class$("javax.swing.tree.TreePath"))) : super.getCellEditor(n, n2);
        return tableCellEditor;
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        TableCellRenderer tableCellRenderer = null;
        tableCellRenderer = this.support.getView() == 1 && n2 == this.getTreeColumn() ? this.getDefaultRenderer(class$javax$swing$tree$TreePath != null ? class$javax$swing$tree$TreePath : (class$javax$swing$tree$TreePath = JCTreeTable.class$("javax.swing.tree.TreePath"))) : super.getCellRenderer(n, n2);
        return tableCellRenderer;
    }

    public TreePath getClosestPathForLocation(int n, int n2) {
        int n3 = this.rowAtPoint(new Point(n, n2));
        return this.support.getPathForRow(n3);
    }

    public int getClosestRowForLocation(int n, int n2) {
        return this.rowAtPoint(new Point(n, n2));
    }

    public TreePath getEditingPath() {
        int n = this.getEditingRow();
        if (n == -1) {
            return null;
        }
        return this.support.getPathForRow(n);
    }

    public Enumeration getExpandedDescendants(TreePath treePath) {
        return this.support.getExpandedDescendants(treePath);
    }

    public Rectangle getPathBounds(TreePath treePath) {
        return null;
    }

    public TreePath getPathForLocation(int n, int n2) {
        return this.getClosestPathForLocation(n, n2);
    }

    public TreePath getPathForRow(int n) {
        return this.support.getPathForRow(n);
    }

    public Dimension getPreferredSize() {
        if (JCEnvironment.isDesignTime()) {
            this.expandRow(0);
            return new Dimension(200, 200);
        }
        return super.getPreferredSize();
    }

    public Rectangle getRowBounds(int n) {
        return null;
    }

    public int getRowForLocation(int n, int n2) {
        return this.getClosestRowForLocation(n, n2);
    }

    public int getRowForPath(TreePath treePath) {
        return this.support.getRowForPath(treePath);
    }

    public int[] getRowsForPaths(TreePath[] treePathArray) {
        return this.support.getRowsForPaths(treePathArray);
    }

    public boolean getScrollsOnExpand() {
        return this.support.getScrollsOnExpand();
    }

    public TreePath getSelectionPath() {
        int n = this.getSelectedRow();
        if (n < 0) {
            return null;
        }
        return this.support.getPathForRow(n);
    }

    public TreePath[] getSelectionPaths() {
        int[] nArray = this.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            return null;
        }
        TreePath[] treePathArray = new TreePath[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            treePathArray[n] = this.support.getPathForRow(nArray[n]);
            ++n;
        }
        return treePathArray;
    }

    public int getShowNodeLines() {
        return this.support.getShowNodeLines();
    }

    public boolean getShowsRootHandles() {
        return this.support.getShowsRootHandles();
    }

    public int getSwitchPolicy() {
        return this.switchPolicy;
    }

    public int getTreeColumn() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            if (tableColumnModel.getColumn(n2) instanceof SwitchTableColumn) {
                return n2;
            }
            ++n2;
        }
        return 0;
    }

    public JCTreeIconRenderer getTreeIconRenderer() {
        return this.support.getTreeIconRenderer();
    }

    public JCTreeTableSelectionModel getTreeSelectionModel() {
        return this.treeSelectionModel;
    }

    public JCTreeTableModel getTreeTableModel() {
        return this.support.getTreeTableModel();
    }

    public int getView() {
        return this.support.getView();
    }

    public boolean isPathSelected(TreePath treePath) {
        if (this.treeSelectionModel != null) {
            return this.treeSelectionModel.isPathSelected(treePath);
        }
        return false;
    }

    protected boolean isPointOverSwitch(Point point) {
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            int n2 = tableColumn.getWidth();
            if (n + n2 > point.x) {
                return point.x - n < 16 && tableColumn.getHeaderRenderer() instanceof SwitchRenderer;
            }
            n += n2;
        }
        return false;
    }

    public boolean isRootVisible() {
        return this.support.isRootVisible();
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void makeVisible(TreePath treePath) {
        TreePath treePath2;
        if (treePath != null && (treePath2 = treePath.getParentPath()) != null) {
            this.expandPath(treePath2);
        }
    }

    public void removeTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.support.removeTreeExpansionListener(treeExpansionListener);
    }

    public void removeTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.support.removeTreeWillExpandListener(treeWillExpandListener);
    }

    public void setAbout(String string) {
    }

    public void setRootVisible(boolean bl) {
        this.support.setRootVisible(bl);
    }

    public void setScrollsOnExpand(boolean bl) {
        this.support.setScrollsOnExpand(bl);
    }

    public void setSelectionPath(TreePath treePath) {
        this.makeVisible(treePath);
        this.treeSelectionModel.setSelectionPath(treePath);
    }

    public void setSelectionPaths(TreePath[] treePathArray) {
        if (treePathArray != null) {
            int n = treePathArray.length - 1;
            while (n >= 0) {
                this.makeVisible(treePathArray[n]);
                --n;
            }
        }
        this.treeSelectionModel.setSelectionPaths(treePathArray);
    }

    public void setShowNodeLines(int n) {
        this.support.setShowNodeLines(n);
    }

    public void setShowsRootHandles(boolean bl) {
        this.support.setShowsRootHandles(bl);
    }

    public void setSortable(boolean bl) {
        this.support.setSortable(bl);
        this.sortable = bl;
    }

    public void setSwitchPolicy(int n) {
        this.switchPolicy = n;
    }

    public void setTreeIconRenderer(JCTreeIconRenderer jCTreeIconRenderer) {
        this.support.setTreeIconRenderer(jCTreeIconRenderer);
    }

    public void setTreeTableModel(JCTreeTableModel jCTreeTableModel) {
        this.support.setTreeTableModel(jCTreeTableModel);
    }

    public void setTreeTableSelectionModel(JCTreeTableSelectionModel jCTreeTableSelectionModel) {
        if (this.treeSelectionModel == null) {
            this.treeSelectionModel = EmptyTreeSelectionModel.getSharedInstance();
        }
        JCTreeTableSelectionModel jCTreeTableSelectionModel2 = this.treeSelectionModel;
        this.treeSelectionModel = jCTreeTableSelectionModel;
        this.treeSelectionModel.setRowMapper(this.support);
        this.setSelectionModel(this.treeSelectionModel.getListSelectionModel());
        this.firePropertyChange("treeSelectionModel", jCTreeTableSelectionModel2, this.selectionModel);
    }

    public void setUI(TableUI tableUI) {
        if (this.support != null) {
            this.support.inferLookAndFeel();
        }
        super.setUI(tableUI);
    }

    public void setView(int n) {
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            if (!(tableCellRenderer instanceof SwitchRenderer)) continue;
            ((SwitchRenderer)tableCellRenderer).setView(n);
        }
        this.support.setView(n);
    }

    protected void toggleView() {
        if (this.getView() == 1) {
            this.setView(2);
        } else {
            this.setView(1);
        }
    }

    public void updateUI() {
        this.setUI(new TreeTableUI());
    }

    class TableHeaderMouseAdapter
    extends MouseAdapter
    implements Serializable {
        TableHeaderMouseAdapter() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 1 && !mouseEvent.isPopupTrigger()) {
                int n = JCTreeTable.this.columnAtPoint(mouseEvent.getPoint());
                boolean bl = JCTreeTable.this.switchPolicy != 1 ? JCTreeTable.this.isPointOverSwitch(mouseEvent.getPoint()) : false;
                if (bl) {
                    JCTreeTable.this.toggleView();
                } else if (JCTreeTable.this.isSortable() && JCTreeTable.this.switchPolicy == 2 && JCTreeTable.this.getView() == 1) {
                    JCTreeTable.this.setView(2);
                    JCTreeTable.this.sort(n);
                } else if (JCTreeTable.this.isSortable()) {
                    JCTreeTable.this.sort(n);
                }
            }
        }
    }

    protected class TreeTableUI
    extends BasicTableUI {
        protected TreeTableUI() {
        }

        protected MouseInputListener createMouseInputListener() {
            return new TreeTableMouseInputHandler();
        }

        protected class TreeTableMouseInputHandler
        extends BasicTableUI.MouseInputHandler {
            protected boolean mousePressedInControlBox = false;

            protected TreeTableMouseInputHandler() {
                super(TreeTableUI.this);
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                if (!this.mousePressedInControlBox) {
                    super.mouseDragged(mouseEvent);
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                int n = JCTreeTable.this.rowAtPoint(mouseEvent.getPoint());
                int n2 = JCTreeTable.this.columnAtPoint(mouseEvent.getPoint());
                Point point = new Point(mouseEvent.getPoint());
                point.y -= n * (JCTreeTable.this.getRowHeight() + ((TreeTableUI)TreeTableUI.this).JCTreeTable.this.getIntercellSpacing().height);
                if (!((TreeTableUI)TreeTableUI.this).JCTreeTable.this.support.processClickInTreeColumn(mouseEvent, n, n2, point, JCTreeTable.this.getRowHeight())) {
                    this.mousePressedInControlBox = false;
                    super.mousePressed(mouseEvent);
                } else {
                    this.mousePressedInControlBox = true;
                    JCTreeTable.this.removeEditor();
                }
            }
        }
    }

    class TreeRendererEditor
    extends JPanel {
        Insets insets = new Insets(0, 0, 0, 0);
        protected TreePath path;
        protected Object value;
        protected Class value_class;

        TreeRendererEditor() {
        }

        public void doLayout() {
            if (this.getComponentCount() == 0 || this.path == null) {
                JCDebug.assert(false);
                return;
            }
            Component component = this.getComponent(0);
            Dimension dimension = this.getSize();
            int n = JCTreeTable.this.support.getRendererIndent(this.path);
            component.setBounds(n, 0, dimension.width - n, dimension.height);
        }

        public Insets getInsets() {
            return this.insets;
        }

        public boolean isOpaque() {
            return false;
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            JCTreeTable.this.support.prepareCellForRender(graphics, dimension.width, dimension.height);
            super.paint(graphics);
            JCTreeTable.this.support.renderHierarchy(graphics, new Rectangle(new Point(0, 0), dimension), this.path, this.value, this.value_class);
        }
    }

    class Renderer
    extends TreeRendererEditor
    implements TableCellRenderer {
        TableCellRenderer renderer;

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (jTable != null) {
                Serializable serializable;
                if (this.renderer == null) {
                    JCCellRenderer jCCellRenderer;
                    serializable = jTable.getColumnModel().getColumn(n2);
                    if (this.renderer == null && serializable instanceof JCTableColumn && (jCCellRenderer = EditorRendererRegistry.getCentralRegistry().getCellRendererInstance(JCTreeTable.this.support.getTreeColumnClass(), ((JCTableColumn)serializable).getRegistryType())) != null) {
                        this.renderer = new JCCellRendererToJTable(jCCellRenderer);
                    }
                    if (this.renderer == null) {
                        this.renderer = JCTreeTable.this.getDefaultRenderer(JCTreeTable.this.support.getTreeColumnClass());
                    }
                }
                if (object instanceof TreePath) {
                    this.path = (TreePath)object;
                    this.value = JCTreeTable.this.support.getTreeColumnValue(this.path.getLastPathComponent());
                } else {
                    this.path = null;
                    this.value = object;
                }
                this.value_class = this.value != null ? this.value.getClass() : null;
                serializable = this.renderer.getTableCellRendererComponent(jTable, this.value, bl, bl2, n, n2);
                if (((Component)serializable).getParent() != this) {
                    this.add((Component)serializable);
                }
            }
            return this;
        }
    }

    class Editor
    extends TreeRendererEditor
    implements TableCellEditor {
        TableCellEditor editor;

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.getEditor().addCellEditorListener(cellEditorListener);
        }

        public void cancelCellEditing() {
            this.getEditor().cancelCellEditing();
        }

        public Object getCellEditorValue() {
            return this.getEditor().getCellEditorValue();
        }

        protected TableCellEditor getEditor() {
            return this.getEditor(JCTreeTable.this);
        }

        protected TableCellEditor getEditor(JTable jTable) {
            if (this.editor == null) {
                JCCellEditor jCCellEditor;
                TableColumn tableColumn = JCTreeTable.this.getColumnModel().getColumn(0);
                this.editor = tableColumn.getCellEditor();
                if (this.editor == null && tableColumn instanceof JCTableColumn && (jCCellEditor = EditorRendererRegistry.getCentralRegistry().getCellEditorInstance(JCTreeTable.this.support.getTreeColumnClass(), ((JCTableColumn)tableColumn).getRegistryType())) != null) {
                    this.editor = new JCCellEditorToJTable(jCCellEditor);
                }
                if (this.editor == null) {
                    this.editor = JCTreeTable.this.getDefaultEditor(JCTreeTable.this.support.getTreeColumnClass());
                }
            }
            return this.editor;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.path = (TreePath)object;
            Component component = this.getEditor(jTable).getTableCellEditorComponent(jTable, JCTreeTable.this.support.getTreeColumnValue(this.path.getLastPathComponent()), bl, n, n2);
            if (component.getParent() != this) {
                this.add(component);
            }
            return this;
        }

        public boolean isCellEditable(EventObject eventObject) {
            return this.getEditor().isCellEditable(eventObject);
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.getEditor().removeCellEditorListener(cellEditorListener);
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return this.getEditor().shouldSelectCell(eventObject);
        }

        public boolean stopCellEditing() {
            return this.getEditor().stopCellEditing();
        }
    }

    class SwitchTableColumn
    extends JCTableColumn {
        public SwitchTableColumn(int n) {
            super(n);
            this.setHeaderRenderer(this.createDefaultHeaderRenderer());
        }

        protected TableCellRenderer createDefaultHeaderRenderer() {
            SwitchRenderer switchRenderer = new SwitchRenderer();
            return switchRenderer;
        }
    }

    static class SwitchRenderer
    extends JPanel
    implements TableCellRenderer,
    JCSortableTable.SortableColumnHeader {
        protected JButton switchButton;
        protected JLabel label = new JLabel("label");
        protected JButton sortButton = new JButton();
        protected JCBrace rightBrace = JCBrace.createHorizontalBrace(3);
        protected SwitchIcon icon = new SwitchIcon();

        public SwitchRenderer() {
            this.switchButton = new JButton(this.icon);
            JCElasticLayout jCElasticLayout = new JCElasticLayout(0);
            jCElasticLayout.setAlignment(0);
            this.setLayout(jCElasticLayout);
            this.sortButton.setBorder(emptyBorder);
            this.sortButton.setVerticalAlignment(0);
            this.switchButton.setBorder(emptyBorder);
            this.add(this.switchButton);
            this.add(new JSeparator(1));
            this.add((Component)this.label, JCElasticLayout.HORIZONTALLY_ELASTIC_CONSTRAINT);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JTableHeader jTableHeader;
            if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                this.label.setForeground(jTableHeader.getForeground());
                this.label.setBackground(jTableHeader.getBackground());
                this.label.setFont(jTableHeader.getFont());
            }
            this.label.setText(object == null ? "" : object.toString());
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }

        public void setSortIcon(Icon icon) {
            if (icon == null && this.sortButton.getParent() != null) {
                this.remove(this.sortButton);
                this.remove(this.rightBrace);
            } else if (icon != null) {
                this.sortButton.setIcon(icon);
                if (this.sortButton.getParent() == null) {
                    this.add(this.sortButton);
                    this.add(this.rightBrace);
                }
            }
        }

        protected void setView(int n) {
            this.icon.setView(n);
        }
    }

    static class SwitchIcon
    implements Icon,
    Serializable {
        protected int view = 1;

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(Color.black);
            if (this.view == 2) {
                int n3 = 0;
                while (n3 < 15) {
                    int n4 = 0;
                    while (n4 < 16) {
                        graphics.drawLine(n + n4, n2 + n3 + 1, n + n4 + 2, n2 + n3 + 1);
                        graphics.drawLine(n + n4, n2 + n3 + 1 + 1, n + n4 + 2, n2 + n3 + 1 + 1);
                        n4 += 4;
                    }
                    n3 += 3;
                }
            } else {
                int n5 = n2 + 1;
                graphics.drawLine(n, n5, n + 4 + 2, n5);
                graphics.drawLine(n, n5 + 1, n + 4 + 2, n5 + 1);
                graphics.drawLine(n + 3, n5 += 3, n + 4 + 2, n5);
                graphics.drawLine(n + 3, n5 + 1, n + 4 + 2, n5 + 1);
                graphics.drawLine(n + 3, n5 += 3, n + 4 + 2, n5);
                graphics.drawLine(n + 3, n5 + 1, n + 4 + 2, n5 + 1);
                graphics.drawLine(n, n5 += 3, n + 4 + 2, n5);
                graphics.drawLine(n, n5 + 1, n + 4 + 2, n5 + 1);
                int n6 = 0;
                while (n6 < 15) {
                    int n7 = 8;
                    while (n7 < 16) {
                        graphics.drawLine(n + n7, n2 + 1 + n6, n + n7 + 2, n2 + n6 + 1);
                        graphics.drawLine(n + n7, n2 + 1 + n6 + 1, n + n7 + 2, n2 + n6 + 1 + 1);
                        n7 += 4;
                    }
                    n6 += 3;
                }
            }
        }

        public void setView(int n) {
            this.view = n;
        }
    }

    protected static class EmptyTreeSelectionModel
    extends DefaultTreeTableSelectionModel {
        protected static EmptyTreeSelectionModel emptyModel = new EmptyTreeSelectionModel();

        protected EmptyTreeSelectionModel() {
        }

        public void addSelectionPaths(TreePath[] treePathArray) {
        }

        public static EmptyTreeSelectionModel getSharedInstance() {
            return emptyModel;
        }

        public void removeSelectionPaths(TreePath[] treePathArray) {
        }

        public void setSelectionPaths(TreePath[] treePathArray) {
        }
    }
}

