/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing.gauge;

import com.klg.jclass.swing.gauge.GaugeUtil;
import com.klg.jclass.swing.gauge.JCCircularScale;
import com.klg.jclass.swing.gauge.JCRange;
import com.klg.jclass.swing.gauge.JCScale;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.io.Serializable;

public class JCCircularRange
extends JCRange
implements Serializable {
    static final long serialVersionUID = -3410957533581346635L;
    protected int innerArcStartCompensator = 0;
    protected int innerArcStopCompensator = 0;

    public JCCircularRange(Color color, JCCircularScale jCCircularScale, double d, double d2, double d3, double d4) {
        super(color, jCCircularScale, d, d2, d3, d4);
    }

    private double computeControlPointFactor(double d) {
        double d2 = d / 2.0 / 180.0 * Math.PI;
        double d3 = 1.3333333333333333 * (1.0 - Math.cos(d2)) / Math.sin(d2);
        return d3;
    }

    public int getInnerArcStartCompensator() {
        return this.innerArcStartCompensator;
    }

    public int getInnerArcStopCompensator() {
        return this.innerArcStopCompensator;
    }

    public Dimension getPreferredSize() {
        return this.scale.getPreferredSize();
    }

    public void paintComponent(Graphics graphics) {
        double d;
        double d2;
        JCCircularScale jCCircularScale = (JCCircularScale)this.scale;
        double d3 = jCCircularScale.getMin();
        double d4 = jCCircularScale.getMax();
        double d5 = jCCircularScale.getRadius();
        double d6 = jCCircularScale.getStartAngle();
        double d7 = jCCircularScale.getStopAngle();
        double d8 = this.startValue;
        double d9 = this.stopValue;
        if (jCCircularScale.getDirection() == JCScale.Direction.CLOCKWISE) {
            double d10 = d8;
            d8 = d9;
            d9 = d10;
            d9 = d4 - d9 + d3;
            d8 = d4 - d8 + d3;
        }
        boolean bl = (d2 = GaugeUtil.valueToAngle(d8, d3, d4, d6, d7)) > (d = GaugeUtil.valueToAngle(d9, d3, d4, d6, d7));
        double d11 = Math.min(this.innerExtent, this.outerExtent) * d5;
        double d12 = Math.max(this.innerExtent, this.outerExtent) * d5;
        if (d2 >= d) {
            d += 360.0;
        }
        double d13 = d - d2;
        Graphics graphics2 = graphics.create();
        double d14 = (double)jCCircularScale.getGauge().getArcBounds().x + jCCircularScale.getRadius();
        double d15 = (double)jCCircularScale.getGauge().getArcBounds().y + jCCircularScale.getRadius();
        int n = (int)(d14 - d12);
        int n2 = (int)(d15 - d12);
        int n3 = (int)(2.0 * d12);
        int n4 = (int)(2.0 * d12);
        n = (int)((double)n + ((double)n3 - (double)n3 * jCCircularScale.getExtent()) / 2.0);
        n2 = (int)((double)n2 + ((double)n4 - (double)n4 * jCCircularScale.getExtent()) / 2.0);
        n3 = (int)((double)n3 * jCCircularScale.getExtent());
        n4 = (int)((double)n4 * jCCircularScale.getExtent());
        int n5 = (int)(d14 - d11);
        int n6 = (int)(d15 - d11);
        int n7 = (int)(2.0 * d11);
        int n8 = (int)(2.0 * d11);
        n5 = (int)((double)n5 + ((double)n7 - (double)n7 * jCCircularScale.getExtent()) / 2.0);
        n6 = (int)((double)n6 + ((double)n8 - (double)n8 * jCCircularScale.getExtent()) / 2.0);
        n7 = (int)((double)n7 * jCCircularScale.getExtent());
        n8 = (int)((double)n8 * jCCircularScale.getExtent());
        Graphics2D graphics2D = (Graphics2D)graphics2;
        int n9 = Math.abs(n2 - n6);
        graphics2D.setStroke(new BasicStroke(n9));
        GeneralPath generalPath = this.traceArcPath(d14 * 2.0 - d14, d15, n3 / 2, n4 / 2, -d2, -d13);
        generalPath.lineTo((int)(d14 * 2.0 - d14), (int)d15);
        generalPath.closePath();
        graphics2D.clip(generalPath);
        graphics2D.draw(new Arc2D.Double(n + (n5 - n) / 2, n2 + (n6 - n2) / 2, n4 - (n4 - n8) / 2, n4 - (n4 - n8) / 2, d2, d - d2, 0));
        graphics2.dispose();
    }

    public void redraw() {
        if (((JCCircularScale)this.scale).getGauge().getRepaintEnabled()) {
            this.repaint();
        }
    }

    public void setInnerArcStartCompensator(int n) {
        this.innerArcStartCompensator = n;
        this.redraw();
    }

    public void setInnerArcStopCompensator(int n) {
        this.innerArcStopCompensator = n;
        this.redraw();
    }

    private GeneralPath traceArcPath(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8;
        double d9;
        GeneralPath generalPath = new GeneralPath();
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = 0.0;
        double d18 = d6 < 0.0 ? (d5 + d6) / 180.0 * Math.PI : d5 / 180.0 * Math.PI;
        d10 = d + d3 * Math.cos(d18);
        d14 = d2 + d4 * Math.sin(d18);
        generalPath.moveTo((float)d10, (float)d14);
        if (Math.abs(d6) < 0.001) {
            d18 = (d5 + d6) / 180.0 * Math.PI;
            d10 = d + d3 * Math.cos(d18);
            d14 = d2 + d4 * Math.sin(d18);
        }
        if (d6 < 0.0) {
            d5 += d6;
            d6 = -d6;
        }
        double d19 = 0.5522848 * d3;
        double d20 = 0.5522848 * d4;
        d18 = d5 / 180.0 * Math.PI;
        d10 = d + d3 * Math.cos(d18);
        d14 = d2 + d4 * Math.sin(d18);
        double d21 = (int)d5 / 90 * 90;
        if (Math.abs(d21 - d5) > 0.001) {
            if (d5 > 0.0) {
                d21 += 90.0;
            }
            if ((d9 = d5 + d6) > d21) {
                d9 = d21;
            }
            d18 = d9 / 180.0 * Math.PI;
            d13 = d + d3 * Math.cos(d18);
            d17 = d2 + d4 * Math.sin(d18);
            d8 = d9 - d5;
            d7 = this.computeControlPointFactor(d8);
            d11 = d10 - d7 * (d14 - d2);
            d15 = d14 + d7 * (d10 - d);
            d12 = d13 + d7 * (d17 - d2);
            d16 = d17 - d7 * (d13 - d);
            generalPath.curveTo((float)d11, (float)d15, (float)d12, (float)d16, (float)d13, (float)d17);
            d10 = d13;
            d14 = d17;
        }
        d9 = d5 + d6;
        while (d21 + 90.0 <= d9) {
            int n = (int)d21 % 360;
            if (n == 0) {
                d11 = 0.0;
                d15 = d20;
                d12 = d19;
                d16 = 0.0;
            } else if (n == 90 || n == -270) {
                d11 = -d19;
                d15 = 0.0;
                d12 = 0.0;
                d16 = d20;
            } else if (n == 180 || n == -180) {
                d11 = 0.0;
                d15 = -d20;
                d12 = -d19;
                d16 = 0.0;
            } else if (n == 270 || n == -90) {
                d11 = d19;
                d15 = 0.0;
                d12 = 0.0;
                d16 = -d20;
            }
            d18 = (d21 += 90.0) / 180.0 * Math.PI;
            d13 = d + d3 * Math.cos(d18);
            d17 = d2 + d4 * Math.sin(d18);
            generalPath.curveTo((float)(d11 += d10), (float)(d15 += d14), (float)(d12 += d13), (float)(d16 += d17), (float)d13, (float)d17);
            d10 = d13;
            d14 = d17;
        }
        if (d21 < d9 && Math.abs(d21 - d9) > 0.001) {
            d18 = d9 / 180.0 * Math.PI;
            d13 = d + d3 * Math.cos(d18);
            d17 = d2 + d4 * Math.sin(d18);
            d8 = d9 - d21;
            d7 = this.computeControlPointFactor(d8);
            d11 = d10 - d7 * (d14 - d2);
            d15 = d14 + d7 * (d10 - d);
            d12 = d13 + d7 * (d17 - d2);
            d16 = d17 - d7 * (d13 - d);
            generalPath.curveTo((float)d11, (float)d15, (float)d12, (float)d16, (float)d13, (float)d17);
            d10 = d13;
            d14 = d17;
        }
        return generalPath;
    }
}

