/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing.gauge;

import com.klg.jclass.swing.gauge.GaugeUtil;
import com.klg.jclass.swing.gauge.JCCircularGauge;
import com.klg.jclass.swing.gauge.JCCircularScale;
import com.klg.jclass.swing.gauge.JCNeedleStyle;
import com.klg.jclass.swing.gauge.JCScale;
import com.klg.jclass.util.JCListenerList;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JCNeedle
extends JComponent {
    static final long serialVersionUID = 3535895026693348240L;
    protected double needleWidth = 15.0;
    protected JCCircularGauge gauge;
    protected JCListenerList changeListeners = null;
    protected ChangeEvent changeEvent = new ChangeEvent(this);
    protected boolean sendEvents = true;
    protected InteractionType interactionType = InteractionType.NONE;
    protected double length = 1.0;
    protected JCNeedleStyle needleStyle = JCNeedleStyle.ARROW;
    protected double value;

    public JCNeedle(JCCircularGauge jCCircularGauge) {
        this.gauge = jCCircularGauge;
        if (jCCircularGauge.getScale() != null) {
            this.value = jCCircularGauge.getScale().getMin();
        }
    }

    public JCNeedle(Color color, double d, JCCircularGauge jCCircularGauge, InteractionType interactionType, boolean bl, double d2, JCNeedleStyle jCNeedleStyle, double d3) {
        this.needleWidth = d;
        this.gauge = jCCircularGauge;
        this.interactionType = interactionType;
        this.length = d2;
        this.needleStyle = jCNeedleStyle;
        this.value = d3;
        this.setForeground(color);
        this.setVisible(bl);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners = JCListenerList.add(this.changeListeners, changeListener);
    }

    public JCCircularGauge getGauge() {
        return this.gauge;
    }

    public InteractionType getInteractionType() {
        return this.interactionType;
    }

    public double getLength() {
        return this.length;
    }

    public JCNeedleStyle getNeedleStyle() {
        return this.needleStyle;
    }

    public double getNeedleWidth() {
        return this.needleWidth;
    }

    public Dimension getPreferredSize() {
        return this.gauge.getGaugeArea().getPreferredSize();
    }

    public boolean getSendEvents() {
        return this.sendEvents;
    }

    public double getValue() {
        return this.value;
    }

    public void paint(Graphics graphics) {
        if (this.isVisible()) {
            JCCircularScale jCCircularScale = this.gauge.getScale();
            double d = jCCircularScale.getRadius() * this.length;
            double d2 = d / (double)(this.needleStyle.getExtrema().x - this.needleStyle.getExtrema().width);
            double d3 = this.needleWidth / (double)(this.needleStyle.getExtrema().y - this.needleStyle.getExtrema().height);
            Polygon polygon = GaugeUtil.scale(this.needleStyle, Math.abs(d2), Math.abs(d3));
            double d4 = this.value;
            if (this.gauge.getScale().getDirection() == JCScale.Direction.CLOCKWISE) {
                d4 = this.gauge.getScale().getMax() - this.value + this.gauge.getScale().getMin();
            }
            double d5 = GaugeUtil.valueToAngle(d4, jCCircularScale.getMin(), jCCircularScale.getMax(), jCCircularScale.getStartAngle(), jCCircularScale.getStopAngle());
            Polygon polygon2 = GaugeUtil.rotate(polygon, d5);
            double d6 = (double)jCCircularScale.getGauge().getArcBounds().x + jCCircularScale.getRadius();
            double d7 = (double)jCCircularScale.getGauge().getArcBounds().y + jCCircularScale.getRadius();
            Graphics graphics2 = graphics.create();
            graphics2.setColor(this.getForeground());
            graphics2.translate((int)d6, (int)d7);
            graphics2.fillPolygon(polygon2);
            graphics2.dispose();
        }
    }

    public void redraw() {
        if (this.gauge.getRepaintEnabled()) {
            this.repaint();
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners = JCListenerList.remove(this.changeListeners, changeListener);
    }

    public void sendChangeEvent(ChangeEvent changeEvent) {
        Enumeration enumeration = JCListenerList.elements(this.changeListeners);
        while (enumeration.hasMoreElements()) {
            ((ChangeListener)enumeration.nextElement()).stateChanged(changeEvent);
        }
    }

    public void setGauge(JCCircularGauge jCCircularGauge) {
        this.gauge = jCCircularGauge;
    }

    public void setInteractionType(InteractionType interactionType) {
        this.interactionType = interactionType;
    }

    public void setLength(double d) {
        this.length = d;
        this.redraw();
    }

    public void setNeedleStyle(JCNeedleStyle jCNeedleStyle) {
        this.needleStyle = jCNeedleStyle;
        this.redraw();
    }

    public void setNeedleWidth(double d) {
        this.needleWidth = d;
        this.redraw();
    }

    public void setSendEvents(boolean bl) {
        this.sendEvents = bl;
    }

    public void setValue(double d) {
        if (this.value != d) {
            this.value = d;
            if (this.sendEvents) {
                this.sendChangeEvent(this.changeEvent);
            }
            this.redraw();
        }
    }

    public static class InteractionType
    implements Serializable {
        public static final InteractionType NONE = new InteractionType();
        public static final InteractionType DRAG = new InteractionType();
        public static final InteractionType CLICK = new InteractionType();
        public static final InteractionType CLICK_DRAG = new InteractionType();

        private InteractionType() {
        }
    }
}

