/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.formulae;

import com.klg.jclass.util.formulae.Expression;
import com.klg.jclass.util.formulae.ExpressionList;
import com.klg.jclass.util.formulae.ExpressionReference;
import com.klg.jclass.util.formulae.MathExpressionList;
import com.klg.jclass.util.formulae.MathScalar;
import com.klg.jclass.util.formulae.MathValue;
import com.klg.jclass.util.formulae.OperandMismatchException;
import com.klg.jclass.util.formulae.Operation;
import com.klg.jclass.util.formulae.Result;
import java.util.Iterator;

public class Remainder
extends Operation {
    public Remainder(Expression expression, Expression expression2) {
        super(expression, expression2);
    }

    public Remainder(Expression expression, Number number) {
        super(expression, number);
    }

    public Remainder(Number number, Expression expression) {
        super(number, expression);
    }

    public Remainder(Number number, Number number2) {
        super(number, number2);
    }

    private MathValue doRemainder(MathValue mathValue, MathValue mathValue2) {
        if (mathValue instanceof MathScalar && mathValue2 instanceof MathScalar) {
            MathScalar mathScalar = (MathScalar)mathValue;
            MathScalar mathScalar2 = (MathScalar)mathValue2;
            Number number = this.remainderSimple(mathScalar.realValue, mathScalar2.realValue);
            return new MathScalar(number);
        }
        throw new OperandMismatchException("Cannot compute remainders from a vector or a matrix");
    }

    public Result evaluate() {
        if (this.leftOperand == null || this.rightOperand == null) {
            throw new IllegalArgumentException("Remainder must have two operands");
        }
        return this.getResult(this.leftOperand, this.rightOperand);
    }

    private Result getResult(Expression expression, Expression expression2) {
        if (expression instanceof Operation || expression instanceof ExpressionReference) {
            expression = expression.evaluate();
        }
        if (expression2 instanceof Operation || expression instanceof ExpressionReference) {
            expression2 = expression2.evaluate();
        }
        if (expression instanceof MathValue && expression2 instanceof MathValue) {
            MathValue mathValue = (MathValue)expression;
            MathValue mathValue2 = (MathValue)expression2;
            return this.doRemainder(mathValue, mathValue2);
        }
        if (expression instanceof ExpressionList && expression2 instanceof ExpressionList) {
            ExpressionList expressionList = (ExpressionList)expression;
            ExpressionList expressionList2 = (ExpressionList)expression2;
            if (expressionList.size() != expressionList2.size()) {
                throw new OperandMismatchException("Remainder:  Cannot use lists of different sizes");
            }
            Iterator iterator = expressionList.iterator();
            Iterator iterator2 = expressionList2.iterator();
            MathExpressionList mathExpressionList = new MathExpressionList();
            while (iterator.hasNext()) {
                Expression expression3 = (Expression)iterator.next();
                Expression expression4 = (Expression)iterator2.next();
                ((ExpressionList)mathExpressionList).add(this.getResult(expression3, expression4));
            }
            return mathExpressionList;
        }
        if (expression instanceof MathValue && expression2 instanceof ExpressionList) {
            ExpressionList expressionList = (ExpressionList)expression2;
            Iterator iterator = expressionList.iterator();
            MathExpressionList mathExpressionList = new MathExpressionList();
            while (iterator.hasNext()) {
                Expression expression5 = (Expression)iterator.next();
                ((ExpressionList)mathExpressionList).add(this.getResult(expression, expression5));
            }
            return mathExpressionList;
        }
        if (expression instanceof ExpressionList && expression2 instanceof MathValue) {
            ExpressionList expressionList = (ExpressionList)expression;
            Iterator iterator = expressionList.iterator();
            MathExpressionList mathExpressionList = new MathExpressionList();
            while (iterator.hasNext()) {
                Expression expression6 = (Expression)iterator.next();
                ((ExpressionList)mathExpressionList).add(this.getResult(expression6, expression2));
            }
            return mathExpressionList;
        }
        throw new OperandMismatchException("Remainder:  Cannot divide given data types");
    }

    private Number remainderSimple(Number number, Number number2) {
        if (number instanceof Double || number2 instanceof Double) {
            int n = (int)(number.doubleValue() / number2.doubleValue());
            return new Double(number.doubleValue() - number2.doubleValue() * (double)n);
        }
        int n = number.intValue() / number2.intValue();
        return new Integer(number.intValue() - number2.intValue() * n);
    }
}

