/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.formulae;

import com.klg.jclass.table.TableDataModel;
import com.klg.jclass.util.formulae.Expression;
import com.klg.jclass.util.formulae.ExpressionList;
import com.klg.jclass.util.formulae.MathMatrix;
import com.klg.jclass.util.formulae.MathScalar;
import com.klg.jclass.util.formulae.MathValue;
import com.klg.jclass.util.formulae.MathVector;
import com.klg.jclass.util.formulae.Result;
import com.klg.jclass.util.formulae.TableExpressionListIterator;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class TableExpressionList
extends ExpressionList {
    protected TableDataModel tableData;
    protected Expression startRow;
    protected Expression endRow;
    protected Expression startColumn;
    protected Expression endColumn;
    protected Rectangle range;

    public TableExpressionList(TableDataModel tableDataModel, Expression expression, Expression expression2, Expression expression3, Expression expression4) {
        this.tableData = tableDataModel;
        this.range = this.computeRange(expression, expression3, expression2, expression4);
        this.startRow = expression;
        this.endRow = expression2;
        this.startColumn = expression3;
        this.endColumn = expression4;
    }

    public TableExpressionList(TableDataModel tableDataModel, Rectangle rectangle) {
        this.tableData = tableDataModel;
        this.checkRange(rectangle);
        this.range = rectangle;
        this.startRow = new MathScalar(rectangle.y);
        this.endRow = new MathScalar(rectangle.y + rectangle.height - 1);
        this.startColumn = new MathScalar(rectangle.x);
        this.endColumn = new MathScalar(rectangle.x + rectangle.width - 1);
    }

    private void checkRange(Rectangle rectangle) {
        if (rectangle.x < 0 || rectangle.width < 0 || rectangle.x + rectangle.width > this.tableData.getNumColumns()) {
            throw new IllegalArgumentException("Column selection is out of range");
        }
        if (rectangle.y < 0 || rectangle.height < 0 || rectangle.y + rectangle.height > this.tableData.getNumRows()) {
            throw new IllegalArgumentException("Row selection is out of range");
        }
    }

    public Object clone() {
        TableExpressionList tableExpressionList;
        try {
            tableExpressionList = (TableExpressionList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        if (this.startRow != null) {
            try {
                tableExpressionList.startRow = (Expression)this.startRow.evaluate().clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                tableExpressionList.startRow = new MathScalar(0);
            }
        }
        if (this.startColumn != null) {
            try {
                tableExpressionList.startColumn = (Expression)this.startColumn.evaluate().clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                tableExpressionList.startColumn = new MathScalar(0);
            }
        }
        if (this.endRow != null) {
            try {
                tableExpressionList.endRow = (Expression)this.endRow.evaluate().clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                tableExpressionList.endRow = new MathScalar(0);
            }
        }
        if (this.endColumn != null) {
            try {
                tableExpressionList.endColumn = (Expression)this.endColumn.evaluate().clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                tableExpressionList.endColumn = new MathScalar(0);
            }
        }
        if (this.range != null) {
            tableExpressionList.range = new Rectangle(this.range);
        }
        return tableExpressionList;
    }

    private Rectangle computeRange(Expression expression, Expression expression2, Expression expression3, Expression expression4) {
        try {
            int n = ((MathValue)expression2.evaluate()).numberValue().intValue();
            int n2 = ((MathValue)expression4.evaluate()).numberValue().intValue();
            int n3 = ((MathValue)expression.evaluate()).numberValue().intValue();
            int n4 = ((MathValue)expression3.evaluate()).numberValue().intValue();
            Rectangle rectangle = new Rectangle(n, n3, n2 - n + 1, n4 - n3 + 1);
            this.checkRange(rectangle);
            return rectangle;
        }
        catch (ArithmeticException arithmeticException) {
            return null;
        }
    }

    public boolean contains(Object object) {
        return false;
    }

    protected Expression copy(boolean bl) {
        if (bl) {
            this.range = this.computeRange(this.startRow, this.startColumn, this.endRow, this.endColumn);
        }
        if (!bl || this.range == null) {
            return new TableExpressionList(this.tableData, this.startRow, this.endRow, this.startColumn, this.endColumn);
        }
        return new TableExpressionList(this.tableData, this.range);
    }

    private Object encapsulateValue(Object object) {
        if (object instanceof Expression) {
            return object;
        }
        if (object instanceof Number) {
            return new MathScalar((Number)object);
        }
        if (object instanceof Number[]) {
            return new MathVector((Number[])object);
        }
        if (object instanceof Number[][]) {
            return new MathMatrix((Number[][])object);
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.indexOf(46) >= -1) {
                return new MathScalar(Double.valueOf(string));
            }
            return new MathScalar(Integer.valueOf(string));
        }
        throw new ClassCastException("Cannot return \"" + object + "\" as a MathValue");
    }

    public boolean equals(Object object) {
        if (!(object instanceof TableExpressionList)) {
            return false;
        }
        TableExpressionList tableExpressionList = (TableExpressionList)object;
        if (tableExpressionList.tableData != this.tableData) {
            return false;
        }
        if (this.range != null) {
            return this.range.equals(tableExpressionList.range);
        }
        return this.startColumn == tableExpressionList.startColumn && this.endColumn == tableExpressionList.endColumn && this.startRow == tableExpressionList.startRow && this.endRow == tableExpressionList.endRow;
    }

    public Object get(int n) {
        this.updateRange();
        if (n < 0 || this.range.height == 1 && n >= this.range.width || this.range.width == 1 && n >= this.range.height) {
            throw new ArrayIndexOutOfBoundsException("Index is outside the table Expression's range");
        }
        if (this.range.height == 1) {
            Object object = this.tableData.getTableDataItem(this.range.y, this.range.x + n);
            return this.encapsulateValue(object);
        }
        if (this.range.width == 1) {
            Object object = this.tableData.getTableDataItem(this.range.y + n, this.range.x);
            return this.encapsulateValue(object);
        }
        return new TableExpressionList(this.tableData, new Rectangle(this.range.x, this.range.y + n, this.range.width, 1));
    }

    public Expression getEndColumn() {
        return this.endColumn;
    }

    public Expression getEndRow() {
        return this.endRow;
    }

    public Rectangle getRange() {
        if (this.range == null) {
            return this.computeRange(this.startRow, this.startColumn, this.endRow, this.endColumn);
        }
        return new Rectangle(this.range);
    }

    public Expression getStartColumn() {
        return this.startColumn;
    }

    public Expression getStartRow() {
        return this.startRow;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public int indexOf(Object object) {
        return -1;
    }

    public Iterator iterator() {
        return this.listIterator(0);
    }

    public int lastIndexOf(Object object) {
        return -1;
    }

    public ListIterator listIterator(int n) {
        this.updateRange();
        return new TableExpressionListIterator(this, n);
    }

    public void setEndColumn(Expression expression) {
        this.range = this.computeRange(this.startRow, this.startColumn, this.endRow, expression);
        this.endColumn = expression;
    }

    public void setEndRow(Expression expression) {
        this.range = this.computeRange(this.startRow, this.startColumn, expression, this.endColumn);
        this.endRow = expression;
    }

    public void setRange(Rectangle rectangle) {
        this.checkRange(rectangle);
        this.range = new Rectangle(rectangle);
        this.startRow = new MathScalar(this.range.y);
        this.endRow = new MathScalar(this.range.y + this.range.height - 1);
        this.startColumn = new MathScalar(this.range.x);
        this.endColumn = new MathScalar(this.range.x + this.range.width - 1);
    }

    public void setStartColumn(Expression expression) {
        this.range = this.computeRange(this.startRow, expression, this.endRow, this.endColumn);
        this.startColumn = expression;
    }

    public void setStartRow(Expression expression) {
        this.range = this.computeRange(expression, this.startColumn, this.endRow, this.endColumn);
        this.startRow = expression;
    }

    public int size() {
        this.updateRange();
        if (this.range.height > 1) {
            return this.range.height;
        }
        return this.range.width;
    }

    public List subList(int n, int n2) {
        if (n < 0 || n2 < n) {
            throw new ArrayIndexOutOfBoundsException("start must be non-negative and range must be increasing");
        }
        this.updateRange();
        if (this.range.height > 1) {
            if (n2 >= this.range.height) {
                throw new ArrayIndexOutOfBoundsException("end index past the end of the List");
            }
            return new TableExpressionList(this.tableData, new Rectangle(this.range.x, this.range.y + n, this.range.width, n2 - n));
        }
        if (n2 >= this.range.width) {
            throw new ArrayIndexOutOfBoundsException("end index past the end of the List");
        }
        return new TableExpressionList(this.tableData, new Rectangle(this.range.x + n, this.range.y, n2 - n, this.range.height));
    }

    public Object[] toArray(Object[] objectArray) {
        this.updateRange();
        if (this.range.width == 1) {
            int n = 0;
            while (n < this.range.height) {
                objectArray[n] = this.tableData.getTableDataItem(this.range.y + n, this.range.x);
                ++n;
            }
        } else if (this.range.height == 1) {
            int n = 0;
            while (n < this.range.width) {
                objectArray[n] = this.tableData.getTableDataItem(this.range.y, this.range.x + n);
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.range.height) {
                objectArray[n] = new TableExpressionList(this.tableData, new Rectangle(this.range.x, this.range.y + n, this.range.width, 1));
                ++n;
            }
        }
        return objectArray;
    }

    private void updateRange() {
        if (this.range != null) {
            return;
        }
        this.range = this.computeRange(this.startRow, this.startColumn, this.endRow, this.endColumn);
        if (this.range == null) {
            Result result = this.startRow.evaluate();
            Result result2 = this.startColumn.evaluate();
            Result result3 = this.endRow.evaluate();
            Result result4 = this.endColumn.evaluate();
        }
    }
}

