/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dialogs.normalization;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class RatioStatsNormInitDialog
extends AlgorithmDialog {
    private JComboBox ciComboBox;
    private int result = 2;
    private final String[] CI_VALUES = new String[]{"95%", "99%"};

    public RatioStatsNormInitDialog() {
        super(new JFrame(), "Ratio Statistics Normalization", true);
        this.ciComboBox = new JComboBox<String>(this.CI_VALUES);
        this.ciComboBox.setEditable(false);
        this.ciComboBox.setSelectedIndex(0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.white);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Confidence Interval"));
        jPanel.add((Component)this.ciComboBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(30, 0, 30, 0), 0, 0));
        this.addContent(jPanel);
        this.setActionListeners(new Listener());
        this.setSize(new Dimension(450, 220));
        this.setResizable(false);
        this.pack();
    }

    public int getCI() {
        int n = 0;
        String string = (String)this.ciComboBox.getSelectedItem();
        string = string.substring(0, 2);
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        this.dispose();
        return this.result;
    }

    public static void main(String[] stringArray) {
        RatioStatsNormInitDialog ratioStatsNormInitDialog = new RatioStatsNormInitDialog();
        ratioStatsNormInitDialog.show();
        System.out.println("ci = " + ratioStatsNormInitDialog.getCI());
        System.exit(0);
    }

    public class Listener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                RatioStatsNormInitDialog.this.result = 0;
                RatioStatsNormInitDialog.this.dispose();
            } else if (string.equals("reset-command")) {
                RatioStatsNormInitDialog.this.ciComboBox.setSelectedIndex(0);
            } else if (string.equals("cancel-command")) {
                RatioStatsNormInitDialog.this.result = 2;
                RatioStatsNormInitDialog.this.dispose();
            } else if (string.equals("info-command")) {
                HelpWindow helpWindow = new HelpWindow(RatioStatsNormInitDialog.this, "Ratio Statistics Initialization Dialog");
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 420);
                    helpWindow.setLocation();
                    helpWindow.show();
                } else {
                    helpWindow.setVisible(false);
                    helpWindow.dispose();
                }
            }
        }
    }
}

