/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ease.gotree;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.DecimalFormat;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.gui.helpers.ktree.ITreeNode;
import org.tigr.microarray.mev.cluster.gui.helpers.ktree.ITreeNodeRenderer;
import org.tigr.microarray.mev.cluster.gui.helpers.ktree.KNodeImpl;

public class GONode
extends KNodeImpl
implements ITreeNodeRenderer,
Serializable {
    public static final long serialVersionUID = 20200201020001L;
    private String goID;
    private String goTerm;
    private String goCategory;
    private double pValue;
    private int listHits;
    private int listSize;
    private int popHits;
    private int popSize;
    private double lowerThr;
    private double upperThr;
    private int clusterIndex = -1;
    private int renderingHint;
    private int VERBOSE_HEIGHT = 130;
    private int VERBOSE_WIDTH = 125;
    private int NON_VERBOSE_HEIGHT = 15;
    private int NON_VERBOSE_WIDTH = 15;
    private int GO_ID_HEIGHT = 20;
    private int GO_TERM_HEIGHT = 70;
    private int GO_STAT_HEIGHT = 20;
    private int GO_POP_HEIGHT = 20;

    public GONode(String string, String string2, String string3, double d, int n, int n2, int n3, int n4, int n5) {
        this.goID = string;
        this.goTerm = string2;
        this.goCategory = string3;
        this.pValue = d;
        this.listHits = n;
        this.listSize = n2;
        this.popHits = n3;
        this.popSize = n4;
        this.clusterIndex = n5;
    }

    public GONode(GONode gONode) {
        this.goID = gONode.getGOID();
        this.goTerm = gONode.getTerm();
        this.goCategory = gONode.getCategory();
        this.pValue = gONode.getPValue();
        this.listHits = gONode.getListHits();
        this.listSize = gONode.getListSize();
        this.popHits = gONode.getPopHits();
        this.popSize = gONode.getPopSize();
        this.upperThr = gONode.getUpperThr();
        this.lowerThr = gONode.getLowerThr();
        this.children = gONode.getChildren();
        this.parents = gONode.getParents();
        this.level = gONode.getLevel();
        this.verboseRendering = gONode.isVerboseRendering();
        this.clusterIndex = gONode.getClusterIndex();
    }

    public String getTerm() {
        return this.goTerm;
    }

    public String getGOID() {
        return this.goID;
    }

    public double getPValue() {
        return this.pValue;
    }

    public String getCategory() {
        return this.goCategory;
    }

    public int getListHits() {
        return this.listHits;
    }

    public int getListSize() {
        return this.listSize;
    }

    public int getPopHits() {
        return this.popHits;
    }

    public int getPopSize() {
        return this.popSize;
    }

    public void setTerm(String string) {
        this.goTerm = string;
    }

    public void setListHits(int n) {
        this.listHits = n;
    }

    public void setListSize(int n) {
        this.listSize = n;
    }

    public void setPopHits(int n) {
        this.popHits = n;
    }

    public void setPopSize(int n) {
        this.popSize = n;
    }

    public void setLowerThr(double d) {
        this.lowerThr = d;
    }

    public void setUpperThr(double d) {
        this.upperThr = d;
    }

    public double getLowerThr() {
        return this.lowerThr;
    }

    public double getUpperThr() {
        return this.upperThr;
    }

    public int getClusterIndex() {
        return this.clusterIndex;
    }

    public void addChild(GONode gONode) {
        super.addChild((ITreeNode)gONode);
    }

    public void addParent(GONode gONode) {
        super.addParent((ITreeNode)gONode);
    }

    public void setRenderingHint(int n) {
        this.renderingHint = n;
        this.setDimensions();
    }

    public void renderNode(Graphics2D graphics2D, int n, int n2, int n3) {
        Color color = graphics2D.getColor();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Composite composite = graphics2D.getComposite();
        if (n3 == 3) {
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.3f);
            graphics2D.setComposite(alphaComposite);
        }
        int n4 = 0;
        this.x = n;
        this.y = n2;
        if (this.verboseRendering) {
            String string;
            this.x = n;
            this.y = n2;
            graphics2D.drawRect(n, n2, this.w, this.h);
            graphics2D.drawRect(n + 1, n2 + ++n4, this.w - 2, this.h - 2);
            if (this.pValue > this.upperThr) {
                graphics2D.setColor(Color.green);
            } else if (this.pValue <= this.upperThr && this.pValue > this.lowerThr) {
                graphics2D.setColor(Color.orange);
            } else {
                graphics2D.setColor(Color.red);
            }
            graphics2D.fillRect(n + 2, n2 + ++n4, this.w - 3, this.GO_ID_HEIGHT);
            graphics2D.setColor(color);
            TextLayout textLayout = new TextLayout(this.goID, graphics2D.getFont(), graphics2D.getFontRenderContext());
            textLayout.draw(graphics2D, (float)n + ((float)this.w - textLayout.getAdvance()) / 2.0f, (float)n2 + textLayout.getAscent() + ((float)this.GO_ID_HEIGHT - textLayout.getAscent()) / 2.0f);
            graphics2D.drawLine(n, n2 + (n4 += this.GO_ID_HEIGHT), n + this.w, n2 + n4);
            int n5 = n2 + n4 + 2;
            int n6 = n + 6;
            this.renderGoTermText(graphics2D, n6, n5);
            graphics2D.drawLine(n, n2 + this.GO_TERM_HEIGHT + n4, n + this.w, n2 + this.GO_TERM_HEIGHT + n4);
            n4 += this.GO_TERM_HEIGHT;
            if (this.pValue < 1.0E-4) {
                DecimalFormat decimalFormat = new DecimalFormat("0.#####E00");
                string = decimalFormat.format(this.pValue);
            } else {
                DecimalFormat decimalFormat = new DecimalFormat("0.#####");
                string = decimalFormat.format(this.pValue);
            }
            textLayout = new TextLayout("p = " + string, graphics2D.getFont(), graphics2D.getFontRenderContext());
            textLayout.draw(graphics2D, (float)n + ((float)this.w - textLayout.getAdvance()) / 2.0f, (float)(n2 + n4) + textLayout.getAscent() + ((float)this.GO_STAT_HEIGHT - textLayout.getAscent()) / 2.0f);
            graphics2D.drawLine(n, n2 + this.GO_STAT_HEIGHT + n4, n + this.w, n2 + this.GO_STAT_HEIGHT + n4);
            textLayout = new TextLayout("(" + String.valueOf(this.listHits) + ")   (" + String.valueOf(this.popHits) + ")", graphics2D.getFont(), graphics2D.getFontRenderContext());
            textLayout.draw(graphics2D, (float)n + ((float)this.w - textLayout.getAdvance()) / 2.0f, (float)(n2 + (n4 += this.GO_STAT_HEIGHT)) + textLayout.getAscent() + ((float)this.GO_POP_HEIGHT - textLayout.getAscent()) / 2.0f - 2.0f);
            if (n3 == 1) {
                graphics2D.setColor(Color.red);
                graphics2D.drawRect(n - 3, n2 - 3, this.w + 6, this.h + 6);
                graphics2D.drawRect(n - 2, n2 - 2, this.w + 4, this.h + 4);
                graphics2D.setColor(color);
            } else if (n3 == 2) {
                graphics2D.setColor(Color.blue);
                graphics2D.drawRect(n - 3, n2 - 3, this.w + 6, this.h + 6);
                graphics2D.drawRect(n - 2, n2 - 2, this.w + 4, this.h + 4);
                graphics2D.setColor(color);
            }
        } else {
            if (this.pValue > this.upperThr) {
                graphics2D.setColor(Color.green);
            } else if (this.pValue <= this.upperThr && this.pValue > this.lowerThr) {
                graphics2D.setColor(Color.orange);
            } else {
                graphics2D.setColor(Color.red);
            }
            graphics2D.fillOval(n, n2, this.w, this.h);
            graphics2D.setColor(Color.black);
            graphics2D.drawOval(n, n2, this.w, this.h);
            graphics2D.setColor(color);
            if (n3 == 1) {
                graphics2D.setColor(Color.red);
                graphics2D.drawOval(n - 3, n2 - 3, this.w + 6, this.h + 6);
                graphics2D.drawOval(n - 2, n2 - 2, this.w + 4, this.h + 4);
                graphics2D.setColor(color);
            } else if (n3 == 2) {
                graphics2D.setColor(Color.blue);
                graphics2D.drawOval(n - 3, n2 - 3, this.w + 6, this.h + 6);
                graphics2D.drawOval(n - 2, n2 - 2, this.w + 4, this.h + 4);
                graphics2D.setColor(color);
            }
        }
        graphics2D.setComposite(composite);
    }

    private void renderPVaue(Graphics2D graphics2D, int n) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(5);
        decimalFormat.setMaximumIntegerDigits(1);
        decimalFormat.setMinimumIntegerDigits(1);
        decimalFormat.setMinimumFractionDigits(4);
        String string = decimalFormat.format(this.pValue);
        TextLayout textLayout = new TextLayout("p = " + string, graphics2D.getFont(), graphics2D.getFontRenderContext());
        textLayout.draw(graphics2D, (float)this.x + ((float)this.w - textLayout.getAdvance()) / 2.0f, (float)(this.y + n) + textLayout.getAscent() + ((float)this.GO_STAT_HEIGHT - textLayout.getAscent()) / 2.0f);
    }

    private void renderGoTermText(Graphics2D graphics2D, int n, int n2) {
        Point2D.Float float_;
        TextLayout textLayout;
        AttributedString attributedString = new AttributedString(this.goTerm);
        attributedString.addAttribute(TextAttribute.JUSTIFICATION, TextAttribute.JUSTIFICATION_NONE);
        attributedString.addAttribute(TextAttribute.FONT, new Font("Arial", 0, 12));
        int n3 = graphics2D.getFontMetrics().stringWidth(this.goTerm);
        if (n3 > 4 * this.w) {
            attributedString.addAttribute(TextAttribute.FONT, new Font("Arial", 0, 11));
        }
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
        Vector<TextLayout> vector = new Vector<TextLayout>();
        Vector<Point2D.Float> vector2 = new Vector<Point2D.Float>();
        while (lineBreakMeasurer.getPosition() < attributedCharacterIterator.getEndIndex()) {
            textLayout = lineBreakMeasurer.nextLayout(this.w - 10);
            n2 = (int)((float)n2 + textLayout.getAscent());
            float_ = new Point2D.Float(n, n2);
            if (vector.size() > 0) {
                TextLayout textLayout2 = (TextLayout)vector.elementAt(vector.size() - 1);
                textLayout2 = textLayout2.getJustifiedLayout(this.w - 10);
                vector.setElementAt(textLayout2, vector.size() - 1);
            }
            vector2.addElement(float_);
            vector.addElement(textLayout);
            n2 = (int)((float)n2 + (textLayout.getDescent() + textLayout.getLeading()));
        }
        for (int i = 0; i < vector.size(); ++i) {
            textLayout = (TextLayout)vector.elementAt(i);
            float_ = (Point2D.Float)vector2.elementAt(i);
            textLayout.draw(graphics2D, float_.x, float_.y);
        }
    }

    private void setDimensions() {
        if (this.renderingHint == 0) {
            this.w = this.VERBOSE_WIDTH;
            this.h = this.VERBOSE_HEIGHT;
            this.verboseRendering = true;
        } else {
            this.w = this.NON_VERBOSE_WIDTH;
            this.h = this.NON_VERBOSE_HEIGHT;
            this.verboseRendering = false;
        }
    }
}

