/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ease.gotree;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.ktree.ITreeNode;
import org.tigr.microarray.mev.cluster.gui.helpers.ktree.Ktree;
import org.tigr.microarray.mev.cluster.gui.impl.ease.gotree.EaseThresholdDialog;
import org.tigr.microarray.mev.cluster.gui.impl.ease.gotree.GONode;
import org.tigr.microarray.mev.cluster.gui.impl.ease.gotree.GOTreeHeader;

public class GOTreeViewer
extends JPanel
implements IViewer,
Serializable {
    public static final long serialVersionUID = 20200201010001L;
    private String category;
    private Ktree tree;
    private Vector nodes;
    private DefaultMutableTreeNode viewerNode;
    private int selectionPolarity = 0;
    private JPopupMenu popup;
    private boolean verbose = false;
    private GOTreeHeader header;
    private JMenu newTreeMenu;
    private JMenu launchMenu;
    private IFramework framework;
    private double upper = 0.05;
    private double lower = 0.01;
    private String baseFileSystem;

    public GOTreeViewer() {
    }

    public GOTreeViewer(GONode gONode) {
        super(new GridBagLayout());
        this.tree = new Ktree((ITreeNode)gONode);
        this.add((Component)this.tree, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public GOTreeViewer(GONode[][] gONodeArray, DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        super(new GridBagLayout());
        this.baseFileSystem = string;
        this.tree = new Ktree((ITreeNode[][])gONodeArray);
        this.header = new GOTreeHeader(gONodeArray[0][0], this, this.upper, this.lower);
        this.viewerNode = defaultMutableTreeNode;
        this.add((Component)this.tree, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.nodes = new Vector();
        for (int i = 0; i < gONodeArray.length; ++i) {
            for (int j = 0; j < gONodeArray[i].length; ++j) {
                this.nodes.addElement(gONodeArray[i][j]);
            }
        }
        Listener listener = new Listener();
        this.tree.addMouseListener((MouseListener)listener);
        this.addMouseListener(listener);
        this.createPopupMenu(listener);
    }

    public GOTreeViewer(String string, String[] stringArray, String[][] stringArray2, DefaultMutableTreeNode defaultMutableTreeNode, String string2) {
        super(new GridBagLayout());
        this.viewerNode = defaultMutableTreeNode;
        this.baseFileSystem = string2;
        this.category = string;
        GONode[][] gONodeArray = this.constructTree(string, stringArray, stringArray2);
        this.tree = new Ktree((ITreeNode[][])gONodeArray);
        this.header = new GOTreeHeader(gONodeArray[0][0], this, this.upper, this.lower);
        this.add((Component)this.tree, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        Listener listener = new Listener();
        this.tree.addMouseListener((MouseListener)listener);
        this.addMouseListener(listener);
        this.createPopupMenu(listener);
        this.setVerboseNodeStyle(false);
    }

    private GONode[][] constructTree(String string, String[] stringArray, String[][] stringArray2) {
        GONode gONode;
        int n;
        int n2;
        Hashtable hashtable = new Hashtable(stringArray2.length);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        String[] stringArray3 = new String[]{"Acc.", "Term", "List Hits", "Pop. Hits", "File"};
        boolean bl = false;
        int n9 = 0;
        for (n2 = 0; n2 < stringArray3.length; ++n2) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(stringArray3[n2])) continue;
                n9 = i;
            }
            if (n2 == 0) {
                n3 = n9;
                continue;
            }
            if (n2 == 1) {
                n4 = n9;
                continue;
            }
            if (n2 == 2) {
                n5 = n9;
                continue;
            }
            if (n2 == 3) {
                n6 = n9;
                continue;
            }
            n8 = n9;
        }
        if (n3 < 4) {
            bl = true;
            n7 = 8;
        } else {
            n7 = 7;
        }
        this.nodes = new Vector(stringArray2.length);
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            if (stringArray2[n2][n8].indexOf(this.category) == -1) continue;
            GONode gONode2 = new GONode(stringArray2[n2][n3], stringArray2[n2][n4], this.category, Double.parseDouble(stringArray2[n2][n7]), Integer.parseInt(stringArray2[n2][n5]), Integer.parseInt(stringArray2[n2][n5 + 1]), Integer.parseInt(stringArray2[n2][n6]), Integer.parseInt(stringArray2[n2][n6 + 1]), n2);
            gONode2.setRenderingHint(1);
            gONode2.setLowerThr(0.01);
            gONode2.setUpperThr(0.05);
            this.nodes.addElement(gONode2);
        }
        this.makeAssociations(this.nodes);
        GONode gONode3 = new GONode("GO:00000001", this.category, this.category, 1.0, 100, 100, 100, 100, -1);
        gONode3.setRenderingHint(1);
        for (n = 0; n < this.nodes.size(); ++n) {
            gONode = (GONode)this.nodes.elementAt(n);
            if (gONode.hasParents()) continue;
            gONode.addParent(gONode3);
            gONode3.addChild(gONode);
        }
        this.nodes.addElement(gONode3);
        this.setLevelIndex(this.nodes);
        n = 0;
        for (int i = 0; i < this.nodes.size(); ++i) {
            gONode = (GONode)this.nodes.elementAt(i);
            n = Math.max(n, gONode.getLevel());
        }
        GONode[][] gONodeArray = new GONode[n + 1][];
        for (int i = 0; i < gONodeArray.length; ++i) {
            gONodeArray[i] = this.getLevelNodes(this.nodes, i);
        }
        ITreeNode[] iTreeNodeArray = gONode3.getChildren();
        if (iTreeNodeArray.length > 0) {
            gONode3.setListSize(((GONode)iTreeNodeArray[0]).getListSize());
            gONode3.setListHits(((GONode)iTreeNodeArray[0]).getListSize());
            gONode3.setPopSize(((GONode)iTreeNodeArray[0]).getPopSize());
            gONode3.setPopHits(((GONode)iTreeNodeArray[0]).getPopSize());
        }
        return gONodeArray;
    }

    private GONode[] getLevelNodes(Vector vector, int n) {
        Vector<GONode> vector2 = new Vector<GONode>();
        for (int i = 0; i < vector.size(); ++i) {
            GONode gONode = (GONode)vector.elementAt(i);
            if (gONode.getLevel() != n) continue;
            vector2.addElement(gONode);
        }
        GONode[] gONodeArray = new GONode[vector2.size()];
        for (int i = 0; i < gONodeArray.length; ++i) {
            gONodeArray[i] = (GONode)vector2.elementAt(i);
        }
        return gONodeArray;
    }

    private boolean makeAssociations(Vector vector) {
        Hashtable hashtable = null;
        try {
            hashtable = this.getAllAssociations();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("fnfe");
            fileNotFoundException.printStackTrace();
            return false;
        }
        catch (IOException iOException) {
            System.out.println("ioe");
            iOException.printStackTrace();
            return false;
        }
        if (hashtable == null || hashtable.size() == 0) {
            return false;
        }
        for (int i = 0; i < vector.size(); ++i) {
            this.makeAssociations(hashtable, vector, (GONode)vector.elementAt(i));
        }
        return true;
    }

    private void makeAssociations(Hashtable hashtable, Vector vector, GONode gONode) {
        String string = gONode.getTerm();
        if (!hashtable.containsKey(string)) {
            return;
        }
        Vector vector2 = (Vector)hashtable.get(string);
        if (vector2 == null) {
            return;
        }
        for (int i = 0; i < vector2.size(); ++i) {
            GONode gONode2 = this.getNode(vector, (String)vector2.elementAt(i));
            if (gONode2 == null) continue;
            gONode.addParent(gONode2);
            gONode2.addChild(gONode);
            this.makeAssociations(hashtable, vector, gONode2);
        }
    }

    public int getViewerWidth() {
        return this.tree.getTreePixelWidth();
    }

    private void setLevelIndex(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            GONode gONode = (GONode)vector.elementAt(i);
            gONode.setLevel(gONode.getMaxPathLengthToRoot() - 1);
        }
    }

    private Hashtable getAllAssociations() throws FileNotFoundException, IOException {
        String string;
        Hashtable hashtable = new Hashtable(10000);
        File file = TMEV.getFile((String)(this.baseFileSystem + "/Data/Class/Implies/"));
        String string2 = file.getPath();
        String string3 = string2 + "/" + this.category + ".txt";
        File file2 = new File(string3);
        if (!file2.exists() || !file2.isFile()) {
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string3));
        while ((string = bufferedReader.readLine()) != null) {
            int n = string.indexOf(9);
            if (n >= string.length() || n < 1) continue;
            if (!hashtable.containsKey(string.substring(0, n).trim())) {
                hashtable.put(string.substring(0, n).trim(), new Vector());
                ((Vector)hashtable.get(string.substring(0, n).trim())).addElement(string.substring(n, string.length()).trim());
                continue;
            }
            ((Vector)hashtable.get(string.substring(0, n).trim())).addElement(string.substring(n, string.length()).trim());
        }
        return hashtable;
    }

    private GONode getNode(Vector vector, String string) {
        Iterator iterator = vector.iterator();
        GONode gONode = null;
        boolean bl = false;
        while (!bl && iterator.hasNext()) {
            GONode gONode2 = (GONode)iterator.next();
            if (!string.equals(gONode2.getTerm())) continue;
            gONode = gONode2;
            bl = true;
        }
        return gONode;
    }

    public int[][] getClusters() {
        return null;
    }

    public JComponent getContentComponent() {
        return this.tree;
    }

    public JComponent getCornerComponent(int n) {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    public BufferedImage getImage() {
        return null;
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public void onClosed() {
    }

    public void onDataChanged(IData iData) {
    }

    public void onDeselected() {
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
    }

    public void onSelected(IFramework iFramework) {
        this.framework = iFramework;
        this.header.update();
        if (this.viewerNode == null) {
            this.viewerNode = (DefaultMutableTreeNode)iFramework.getCurrentNode().getParent();
        }
    }

    private void setStraitConnectorStyle(boolean bl) {
        this.tree.setStraitConnectorStyle(bl);
        this.tree.repaint();
    }

    private void setVerboseNodeStyle(boolean bl) {
        int n;
        if (bl) {
            n = 0;
            this.tree.setInterNodeHeight(60);
            this.tree.setInterNodeWidth(30);
        } else {
            n = 1;
            this.tree.setInterNodeHeight(40);
            this.tree.setInterNodeWidth(15);
        }
        this.verbose = bl;
        for (int i = 0; i < this.nodes.size(); ++i) {
            ((GONode)this.nodes.elementAt(i)).setRenderingHint(n);
        }
        this.tree.updateSize();
        this.header.update();
        this.tree.repaint();
    }

    private void setThresholds() {
        EaseThresholdDialog easeThresholdDialog = new EaseThresholdDialog((JFrame)this.framework.getFrame(), this.lower, this.upper);
        if (easeThresholdDialog.showModal() == 0) {
            this.setThresholds(easeThresholdDialog.getUpperThreshold(), easeThresholdDialog.getLowerThreshold());
            this.tree.repaint();
            this.header.repaint();
        }
    }

    public void setThresholds(double d, double d2) {
        this.lower = d2;
        this.upper = d;
        for (int i = 0; i < this.nodes.size(); ++i) {
            GONode gONode = (GONode)this.nodes.elementAt(i);
            gONode.setLowerThr(d2);
            gONode.setUpperThr(d);
        }
        this.header.setThresholds(d, d2);
    }

    private void setSelected(int n, int n2) {
        if (this.tree.checkSelection(n, n2, this.selectionPolarity)) {
            this.newTreeMenu.setEnabled(true);
            this.launchMenu.setEnabled(true);
            this.header.updateInfo(new GONode((GONode)this.tree.getSelectedNode()));
        } else {
            this.header.updateInfo(new GONode((GONode)this.tree.getRoot()));
            this.newTreeMenu.setEnabled(false);
            this.launchMenu.setEnabled(false);
        }
        this.tree.repaint();
    }

    private void launchNewGOTreeViewer() {
        int n;
        GONode gONode;
        int n2;
        Vector vector = this.tree.getSelectedPathNodes();
        if (vector.isEmpty()) {
            return;
        }
        Vector<GONode> vector2 = new Vector<GONode>();
        int n3 = Integer.MAX_VALUE;
        for (n2 = 0; n2 < vector.size(); ++n2) {
            gONode = (GONode)vector.elementAt(n2);
            n3 = Math.min(n3, gONode.getLevel());
            vector2.add(new GONode(gONode));
        }
        n2 = 0;
        for (int i = 0; i < vector2.size(); ++i) {
            gONode = (GONode)vector2.elementAt(i);
            gONode.setLevel(gONode.getLevel() - n3);
            n2 = Math.max(n2, gONode.getLevel());
            gONode.setRenderingHint(0);
        }
        this.pruneExtraNodes(vector2, vector, n2);
        Vector<GONode[]> vector3 = new Vector<GONode[]>();
        for (int i = 0; i < n2 + 1; ++i) {
            vector3.addElement(this.getLevelNodes(vector2, i));
        }
        Vector<GONode[]> vector4 = new Vector<GONode[]>();
        for (n = 0; n < vector3.size(); ++n) {
            GONode[] gONodeArray = (GONode[])vector3.elementAt(n);
            if (gONodeArray.length >= 1) continue;
            vector4.add(gONodeArray);
        }
        for (n = 0; n < vector4.size(); ++n) {
            vector3.remove(vector4.elementAt(n));
        }
        GONode[][] gONodeArray = new GONode[vector3.size()][];
        for (int i = 0; i < gONodeArray.length; ++i) {
            gONodeArray[i] = (GONode[])vector3.elementAt(i);
            for (int j = 0; j < gONodeArray[i].length; ++j) {
                gONodeArray[i][j].setLevel(i);
            }
        }
        GOTreeViewer gOTreeViewer = new GOTreeViewer(gONodeArray, this.viewerNode, this.baseFileSystem);
        gOTreeViewer.setThresholds(this.upper, this.lower);
        JFrame jFrame = new JFrame();
        JScrollPane jScrollPane = new JScrollPane(gOTreeViewer.getContentComponent());
        jScrollPane.setColumnHeaderView(gOTreeViewer.getHeaderComponent());
        jFrame.getContentPane().add(jScrollPane);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        jFrame.setSize(dimension.width / 3, dimension.height / 2);
        jFrame.setVisible(true);
        gOTreeViewer.onSelected(this.framework);
    }

    private void pruneExtraNodes(Vector vector, Vector vector2, int n) {
        for (int i = 0; i < vector.size(); ++i) {
            GONode gONode;
            int n2;
            Vector<GONode> vector3;
            ITreeNode[] iTreeNodeArray;
            GONode gONode2 = (GONode)vector.elementAt(i);
            if (gONode2.getLevel() == 0) {
                gONode2.clearParents();
            } else {
                iTreeNodeArray = gONode2.getParents();
                vector3 = new Vector<GONode>();
                for (n2 = 0; n2 < iTreeNodeArray.length; ++n2) {
                    gONode = null;
                    if (!vector2.contains(iTreeNodeArray[n2]) || (gONode = this.findNode(vector, ((GONode)iTreeNodeArray[n2]).getGOID())) == null) continue;
                    vector3.addElement(gONode);
                }
                gONode2.setParents(vector3);
            }
            if (gONode2.getLevel() == n) {
                gONode2.clearChildren();
                continue;
            }
            iTreeNodeArray = gONode2.getChildren();
            vector3 = new Vector();
            for (n2 = 0; n2 < iTreeNodeArray.length; ++n2) {
                gONode = null;
                if (!vector2.contains(iTreeNodeArray[n2]) || (gONode = this.findNode(vector, ((GONode)iTreeNodeArray[n2]).getGOID())) == null) continue;
                vector3.addElement(gONode);
            }
            gONode2.setChildren(vector3);
        }
    }

    private void onOpenViewer(String string) {
        GONode gONode = (GONode)this.tree.getSelectedNode();
        if (gONode == null) {
            return;
        }
        int n = gONode.getClusterIndex();
        if (n == -1 || this.viewerNode == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.viewerNode.getChildAt(1);
        if (defaultMutableTreeNode.getChildCount() < n) {
            return;
        }
        defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
        if (string.equals("expression image")) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
        } else if (string.equals("centroid graph")) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(1);
        } else if (string.equals("expression graph")) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(2);
        }
        if (this.framework != null) {
            this.framework.setTreeNode(defaultMutableTreeNode);
        }
    }

    private void createDockedGOTreeViewer() {
        int n;
        GONode gONode;
        int n2;
        Vector vector = this.tree.getSelectedPathNodes();
        if (vector.isEmpty()) {
            return;
        }
        Vector<GONode> vector2 = new Vector<GONode>();
        int n3 = Integer.MAX_VALUE;
        for (n2 = 0; n2 < vector.size(); ++n2) {
            gONode = (GONode)vector.elementAt(n2);
            n3 = Math.min(n3, gONode.getLevel());
            vector2.add(new GONode(gONode));
        }
        n2 = 0;
        for (int i = 0; i < vector2.size(); ++i) {
            gONode = (GONode)vector2.elementAt(i);
            gONode.setLevel(gONode.getLevel() - n3);
            n2 = Math.max(n2, gONode.getLevel());
            gONode.setRenderingHint(0);
        }
        this.pruneExtraNodes(vector2, vector, n2);
        Vector<GONode[]> vector3 = new Vector<GONode[]>();
        for (int i = 0; i < n2 + 1; ++i) {
            vector3.addElement(this.getLevelNodes(vector2, i));
        }
        Vector<GONode[]> vector4 = new Vector<GONode[]>();
        for (n = 0; n < vector3.size(); ++n) {
            GONode[] gONodeArray = (GONode[])vector3.elementAt(n);
            if (gONodeArray.length >= 1) continue;
            vector4.add(gONodeArray);
        }
        for (n = 0; n < vector4.size(); ++n) {
            vector3.remove(vector4.elementAt(n));
        }
        GONode[][] gONodeArray = new GONode[vector3.size()][];
        for (int i = 0; i < gONodeArray.length; ++i) {
            gONodeArray[i] = (GONode[])vector3.elementAt(i);
            for (int j = 0; j < gONodeArray[i].length; ++j) {
                gONodeArray[i][j].setLevel(i);
            }
        }
        GOTreeViewer gOTreeViewer = new GOTreeViewer(gONodeArray, this.viewerNode, this.baseFileSystem);
        gOTreeViewer.setThresholds(this.upper, this.lower);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new LeafInfo("GO Subtree", (IViewer)gOTreeViewer));
        this.framework.addNode(this.viewerNode, defaultMutableTreeNode);
        this.framework.setTreeNode(defaultMutableTreeNode);
    }

    private GONode findNode(Vector vector, String string) {
        for (int i = 0; i < vector.size(); ++i) {
            if (!((GONode)vector.elementAt(i)).getGOID().equals(string)) continue;
            return (GONode)vector.elementAt(i);
        }
        return null;
    }

    private void createPopupMenu(ActionListener actionListener) {
        this.popup = new JPopupMenu();
        JMenu jMenu = new JMenu("Node Style");
        ButtonGroup buttonGroup = new ButtonGroup();
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Minimal", true);
        jCheckBoxMenuItem.setActionCommand("simple-node-command");
        jCheckBoxMenuItem.addActionListener(actionListener);
        buttonGroup.add(jCheckBoxMenuItem);
        jMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem = new JCheckBoxMenuItem("Verbose");
        jCheckBoxMenuItem.setActionCommand("verbose-node-command");
        jCheckBoxMenuItem.addActionListener(actionListener);
        buttonGroup.add(jCheckBoxMenuItem);
        jMenu.add(jCheckBoxMenuItem);
        this.popup.add(jMenu);
        this.popup.addSeparator();
        jMenu = new JMenu("Connector Style");
        buttonGroup = new ButtonGroup();
        jCheckBoxMenuItem = new JCheckBoxMenuItem("Curved", true);
        jCheckBoxMenuItem.setActionCommand("curved-connector-command");
        jCheckBoxMenuItem.addActionListener(actionListener);
        buttonGroup.add(jCheckBoxMenuItem);
        jMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem = new JCheckBoxMenuItem("Strait");
        jCheckBoxMenuItem.setActionCommand("strait-connector-command");
        jCheckBoxMenuItem.addActionListener(actionListener);
        buttonGroup.add(jCheckBoxMenuItem);
        jMenu.add(jCheckBoxMenuItem);
        this.popup.add(jMenu);
        this.popup.addSeparator();
        JMenuItem jMenuItem = new JMenuItem("Set Thresholds");
        jMenuItem.setActionCommand("set-thresholds-command");
        jMenuItem.addActionListener(actionListener);
        this.popup.add(jMenuItem);
        this.popup.addSeparator();
        jMenu = new JMenu("Selection Polarity");
        buttonGroup = new ButtonGroup();
        JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("Select Ancestors");
        jCheckBoxMenuItem2.setActionCommand("ancestor-selection-command");
        jCheckBoxMenuItem2.addActionListener(actionListener);
        buttonGroup.add(jCheckBoxMenuItem2);
        jMenu.add(jCheckBoxMenuItem2);
        jCheckBoxMenuItem2 = new JCheckBoxMenuItem("Select Successors");
        jCheckBoxMenuItem2.setActionCommand("successor-selection-command");
        jCheckBoxMenuItem2.addActionListener(actionListener);
        buttonGroup.add(jCheckBoxMenuItem2);
        jMenu.add(jCheckBoxMenuItem2);
        jCheckBoxMenuItem2 = new JCheckBoxMenuItem("Bipolar Selection", true);
        jCheckBoxMenuItem2.setActionCommand("bipolar-selection-command");
        jCheckBoxMenuItem2.addActionListener(actionListener);
        buttonGroup.add(jCheckBoxMenuItem2);
        jMenu.add(jCheckBoxMenuItem2);
        this.popup.add(jMenu);
        this.popup.addSeparator();
        this.newTreeMenu = new JMenu("Create Subset Viewer");
        this.newTreeMenu.setEnabled(false);
        jMenuItem = new JMenuItem("In New Window...");
        jMenuItem.setActionCommand("new-subtree-command");
        jMenuItem.addActionListener(actionListener);
        this.newTreeMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Docked in Result Tree...");
        jMenuItem.setActionCommand("new-docked-subtree-command");
        jMenuItem.addActionListener(actionListener);
        this.newTreeMenu.add(jMenuItem);
        this.popup.add(this.newTreeMenu);
        this.popup.addSeparator();
        this.launchMenu = new JMenu("Open Viewer");
        this.launchMenu.setEnabled(false);
        jMenuItem = new JMenuItem("Expression Image");
        jMenuItem.setActionCommand("launch-expression-image-command");
        jMenuItem.addActionListener(actionListener);
        this.launchMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Centroid Graph");
        jMenuItem.setActionCommand("launch-centroid-graph-command");
        jMenuItem.addActionListener(actionListener);
        this.launchMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Expression Graph");
        jMenuItem.setActionCommand("launch-expression-graph-command");
        jMenuItem.addActionListener(actionListener);
        this.launchMenu.add(jMenuItem);
        this.popup.add(this.launchMenu);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.baseFileSystem);
        objectOutputStream.writeObject(this.category);
        objectOutputStream.writeObject(this.tree);
        objectOutputStream.writeObject(this.nodes);
        objectOutputStream.writeInt(this.selectionPolarity);
        objectOutputStream.writeBoolean(this.verbose);
        objectOutputStream.writeObject(this.header);
        objectOutputStream.writeDouble(this.upper);
        objectOutputStream.writeDouble(this.lower);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.baseFileSystem = (String)objectInputStream.readObject();
        this.category = (String)objectInputStream.readObject();
        this.tree = (Ktree)objectInputStream.readObject();
        this.nodes = (Vector)objectInputStream.readObject();
        this.selectionPolarity = objectInputStream.readInt();
        this.verbose = objectInputStream.readBoolean();
        this.header = (GOTreeHeader)objectInputStream.readObject();
        this.upper = objectInputStream.readDouble();
        this.lower = objectInputStream.readDouble();
        Listener listener = new Listener();
        this.tree.addMouseListener((MouseListener)listener);
        this.addMouseListener(listener);
        this.createPopupMenu(listener);
    }

    public int getViewerType() {
        return -1;
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("verbose-node-command")) {
                GOTreeViewer.this.setVerboseNodeStyle(true);
            } else if (string.equals("simple-node-command")) {
                GOTreeViewer.this.setVerboseNodeStyle(false);
            } else if (string.equals("strait-connector-command")) {
                GOTreeViewer.this.setStraitConnectorStyle(true);
            } else if (string.equals("curved-connector-command")) {
                GOTreeViewer.this.setStraitConnectorStyle(false);
            } else if (string.equals("set-thresholds-command")) {
                GOTreeViewer.this.setThresholds();
            } else if (string.equals("bipolar-selection-command")) {
                GOTreeViewer.this.selectionPolarity = 0;
            } else if (string.equals("ancestor-selection-command")) {
                GOTreeViewer.this.selectionPolarity = 1;
            } else if (string.equals("successor-selection-command")) {
                GOTreeViewer.this.selectionPolarity = 2;
            } else if (string.equals("new-subtree-command")) {
                GOTreeViewer.this.launchNewGOTreeViewer();
            } else if (string.equals("new-docked-subtree-command")) {
                GOTreeViewer.this.createDockedGOTreeViewer();
            } else if (string.equals("launch-expression-image-command")) {
                GOTreeViewer.this.onOpenViewer("expression image");
            } else if (string.equals("launch-centroid-graph-command")) {
                GOTreeViewer.this.onOpenViewer("centroid graph");
            } else if (string.equals("launch-expression-graph-command")) {
                GOTreeViewer.this.onOpenViewer("expression graph");
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                GOTreeViewer.this.popup.show((Component)GOTreeViewer.this.tree, mouseEvent.getX(), mouseEvent.getY());
            } else if (mouseEvent.getModifiers() == 16) {
                GOTreeViewer.this.setSelected(mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                GOTreeViewer.this.popup.show((Component)GOTreeViewer.this.tree, mouseEvent.getX(), mouseEvent.getY());
            } else if (mouseEvent.getModifiers() == 16) {
                GOTreeViewer.this.setSelected(mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                GOTreeViewer.this.popup.show((Component)GOTreeViewer.this.tree, mouseEvent.getX(), mouseEvent.getY());
            } else if (mouseEvent.getModifiers() == 16) {
                GOTreeViewer.this.setSelected(mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

